/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.database.dialects.oracle.types.OraNestedTableType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.psi.OraReferenceTypeElementImpl;
import com.intellij.sql.editor.SqlBaseValidationDelegate;
import com.intellij.sql.editor.SqlValidatingHighlightVisitor;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlTypeElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/dialects/oracle/OraValidationDelegate;", "Lcom/intellij/sql/editor/SqlBaseValidationDelegate;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "visitSqlFunctionCallExpression", "", "o", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "visitSqlSelectIntoClause", "Lcom/intellij/sql/psi/SqlSelectIntoClause;", "visitSqlTypeElement", "Lcom/intellij/sql/psi/SqlTypeElement;", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraValidationDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraValidationDelegate.kt\ncom/intellij/sql/dialects/oracle/OraValidationDelegate\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,63:1\n66#2,2:64\n*S KotlinDebug\n*F\n+ 1 OraValidationDelegate.kt\ncom/intellij/sql/dialects/oracle/OraValidationDelegate\n*L\n27#1:64,2\n*E\n"})
public final class OraValidationDelegate
extends SqlBaseValidationDelegate {
    public OraValidationDelegate(@NotNull SqlLanguageDialectEx dialect, @NotNull HighlightInfoHolder holder) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(dialect, holder);
    }

    public void visitSqlSelectIntoClause(@NotNull SqlSelectIntoClause o2) {
        SqlQueryExpression outerQuery;
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        super.visitSqlSelectIntoClause(o2);
        PsiElement psiElement = o2.getParent();
        SqlQueryExpression sqlQueryExpression = psiElement instanceof SqlQueryExpression ? (SqlQueryExpression)psiElement : null;
        if (sqlQueryExpression != null) {
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)sqlQueryExpression;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            v1 = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, SqlQueryExpression.class, (boolean)true);
        } else {
            v1 = outerQuery = null;
        }
        if (outerQuery != null) {
            SqlValidatingHighlightVisitor.Delegate delegate = this;
            PsiElement psiElement2 = (PsiElement)o2;
            String string = SqlBundle.message((String)"inspection.into.is.not.allowed.in.nested.query", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SqlValidatingHighlightVisitor.Delegate.reportError$default(delegate, psiElement2, string, null, 4, null);
        }
    }

    public void visitSqlTypeElement(@NotNull SqlTypeElement o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        super.visitSqlTypeElement(o2);
        if (!(o2 instanceof OraReferenceTypeElementImpl)) {
            return;
        }
        IElementType type2 = ((OraReferenceTypeElementImpl)o2).getSuffixTokenType();
        if (!Intrinsics.areEqual((Object)type2, (Object)OraTypes.ORA_TYPE)) {
            return;
        }
        SqlReferenceExpression sqlReferenceExpression = ((OraReferenceTypeElementImpl)o2).getReferenceExpression();
        if (sqlReferenceExpression == null) {
            return;
        }
        SqlReferenceExpression ref2 = sqlReferenceExpression;
        DasSymbol dasSymbol = ref2.resolveSymbol();
        if (dasSymbol == null) {
            return;
        }
        DasSymbol symbol = dasSymbol;
        ObjectKind objectKind = symbol.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        ObjectKind kind = objectKind;
        if (!(Intrinsics.areEqual((Object)kind, (Object)ObjectKind.COLUMN) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VARIABLE) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.ARGUMENT) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.OBJECT_ATTRIBUTE) || Intrinsics.areEqual((Object)kind, (Object)SqlDbElementType.LOCAL_ALIAS))) {
            SqlValidatingHighlightVisitor.Delegate delegate = this;
            PsiElement psiElement = ((OraReferenceTypeElementImpl)o2).getSuffixToken();
            Intrinsics.checkNotNull((Object)psiElement);
            String string = SqlBundle.message((String)"inspection.ora.wrong.percent.type", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SqlValidatingHighlightVisitor.Delegate.reportWarning$default(delegate, psiElement, string, null, 4, null);
        }
    }

    public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        super.visitSqlFunctionCallExpression(o2);
        BuiltinFunction builtinFunction = o2.getFunctionDefinition();
        if (builtinFunction == null) {
            return;
        }
        BuiltinFunction funDef = builtinFunction;
        if (!Intrinsics.areEqual((Object)funDef.getName(), (Object)"SET") && !Intrinsics.areEqual((Object)funDef.getName(), (Object)"CARDINALITY")) {
            return;
        }
        Object object = o2.getParameterList();
        if (object == null || (object = object.getExpressionList()) == null || (object = (SqlExpression)CollectionsKt.singleOrNull((List)object)) == null) {
            return;
        }
        Object arg = object;
        DasType dasType = arg.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = DasTypeUtilsKt.unwrap$default(dasType, false, null, 3, null);
        if (!Intrinsics.areEqual((Object)dasType2, DasTypeSystemBase.UNKNOWN) && !(dasType2 instanceof OraNestedTableType)) {
            SqlValidatingHighlightVisitor.Delegate delegate = this;
            PsiElement psiElement = (PsiElement)arg;
            String string = SqlBundle.message((String)"inspection.ora.nested.table.expected", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            SqlValidatingHighlightVisitor.Delegate.reportError$default(delegate, psiElement, string, null, 4, null);
        }
    }
}

