/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/dialects/mysql/inspections/MysqlSpaceAfterFunctionNameInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "RemoveWhitespace", "intellij.database.dialects.mysqlbase"})
public final class MysqlSpaceAfterFunctionNameInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!dialect.getDbms().isMysql()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$manager = $manager;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlFunctionCallExpression(@Nullable SqlFunctionCallExpression o2) {
                super.visitSqlFunctionCallExpression(o2);
                if (o2 == null) {
                    return;
                }
                if (!this.isAggregate(o2)) {
                    return;
                }
                if (o2.getChildren().length < 2) {
                    return;
                }
                PsiElement psiElement = o2.getChildren()[1];
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"get(...)");
                PsiElement c2 = psiElement;
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)c2), (Object)TokenType.WHITE_SPACE)) {
                    this.addDescriptor(this.$manager.createProblemDescriptor(c2, SqlBundle.message((String)"inspection.message.whitespace.between.function.name.open.parenthesis", (Object[])new Object[0]), (LocalQuickFix)new RemoveWhitespace(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
                }
            }

            private final boolean isAggregate(SqlFunctionCallExpression o2) {
                BuiltinFunction builtinFunction = o2.getFunctionDefinition();
                Object object = builtinFunction instanceof BuiltinFunction ? builtinFunction : null;
                if (object == null) {
                    return false;
                }
                BuiltinFunction def = object;
                return Intrinsics.areEqual((Object)"true", (Object)def.getDialectAttribute("aggregate"));
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/dialects/mysql/inspections/MysqlSpaceAfterFunctionNameInspection$RemoveWhitespace;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "removeWhitespace", "w", "Lcom/intellij/psi/PsiElement;", "intellij.database.dialects.mysqlbase"})
    public static final class RemoveWhitespace
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.remove.whitespace", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement w = descriptor2.getPsiElement();
            if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)w), (Object)TokenType.WHITE_SPACE)) {
                Intrinsics.checkNotNull((Object)w);
                this.removeWhitespace(w);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void removeWhitespace(PsiElement w) {
            CodeEditUtil.allowToMarkNodesForPostponedFormatting((boolean)false);
            try {
                w.delete();
            }
            finally {
                CodeEditUtil.allowToMarkNodesForPostponedFormatting((boolean)true);
            }
        }
    }
}

