/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql.inspections;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/dialects/mssql/inspections/MsBuiltinInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.dialects.mssql"})
public final class MsBuiltinInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!dialect.getDbms().isMicrosoft()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                BuiltinFunction builtinFunction = o2.getFunctionDefinition();
                if (builtinFunction == null) {
                    return;
                }
                BuiltinFunction builtinFunction2 = builtinFunction;
                if (!StringsKt.equals((String)builtinFunction2.getName(), (String)"isnull", (boolean)true)) {
                    return;
                }
                Object object = o2.getParameterList();
                if (object == null || (object = object.getExpressionList()) == null) {
                    return;
                }
                Object expressions2 = object;
                if (expressions2.size() != 2) {
                    return;
                }
                DasType dasType = ((SqlExpression)expressions2.get(0)).getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                DasType type1 = dasType;
                DasType dasType2 = ((SqlExpression)expressions2.get(1)).getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
                DasType type2 = dasType2;
                if (DasTypeUtilsKt.getCategory(type1) != DasTypeCategory.STRING && DasTypeUtilsKt.getCategory(type2) != DasTypeCategory.STRING) {
                    return;
                }
                if (type1.toDataType().getLength() < type2.toDataType().getLength()) {
                    PsiElement psiElement = (PsiElement)o2;
                    String string = AnalysisBundle.message((String)"MsBuiltinInspection.inspection.message.second.argument.isnull.implicitly.truncated", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.reportProblem(psiElement, string);
                }
            }

            private final void reportProblem(PsiElement anchor2, @InspectionMessage String message2) {
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor2, message2, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
            }
        };
    }
}

