/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.database.Dbms;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.sql.completion.SqlKeywordCompletionContributor;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.mongo.js.MongoJSCodeFragment;
import com.intellij.sql.dialects.mongo.js.MongoJSPsiUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.resolve.MongoJSResolveHelper;
import com.intellij.sql.dialects.mongo.js.psi.resolve.ResolveUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.resolve.place.MongoJSExpressionPlace;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/dialects/mongo/js/completion/MongoJSSqlKeywordCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "SQL_FAKE_IDENTIFIER_TEXT", "", "sqlKeywordCompletionContributor", "Lcom/intellij/sql/completion/SqlKeywordCompletionContributor;", "sqlLanguageDialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "Lorg/jetbrains/annotations/NotNull;", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.database.dialects.mongo"})
public final class MongoJSSqlKeywordCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final MongoJSSqlKeywordCompletionProvider INSTANCE = new MongoJSSqlKeywordCompletionProvider();
    @NotNull
    private static final String SQL_FAKE_IDENTIFIER_TEXT = "sqlFakeIdentifierText";
    @NotNull
    private static final SqlKeywordCompletionContributor sqlKeywordCompletionContributor = new SqlKeywordCompletionContributor();
    @NotNull
    private static final SqlLanguageDialect sqlLanguageDialect;

    private MongoJSSqlKeywordCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiElement qualifier;
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (parameters2.getOriginalFile() instanceof MongoJSCodeFragment) {
            return;
        }
        PsiElement psiElement = parameters2.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        if (position.getParent() instanceof PsiErrorElement) {
            return;
        }
        MongoJSResolveHelper mongoJSResolveHelper = ResolveUtilKt.getMongoHelper(position);
        if (mongoJSResolveHelper == null) {
            return;
        }
        MongoJSResolveHelper helper = mongoJSResolveHelper;
        PsiElement psiElement2 = MongoJSPsiUtilKt.parentIfInstanceOf(position, helper.getReferenceExpressionClass());
        if (psiElement2 == null) {
            return;
        }
        PsiElement expression = psiElement2;
        PsiReference psiReference = expression.getReference();
        PsiQualifiedReference psiQualifiedReference = psiReference instanceof PsiQualifiedReference ? (PsiQualifiedReference)psiReference : null;
        Object object = qualifier = psiQualifiedReference != null ? psiQualifiedReference.getQualifier() : null;
        if (qualifier != null) {
            return;
        }
        if (MongoJSExpressionPlace.Companion.fromIfCorrect(expression, parameters2.getOriginalFile()) != MongoJSExpressionPlace.EXPRESSION_STATEMENT) {
            return;
        }
        SqlFile sqlFile = SqlPsiElementFactory.createROFileFromText((CharSequence)SQL_FAKE_IDENTIFIER_TEXT, sqlLanguageDialect, position.getProject(), null);
        Intrinsics.checkNotNullExpressionValue((Object)sqlFile, (String)"createROFileFromText(...)");
        SqlFile sqlFakeFile = sqlFile;
        PsiElement psiElement3 = sqlFakeFile.findElementAt(0);
        if (psiElement3 == null) {
            return;
        }
        PsiElement sqlFakePosition = psiElement3;
        CompletionParameters sqlFakeParameters = new CompletionParameters(sqlFakePosition, (PsiFile)sqlFakeFile, parameters2.getCompletionType(), 0, 1, parameters2.getEditor(), parameters2.getProcess());
        sqlKeywordCompletionContributor.fillCompletionVariants(sqlFakeParameters, result2);
    }

    static {
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(Dbms.MONGO);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        MongoJSSqlKeywordCompletionProvider.sqlLanguageDialect = sqlLanguageDialect;
    }
}

