/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.greenplum;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.greenplum.GPlumDdlParsing;
import com.intellij.sql.dialects.greenplum.GPlumDialect;
import com.intellij.sql.dialects.greenplum.GPlumDmlParsing;
import com.intellij.sql.dialects.greenplum.GPlumElementTypes;
import com.intellij.sql.dialects.greenplum.GPlumExpressionParsing;
import com.intellij.sql.dialects.greenplum.GPlumGeneratedParser;
import com.intellij.sql.dialects.greenplum.GPlumPlParsing;
import com.intellij.sql.dialects.greenplum.GPlumTypes;
import com.intellij.sql.dialects.postgres.PgParserBase;
import com.intellij.sql.psi.SqlReferenceElementType;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class GPlumParser
extends PgParserBase {
    public GPlumParser(boolean pl) {
        super(GPlumDialect.INSTANCE, pl);
    }

    @Override
    protected boolean parseExtraRoots(IElementType root2, PsiBuilder builder, int level) {
        return GPlumGeneratedParser.parse_root_(root2, builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = GPlumExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error(DatabaseBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        return result2;
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, GPlumExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        if (this.isPlSql()) {
            return GPlumPlParsing.pl_statement(builder, level);
        }
        if (super.parseSqlStatement(builder, level)) {
            return true;
        }
        return GPlumGeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return GPlumGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return GPlumDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? GPlumPlParsing.type_element_ext(builder, level) : GPlumDdlParsing.type_element(builder, level);
    }

    @Override
    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        if (this.isPlSql() && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT) && builder.getTokenText() != null && builder.getTokenText().startsWith("$")) {
            this.consumeIdentifier(builder);
            return SQL_VARIABLE_REFERENCE;
        }
        return super.consumeCustomParameterReference(builder);
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, GPlumExpressionParsing::parenthesized_values_expr, GPlumDmlParsing::top_query_expression, GPlumParser::parseTopQueryExpressionTail, GPlumExpressionParsing::row_element_list, (b2, l) -> GPlumExpressionParsing.root_expr_0(b2, l, -1) && GPlumExpressionParsing.row_element_list_separator(b2, l) && GPlumExpressionParsing.row_element_list(b2, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, GPlumDmlParsing::parenthesized_aliased_join_expression, GPlumDmlParsing::top_query_expression, GPlumParser::parseTopQueryExpressionTail, (b2, l) -> GPlumDmlParsing.join_expression(b2, l, -1), (b2, l) -> GPlumDmlParsing.join_expression_0(b2, l, -1));
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        if (GPlumGeneratedParser.within_group_clause(builder, level) | GPlumGeneratedParser.analytic_clause(builder, level)) {
            IElementType type2;
            LighterASTNode ref2 = SqlGeneratedParserUtil.getExposedFunctionRef(builder);
            IElementType iElementType = type2 = ref2 == null ? null : ref2.getTokenType();
            if (type2 == SQL_REFERENCE || type2 == SQL_ANY_CALLABLE_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)ref2).remapTokenType((IElementType)SQL_FUNCTION_REFERENCE);
            }
        }
        return true;
    }

    @Override
    public boolean parseFunctionParametersEnd(PsiBuilder builder, int level, BuiltinFunction definition2) {
        GPlumDmlParsing.order_by_clause(builder, level);
        return true;
    }

    @Override
    protected boolean parseTypedReference(PsiBuilder builder, SqlReferenceElementType refType) {
        boolean result2 = super.parseTypedReference(builder, refType);
        if (!result2 && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_STRING_TOKEN)) {
            PsiBuilder.Marker mark2 = builder.mark();
            builder.advanceLexer();
            mark2.done((IElementType)SQL_STRING_LITERAL);
            result2 = true;
        }
        if (result2 && SqlParserUtil.consumeOptionalToken(builder, (IElementType)PG_OP_TYPE_CAST)) {
            PsiBuilder.Marker marker = Objects.requireNonNull((PsiBuilder.Marker)builder.getLatestDoneMarker());
            GPlumPlParsing.type_element_ext_inner(builder, 0);
            marker.precede().done((IElementType)SQL_BINARY_EXPRESSION);
        }
        return result2;
    }

    @Override
    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean variadic = SqlParserUtil.consumeToken(builder, true, GPlumTypes.GPLUM_VARIADIC);
        return super.parseFunctionArgument(builder, level, optional && !variadic, allowBoolean);
    }

    @Override
    @Nullable
    public IElementType getLazyCodeBlockType() {
        return GPlumElementTypes.Misc.GPLUM_LAZY_CODE_BLOCK;
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        GPlumDmlParsing.query_expression_0(builder, level, -1);
        return GPlumDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

