/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.bigquery.refactoring;

import com.intellij.database.util.DdlBuilder;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/dialects/bigquery/refactoring/BigQueryExtractFunctionHelper;", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;", "()V", "supportsTableFunctions", "", "getSupportsTableFunctions", "()Z", "generateBodyStatement", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "functionInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "generateTableType", "sqlType", "Lcom/intellij/sql/psi/SqlTableType;", "getRoutineKeyword", "", "intellij.database.dialects.bigquery"})
public final class BigQueryExtractFunctionHelper
extends SqlExtractFunctionHelper {
    @NotNull
    public static final BigQueryExtractFunctionHelper INSTANCE = new BigQueryExtractFunctionHelper();

    private BigQueryExtractFunctionHelper() {
    }

    @Override
    public boolean getSupportsTableFunctions() {
        return true;
    }

    @Override
    @NotNull
    public String getRoutineKeyword(@NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        return functionInfo.getCodeInfo().isTableFunction() ? "table function" : "function";
    }

    @Override
    public void generateTableType(@NotNull DdlBuilder builder, @NotNull SqlTableType sqlType) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        builder.keyword("table");
        builder.symbol("<");
        this.generateTableTypeColumns(builder, sqlType);
        builder.symbol(">");
    }

    @Override
    protected void generateBodyStatement(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        this.generateReturnExpression(builder, functionInfo);
    }
}

