/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.ConfigUrlBean;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.util.DbTestUtils;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SqlCommonTestUtilsCore {
    @TestOnly
    @NotNull
    public static JBIterable<DbmsExtension.Bean<SqlLanguageDialect>> loadSqlDialectBeans() {
        return SqlCommonTestUtilsCore.loadDbmsExtensionBeans(SqlLanguageDialect.EP);
    }

    @TestOnly
    @NotNull
    public static JBIterable<DbmsExtension.Bean<DatabaseDialect>> loadDatabaseDialectBeans() {
        return SqlCommonTestUtilsCore.loadDbmsExtensionBeans(DatabaseDialect.EP);
    }

    @TestOnly
    @NotNull
    public static <T> JBIterable<DbmsExtension.Bean<T>> loadDbmsExtensionBeans(@NotNull DbmsExtension<T> ep) {
        if (ep == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(0);
        }
        String epName = ep.getName();
        boolean isInstance = ep == SqlLanguageDialect.EP;
        Class clazz = isInstance ? DbmsExtension.InstanceBean.class : DbmsExtension.Bean.class;
        JBIterable<DbmsExtension.InstanceBean> jBIterable = DbTestUtils.loadBeans(epName, clazz);
        if (jBIterable == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @TestOnly
    @NotNull
    public static List<URL> loadConfigUrls(@NotNull ExtensionPointName<ConfigUrlBean> ep) {
        if (ep == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(2);
        }
        List<URL> list = ConfigUrlBean.getUrls(SqlCommonTestUtilsCore.loadConfigUrlBeans(ep));
        if (list == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(3);
        }
        return list;
    }

    @TestOnly
    @NotNull
    public static List<ConfigUrlBean> loadConfigUrlBeans(@NotNull ExtensionPointName<ConfigUrlBean> ep) {
        if (ep == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(4);
        }
        List list = DbTestUtils.loadBeans(ep.getName(), ConfigUrlBean.class).toList();
        if (list == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static <T> T getDialectClass(@NotNull String dialectClass, @NotNull String suffix2) {
        Object object;
        if (dialectClass == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(6);
        }
        if (suffix2 == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(7);
        }
        String path = dialectClass.replace("Dialect", suffix2);
        try {
            object = ReflectionUtil.newInstance(Class.forName(path));
        }
        catch (ClassNotFoundException e2) {
            Object object2;
            String basePath = SqlCommonTestUtilsCore.getBaseDialectClass(path);
            if (basePath == null) {
                throw new AssertionError((Object)e2);
            }
            try {
                object2 = ReflectionUtil.newInstance(Class.forName(basePath));
            }
            catch (ClassNotFoundException e22) {
                throw new AssertionError((Object)e22);
            }
            if (object2 == null) {
                SqlCommonTestUtilsCore.$$$reportNull$$$0(9);
            }
            return (T)object2;
        }
        if (object == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(8);
        }
        return (T)object;
    }

    private static String getBaseDialectClass(String path) {
        if (path.contains(".mysql.Mysql")) {
            return path.replace(".mysql.Mysql", ".mysqlbase.MysqlBase");
        }
        if (path.contains(".maria.Maria")) {
            return path.replace(".maria.Maria", ".mysqlbase.MysqlBase");
        }
        if (path.contains(".db2.Db2LUW")) {
            return path.replace(".db2.Db2LUW", ".db2.Db2Base");
        }
        if (path.contains(".db2.Db2")) {
            return path.replace(".db2.Db2", ".db2.Db2Base");
        }
        return null;
    }

    public static void updateScopeFromModel(LocalDataSource dataSource2) {
        dataSource2.setIntrospectionScope(TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(((BasicModel)dataSource2.getModel()).getRoot().getAllSchemas()).map(s2 -> TreePatternUtils.create(ObjectPaths.of(s2)))));
    }

    @Nullable
    public static String findTestDirective(@NotNull String fileText, @NotNull String directive) {
        if (fileText == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(10);
        }
        if (directive == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(11);
        }
        for (String line : StringUtil.splitByLines((String)fileText)) {
            if (!line.startsWith(directive)) continue;
            return line.substring(directive.length());
        }
        return null;
    }

    @NotNull
    public static List<String> findTestDirectives(@NotNull String fileText, @NotNull String directive) {
        if (fileText == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(12);
        }
        if (directive == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(13);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String line : StringUtil.splitByLines((String)fileText)) {
            if (!line.startsWith(directive)) continue;
            result2.add(line.substring(directive.length()));
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    public static String findTestDirectiveValue(@NotNull String fileText, @NotNull String directive) {
        Pattern p2;
        Matcher matcher;
        if (fileText == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(15);
        }
        if (directive == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(16);
        }
        if (!(matcher = (p2 = Pattern.compile("(?:^|\\n)\\s*" + Pattern.quote(directive) + "([^\\n]*)")).matcher(fileText)).find()) {
            return null;
        }
        return matcher.group(1).trim();
    }

    @Nullable
    public static Boolean getIsAvailableStatus(@NotNull String text2) {
        String s2;
        if (text2 == null) {
            SqlCommonTestUtilsCore.$$$reportNull$$$0(17);
        }
        if ((s2 = StringUtil.trim((String)SqlCommonTestUtilsCore.findTestDirective(text2, "-- IS_AVAILABLE: "))) == null) {
            return null;
        }
        return switch (s2) {
            case "false" -> false;
            case "true" -> true;
            default -> throw new AssertionError((Object)("Boolean expected: " + s2));
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 8, 9, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ep";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlCommonTestUtilsCore";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directive";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlCommonTestUtilsCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDbmsExtensionBeans";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfigUrls";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfigUrlBeans";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectClass";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestDirectives";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadDbmsExtensionBeans";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadConfigUrls";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadConfigUrlBeans";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDialectClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTestDirective";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findTestDirectives";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findTestDirectiveValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getIsAvailableStatus";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 8, 9, 14 -> new IllegalStateException(string);
        };
    }
}

