/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dataFlow;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dataFlow.CursorState;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.FlowUtilKt;
import com.intellij.sql.dataFlow.SqlFlowGraphBuilder;
import com.intellij.sql.dataFlow.instructions.SqlAssignmentInstruction;
import com.intellij.sql.dataFlow.instructions.SqlCursorInstruction;
import com.intellij.sql.dataFlow.instructions.SqlEnterSubroutineInstruction;
import com.intellij.sql.dataFlow.instructions.SqlFlowGraph;
import com.intellij.sql.dataFlow.instructions.SqlInstruction;
import com.intellij.sql.dataFlow.instructions.SqlInstructionVisitor;
import com.intellij.sql.dataFlow.instructions.SqlJumpInstruction;
import com.intellij.sql.dataFlow.instructions.SqlPseudoValue;
import com.intellij.sql.dataFlow.instructions.SqlPseudoValueSource;
import com.intellij.sql.dataFlow.instructions.SqlSubroutineDefinitionInstruction;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a@\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00012$\u0010\u0005\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\u00060\u0006H\u0002\u001a \u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002\u001aF\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\u00062\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0002\u001ab\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\b2$\u0010\u0005\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\u00060\u00062\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\u00062\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u000e*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\n\u0010\u001b\u001a\u00020\u0018*\u00020\u001c\u001a\u001c\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001*\u00020\u0018\u001a\u0010\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f*\u00020\u0018\u001a\u0010\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u0003*\u00020\u0018\u001a\u0010\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"*\u00020#\u001a\u0010\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180\"*\u00020\u0018\u00a8\u0006%"}, d2={"extractCursorInstructionsStates", "", "Lcom/intellij/sql/dataFlow/instructions/SqlCursorInstruction;", "", "Lcom/intellij/sql/dataFlow/CursorState;", "states", "", "Lcom/intellij/sql/dataFlow/instructions/SqlInstruction;", "Lcom/intellij/sql/psi/SqlDefinition;", "", "getDefinitionAndState", "Lkotlin/Pair;", "inst", "merge", "", "to", "from", "avoid", "updateStates", "predecessor", "currentDef", "currentStates", "initialState", "accept", "Lcom/intellij/sql/dataFlow/instructions/SqlFlowGraph;", "visitor", "Lcom/intellij/sql/dataFlow/instructions/SqlInstructionVisitor;", "buildFlowGraph", "Lcom/intellij/sql/psi/SqlRoutineDefinition;", "computeCursorStates", "findExitPoints", "", "findUnreachableInstructions", "parentBuilders", "Lkotlin/sequences/Sequence;", "Lcom/intellij/sql/dataFlow/SqlFlowGraphBuilder;", "parentGraphs", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nflowUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 flowUtil.kt\ncom/intellij/sql/dataFlow/FlowUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,156:1\n1855#2,2:157\n1855#2,2:159\n1855#2,2:175\n372#3,7:161\n372#3,7:168\n*S KotlinDebug\n*F\n+ 1 flowUtil.kt\ncom/intellij/sql/dataFlow/FlowUtilKt\n*L\n22#1:157,2\n39#1:159,2\n145#1:175,2\n107#1:161,7\n115#1:168,7\n*E\n"})
public final class FlowUtilKt {
    @NotNull
    public static final SqlFlowGraph buildFlowGraph(@NotNull SqlRoutineDefinition $this$buildFlowGraph) {
        Intrinsics.checkNotNullParameter((Object)$this$buildFlowGraph, (String)"<this>");
        DFABuildingVisitor dFABuildingVisitor = SqlImplUtil.getSqlDialectSafe((PsiElement)$this$buildFlowGraph).createDFAVisitor();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dFABuildingVisitor), (String)"createDFAVisitor(...)");
        DFABuildingVisitor visitor2 = dFABuildingVisitor;
        $this$buildFlowGraph.accept((SqlVisitor)visitor2);
        return visitor2.getFlowGraph();
    }

    public static final void accept(@NotNull SqlFlowGraph $this$accept, @NotNull SqlInstructionVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)$this$accept, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Iterable $this$forEach$iv = $this$accept.getInstructions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlInstruction it2 = (SqlInstruction)element$iv;
            boolean bl = false;
            it2.accept(visitor2);
        }
    }

    @NotNull
    public static final Set<SqlInstruction> findUnreachableInstructions(@NotNull SqlFlowGraph $this$findUnreachableInstructions) {
        Intrinsics.checkNotNullParameter((Object)$this$findUnreachableInstructions, (String)"<this>");
        LinkedHashSet unprocessed = new LinkedHashSet($this$findUnreachableInstructions.getInstructions());
        Stack stack = new Stack();
        stack.push((Object)$this$findUnreachableInstructions.getEntryPoint());
        while (!((Collection)stack).isEmpty()) {
            SqlInstruction instruction2 = (SqlInstruction)stack.pop();
            if (!unprocessed.remove(instruction2)) continue;
            if (instruction2 instanceof SqlEnterSubroutineInstruction) {
                CollectionsKt.addAll((Collection)unprocessed, (Iterable)((SqlEnterSubroutineInstruction)instruction2).getJumpTo().getInstructions());
            }
            if (instruction2 instanceof SqlSubroutineDefinitionInstruction) {
                CollectionsKt.addAll((Collection)unprocessed, (Iterable)FlowUtilKt.findUnreachableInstructions(((SqlSubroutineDefinitionInstruction)instruction2).getFlowGraph()));
            }
            Iterable $this$forEach$iv = instruction2.getSuccessors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlInstruction it2 = (SqlInstruction)element$iv;
                boolean bl = false;
                stack.push((Object)it2);
            }
        }
        return unprocessed;
    }

    @NotNull
    public static final Map<SqlCursorInstruction, Set<CursorState>> computeCursorStates(@NotNull SqlFlowGraph $this$computeCursorStates) {
        Intrinsics.checkNotNullParameter((Object)$this$computeCursorStates, (String)"<this>");
        boolean isInitiallyOpen = SqlImplUtil.getSqlDialectSafe((PsiElement)$this$computeCursorStates.getSource()).getDbms().isGreenplum();
        CursorState initialState = isInitiallyOpen ? CursorState.OPEN : CursorState.CLOSE;
        Map states2 = new LinkedHashMap();
        Iterator iterator = ((JBTreeTraverser)new JBTreeTraverser(arg_0 -> FlowUtilKt.computeCursorStates$lambda$2((Function1)new Function1<SqlInstruction, Iterable<? extends SqlInstruction>>((Map<SqlInstruction, Map<SqlDefinition, Set<CursorState>>>)states2, $this$computeCursorStates){
            final /* synthetic */ Map<SqlInstruction, Map<SqlDefinition, Set<CursorState>>> $states;
            final /* synthetic */ SqlFlowGraph $this_computeCursorStates;
            {
                this.$states = $states;
                this.$this_computeCursorStates = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Iterable<SqlInstruction> invoke(SqlInstruction instr) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNull((Object)instr);
                this.$states.put(instr, (Map<SqlDefinition, Set<CursorState>>)new LinkedHashMap<K, V>());
                Iterable iterable = instr.getPredecessors();
                Map<SqlInstruction, Map<SqlDefinition, Set<CursorState>>> map2 = this.$states;
                SqlFlowGraph sqlFlowGraph = this.$this_computeCursorStates;
                boolean $i$f$filter = false;
                void var6_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    SqlInstruction it2 = (SqlInstruction)element$iv$iv;
                    boolean bl = false;
                    if (!(!map2.containsKey(it2) && Intrinsics.areEqual((Object)it2.getOwnerGraph().getSource(), (Object)sqlFlowGraph.getSource()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }, arg_0)).withRoot((Object)$this$computeCursorStates.getExitPoint())).postOrderDfsTraversal().typedIterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"typedIterator(...)");
        TreeTraversal.TracingIt it2 = (TreeTraversal.TracingIt)iterator;
        Object[] objectArray = new SqlInstruction[]{$this$computeCursorStates.getEntryPoint()};
        Set hasProcessedPathToEntryPoint = SetsKt.mutableSetOf((Object[])objectArray);
        while (it2.advance()) {
            ProgressManager.checkCanceled();
            SqlInstruction inst = (SqlInstruction)it2.current();
            Object v2 = states2.get(inst);
            Intrinsics.checkNotNull(v2);
            Map currentStates = (Map)v2;
            SqlCursorInstruction sqlCursorInstruction = inst instanceof SqlCursorInstruction ? (SqlCursorInstruction)inst : null;
            PsiElement psiElement = sqlCursorInstruction != null && (sqlCursorInstruction = sqlCursorInstruction.getReference()) != null ? sqlCursorInstruction.resolve() : null;
            SqlDefinition currentDef = psiElement instanceof SqlDefinition ? (SqlDefinition)psiElement : null;
            for (SqlInstruction predecessor : inst.getPredecessors()) {
                if (!hasProcessedPathToEntryPoint.contains(predecessor)) continue;
                Intrinsics.checkNotNull((Object)inst);
                hasProcessedPathToEntryPoint.add(inst);
                FlowUtilKt.updateStates(predecessor, currentDef, states2, currentStates, initialState);
            }
        }
        return FlowUtilKt.extractCursorInstructionsStates(states2);
    }

    private static final Map<SqlCursorInstruction, Set<CursorState>> extractCursorInstructionsStates(Map<SqlInstruction, Map<SqlDefinition, Set<CursorState>>> states2) {
        Map cursorInstructionsStates = new LinkedHashMap();
        for (Map.Entry<SqlInstruction, Map<SqlDefinition, Set<CursorState>>> entry : states2.entrySet()) {
            Set<CursorState> s2;
            SqlDefinition def;
            SqlInstruction inst = entry.getKey();
            if (!(inst instanceof SqlCursorInstruction)) continue;
            SqlReferenceExpression sqlReferenceExpression = ((SqlCursorInstruction)inst).getReference();
            Object object = sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null;
            if ((object instanceof SqlDefinition ? (SqlDefinition)object : null) == null) continue;
            def = def;
            if (entry.getValue().get(def) == null) continue;
            cursorInstructionsStates.put(inst, s2);
        }
        return cursorInstructionsStates;
    }

    private static final void updateStates(SqlInstruction predecessor, SqlDefinition currentDef, Map<SqlInstruction, Map<SqlDefinition, Set<CursorState>>> states2, Map<SqlDefinition, Set<CursorState>> currentStates, CursorState initialState) {
        Map map2 = states2.get(predecessor);
        if (map2 == null) {
            map2 = new LinkedHashMap();
        }
        Map prevStates = map2;
        Pair<SqlDefinition, CursorState> pair = FlowUtilKt.getDefinitionAndState(predecessor);
        SqlDefinition prevDef = (SqlDefinition)pair.component1();
        CursorState updatedState = (CursorState)((Object)pair.component2());
        if (currentDef != null && !prevStates.containsKey(currentDef)) {
            Map map3 = prevStates;
            Object object = new CursorState[]{initialState};
            object = SetsKt.mutableSetOf((Object[])object);
            map3.put(currentDef, object);
        }
        FlowUtilKt.merge(currentStates, prevStates, prevDef);
        if (prevDef != null && updatedState != null) {
            Set set;
            Map<SqlDefinition, Set<CursorState>> $this$getOrPut$iv = currentStates;
            boolean $i$f$getOrPut = false;
            Set value$iv = $this$getOrPut$iv.get(prevDef);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(prevDef, answer$iv);
                set = answer$iv;
            } else {
                set = value$iv;
            }
            set.add((CursorState)updatedState);
        }
    }

    private static final void merge(Map<SqlDefinition, Set<CursorState>> to, Map<SqlDefinition, Set<CursorState>> from, SqlDefinition avoid) {
        for (Map.Entry<SqlDefinition, Set<CursorState>> entry : from.entrySet()) {
            Set set;
            SqlDefinition cursor2 = entry.getKey();
            Set<CursorState> cursorStates = entry.getValue();
            if (Intrinsics.areEqual((Object)cursor2, (Object)avoid)) continue;
            Map<SqlDefinition, Set<CursorState>> $this$getOrPut$iv = to;
            boolean $i$f$getOrPut = false;
            Set value$iv = $this$getOrPut$iv.get(cursor2);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(cursor2, answer$iv);
                set = answer$iv;
            } else {
                set = value$iv;
            }
            set.addAll((Collection<CursorState>)cursorStates);
        }
    }

    private static final Pair<SqlDefinition, CursorState> getDefinitionAndState(SqlInstruction inst) {
        SqlDefinition def = null;
        CursorState state = null;
        SqlInstruction sqlInstruction = inst;
        if (sqlInstruction instanceof SqlCursorInstruction) {
            SqlReferenceExpression sqlReferenceExpression = ((SqlCursorInstruction)inst).getReference();
            PsiElement psiElement = sqlReferenceExpression != null ? sqlReferenceExpression.resolve() : null;
            def = psiElement instanceof SqlDefinition ? (SqlDefinition)psiElement : null;
            state = ((SqlCursorInstruction)inst).getOp() == SqlCursorInstruction.CursorOperation.CLOSE ? CursorState.CLOSE : CursorState.OPEN;
        } else if (sqlInstruction instanceof SqlAssignmentInstruction) {
            SqlPseudoValue sqlPseudoValue = ((SqlAssignmentInstruction)inst).getRValue();
            SqlPseudoValueSource sqlPseudoValueSource = sqlPseudoValue != null ? sqlPseudoValue.getSource() : null;
            SqlPseudoValueSource.Psi psi = sqlPseudoValueSource instanceof SqlPseudoValueSource.Psi ? (SqlPseudoValueSource.Psi)sqlPseudoValueSource : null;
            if (!((psi != null ? psi.getElement() : null) instanceof SqlQueryExpression)) {
                def = (SqlDefinition)((SqlAssignmentInstruction)inst).getLValue();
                state = CursorState.UNKNOWN;
            }
        }
        return new Pair(def, state);
    }

    @NotNull
    public static final Collection<SqlInstruction> findExitPoints(@NotNull SqlFlowGraph $this$findExitPoints) {
        Intrinsics.checkNotNullParameter((Object)$this$findExitPoints, (String)"<this>");
        ArrayDeque<SqlInstruction> candidates2 = new ArrayDeque<SqlInstruction>();
        ArrayList result2 = new ArrayList();
        CollectionsKt.addAll((Collection)candidates2, (Iterable)$this$findExitPoints.getExitPoint().getPredecessors());
        CollectionsKt.addAll((Collection)candidates2, (Iterable)$this$findExitPoints.getErrorPoint().getPredecessors());
        while (!((Collection)candidates2).isEmpty()) {
            SqlInstruction candidate2 = (SqlInstruction)candidates2.poll();
            if (candidate2 instanceof SqlJumpInstruction) {
                Iterable $this$forEach$iv = candidate2.getPredecessors();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlInstruction it2 = (SqlInstruction)element$iv;
                    boolean bl = false;
                    candidates2.offer(it2);
                }
                continue;
            }
            ((Collection)result2).add(candidate2);
        }
        return result2;
    }

    @NotNull
    public static final Sequence<SqlFlowGraphBuilder> parentBuilders(@NotNull SqlFlowGraphBuilder $this$parentBuilders) {
        Intrinsics.checkNotNullParameter((Object)$this$parentBuilders, (String)"<this>");
        return SequencesKt.generateSequence((Object)$this$parentBuilders, (Function1)parentBuilders.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<SqlFlowGraph> parentGraphs(@NotNull SqlFlowGraph $this$parentGraphs) {
        Intrinsics.checkNotNullParameter((Object)$this$parentGraphs, (String)"<this>");
        return SequencesKt.generateSequence((Object)$this$parentGraphs, (Function1)parentGraphs.1.INSTANCE);
    }

    private static final Iterable computeCursorStates$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }
}

