/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.CommonBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.DbObjectEditorDialogBase;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.editors.DatabaseEditorBase;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.editors.ObjectEditorWithPreview;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.database.view.ui.ErrorNotificationWrapperPanel;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.ResultProcessorProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class AbstractDbRefactoringDialog<Ed extends DatabaseEditorBaseEx>
extends DialogWrapper
implements ResultProcessorProvider {
    private final Project myProject;
    protected Ed myEditor;
    protected final ObjectEditorWithPreview myEditorPreview;
    protected final DatabaseEditorState myState;
    protected final EditorModelsCache myEditorModelsCache;
    protected final DeModel myModel;
    protected final MyOkAction myNewOkAction;
    protected final PreviewAction myPreviewAction;
    protected final ErrorNotificationWrapperPanel myErrorPanel;
    @Nullable
    private ResultProcessor myProcessor;
    protected boolean myRefactoring;
    protected boolean myPreviewUsages;
    private final JPanel myCentralPanel;

    @NotNull
    public DatabaseEditorState getState() {
        DatabaseEditorState databaseEditorState = this.myState;
        if (databaseEditorState == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(0);
        }
        return databaseEditorState;
    }

    public AbstractDbRefactoringDialog(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(1);
        }
        super(context.getProject(), true);
        this.myPreviewUsages = true;
        this.myProject = context.getProject();
        LocalDataSource ds = DbImplUtil.getMaybeLocalDataSource(context.getDataSource());
        SqlCodeStyleSettings settings = ds != null ? ScriptingTaskBuilderKt.getSqlCodeStyle(ds) : SqlCodeStyles.getSqlSettings((Project)this.myProject, (Language)context.getSqlDialect());
        this.myEditorModelsCache = new EditorModelsCache(settings);
        this.setModal(true);
        this.myModel = AbstractDbRefactoringDialog.createModel(context);
        this.myState = new DatabaseEditorState(context);
        this.myEditorPreview = new ObjectEditorWithPreview();
        this.myEditorPreview.subscribePreviewChanged(new ObjectEditorWithPreview.PreviewListener(){

            @Override
            public void changed() {
                AbstractDbRefactoringDialog.this.updateActions();
            }
        });
        this.myCentralPanel = new JPanel(new BorderLayout());
        this.myErrorPanel = new ErrorNotificationWrapperPanel();
        this.myErrorPanel.add((Component)this.myEditorPreview.getComponent(), "Center");
        this.myCentralPanel.add((Component)this.myErrorPanel, "Center");
        this.myNewOkAction = new MyOkAction();
        this.myPreviewAction = new PreviewAction();
        this.setRefactoring(false);
        this.setResultProcessor(new GenericEditingResultProcessor(this, DbRefactoringHelper.DB_SETTINGS, null));
    }

    public void setOptions(@NotNull ScriptingOptions options2) {
        if (options2 == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(2);
        }
        this.myEditorPreview.setOptions(options2);
    }

    public ScriptingOptions getOptions() {
        ScriptingTask task = this.myEditorPreview.getTask();
        return task == null ? null : task.getOptions();
    }

    public void doCancelAction() {
        if (this.userCancelledCancel()) {
            return;
        }
        super.doCancelAction();
    }

    private boolean userCancelledCancel() {
        return DbObjectEditorDialogBase.userCancelledCancel(this.myProject, this.isModified());
    }

    private boolean isModified() {
        return !this.myEditorPreview.isInvalid() && StringUtil.isNotEmpty((String)this.myEditorPreview.getStatement());
    }

    @Override
    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.myModel;
        if (deModel == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(3);
        }
        return deModel;
    }

    @NotNull
    @NlsContexts.DialogTitle
    protected abstract String getTitle(boolean var1);

    public void finish() {
        this.myEditorPreview.updatePreview();
        this.init();
    }

    public void finishAndShow() {
        this.finish();
        this.show();
    }

    public void setRefactoring(boolean refactoring) {
        this.myRefactoring = refactoring;
        this.setTitle(this.getTitle(refactoring));
    }

    public void setResultProcessor(@NotNull ResultProcessor proc) {
        if (proc == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(4);
        }
        if (this.myEditor != null) {
            throw new AssertionError((Object)"Result processor must be set before editor");
        }
        this.myProcessor = proc;
    }

    @Override
    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myState.context;
        if (databaseEditorContext == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(5);
        }
        return databaseEditorContext;
    }

    protected void setEditor(@NotNull Ed editor2) {
        if (editor2 == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(6);
        }
        if (this.myEditor != null) {
            throw new AssertionError((Object)"Editor is already set");
        }
        if (this.myProcessor == null) {
            throw new AssertionError((Object)"Result processor must be set before editor");
        }
        this.myEditor = editor2;
        Disposer.register((Disposable)this.getDisposable(), editor2);
        this.myEditorPreview.setTrailWidget(this.myProcessor.getPreviewWidget());
        JComponent settings = this.myProcessor.getSettingsPanel();
        if (settings != null) {
            this.myCentralPanel.add((Component)settings, "South");
        }
        this.myEditorPreview.setEditor((DatabaseEditorBaseEx)editor2, this.myProcessor.createTraverser(((DatabaseEditorBase)editor2).getModel()));
        this.setTitle(this.getTitle(this.myRefactoring));
    }

    @Override
    public void settingsChanged() {
        this.myEditorPreview.updatePreview();
    }

    public boolean isValid() {
        return ((DatabaseEditorBase)this.myEditor).areEditorsValid();
    }

    @Override
    @NotNull
    public JBIterable<Pair<PsiElement, String>> collectRenames() {
        if (!this.myRefactoring) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                AbstractDbRefactoringDialog.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }
        JBIterable<Pair<PsiElement, String>> jBIterable = DbRenamePsiElementProcessor.collectRenameElements(this.myModel, this.getContext().getDataSource());
        if (jBIterable == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @Override
    public Project getProject() {
        return this.getContext().getProject();
    }

    @NotNull
    public static DeModel createModel(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(9);
        }
        SchemaEditor editor2 = context.getSchemaEditor();
        DeModel model2 = editor2.createModel(context, context.getModel());
        return new DeModel(model2);
    }

    @NotNull
    private <De extends DeObject> De exportImpl(@NotNull BasicElement obj2, boolean withChildren) {
        if (obj2 == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(10);
        }
        Object De = this.myModel.getExportHelper().exportDeep(this.getContext().getModel(), obj2, withChildren);
        if (De == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(11);
        }
        return De;
    }

    @NotNull
    public <De extends DeObject> De export(@NotNull BasicElement obj2, boolean withChildren) {
        if (obj2 == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(12);
        }
        return this.exportImpl(obj2, withChildren);
    }

    @Contract(value="!null, _ -> !null")
    public <De extends DeObject> De exportOp(@Nullable BasicElement obj2, boolean withChildren) {
        return obj2 == null ? null : (De)this.export(obj2, withChildren);
    }

    protected Action @NotNull [] createActions() {
        Object[] actions = super.createActions();
        if (!this.myRefactoring) {
            if (actions == null) {
                AbstractDbRefactoringDialog.$$$reportNull$$$0(13);
            }
            return actions;
        }
        int idx = 0;
        if (actions.length != 0) {
            idx = actions[0] == this.getOKAction() ? 1 : actions.length - 1;
        }
        Action[] actionArray = (Action[])ArrayUtil.insert((Object[])actions, (int)idx, (Object)this.getPreviewAction());
        if (actionArray == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(14);
        }
        return actionArray;
    }

    protected void updateActions() {
        boolean valid = this.isRefactoringValid();
        this.setOKActionEnabled(valid);
        this.getPreviewAction().setEnabled(valid && !this.collectRenames().isEmpty());
        this.myNewOkAction.updateText();
        if (this.myProcessor != null) {
            this.myProcessor.update();
        }
    }

    public void setOKActionEnabled(boolean isEnabled) {
        this.getOKAction().setEnabled(isEnabled);
    }

    @NotNull
    protected Action getOKAction() {
        MyOkAction myOkAction = this.myNewOkAction;
        if (myOkAction == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(15);
        }
        return myOkAction;
    }

    private Action getPreviewAction() {
        return this.myPreviewAction;
    }

    protected boolean isRefactoringValid() {
        return !this.myEditorPreview.isInvalid() && !StringUtil.isEmptyOrSpaces((String)this.statement());
    }

    protected void doOKAction() {
        this.processDoNotAskOnOk(0);
        if (this.myProcessor != null && this.getOKAction().isEnabled()) {
            this.myProcessor.process().whenComplete(AsyncUtil.getEdtExecutor(), (r, th) -> {
                if (th != null) {
                    if (!(th instanceof GenericEditingResultProcessor.AbortedByUserException)) {
                        this.myErrorPanel.reportError(th.getMessage());
                    }
                } else {
                    this.close(Boolean.TRUE.equals(r) ? 0 : 1);
                }
            });
        }
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return AbstractDbRefactoringDialog.class.getName();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCentralPanel;
    }

    @Override
    @NotNull
    public String statement() {
        String string = this.myEditorPreview.getStatement();
        if (string == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditorPreview.getPreferredFocusedComponent();
    }

    protected void checkObjectInContext(@Nullable DasObject object) {
        DasObject o2 = DbUtil.getDasObject(object);
        BasicModel model2 = this.getContext().getModel();
        if (object != null && model2 != null && ((JBTreeTraverser)model2.traverser().filter(Conditions.is((Object)o2))).bfsTraversal().first() == null) {
            throw new AssertionError((Object)("Object " + object.getName() + " " + object.getClass().getName() + " " + object + " not in context"));
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo info2 = super.doValidate();
        if (info2 != null || this.myProcessor == null) {
            return info2;
        }
        return this.myProcessor.validate();
    }

    @Override
    public boolean isPreviewUsages() {
        return this.myPreviewUsages;
    }

    @NotNull
    public Ed getEditor() {
        Ed Ed = this.myEditor;
        if (Ed == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(17);
        }
        return Ed;
    }

    @TestOnly
    @NotNull
    public ResultProcessor getProcessor() {
        ResultProcessor resultProcessor = Objects.requireNonNull(this.myProcessor);
        if (resultProcessor == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(18);
        }
        return resultProcessor;
    }

    @NotNull
    public DatabaseEditorBaseEx getActiveEditor() {
        Ed Ed = this.myEditor;
        if (Ed == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(19);
        }
        return Ed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 6, 9, 10, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/AbstractDbRefactoringDialog";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/AbstractDbRefactoringDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRenames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "exportImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "statement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setResultProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "exportImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 6, 9, 10, 12 -> new IllegalArgumentException(string);
        };
    }

    private class MyOkAction
    extends DialogWrapper.OkAction {
        private MyOkAction() {
            super((DialogWrapper)AbstractDbRefactoringDialog.this);
        }

        public void updateText() {
            this.putValue("Name", AbstractDbRefactoringDialog.this.myProcessor == null ? CommonBundle.getOkButtonText() : AbstractDbRefactoringDialog.this.myProcessor.getCurrentAction());
        }

        public boolean isEnabled() {
            return super.isEnabled() && AbstractDbRefactoringDialog.this.isRefactoringValid();
        }

        protected void doAction(ActionEvent e2) {
            AbstractDbRefactoringDialog.this.myPreviewUsages = false;
            super.doAction(e2);
        }
    }

    private class PreviewAction
    extends DialogWrapper.OkAction {
        PreviewAction() {
            super((DialogWrapper)AbstractDbRefactoringDialog.this);
            this.putValue("Name", RefactoringBundle.message((String)"preview.button"));
            this.putValue("Default", false);
            if (SystemInfo.isMac) {
                this.putValue("FocusedAction", Boolean.TRUE);
            }
        }

        public void actionPerformed(ActionEvent e2) {
            AbstractDbRefactoringDialog.this.myPreviewUsages = true;
            super.doAction(e2);
        }
    }

    public static interface ResultProcessor {
        @Nullable
        public JComponent getPreviewWidget();

        @NotNull
        public AsyncTask<?> process();

        @NotNull
        public DdlPreview.ModelTraverser createTraverser(@NotNull EditorModelBase var1);

        @Nullable
        public JComponent getSettingsPanel();

        @Nls
        public String getCurrentAction();

        public void update();

        public ValidationInfo validate();
    }
}

