/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.Dbms;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.util.common.MapFun;
import com.intellij.database.view.structure.DvTreeAbstractLayer;
import com.intellij.database.view.structure.DvTreeCacheLayer;
import com.intellij.database.view.structure.DvTreeContext;
import com.intellij.database.view.structure.DvTreeDsFoldersLayer;
import com.intellij.database.view.structure.DvTreeFundamentLayer;
import com.intellij.database.view.structure.DvTreeImplantingLayer;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvTreeLayoutLayer;
import com.intellij.database.view.structure.DvTreeModelLayer;
import com.intellij.database.view.structure.DvTreeOptimizationLayer;
import com.intellij.database.view.structure.DvTreeRootLayer;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvTreeTransformLayer;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0005\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%2\u0006\u0010'\u001a\u00020&J\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020&J\u000e\u0010,\u001a\u00020+2\u0006\u0010'\u001a\u00020&J\u000e\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\u0014J\u0018\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\rH\u0002J\u000e\u00100\u001a\u00020)2\u0006\u0010.\u001a\u00020\u0014J\"\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\u00142\b\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u000104J\u000e\u00106\u001a\u00020)2\u0006\u0010.\u001a\u00020\u0014J\u0018\u00106\u001a\u00020)2\u0006\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\rH\u0002J\u0013\u00107\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u00108J\u0019\u00109\u001a\b\u0012\u0004\u0012\u00020&0\b2\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0002\u0010:J#\u0010;\u001a\b\u0012\u0004\u0012\u00020&0\b2\u0006\u0010'\u001a\u00020&2\u0006\u0010<\u001a\u00020+H\u0002\u00a2\u0006\u0002\u0010=J\u0006\u0010>\u001a\u00020&J\u0006\u0010?\u001a\u00020\u000eJ\u000e\u0010@\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020&J\u000e\u0010A\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020&J\u0010\u0010B\u001a\u00020\u00162\u0006\u0010C\u001a\u00020DH\u0007J\u000e\u0010E\u001a\u00020)2\u0006\u0010.\u001a\u00020\u0014J\u0010\u0010F\u001a\u00020)2\u0006\u00102\u001a\u00020\u0014H\u0002J\u0010\u0010G\u001a\u00020)2\u0006\u00102\u001a\u00020\u0014H\u0002J$\u0010H\u001a\u00020)2\u0006\u00102\u001a\u00020\u00142\b\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u000104H\u0002J\u0010\u0010I\u001a\u00020)2\u0006\u00102\u001a\u00020\u0014H\u0002J\u0018\u0010J\u001a\u00020)2\u0006\u00102\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\rH\u0002J\u0006\u0010K\u001a\u00020)J\u0010\u0010L\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020&J\u0013\u0010M\u001a\u00070N\u00a2\u0006\u0002\bO2\u0006\u0010'\u001a\u00020&J\u0010\u0010P\u001a\u00020)2\u0006\u0010/\u001a\u00020\rH\u0002J\b\u0010Q\u001a\u00020)H\u0002R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0004\n\u0002\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0018\"\u0004\b\u001f\u0010\u001aR\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"R\u000e\u0010#\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructure;", "", "project", "Lcom/intellij/openapi/project/Project;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/view/structure/DvViewOptions;)V", "activeLayers", "", "Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "[Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "actualDbms", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/database/Dbms;", "", "context", "Lcom/intellij/database/view/structure/DvTreeContext;", "getContext", "()Lcom/intellij/database/view/structure/DvTreeContext;", "dsDbms", "Lcom/intellij/database/model/RawDataSource;", "foldersLayer", "Lcom/intellij/database/view/structure/DvTreeLayer;", "getFoldersLayer", "()Lcom/intellij/database/view/structure/DvTreeLayer;", "setFoldersLayer", "(Lcom/intellij/database/view/structure/DvTreeLayer;)V", "fundamentLayer", "Lcom/intellij/database/view/structure/DvTreeFundamentLayer;", "layoutLayer", "getLayoutLayer", "setLayoutLayer", "storeyLayers", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "[Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "upperLayer", "childrenOf", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicNode;", "node", "clearAll", "", "countAllChildrenOf", "", "countRealChildrenOf", "dataSourceAdded", "ds", "dbms", "dataSourceChanged", "dataSourceModelReplaced", "dataSource", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "dataSourceRemoved", "getActiveLayers", "()[Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "getPath", "(Lcom/intellij/database/model/basic/BasicNode;)[Lcom/intellij/database/model/basic/BasicNode;", "getPathArray", "depth", "(Lcom/intellij/database/model/basic/BasicNode;I)[Lcom/intellij/database/model/basic/BasicNode;", "getRootNode", "hasDataSourcesThatSupportMultilevel", "isAlwaysLeaf", "isValid", "layer", "level", "", "notifyDataSourcePathChanged", "onDataSourceAdded", "onDataSourceChanged", "onDataSourceModelReplaced", "onDataSourcePathChanged", "onDataSourceRemoved", "onViewOptionsChanged", "parentOf", "presentableNameOf", "", "Lcom/intellij/openapi/util/NlsSafe;", "recheckDbms", "setupLayers", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeStructure.kt\ncom/intellij/database/view/structure/DvTreeStructure\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArrayFun.kt\ncom/intellij/database/util/common/ArrayFun\n*L\n1#1,217:1\n37#2,2:218\n13309#3,2:220\n13309#3,2:222\n13309#3,2:224\n13309#3,2:226\n13309#3,2:228\n10#4,2:230\n10#4,2:232\n*S KotlinDebug\n*F\n+ 1 DvTreeStructure.kt\ncom/intellij/database/view/structure/DvTreeStructure\n*L\n62#1:218,2\n112#1:220,2\n116#1:222,2\n120#1:224,2\n124#1:226,2\n128#1:228,2\n132#1:230,2\n202#1:232,2\n*E\n"})
public class DvTreeStructure {
    @NotNull
    private final DvTreeContext context;
    @NotNull
    private final DvTreeFundamentLayer fundamentLayer;
    @NotNull
    private final DvTreeStoreyLayer[] storeyLayers;
    private DvTreeAbstractLayer[] activeLayers;
    private DvTreeLayer upperLayer;
    @NotNull
    private final ConcurrentHashMap<RawDataSource, Dbms> dsDbms;
    @NotNull
    private final ConcurrentHashMap<Dbms, Boolean> actualDbms;
    @ApiStatus.Internal
    public DvTreeLayer layoutLayer;
    @ApiStatus.Internal
    public DvTreeLayer foldersLayer;

    public DvTreeStructure(@NotNull Project project, @NotNull DvViewOptions viewOptions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        this.context = new DvTreeContext(project, viewOptions);
        this.fundamentLayer = new DvTreeRootLayer();
        DvTreeStoreyLayer[] dvTreeStoreyLayerArray = new DvTreeStoreyLayer[]{new DvTreeModelLayer(), new DvTreeDsFoldersLayer(), new DvTreeImplantingLayer(), new DvTreeLayoutLayer(), new DvTreeTransformLayer(), new DvTreeOptimizationLayer(), new DvTreeCacheLayer()};
        this.storeyLayers = dvTreeStoreyLayerArray;
        this.dsDbms = new ConcurrentHashMap();
        this.actualDbms = new ConcurrentHashMap();
        this.setupLayers();
    }

    @NotNull
    public final DvTreeContext getContext() {
        return this.context;
    }

    private final void setupLayers() {
        ArrayList layers = new ArrayList();
        this.fundamentLayer.setup$intellij_database_core_impl(this.context);
        ((Collection)layers).add(this.fundamentLayer);
        DvTreeAbstractLayer currentLayer = this.fundamentLayer;
        for (DvTreeStoreyLayer layer : this.storeyLayers) {
            layer.setup$intellij_database_core_impl(currentLayer);
            ((Collection)layers).add(layer);
            currentLayer = layer;
            DvTreeStoreyLayer dvTreeStoreyLayer = layer;
            if (dvTreeStoreyLayer instanceof DvTreeDsFoldersLayer) {
                this.setFoldersLayer(layer);
                continue;
            }
            if (!(dvTreeStoreyLayer instanceof DvTreeLayoutLayer)) continue;
            this.setLayoutLayer(layer);
        }
        this.upperLayer = currentLayer;
        Collection $this$toTypedArray$iv = layers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.activeLayers = thisCollection$iv.toArray(new DvTreeAbstractLayer[0]);
    }

    @NotNull
    public final DvTreeLayer getLayoutLayer() {
        DvTreeLayer dvTreeLayer = this.layoutLayer;
        if (dvTreeLayer != null) {
            return dvTreeLayer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"layoutLayer");
        return null;
    }

    public final void setLayoutLayer(@NotNull DvTreeLayer dvTreeLayer) {
        Intrinsics.checkNotNullParameter((Object)dvTreeLayer, (String)"<set-?>");
        this.layoutLayer = dvTreeLayer;
    }

    @NotNull
    public final DvTreeLayer getFoldersLayer() {
        DvTreeLayer dvTreeLayer = this.foldersLayer;
        if (dvTreeLayer != null) {
            return dvTreeLayer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"foldersLayer");
        return null;
    }

    public final void setFoldersLayer(@NotNull DvTreeLayer dvTreeLayer) {
        Intrinsics.checkNotNullParameter((Object)dvTreeLayer, (String)"<set-?>");
        this.foldersLayer = dvTreeLayer;
    }

    @NotNull
    public final BasicNode getRootNode() {
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.getRoot();
    }

    @Nullable
    public final BasicNode parentOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.parentOf(node2);
    }

    @NotNull
    public final JBIterable<? extends BasicNode> childrenOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.childrenOf(node2);
    }

    public final int countAllChildrenOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.countAllChildrenOf(node2);
    }

    public final int countRealChildrenOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.countRealChildrenOf(node2);
    }

    public final boolean isAlwaysLeaf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.isAlwaysLeaf(node2);
    }

    @NotNull
    public final String presentableNameOf(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.presentableNameOf(node2);
    }

    public final boolean isValid(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.isValid(node2);
    }

    @NotNull
    public final BasicNode[] getPath(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return this.getPathArray(node2, 1);
    }

    private final BasicNode[] getPathArray(BasicNode node2, int depth) {
        BasicNode p2 = this.parentOf(node2);
        if (p2 == node2) {
            throw new InternalError("The method DvTreeStructureService.parentOf() works incorrectly for node: " + node2 + " (node class: " + node2.getClass().getSimpleName() + ")");
        }
        if (p2 == null) {
            BasicNode[] result2 = new BasicNode[depth];
            result2[0] = node2;
            return result2;
        }
        BasicNode[] result3 = this.getPathArray(p2, depth + 1);
        result3[result3.length - depth] = node2;
        return result3;
    }

    public final boolean hasDataSourcesThatSupportMultilevel() {
        return MapFun.containsKeys((Map)this.actualDbms, hasDataSourcesThatSupportMultilevel.1.INSTANCE);
    }

    public final void onViewOptionsChanged() {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it2 = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it2.onViewOptionsChanged$intellij_database_core_impl();
        }
    }

    private final void onDataSourceAdded(RawDataSource dataSource2) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it2 = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it2.onDataSourceAdded$intellij_database_core_impl(dataSource2);
        }
    }

    private final void onDataSourcePathChanged(RawDataSource dataSource2) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it2 = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it2.onDataSourcePathChanged$intellij_database_core_impl(dataSource2);
        }
    }

    private final void onDataSourceModelReplaced(RawDataSource dataSource2, BasicModel oldModel, BasicModel newModel) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it2 = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it2.onDataSourceModelReplaced$intellij_database_core_impl(dataSource2, oldModel, newModel);
        }
    }

    private final void onDataSourceChanged(RawDataSource dataSource2) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it2 = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it2.onDataSourceChanged$intellij_database_core_impl(dataSource2);
        }
    }

    private final void onDataSourceRemoved(RawDataSource dataSource2, Dbms dbms) {
        Object[] objectArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            objectArray = null;
        }
        Object[] $this$forEachReversed$iv = objectArray;
        boolean $i$f$forEachReversed = false;
        for (int i$iv = ArraysKt.getLastIndex((Object[])$this$forEachReversed$iv); -1 < i$iv; --i$iv) {
            Object it2 = $this$forEachReversed$iv[i$iv];
            boolean bl = false;
            ((DvTreeAbstractLayer)it2).onDataSourceRemoved$intellij_database_core_impl(dataSource2, dbms);
        }
    }

    public final void dataSourceAdded(@NotNull RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Dbms dbms = ds.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        this.dataSourceAdded(ds, dbms);
    }

    private final void dataSourceAdded(RawDataSource ds, Dbms dbms) {
        ((Map)this.dsDbms).put(ds, dbms);
        ((Map)this.actualDbms).put(dbms, true);
        this.onDataSourceAdded(ds);
    }

    public final void notifyDataSourcePathChanged(@NotNull RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        this.onDataSourcePathChanged(ds);
    }

    public final void dataSourceModelReplaced(@NotNull RawDataSource dataSource2, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        this.onDataSourceModelReplaced(dataSource2, oldModel, newModel);
    }

    public final void dataSourceChanged(@NotNull RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Dbms dbms = ds.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms newDbms = dbms;
        Dbms oldDbms = this.dsDbms.get(ds);
        if (oldDbms == null) {
            this.dataSourceAdded(ds, newDbms);
        } else if (!Intrinsics.areEqual((Object)oldDbms, (Object)newDbms)) {
            this.dataSourceRemoved(ds, oldDbms);
            this.dataSourceAdded(ds, newDbms);
        } else {
            this.onDataSourceChanged(ds);
        }
    }

    public final void dataSourceRemoved(@NotNull RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Dbms dbms = ds.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        this.dataSourceRemoved(ds, dbms);
    }

    private final void dataSourceRemoved(RawDataSource ds, Dbms dbms) {
        this.dsDbms.remove(ds);
        this.onDataSourceRemoved(ds, dbms);
        if (this.actualDbms.containsKey(dbms)) {
            this.recheckDbms(dbms);
        }
    }

    private final void recheckDbms(Dbms dbms) {
        boolean exists = this.dsDbms.containsValue(dbms);
        if (exists) {
            ((Map)this.actualDbms).put(dbms, true);
        } else {
            this.actualDbms.remove(dbms);
        }
    }

    public final void clearAll() {
        Object[] objectArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            objectArray = null;
        }
        Object[] $this$forEachReversed$iv = objectArray;
        boolean $i$f$forEachReversed = false;
        for (int i$iv = ArraysKt.getLastIndex((Object[])$this$forEachReversed$iv); -1 < i$iv; --i$iv) {
            Object it2 = $this$forEachReversed$iv[i$iv];
            boolean bl = false;
            ((DvTreeAbstractLayer)it2).clearAll();
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public final DvTreeLayer layer(byte level) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        for (DvTreeAbstractLayer layer : dvTreeAbstractLayerArray) {
            if (layer.getLevel() != level) continue;
            return layer;
        }
        throw new IllegalArgumentException("No layer with level " + level);
    }

    @ApiStatus.Internal
    @NotNull
    public final DvTreeAbstractLayer[] getActiveLayers() {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        return (DvTreeAbstractLayer[])dvTreeAbstractLayerArray.clone();
    }
}

