/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.lang.LanguageUtil;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseEditorContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Dbms myDbms;
    @NotNull
    private final DatabaseDialectEx myDialect;
    @Nullable
    private final BasicModel myModel;
    @Nullable
    private final DbDataSource myDataSource;
    @Nullable
    private final SearchPath mySearchPath;
    @Nullable
    private final VirtualFile myVirtualFile;
    @Nullable
    private final Map<? extends DasObject, Pointer<DasObject>> myMapping;
    @NotNull
    private final SchemaEditor mySchemaEditor;
    @Nullable
    public final Grants.Controller<?, ?> myGrantController;

    public DatabaseEditorContext(@NotNull DbElement element2, @Nullable VirtualFile virtualFile) {
        if (element2 == null) {
            DatabaseEditorContext.$$$reportNull$$$0(0);
        }
        this(element2, ObjectPaths.searchPathOf(DbImplUtilCore.getSearchPathObjectForSwitch(element2)), virtualFile);
    }

    public DatabaseEditorContext(@NotNull DbElement element2, @Nullable SearchPath searchPath, @Nullable VirtualFile virtualFile) {
        if (element2 == null) {
            DatabaseEditorContext.$$$reportNull$$$0(1);
        }
        this(element2.getDataSource().getProject(), element2.getDataSource().getDbms(), (BasicModel)ObjectUtils.tryCast((Object)element2.getDataSource().getModel(), BasicModel.class), element2.getDataSource(), searchPath == null ? ObjectPaths.searchPathOf(DbImplUtilCore.getSearchPathObjectForSwitch(element2)) : searchPath, virtualFile, null);
    }

    private DatabaseEditorContext(@NotNull SqlFile file) {
        if (file == null) {
            DatabaseEditorContext.$$$reportNull$$$0(2);
        }
        this(file, DbImplUtilCore.getForcedDataSource((PsiFile)file), null, null);
    }

    private DatabaseEditorContext(@NotNull SqlFile file, @Nullable DbDataSource dataSource2, @Nullable BasicModel model2, @Nullable Map<? extends DasObject, Pointer<DasObject>> mapping) {
        if (file == null) {
            DatabaseEditorContext.$$$reportNull$$$0(3);
        }
        this(file.getProject(), file.getSqlLanguage().getDbms(), model2, dataSource2, DatabaseEditorHelperCore.getSearchPath((PsiFile)file), DatabaseEditorContext.getWritableFile(file), mapping);
    }

    public DatabaseEditorContext(@NotNull Project project, @NotNull Dbms dbms) {
        if (project == null) {
            DatabaseEditorContext.$$$reportNull$$$0(4);
        }
        if (dbms == null) {
            DatabaseEditorContext.$$$reportNull$$$0(5);
        }
        this(project, dbms, null, null, null, null, null);
    }

    @Nullable
    private static VirtualFile getWritableFile(@NotNull SqlFile file) {
        VirtualFile vfile;
        if (file == null) {
            DatabaseEditorContext.$$$reportNull$$$0(6);
        }
        return (vfile = file.getViewProvider().getVirtualFile()).isWritable() ? vfile : null;
    }

    @NotNull
    public static DatabaseEditorContext forFile(@NotNull SqlFile file, boolean light) {
        DbDataSource forced;
        if (file == null) {
            DatabaseEditorContext.$$$reportNull$$$0(7);
        }
        JBIterable<DbDataSource> dataSources2 = (forced = DbImplUtilCore.getForcedDataSource((PsiFile)file)) == null ? DbSqlUtilCore.getAppropriateDataSources((PsiFile)file, false, true) : JBIterable.of((Object)forced);
        for (DbDataSource dataSource2 : dataSources2) {
            SqlDataSource sqlSource = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), SqlDataSource.class);
            if (sqlSource == null || !sqlSource.containsFile(PsiUtilCore.getVirtualFile((PsiElement)file))) continue;
            return new DatabaseEditorContext(dataSource2, file.getVirtualFile());
        }
        if (light) {
            return new DatabaseEditorContext(file);
        }
        BasicModModel model2 = new ModelFactory(new MemoryTextStorage()).createModel(file.getSqlLanguage().getDbms());
        Map mapping = SqlPsiFacade.getInstance((Project)file.getProject()).buildModel((DasModel)model2, Collections.singletonList(file), null);
        return new DatabaseEditorContext(file, (DbDataSource)dataSources2.first(), model2, mapping);
    }

    public DatabaseEditorContext(@NotNull Project project, @NotNull Dbms dbms, @Nullable BasicModel model2, @Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath, @Nullable VirtualFile virtualFile, @Nullable Map<? extends DasObject, Pointer<DasObject>> mapping) {
        if (project == null) {
            DatabaseEditorContext.$$$reportNull$$$0(8);
        }
        if (dbms == null) {
            DatabaseEditorContext.$$$reportNull$$$0(9);
        }
        this.myProject = project;
        this.myDbms = model2 == null ? dbms : model2.getDbms();
        this.myModel = model2;
        this.myDataSource = dataSource2;
        this.mySearchPath = searchPath;
        this.myVirtualFile = virtualFile;
        this.myMapping = mapping;
        this.myDialect = DbImplUtilCore.getDatabaseDialect(this.myDbms);
        this.mySchemaEditor = SchemaEditor.forDbms(this.myDbms);
        this.myGrantController = ModelFacade.forDbms(this.myDbms).getModelHelper().getGrantController();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DatabaseEditorContext.$$$reportNull$$$0(10);
        }
        return project;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            DatabaseEditorContext.$$$reportNull$$$0(11);
        }
        return dbms;
    }

    @NotNull
    public final DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = this.myDialect;
        if (databaseDialectEx == null) {
            DatabaseEditorContext.$$$reportNull$$$0(12);
        }
        return databaseDialectEx;
    }

    @NotNull
    public SchemaEditor getSchemaEditor() {
        SchemaEditor schemaEditor = this.mySchemaEditor;
        if (schemaEditor == null) {
            DatabaseEditorContext.$$$reportNull$$$0(13);
        }
        return schemaEditor;
    }

    @Nullable
    public Map<? extends DasObject, Pointer<DasObject>> getMapping() {
        return this.myMapping;
    }

    @NotNull
    public NamingService getNamingService() {
        NamingService namingService2 = NamingServices.getNamingService(this.myDbms, this.myModel);
        if (namingService2 == null) {
            DatabaseEditorContext.$$$reportNull$$$0(14);
        }
        return namingService2;
    }

    @NotNull
    public SqlLanguageDialect getSqlDialect() {
        SqlLanguageDialect dialect;
        if (this.myDataSource != null) {
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(this.myDataSource);
            if (sqlLanguageDialect == null) {
                DatabaseEditorContext.$$$reportNull$$$0(15);
            }
            return sqlLanguageDialect;
        }
        if (this.myVirtualFile != null && (dialect = (SqlLanguageDialect)ObjectUtils.tryCast((Object)LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)this.myVirtualFile), SqlLanguageDialect.class)) != null) {
            SqlLanguageDialect sqlLanguageDialect = dialect;
            if (sqlLanguageDialect == null) {
                DatabaseEditorContext.$$$reportNull$$$0(16);
            }
            return sqlLanguageDialect;
        }
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(this.myDbms);
        if (sqlLanguageDialect == null) {
            DatabaseEditorContext.$$$reportNull$$$0(17);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public BasicModel getModel() {
        return this.myModel;
    }

    @NotNull
    public CasingProvider getCasingProvider() {
        CasingProvider casingProvider = (CasingProvider)ObjectUtils.chooseNotNull((Object)this.getModel(), (Object)DbImplUtilCore.getDatabaseDialect(this.myDbms));
        if (casingProvider == null) {
            DatabaseEditorContext.$$$reportNull$$$0(18);
        }
        return casingProvider;
    }

    @Nullable
    public DbDataSource getDataSource() {
        return this.myDataSource;
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Nullable
    public VirtualFile getOrCreateVirtualFile() {
        if (this.myVirtualFile != null) {
            return this.myVirtualFile;
        }
        if (this.myDataSource != null) {
            return DbVFSUtils.getInstance().getConsoleVirtualFile(this.myDataSource);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13, 14, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorContext";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaEditor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamingService";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getWritableFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13, 14, 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }
}

