/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0007\u001a#\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/view/RenameHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/basic/BasicModModel;)V", "revDeps", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/model/basic/BasicElement;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "scriptingService", "Lcom/intellij/database/script/generator/ScriptGenerator;", "fixReferences", "", "e", "old", "", "rename", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "newName", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nRenameHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameHelper.kt\ncom/intellij/database/view/RenameHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1855#2,2:45\n1855#2,2:47\n1#3:49\n*S KotlinDebug\n*F\n+ 1 RenameHelper.kt\ncom/intellij/database/view/RenameHelper\n*L\n15#1:45,2\n42#1:47,2\n*E\n"})
public final class RenameHelper {
    @NotNull
    private final Project project;
    @NotNull
    private final BasicModModel model;
    @NotNull
    private final ScriptGenerator scriptingService;
    @NotNull
    private final MultiMap<BasicElement, BasicElement> revDeps;

    public RenameHelper(@NotNull Project project, @NotNull BasicModModel model2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.project = project;
        this.model = model2;
        this.scriptingService = ScriptGenerators.INSTANCE.byModel(this.model);
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet(...)");
        this.revDeps = multiMap;
        for (BasicElement e2 : this.model.basicTraverser()) {
            Iterable<? extends BasicElement> $this$forEach$iv;
            Intrinsics.checkNotNullExpressionValue(e2.getPredecessors(), (String)"getPredecessors(...)");
            boolean $i$f$forEach = false;
            Iterator<? extends BasicElement> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                BasicElement element$iv;
                BasicElement it2 = element$iv = iterator.next();
                boolean bl = false;
                if (it2 == null) continue;
                this.revDeps.putValue((Object)it2, (Object)e2);
            }
        }
    }

    public final void rename(@NotNull BasicModNamedElement e2, @NotNull String newName) {
        CompositeText src2;
        BasicModSourceAware sa;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        if (Intrinsics.areEqual((Object)e2.getName(), (Object)newName)) {
            return;
        }
        BasicModSourceAware basicModSourceAware = sa = e2 instanceof BasicModSourceAware ? (BasicModSourceAware)e2 : null;
        CompositeText compositeText = src2 = basicModSourceAware != null ? basicModSourceAware.getSourceTextOrPlaceholder() : null;
        if (src2 != null) {
            this.model.writeSources(() -> RenameHelper.rename$lambda$4(sa, this, e2, newName, src2));
        } else {
            this.fixReferences(e2, newName);
            e2.setName(newName);
        }
    }

    private final void fixReferences(BasicElement e2, String old2) {
        Collection collection2 = this.revDeps.get((Object)e2);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
        Iterable $this$forEach$iv = collection2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement it2 = (BasicElement)element$iv;
            boolean bl = false;
            BasicModElement basicModElement = it2 instanceof BasicModElement ? (BasicModElement)it2 : null;
            if (basicModElement == null) continue;
            basicModElement.fixReference(e2, old2);
        }
    }

    private static final void rename$lambda$4(BasicModSourceAware $sa, RenameHelper this$0, BasicModNamedElement $e, String $newName, CompositeText $src) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
            Intrinsics.checkNotNullParameter((Object)$newName, (String)"$newName");
            $sa.setSourceText(null);
            this$0.fixReferences($e, $newName);
            $e.setName($newName);
            $sa.setSourceText($src);
            CompositeText compositeText = this$0.scriptingService.reviseSource(this$0.project, $sa);
            if (compositeText != null) {
                CompositeText it2 = compositeText;
                boolean bl = false;
                $sa.setSourceText(it2);
            }
            ModFamily modFamily = (ModFamily)$e.familyOf(ObjectKind.BODY);
            BasicModElement basicModElement = modFamily != null ? (BasicModElement)CollectionsKt.firstOrNull((Iterable)modFamily) : null;
            BasicModSourceAware basicModSourceAware = basicModElement instanceof BasicModSourceAware ? (BasicModSourceAware)basicModElement : null;
            if (basicModSourceAware == null) break block2;
            BasicModSourceAware body2 = basicModSourceAware;
            boolean bl = false;
            CompositeText compositeText2 = this$0.scriptingService.reviseSource(this$0.project, body2);
            if (compositeText2 != null) {
                CompositeText it3 = compositeText2;
                boolean bl2 = false;
                body2.setSourceText(it3);
            }
        }
    }
}

