/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiLevelSchema;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.LevelFun;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.common.CalendarFun;
import com.intellij.database.util.common.StringFun;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseDocumentationService;
import com.intellij.database.view.structure.DvDsGroup;
import com.intellij.model.Pointer;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationContent;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.JBTreeTraverser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 -2\u00020\u0001:\u0003-./B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J=\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u001c\u0010\u0010\u001a\u0018\u0012\u0004\u0012\u0002H\r\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\u0004\u0012\u00020\u00140\u0011H\u0002\u00a2\u0006\u0002\u0010\u0015J[\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u001c\u0010\u0010\u001a\u0018\u0012\u0004\u0012\u0002H\r\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\u0004\u0012\u00020\u00140\u00112\u001c\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u0002H\r\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\u0004\u0012\u00020\u00140\u0011H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u000eJ$\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0014\u0010\u001c\u001a\u00100\u0012j\u0007`\u0013\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b\u001dJ&\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0014\u0010\u001c\u001a\u00100\u0012j\u0007`\u0013\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b\u001dH\u0002J\u001c\u0010 \u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010\u001c\u001a\u00060\u0012j\u0002`\u0013H\u0002J&\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\u0014\u0010\u001c\u001a\u00100\u0012j\u0007`\u0013\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b\u001dH\u0002J&\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0014\u0010\u001c\u001a\u00100\u0012j\u0007`\u0013\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b\u001dH\u0002J \u0010'\u001a\n (*\u0004\u0018\u00010\u00120\u0012*\u00060\u0012j\u0002`\u00132\u0006\u0010)\u001a\u00020*H\u0002J \u0010+\u001a\n (*\u0004\u0018\u00010\u00120\u0012*\u00060\u0012j\u0002`\u00132\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010,\u001a\n (*\u0004\u0018\u00010\u00120\u0012*\u00060\u0012j\u0002`\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00060"}, d2={"Lcom/intellij/database/view/DatabaseDocumentationService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "gatherDataSourceStatistics", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "prepare", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "N", "Lcom/intellij/database/model/basic/BasicNode;", "node", "fastProducer", "Lkotlin/Function2;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "(Lcom/intellij/database/model/basic/BasicNode;Lkotlin/jvm/functions/Function2;)Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "slowProducer", "(Lcom/intellij/database/model/basic/BasicNode;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "prepareQuickDoc", "produceForDataSourceFast", "ds", "Lcom/intellij/database/model/RawDataSource;", "b", "Lorg/jetbrains/annotations/Nls;", "dsn", "Lcom/intellij/database/view/DataSourceNode;", "produceForDataSourceSlow", "produceForGroupFast", "group", "Lcom/intellij/database/view/structure/DvDsGroup;", "produceForSchemaFast", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "appendNoBreak", "kotlin.jvm.PlatformType", "text", "", "appendText", "br", "Companion", "DatabaseNodeDocumentationTarget1", "DatabaseNodeDocumentationTarget2", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseDocumentationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseDocumentationService.kt\ncom/intellij/database/view/DatabaseDocumentationService\n+ 2 DatabaseDocumentationService.kt\ncom/intellij/database/view/DatabaseDocumentationService$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n142#2:192\n1855#3,2:193\n1045#3:195\n*S KotlinDebug\n*F\n+ 1 DatabaseDocumentationService.kt\ncom/intellij/database/view/DatabaseDocumentationService\n*L\n79#1:192\n89#1:193,2\n95#1:195\n*E\n"})
public final class DatabaseDocumentationService {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Regex textNLPattern = new Regex("\r?\n");

    public DatabaseDocumentationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final DocumentationTarget prepareQuickDoc(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        BasicNode basicNode = node2;
        return basicNode instanceof DvDsGroup ? this.prepare(node2, (Function2)new Function2<DvDsGroup, StringBuilder, Unit>((Object)this){

            public final void invoke(@NotNull DvDsGroup p0, @NotNull StringBuilder p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                DatabaseDocumentationService.access$produceForGroupFast((DatabaseDocumentationService)this.receiver, p0, p1);
            }
        }) : (basicNode instanceof DataSourceNode ? this.prepare(node2, (Function2)new Function2<DataSourceNode, StringBuilder, Unit>((Object)this){

            public final void invoke(@NotNull DataSourceNode p0, @NotNull StringBuilder p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                DatabaseDocumentationService.access$produceForDataSourceFast((DatabaseDocumentationService)this.receiver, p0, p1);
            }
        }, (Function2)new Function2<DataSourceNode, StringBuilder, Unit>((Object)this){

            public final void invoke(@NotNull DataSourceNode p0, @NotNull StringBuilder p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                DatabaseDocumentationService.access$produceForDataSourceSlow((DatabaseDocumentationService)this.receiver, p0, p1);
            }
        }) : (basicNode instanceof BasicSchema ? this.prepare(node2, (Function2)new Function2<BasicSchema, StringBuilder, Unit>((Object)this){

            public final void invoke(@NotNull BasicSchema p0, @NotNull StringBuilder p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                DatabaseDocumentationService.access$produceForSchemaFast((DatabaseDocumentationService)this.receiver, p0, p1);
            }
        }) : null));
    }

    private final void produceForGroupFast(DvDsGroup group2, StringBuilder b2) {
        b2.append("<b>Group</b>: ").append(group2.getDisplayName()).append("<br/>");
    }

    private final void produceForDataSourceFast(DataSourceNode dsn, StringBuilder b2) {
        this.produceForDataSourceFast(dsn.rawDataSource, b2);
    }

    public final void produceForDataSourceFast(@NotNull RawDataSource ds, @NotNull StringBuilder b2) {
        String dbVersionName;
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(ds);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        SqlLanguageDialect dialect = sqlLanguageDialect;
        Object[] objectArray = new Object[]{dialect.getDisplayName()};
        String string = DatabaseBundle.message("dataSource.quickInfo.dialectPhrase", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String s1 = string;
        StringBuilder stringBuilder = b2.append(s1);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        this.br(stringBuilder);
        if (ds instanceof LocalDataSource && (dbVersionName = ((LocalDataSource)ds).getDatabaseVersion().name) != null) {
            this.br(b2);
            String string2 = DataSourceUtil.formatDataSourceInfoString((LocalDataSource)ds);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatDataSourceInfoString(...)");
            CharSequence charSequence = string2;
            Regex regex = new Regex("^(.+?):", RegexOption.MULTILINE);
            String string3 = "<b>$1</b>:";
            String info2 = regex.replace(charSequence, string3);
            this.appendText(b2, info2);
            this.br(b2);
        }
    }

    private final void produceForDataSourceSlow(DataSourceNode dsn, StringBuilder b2) {
        BasicModel basicModel = dsn.getModel();
        if (basicModel == null) {
            return;
        }
        BasicModel model2 = basicModel;
        Companion companion = Companion;
        Function0 f$iv = (Function0)new Function0<CharSequence>(this, model2){
            final /* synthetic */ DatabaseDocumentationService this$0;
            final /* synthetic */ BasicModel $model;
            {
                this.this$0 = $receiver;
                this.$model = $model;
                super(0);
            }

            @Nullable
            public final CharSequence invoke() {
                return DatabaseDocumentationService.access$gatherDataSourceStatistics(this.this$0, this.$model);
            }
        };
        boolean $i$f$computeInReadAction = false;
        CharSequence text2 = (CharSequence)ReadAction.nonBlocking((Callable)new Callable(f$iv, null){
            private final /* synthetic */ Function0 function;
            {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                this.function = function2;
            }

            public final /* synthetic */ Object call() {
                return this.function.invoke();
            }
            {
                this(function2);
            }
        }).executeSynchronously();
        StringFun.appendIfNotNull(b2, text2);
    }

    /*
     * WARNING - void declaration
     */
    private final CharSequence gatherDataSourceStatistics(BasicModel model2) {
        void $this$forEach$iv;
        Dbms dbms = model2.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        Object2IntOpenHashMap map2 = new Object2IntOpenHashMap();
        Object object = ((JBTreeTraverser)model2.traverser().expand(arg_0 -> DatabaseDocumentationService.gatherDataSourceStatistics$lambda$0(gatherDataSourceStatistics.1.INSTANCE, arg_0))).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"traverse(...)");
        object = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DasObject it2 = (DasObject)element$iv;
            boolean bl = false;
            map2.addTo((Object)it2.getKind(), 1);
        }
        if (map2.isEmpty()) {
            return null;
        }
        StringBuilder b2 = new StringBuilder();
        StringBuilder stringBuilder = this.br(b2).append("<b>Contents:</b>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        this.br(stringBuilder);
        b2.append("<ul>");
        Object2IntMap.FastEntrySet fastEntrySet = map2.object2IntEntrySet();
        Intrinsics.checkNotNullExpressionValue((Object)fastEntrySet, (String)"object2IntEntrySet(...)");
        Iterable $this$sortedBy$iv = (Iterable)fastEntrySet;
        boolean $i$f$sortedBy = false;
        for (Object2IntMap.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b2) {
                Object2IntMap.Entry it2 = (Object2IntMap.Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((ObjectKind)it2.getKey()).getOrder());
                it2 = (Object2IntMap.Entry)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((ObjectKind)it2.getKey()).getOrder()));
            }
        })) {
            String presentableName;
            Intrinsics.checkNotNull((Object)entry);
            ObjectKind kind = (ObjectKind)((Map.Entry)entry).getKey();
            Integer count = (Integer)((Map.Entry)entry).getValue();
            Intrinsics.checkNotNull((Object)count);
            Intrinsics.checkNotNullExpressionValue((Object)DbPresentationCore.getPresentableName(kind, dbms2, count), (String)"getPresentableName(...)");
            b2.append("<li>").append(count).append(" ").append(presentableName).append("</li>\n");
        }
        b2.append("</ul>");
        return b2;
    }

    private final void produceForSchemaFast(BasicSchema schema2, StringBuilder b2) {
        Instant instant = schema2.getLastIntrospectionLocalTimestamp();
        ZonedDateTime lastIntrospectionTime = instant != null ? instant.atZone(ZoneId.systemDefault()) : null;
        BasicMultiLevelSchema basicMultiLevelSchema = schema2 instanceof BasicMultiLevelSchema ? (BasicMultiLevelSchema)schema2 : null;
        Level lastIntrospectionLevel = basicMultiLevelSchema != null ? basicMultiLevelSchema.getLastIntrospectionLevel() : null;
        String schemaNameH = "<b>" + schema2.getName() + "</b>";
        Object[] objectArray = new Object[]{schemaNameH};
        String string = DatabaseBundle.message("quickDoc.schema.header", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.appendText(b2, string);
        if (lastIntrospectionTime != null || lastIntrospectionLevel != null) {
            b2.append("<p>");
            String string2 = DatabaseBundle.message("quickDoc.schema.lastIntrospection.begin", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.appendNoBreak(b2, string2).append(' ');
            if (lastIntrospectionTime != null) {
                objectArray = new Object[]{CalendarFun.getLocaleDataTimeFormatterMediumStyle().format(lastIntrospectionTime)};
                String string3 = DatabaseBundle.message("quickDoc.schema.lastIntrospection.atTime", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                this.appendNoBreak(b2, string3).append(' ');
            }
            if (lastIntrospectionLevel != null) {
                objectArray = new Object[]{lastIntrospectionLevel, StringsKt.replace$default((String)LevelFun.getMiniBrief(lastIntrospectionLevel), (String)" ", (String)"&nbsp;", (boolean)false, (int)4, null)};
                String string4 = DatabaseBundle.message("quickDoc.schema.lastIntrospection.atLevel", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                this.appendNoBreak(b2, string4);
            }
            b2.append("<p/>\n");
        }
    }

    private final StringBuilder br(StringBuilder $this$br) {
        return $this$br.append("<br/>\n");
    }

    private final StringBuilder appendText(StringBuilder $this$appendText, String text2) {
        CharSequence charSequence = text2;
        Regex regex = textNLPattern;
        String string = "<br/>\n";
        return $this$appendText.append(regex.replace(charSequence, string));
    }

    private final StringBuilder appendNoBreak(StringBuilder $this$appendNoBreak, String text2) {
        return $this$appendNoBreak.append(StringsKt.replace$default((String)text2, (String)" ", (String)"&nbsp;", (boolean)false, (int)4, null));
    }

    private final <N extends BasicNode> DocumentationTarget prepare(N node2, Function2<? super N, ? super StringBuilder, Unit> fastProducer) {
        StringBuilder b2 = new StringBuilder();
        fastProducer.invoke(node2, (Object)b2);
        return new DatabaseNodeDocumentationTarget1<N>(node2, b2);
    }

    private final <N extends BasicNode> DocumentationTarget prepare(N node2, Function2<? super N, ? super StringBuilder, Unit> fastProducer, Function2<? super N, ? super StringBuilder, Unit> slowProducer) {
        StringBuilder b2 = new StringBuilder();
        fastProducer.invoke(node2, (Object)b2);
        return new DatabaseNodeDocumentationTarget2<N>(node2, b2, slowProducer);
    }

    private static final boolean gatherDataSourceStatistics$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$produceForGroupFast(DatabaseDocumentationService $this, DvDsGroup group2, StringBuilder b2) {
        $this.produceForGroupFast(group2, b2);
    }

    public static final /* synthetic */ void access$produceForDataSourceFast(DatabaseDocumentationService $this, DataSourceNode dsn, StringBuilder b2) {
        $this.produceForDataSourceFast(dsn, b2);
    }

    public static final /* synthetic */ void access$produceForDataSourceSlow(DatabaseDocumentationService $this, DataSourceNode dsn, StringBuilder b2) {
        $this.produceForDataSourceSlow(dsn, b2);
    }

    public static final /* synthetic */ void access$produceForSchemaFast(DatabaseDocumentationService $this, BasicSchema schema2, StringBuilder b2) {
        $this.produceForSchemaFast(schema2, b2);
    }

    public static final /* synthetic */ CharSequence access$gatherDataSourceStatistics(DatabaseDocumentationService $this, BasicModel model2) {
        return $this.gatherDataSourceStatistics(model2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u000e\b\b\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/database/view/DatabaseDocumentationService$Companion;", "", "()V", "textNLPattern", "Lkotlin/text/Regex;", "getTextNLPattern", "()Lkotlin/text/Regex;", "computeInReadAction", "X", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getTextNLPattern() {
            return textNLPattern;
        }

        public final <X> X computeInReadAction(@NotNull Function0<? extends X> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            boolean $i$f$computeInReadAction = false;
            return (X)ReadAction.nonBlocking((Callable)new /* invalid duplicate definition of identical inner class */).executeSynchronously();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0019\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0013H\u0016R\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/view/DatabaseDocumentationService$DatabaseNodeDocumentationTarget1;", "N", "Lcom/intellij/database/model/basic/BasicNode;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "node", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Lcom/intellij/database/model/basic/BasicNode;Ljava/lang/StringBuilder;)V", "getB", "()Ljava/lang/StringBuilder;", "getNode", "()Lcom/intellij/database/model/basic/BasicNode;", "Lcom/intellij/database/model/basic/BasicNode;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "createPointer", "Lcom/intellij/model/Pointer;", "intellij.database.impl"})
    private static class DatabaseNodeDocumentationTarget1<N extends BasicNode>
    implements DocumentationTarget {
        @NotNull
        private final N node;
        @NotNull
        private final StringBuilder b;

        public DatabaseNodeDocumentationTarget1(@NotNull N node2, @NotNull StringBuilder b2) {
            Intrinsics.checkNotNullParameter(node2, (String)"node");
            Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
            this.node = node2;
            this.b = b2;
        }

        @NotNull
        public final N getNode() {
            return this.node;
        }

        @NotNull
        protected final StringBuilder getB() {
            return this.b;
        }

        @NotNull
        public Pointer<? extends DocumentationTarget> createPointer() {
            Pointer pointer = Pointer.hardPointer((Object)this);
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
            return pointer;
        }

        @NotNull
        public TargetPresentation computePresentation() {
            TargetPresentation targetPresentation = TargetPresentation.Companion.builder(StringFun.wrapWithHtmlTag(this.b)).presentation();
            Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
            return targetPresentation;
        }

        @NotNull
        public DocumentationResult computeDocumentation() {
            return (DocumentationResult)DocumentationResult.Companion.documentation(StringFun.wrapWithHtmlTag(this.b));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B7\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u001c\u0010\b\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R'\u0010\b\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/DatabaseDocumentationService$DatabaseNodeDocumentationTarget2;", "N", "Lcom/intellij/database/model/basic/BasicNode;", "Lcom/intellij/database/view/DatabaseDocumentationService$DatabaseNodeDocumentationTarget1;", "node", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "slowProducer", "Lkotlin/Function2;", "", "(Lcom/intellij/database/model/basic/BasicNode;Ljava/lang/StringBuilder;Lkotlin/jvm/functions/Function2;)V", "getSlowProducer", "()Lkotlin/jvm/functions/Function2;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "intellij.database.impl"})
    private static final class DatabaseNodeDocumentationTarget2<N extends BasicNode>
    extends DatabaseNodeDocumentationTarget1<N> {
        @NotNull
        private final Function2<N, StringBuilder, Unit> slowProducer;

        public DatabaseNodeDocumentationTarget2(@NotNull N node2, @NotNull StringBuilder b2, @NotNull Function2<? super N, ? super StringBuilder, Unit> slowProducer) {
            Intrinsics.checkNotNullParameter(node2, (String)"node");
            Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
            Intrinsics.checkNotNullParameter(slowProducer, (String)"slowProducer");
            super(node2, b2);
            this.slowProducer = slowProducer;
        }

        @NotNull
        public final Function2<N, StringBuilder, Unit> getSlowProducer() {
            return this.slowProducer;
        }

        @Override
        @NotNull
        public DocumentationResult computeDocumentation() {
            String text1 = StringFun.wrapWithHtmlTag(this.getB());
            DocumentationResult.Documentation documentation = DocumentationResult.Companion.documentation(text1);
            return (DocumentationResult)documentation.updates(FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super DocumentationContent>, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ DatabaseNodeDocumentationTarget2<N> this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$flow = (FlowCollector)this.L$0;
                            this.L$0 = $this$flow;
                            this.label = 1;
                            v0 = DelayKt.delay((long)1L, (Continuation)((Continuation)this));
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            $this$flow = (FlowCollector)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            this.this$0.getSlowProducer().invoke(this.this$0.getNode(), (Object)this.this$0.getB());
                            text2 = StringFun.wrapWithHtmlTag(this.this$0.getB());
                            var4_5 = DocumentationContent.content((String)text2);
                            Intrinsics.checkNotNullExpressionValue((Object)var4_5, (String)"content(...)");
                            this.L$0 = null;
                            this.label = 2;
                            v1 = $this$flow.emit((Object)var4_5, (Continuation)this);
                            if (v1 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl30
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl30:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull FlowCollector<? super DocumentationContent> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })));
        }
    }
}

