/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncCachedValue<T> {
    private final AtomicReference<Pair<T, @Nullable CompletableFuture<T>>> myCurrent;

    public AsyncCachedValue(T initial) {
        this.myCurrent = new AtomicReference<Pair>(Pair.create(initial, null));
    }

    @Nullable
    public T getValue(@NotNull @NotNull Supplier<? extends CompletableFuture<@NotNull T>> compute2) {
        if (compute2 == null) {
            AsyncCachedValue.$$$reportNull$$$0(0);
        }
        while (true) {
            Pair<T, @Nullable CompletableFuture<T>> cur = this.myCurrent.get();
            if (cur.second != null) {
                return this.getValue(cur);
            }
            CompletableFuture<T> next = compute2.get();
            Pair<T, @Nullable CompletableFuture<T>> res2 = this.setNextImpl(cur, next);
            if (res2 != null) {
                return this.getValue(res2);
            }
            next.cancel(true);
        }
    }

    public void invalidate() {
        block1: {
            Pair newValue;
            Pair<T, CompletableFuture<T>> cur;
            do {
                cur = this.myCurrent.get();
                if (cur.second == null) break block1;
            } while (!this.myCurrent.compareAndSet(cur, newValue = Pair.create(this.getValue(cur), null)));
            this.cancel(cur);
        }
    }

    @Nullable
    private @Nullable Pair<T, @Nullable CompletableFuture<T>> setNextImpl(@NotNull Pair<T, @Nullable CompletableFuture<T>> prev, @NotNull CompletableFuture<T> next) {
        Pair newVal;
        if (prev == null) {
            AsyncCachedValue.$$$reportNull$$$0(1);
        }
        if (next == null) {
            AsyncCachedValue.$$$reportNull$$$0(2);
        }
        if (!this.myCurrent.compareAndSet(prev, newVal = Pair.create(this.getValue(prev), next))) {
            return null;
        }
        this.cancel(prev);
        next.whenComplete((r, th) -> this.complete(newVal));
        return newVal;
    }

    private void cancel(@NotNull Pair<T, @Nullable CompletableFuture<T>> val) {
        CompletableFuture f;
        if (val == null) {
            AsyncCachedValue.$$$reportNull$$$0(3);
        }
        if ((f = (CompletableFuture)val.second) != null && !f.isDone()) {
            f.cancel(true);
        }
    }

    private void complete(@NotNull Pair<T, CompletableFuture<T>> val) {
        if (val == null) {
            AsyncCachedValue.$$$reportNull$$$0(4);
        }
        Pair completed = Pair.create(this.getValue(val), CompletableFuture.completedFuture(null));
        this.myCurrent.compareAndSet(val, completed);
    }

    private T getValue(Pair<T, @Nullable CompletableFuture<T>> v2) {
        CompletableFuture f = (CompletableFuture)v2.second;
        Object nextV = f == null ? null : f.getNow(null);
        return (T)ObjectUtils.chooseNotNull(nextV, (Object)v2.first);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compute";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/view/AsyncCachedValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setNextImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "cancel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "complete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

