/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.view.DatabaseView;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDatabaseModifier {
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final DatabaseDepartment myDepartment;
    private final @NlsContexts.ProgressTitle String myTitle;
    private final SearchPath mySearchPath;
    private final ErrorHandler myErrorHandler;
    private boolean myAbortedByUser;
    private final ArrayList<IntrospectionTask> myTasksToPerform;
    private final ArrayList<BasicElement> myElementsToRefresh;
    private final ArrayList<ObjectPath> myPathsToRefresh;
    private final IntrospectionScopeUpdater myScopeUpdater;
    @Nullable
    private ObjectPath myElementToFocus;

    protected AbstractDatabaseModifier(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull DatabaseDepartment department, @NlsContexts.ProgressTitle @NotNull String title) {
        if (project == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(1);
        }
        if (department == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(2);
        }
        if (title == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(3);
        }
        this.myErrorHandler = new ErrorHandler();
        this.myAbortedByUser = false;
        this.myTasksToPerform = new ArrayList(0);
        this.myElementsToRefresh = new ArrayList(0);
        this.myPathsToRefresh = new ArrayList(0);
        this.myScopeUpdater = new IntrospectionScopeUpdater();
        this.myElementToFocus = null;
        this.myProject = project;
        this.myDepartment = department;
        this.mySearchPath = searchPath;
        this.myTitle = title;
        this.myDataSource = dataSource2;
    }

    public void include(@Nullable IntrospectionTask task) {
        if (task != null) {
            this.myTasksToPerform.add(task);
        }
    }

    public void include(@Nullable BasicElement element2) {
        if (element2 != null) {
            this.myElementsToRefresh.add(element2);
        }
    }

    public void include(@Nullable Collection<@NotNull BasicElement> elements2) {
        this.myElementsToRefresh.addAll(elements2);
    }

    public void include(@Nullable ObjectPath path) {
        if (path != null) {
            this.myPathsToRefresh.add(path);
        }
    }

    public void setElementToFocus(@Nullable ObjectPath elementToFocus) {
        this.myElementToFocus = elementToFocus;
    }

    public boolean isAbortedByUser() {
        return this.myAbortedByUser;
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this.myDataSource;
        if (localDataSource == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(4);
        }
        return localDataSource;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    public IntrospectionScopeUpdater getScopeUpdater() {
        IntrospectionScopeUpdater introspectionScopeUpdater = this.myScopeUpdater;
        if (introspectionScopeUpdater == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(6);
        }
        return introspectionScopeUpdater;
    }

    @NotNull
    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = this.myErrorHandler;
        if (errorHandler == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(7);
        }
        return errorHandler;
    }

    protected AsyncTask<Boolean> checkOutdated(@NotNull Iterable<BasicElement> toCheck) {
        List objects2;
        if (toCheck == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(8);
        }
        if ((objects2 = ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoots(toCheck)).expand(o2 -> !(o2 instanceof BasicNamespace))).filter(BasicElement.class).filter(o2 -> DBIntrospectorFactory.isOutdatedCheckSupported(this.myDataSource.getDbms(), this.myDataSource.useJdbcIntrospector(), o2)).toList()).isEmpty()) {
            return AsyncTask.completed(false);
        }
        if (CollectionFun.containsElements(objects2, o2 -> o2.isOutdated())) {
            return AsyncTask.completed(true);
        }
        List<DefiniteIntrospectionTask> tasks = IntrospectionTasks.prepareCheckOutdatedTasks(objects2);
        LoaderContext context = LoaderContext.selectTasks(this.getProject(), this.myDataSource, tasks);
        return DataSourceUtil.performManualSyncTask(context).apply(null, x -> CollectionFun.containsElements(objects2, o2 -> o2.isOutdated()));
    }

    @NotNull
    public AsyncTask<Boolean> runStatements(boolean nonModalSync) {
        if (!this.checkOutdated()) {
            AsyncTask<Boolean> asyncTask = this.runStatementsInner(nonModalSync);
            if (asyncTask == null) {
                AbstractDatabaseModifier.$$$reportNull$$$0(9);
            }
            return asyncTask;
        }
        AsyncTask<Boolean> asyncTask = this.checkOutdated(this.myElementsToRefresh).applyAsync(AsyncUtil.getEdtExecutor(), outdated -> {
            if (outdated.booleanValue()) {
                int idx = Messages.showIdeaMessageDialog((Project)this.getProject(), (String)DatabaseBundle.message("changed.in.database", new Object[0]), (String)DatabaseBundle.message("changed.in.database.title", new Object[0]), (String[])new String[]{DatabaseBundle.message("changed.in.database.force", new Object[0]), DatabaseBundle.message("changed.in.database.synchronize", new Object[0]), CommonBundle.getCancelButtonText()}, (int)1, (Icon)Messages.getWarningIcon(), null);
                if (idx == -1 || idx == 2) {
                    throw new ProcessCanceledException();
                }
                if (idx == 1) {
                    ApplicationManager.getApplication().invokeLater(() -> this.runSync(), ModalityState.nonModal());
                    this.myAbortedByUser = true;
                    throw new ProcessCanceledException();
                }
            }
            return this.runStatementsInner(nonModalSync);
        });
        if (asyncTask == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(10);
        }
        return asyncTask;
    }

    protected boolean checkOutdated() {
        return this.myDataSource.shouldCheckOutdated();
    }

    @NotNull
    protected AsyncTask<Boolean> runStatementsInner(boolean nonModalSync) {
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator == null || !indicator.isRunning()) {
            AsyncTask.Frame frame = AsyncTask.frame(this.myTitle);
            AsyncTask<Boolean> asyncTask = frame.computeAsync(AsyncUtil.getEdtExecutor(), () -> {
                AsyncTask.withBgIndicatorIfNeeded(frame, this.getProject(), null);
                return this.runStatementsInner(nonModalSync, AsyncTask.Companion.getIndicator(frame));
            });
            if (asyncTask == null) {
                AbstractDatabaseModifier.$$$reportNull$$$0(11);
            }
            return asyncTask;
        }
        AsyncTask<Boolean> asyncTask = this.runStatementsInner(nonModalSync, indicator);
        if (asyncTask == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(12);
        }
        return asyncTask;
    }

    @NotNull
    protected AsyncTask<Boolean> runStatementsInner(boolean nonModalSync, ProgressIndicator indicator) {
        Project project = this.getProject();
        DatabaseSessionManager.Facade facade = DatabaseSessionManager.getFacade(project, this.myDataSource, null, this.mySearchPath, false, this.myErrorHandler, this.myDepartment);
        AsyncTask<Boolean> requests = this.scheduleRequests(indicator, facade);
        Ref shownSummary = Ref.create((Object)"");
        if (this.haveElementsToSync()) {
            requests = requests.handle().applyAsync(AsyncUtil.getEdtExecutor(), p2 -> {
                assert (ProgressIndicatorProvider.getGlobalProgressIndicator() == indicator);
                return this.runSync(nonModalSync, (Ref<String>)shownSummary, (Boolean)p2.first, (Throwable)p2.second);
            });
        }
        AsyncTask<Boolean> asyncTask = requests.handle().apply(AsyncUtil.getEdtExecutor(), p2 -> {
            if (!((String)shownSummary.get()).equals(this.myErrorHandler.getSummary())) {
                this.showError(project, this.myErrorHandler);
            }
            if (p2.second != null || this.myErrorHandler.hasErrors()) {
                throw new ProcessCanceledException();
            }
            return (Boolean)p2.first;
        });
        if (asyncTask == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(13);
        }
        return asyncTask;
    }

    @NotNull
    protected AsyncTask<Boolean> runSync(boolean nonModalSync, Ref<String> shownSummary, Boolean res2, Throwable th) {
        if (nonModalSync) {
            ApplicationManager.getApplication().invokeLater(() -> this.runSync(), ModalityState.nonModal());
            AsyncTask<Boolean> asyncTask = AsyncTask.completed(res2, th);
            if (asyncTask == null) {
                AbstractDatabaseModifier.$$$reportNull$$$0(14);
            }
            return asyncTask;
        }
        shownSummary.set((Object)this.myErrorHandler.getSummary());
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!((String)shownSummary.get()).isEmpty()) {
                this.showError(this.getProject(), this.myErrorHandler);
            }
        }, ModalityState.nonModal());
        AsyncTask<Boolean> asyncTask = this.runSync().apply(null, result2 -> res2);
        if (asyncTask == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(15);
        }
        return asyncTask;
    }

    protected void showError(Project project, ErrorHandler handler2) {
        DataSourceUtil.showNotification(project, "", handler2.getSummary(), true, handler2.getFixes());
    }

    @NotNull
    public AsyncTask<Boolean> scheduleRequests(@NotNull ProgressIndicator indicator, @NotNull DatabaseSessionManager.Facade facade) {
        if (indicator == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(16);
        }
        if (facade == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(17);
        }
        AsyncTask<Boolean> asyncTask = this.getExecutor().execute(indicator, facade, this.myErrorHandler);
        if (asyncTask == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(18);
        }
        return asyncTask;
    }

    public AsyncTask<SyncQueue.SyncResult> runSync() {
        Project project = this.getProject();
        LoaderContext loaderContext = this.prepareIntrospectionContext();
        return DataSourceUtil.performManualSyncTask(loaderContext).whenComplete(AsyncUtil.getEdtExecutor(), (r, e2) -> {
            DatabaseView view2 = DatabaseView.getDatabaseView(project);
            view2.selectElement(this.getElementToSelectInDatabaseView());
        });
    }

    private boolean haveElementsToSync() {
        boolean empty2 = this.myTasksToPerform.isEmpty() && this.myElementsToRefresh.isEmpty() && this.myPathsToRefresh.isEmpty();
        return !empty2;
    }

    @Nullable
    protected DbElement getElementToSelectInDatabaseView() {
        ObjectPath info2 = AbstractDatabaseModifier.getObjectToFocus(this.myElementToFocus);
        if (info2 == null) {
            return null;
        }
        DbDataSource dbDataSource = DbSqlUtilCore.getDbDataSource(this.getProject(), this.myDataSource);
        return dbDataSource == null ? null : DbSqlUtilCore.findElement(dbDataSource, info2);
    }

    @Nullable
    private static ObjectPath getObjectToFocus(@Nullable ObjectPath object) {
        if (object == null) {
            return null;
        }
        ObjectKind pKind = object.parent == null ? null : object.parent.kind;
        return DbImplUtilCore.isDataTable(pKind) ? object.parent : object;
    }

    @NotNull
    private LoaderContext prepareIntrospectionContext() {
        ArrayList<IntrospectionTask> tasks = new ArrayList<IntrospectionTask>();
        if (!this.myTasksToPerform.isEmpty()) {
            tasks.addAll(this.myTasksToPerform);
            this.myTasksToPerform.clear();
        }
        if (!this.myElementsToRefresh.isEmpty()) {
            List<IntrospectionTask> tasks1 = IntrospectionTasks.prepareManyElementsRefreshTasks(this.myElementsToRefresh);
            tasks.addAll(tasks1);
            this.myElementsToRefresh.clear();
        }
        if (!this.myPathsToRefresh.isEmpty()) {
            List<IntrospectionTask> tasks2 = IntrospectionTasks.prepareManyObjectPathsRefreshTasks(this.myPathsToRefresh);
            tasks.addAll(tasks2);
            this.myPathsToRefresh.clear();
        }
        LoaderContext context = LoaderContext.selectTasks(this.myProject, this.myDataSource, tasks);
        context.getScopeUpdater().merge(this.myScopeUpdater);
        LoaderContext loaderContext = context;
        if (loaderContext == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(19);
        }
        return loaderContext;
    }

    @NotNull
    protected abstract QueryExecutor getExecutor();

    public static void notifyImpossibilityOnUndo(final Project project) {
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new GlobalUndoableAction(){

            private void notify(@NlsContexts.NotificationContent String msg) {
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(msg, NotificationType.WARNING).setDisplayId("database.undo.is.impossible").notify(project);
            }

            private void notify(boolean undo) {
                this.notify(DatabaseBundle.message("notification.content.can.not.undo.redo.database.modification", undo ? 0 : 1));
            }

            public void undo() {
                this.notify(true);
            }

            public void redo() {
                this.notify(false);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/AbstractDatabaseModifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCheck";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/AbstractDatabaseModifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeUpdater";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorHandler";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "runStatements";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "runStatementsInner";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "runSync";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleRequests";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareIntrospectionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkOutdated";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRequests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 18, 19 -> new IllegalStateException(string);
        };
    }

    protected static interface QueryExecutor {
        public AsyncTask<Boolean> execute(@NotNull ProgressIndicator var1, @NotNull DatabaseSessionManager.Facade var2, @NotNull ErrorHandler var3);
    }
}

