/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util.common;

import com.intellij.database.util.common.StringFun;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0004\u001c\u001d\u001e\u001fB\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015J\u0014\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018*\u00060\u0017j\u0002`\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\u0012*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/intellij/database/util/common/TextTable;", "R", "", "columns", "", "Lcom/intellij/database/util/common/TextTable$Column;", "([Lcom/intellij/database/util/common/TextTable$Column;)V", "columnCnt", "", "getColumns", "()[Lcom/intellij/database/util/common/TextTable$Column;", "[Lcom/intellij/database/util/common/TextTable$Column;", "look", "Lcom/intellij/database/util/common/TextTable$Look;", "getLook", "()Lcom/intellij/database/util/common/TextTable$Look;", "calculateTextWidth", "text", "", "processContent", "content", "", "indent", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "replicateTillWidth", "", "width", "Align", "Column", "Grid", "Look", "intellij.database.util"})
@SourceDebugExtension(value={"SMAP\nTextTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextTable.kt\ncom/intellij/database/util/common/TextTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,154:1\n1#2:155\n19069#3,7:156\n19069#3,7:163\n12474#3,2:170\n*S KotlinDebug\n*F\n+ 1 TextTable.kt\ncom/intellij/database/util/common/TextTable\n*L\n60#1:156,7\n61#1:163,7\n65#1:170,2\n*E\n"})
public final class TextTable<R> {
    @NotNull
    private final Column<R>[] columns;
    @NotNull
    private final Look look;
    private final int columnCnt;

    public TextTable(@NotNull Column<R>[] columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        this.columns = columns2;
        this.look = new Look(null, null, 3, null);
        this.columnCnt = this.columns.length;
    }

    @NotNull
    public final Column<R>[] getColumns() {
        return this.columns;
    }

    @NotNull
    public final Look getLook() {
        return this.look;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CharSequence processContent(@NotNull Iterable<? extends R> content) {
        boolean bl;
        int n;
        int tableSize;
        int tableWidth;
        int longestCellWidth;
        int[] columnWidths;
        Grid grid;
        block25: {
            int n3;
            int m;
            int n4;
            boolean bl2;
            Intrinsics.checkNotNullParameter(content, (String)"content");
            boolean bl3 = bl2 = this.columnCnt > 0;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-TextTable$processContent$22 = false;
                String $i$a$-assert-TextTable$processContent$22 = "A table must have at least one column";
                throw new AssertionError((Object)$i$a$-assert-TextTable$processContent$22);
            }
            grid = this.look.getGrid();
            int rowCnt = 0;
            int n5 = 0;
            int n6 = this.columnCnt;
            Object[] objectArray = new int[n6];
            while (n5 < n6) {
                n4 = n5++;
                objectArray[n4] = this.columns[n4].getWidth();
            }
            columnWidths = objectArray;
            for (R row : content) {
                ++rowCnt;
                objectArray = this.columns;
                int n7 = objectArray.length;
                for (n4 = 0; n4 < n7; ++n4) {
                    int w;
                    int i2 = n4;
                    int column2 = objectArray[n4];
                    CharSequence cellStr = (CharSequence)column2.getFetcher().invoke(row);
                    if (cellStr == null || columnWidths[i2] >= (w = this.calculateTextWidth(cellStr))) continue;
                    columnWidths[i2] = w;
                }
            }
            int[] $this$reduce$iv = columnWidths;
            boolean $i$f$reduce = false;
            if ($this$reduce$iv.length == 0) {
                throw new UnsupportedOperationException("Empty array can't be reduced.");
            }
            int accumulator$iv = $this$reduce$iv[0];
            IntIterator intIterator = new IntRange(1, ArraysKt.getLastIndex((int[])$this$reduce$iv)).iterator();
            while (intIterator.hasNext()) {
                void w;
                int index$iv = intIterator.nextInt();
                int column2 = $this$reduce$iv[index$iv];
                int m2 = accumulator$iv;
                boolean bl4 = false;
                accumulator$iv = m2 + w;
            }
            int columnWidthSum = accumulator$iv;
            int[] $this$reduce$iv2 = columnWidths;
            boolean $i$f$reduce2 = false;
            if ($this$reduce$iv2.length == 0) {
                throw new UnsupportedOperationException("Empty array can't be reduced.");
            }
            int accumulator$iv2 = $this$reduce$iv2[0];
            IntIterator index$iv = new IntRange(1, ArraysKt.getLastIndex((int[])$this$reduce$iv2)).iterator();
            while (index$iv.hasNext()) {
                void w;
                int index$iv2 = index$iv.nextInt();
                int m2 = $this$reduce$iv2[index$iv2];
                m = accumulator$iv2;
                n3 = 0;
                accumulator$iv2 = Integer.max(m, (int)w);
            }
            longestCellWidth = accumulator$iv2;
            tableWidth = columnWidthSum + (this.columnCnt - 1) * grid.getCellGap().length() + grid.getLeftLine().length() + grid.getRightLine().length();
            String string = this.look.getTableIndent();
            int tableWidthWithIndent = tableWidth + (string != null ? string.length() : 0);
            tableSize = tableWidthWithIndent * (rowCnt + 4);
            Column<R>[] $this$any$iv = this.columns;
            boolean $i$f$any = false;
            n3 = $this$any$iv.length;
            for (m = 0; m < n3; ++m) {
                Column<R> element$iv;
                Column<R> it2 = element$iv = $this$any$iv[m];
                n = 0;
                if (!(it2.getTitle() != null)) continue;
                bl = true;
                break block25;
            }
            bl = false;
        }
        boolean hasHeader = bl;
        String string = grid.getTopLine();
        CharSequence topLine = string != null ? this.replicateTillWidth(string, tableWidth) : null;
        String string2 = grid.getHeadLine();
        CharSequence headLine = string2 != null ? this.replicateTillWidth(string2, tableWidth) : null;
        String string3 = grid.getBottomLine();
        CharSequence bottomLine = string3 != null ? this.replicateTillWidth(string3, tableWidth) : null;
        String spaces = StringFun.replicate(' ', longestCellWidth);
        StringBuilder b2 = new StringBuilder(tableSize);
        if (topLine != null) {
            StringBuilder stringBuilder = this.indent(b2).append(topLine);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        }
        if (hasHeader) {
            this.indent(b2);
            b2.append(grid.getLeftLine());
            Column<R>[] columnArray = this.columns;
            int n8 = columnArray.length;
            for (n = 0; n < n8; ++n) {
                String string4;
                int i3 = n;
                Column<R> column3 = columnArray[n];
                int width = columnWidths[i3];
                if (i3 > 0) {
                    StringFun.appendIfNotNull(b2, grid.getCellGap());
                }
                if ((string4 = column3.getTitle()) == null) {
                    string4 = " ";
                }
                String h2 = string4;
                String hp = switch (WhenMappings.$EnumSwitchMapping$0[column3.getAlignment().ordinal()]) {
                    case 1 -> StringsKt.padEnd$default((String)h2, (int)width, (char)'\u0000', (int)2, null);
                    case 2 -> StringsKt.padStart$default((String)h2, (int)width, (char)'\u0000', (int)2, null);
                    default -> throw new NoWhenBranchMatchedException();
                };
                b2.append(hp);
            }
            b2.append(grid.getRightLine());
            Intrinsics.checkNotNullExpressionValue((Object)b2.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)StringFun.appendIfNotNull(this.indent(b2), headLine).append('\n'), (String)"append(...)");
        }
        for (R row : content) {
            this.indent(b2);
            b2.append(grid.getLeftLine());
            Column<R>[] columnArray = this.columns;
            int n9 = columnArray.length;
            for (int j = 0; j < n9; ++j) {
                int i4 = j;
                Column<R> column4 = columnArray[j];
                if (i4 > 0) {
                    StringFun.appendIfNotNull(b2, grid.getCellGap());
                }
                int width = columnWidths[i4];
                CharSequence x = (CharSequence)column4.getFetcher().invoke(row);
                if (x != null) {
                    int w = x.length();
                    if (w < width) {
                        StringBuilder stringBuilder = StringFun.appendIf(b2, column4.getAlignment() == Align.RIGHT, (CharSequence)spaces, w, width).append(x);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                        StringFun.appendIf(stringBuilder, column4.getAlignment() == Align.LEFT, (CharSequence)spaces, w, width);
                        continue;
                    }
                    if (w == width) {
                        b2.append(x);
                        continue;
                    }
                    if (w <= width) continue;
                    b2.append(x, 0, width);
                    continue;
                }
                b2.append(spaces, 0, width);
            }
            b2.append(grid.getRightLine());
            Intrinsics.checkNotNullExpressionValue((Object)b2.append('\n'), (String)"append(...)");
        }
        if (bottomLine != null) {
            StringBuilder stringBuilder = this.indent(b2).append(bottomLine);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        }
        return b2;
    }

    private final int calculateTextWidth(CharSequence text2) {
        return text2.length();
    }

    private final StringBuilder indent(StringBuilder $this$indent) {
        StringFun.appendIfNotNull($this$indent, this.look.getTableIndent());
        return $this$indent;
    }

    private final CharSequence replicateTillWidth(String $this$replicateTillWidth, int width) {
        int pl = $this$replicateTillWidth.length();
        if (pl == width) {
            return $this$replicateTillWidth;
        }
        if (pl > width) {
            String string = $this$replicateTillWidth.substring(0, pl);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        StringBuilder b2 = new StringBuilder(width + pl);
        while (b2.length() < width) {
            b2.append($this$replicateTillWidth);
        }
        if (b2.length() > width) {
            b2.delete(width, b2.length());
        }
        return b2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/util/common/TextTable$Align;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "intellij.database.util"})
    public static final class Align
    extends Enum<Align> {
        public static final /* enum */ Align LEFT = new Align();
        public static final /* enum */ Align RIGHT = new Align();
        private static final /* synthetic */ Align[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Align[] values() {
            return (Align[])$VALUES.clone();
        }

        public static Align valueOf(String value2) {
            return Enum.valueOf(Align.class, value2);
        }

        @NotNull
        public static EnumEntries<Align> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = alignArray = new Align[]{Align.LEFT, Align.RIGHT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B/\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/util/common/TextTable$Column;", "R", "", "title", "", "alignment", "Lcom/intellij/database/util/common/TextTable$Align;", "fetcher", "Lkotlin/Function1;", "", "(Ljava/lang/String;Lcom/intellij/database/util/common/TextTable$Align;Lkotlin/jvm/functions/Function1;)V", "getAlignment", "()Lcom/intellij/database/util/common/TextTable$Align;", "getFetcher", "()Lkotlin/jvm/functions/Function1;", "getTitle", "()Ljava/lang/String;", "width", "", "getWidth", "()I", "setWidth", "(I)V", "intellij.database.util"})
    public static final class Column<R> {
        @Nullable
        private final String title;
        @NotNull
        private final Align alignment;
        @NotNull
        private final Function1<R, CharSequence> fetcher;
        private int width;

        public Column(@Nullable String title, @NotNull Align alignment, @NotNull Function1<? super R, ? extends CharSequence> fetcher) {
            Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
            Intrinsics.checkNotNullParameter(fetcher, (String)"fetcher");
            this.title = title;
            this.alignment = alignment;
            this.fetcher = fetcher;
            String string = this.title;
            this.width = string != null ? string.length() : 0;
        }

        public /* synthetic */ Column(String string, Align align, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                align = Align.LEFT;
            }
            this(string, align, function1);
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final Align getAlignment() {
            return this.alignment;
        }

        @NotNull
        public final Function1<R, CharSequence> getFetcher() {
            return this.fetcher;
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003JK\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/util/common/TextTable$Grid;", "", "topLine", "", "headLine", "bottomLine", "cellGap", "leftLine", "rightLine", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBottomLine", "()Ljava/lang/String;", "getCellGap", "getHeadLine", "getLeftLine", "getRightLine", "getTopLine", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.util"})
    public static final class Grid {
        @Nullable
        private final String topLine;
        @Nullable
        private final String headLine;
        @Nullable
        private final String bottomLine;
        @NotNull
        private final String cellGap;
        @NotNull
        private final String leftLine;
        @NotNull
        private final String rightLine;

        public Grid(@Nullable String topLine, @Nullable String headLine, @Nullable String bottomLine, @NotNull String cellGap, @NotNull String leftLine, @NotNull String rightLine) {
            Intrinsics.checkNotNullParameter((Object)cellGap, (String)"cellGap");
            Intrinsics.checkNotNullParameter((Object)leftLine, (String)"leftLine");
            Intrinsics.checkNotNullParameter((Object)rightLine, (String)"rightLine");
            this.topLine = topLine;
            this.headLine = headLine;
            this.bottomLine = bottomLine;
            this.cellGap = cellGap;
            this.leftLine = leftLine;
            this.rightLine = rightLine;
        }

        public /* synthetic */ Grid(String string, String string2, String string3, String string4, String string5, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "==";
            }
            if ((n & 2) != 0) {
                string2 = "--";
            }
            if ((n & 4) != 0) {
                string3 = "--";
            }
            if ((n & 8) != 0) {
                string4 = "  ";
            }
            if ((n & 0x10) != 0) {
                string5 = "";
            }
            if ((n & 0x20) != 0) {
                string6 = "";
            }
            this(string, string2, string3, string4, string5, string6);
        }

        @Nullable
        public final String getTopLine() {
            return this.topLine;
        }

        @Nullable
        public final String getHeadLine() {
            return this.headLine;
        }

        @Nullable
        public final String getBottomLine() {
            return this.bottomLine;
        }

        @NotNull
        public final String getCellGap() {
            return this.cellGap;
        }

        @NotNull
        public final String getLeftLine() {
            return this.leftLine;
        }

        @NotNull
        public final String getRightLine() {
            return this.rightLine;
        }

        @Nullable
        public final String component1() {
            return this.topLine;
        }

        @Nullable
        public final String component2() {
            return this.headLine;
        }

        @Nullable
        public final String component3() {
            return this.bottomLine;
        }

        @NotNull
        public final String component4() {
            return this.cellGap;
        }

        @NotNull
        public final String component5() {
            return this.leftLine;
        }

        @NotNull
        public final String component6() {
            return this.rightLine;
        }

        @NotNull
        public final Grid copy(@Nullable String topLine, @Nullable String headLine, @Nullable String bottomLine, @NotNull String cellGap, @NotNull String leftLine, @NotNull String rightLine) {
            Intrinsics.checkNotNullParameter((Object)cellGap, (String)"cellGap");
            Intrinsics.checkNotNullParameter((Object)leftLine, (String)"leftLine");
            Intrinsics.checkNotNullParameter((Object)rightLine, (String)"rightLine");
            return new Grid(topLine, headLine, bottomLine, cellGap, leftLine, rightLine);
        }

        public static /* synthetic */ Grid copy$default(Grid grid, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                string = grid.topLine;
            }
            if ((n & 2) != 0) {
                string2 = grid.headLine;
            }
            if ((n & 4) != 0) {
                string3 = grid.bottomLine;
            }
            if ((n & 8) != 0) {
                string4 = grid.cellGap;
            }
            if ((n & 0x10) != 0) {
                string5 = grid.leftLine;
            }
            if ((n & 0x20) != 0) {
                string6 = grid.rightLine;
            }
            return grid.copy(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public String toString() {
            return "Grid(topLine=" + this.topLine + ", headLine=" + this.headLine + ", bottomLine=" + this.bottomLine + ", cellGap=" + this.cellGap + ", leftLine=" + this.leftLine + ", rightLine=" + this.rightLine + ")";
        }

        public int hashCode() {
            int result2 = this.topLine == null ? 0 : this.topLine.hashCode();
            result2 = result2 * 31 + (this.headLine == null ? 0 : this.headLine.hashCode());
            result2 = result2 * 31 + (this.bottomLine == null ? 0 : this.bottomLine.hashCode());
            result2 = result2 * 31 + this.cellGap.hashCode();
            result2 = result2 * 31 + this.leftLine.hashCode();
            result2 = result2 * 31 + this.rightLine.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Grid)) {
                return false;
            }
            Grid grid = (Grid)other;
            if (!Intrinsics.areEqual((Object)this.topLine, (Object)grid.topLine)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.headLine, (Object)grid.headLine)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bottomLine, (Object)grid.bottomLine)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cellGap, (Object)grid.cellGap)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.leftLine, (Object)grid.leftLine)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rightLine, (Object)grid.rightLine);
        }

        public Grid() {
            this(null, null, null, null, null, null, 63, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/util/common/TextTable$Look;", "", "grid", "Lcom/intellij/database/util/common/TextTable$Grid;", "tableIndent", "", "(Lcom/intellij/database/util/common/TextTable$Grid;Ljava/lang/String;)V", "getGrid", "()Lcom/intellij/database/util/common/TextTable$Grid;", "setGrid", "(Lcom/intellij/database/util/common/TextTable$Grid;)V", "getTableIndent", "()Ljava/lang/String;", "setTableIndent", "(Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.util"})
    public static final class Look {
        @NotNull
        private Grid grid;
        @Nullable
        private String tableIndent;

        public Look(@NotNull Grid grid, @Nullable String tableIndent) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            this.grid = grid;
            this.tableIndent = tableIndent;
        }

        public /* synthetic */ Look(Grid grid, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                grid = new Grid(null, null, null, null, null, null, 63, null);
            }
            if ((n & 2) != 0) {
                string = null;
            }
            this(grid, string);
        }

        @NotNull
        public final Grid getGrid() {
            return this.grid;
        }

        public final void setGrid(@NotNull Grid grid) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"<set-?>");
            this.grid = grid;
        }

        @Nullable
        public final String getTableIndent() {
            return this.tableIndent;
        }

        public final void setTableIndent(@Nullable String string) {
            this.tableIndent = string;
        }

        @NotNull
        public final Grid component1() {
            return this.grid;
        }

        @Nullable
        public final String component2() {
            return this.tableIndent;
        }

        @NotNull
        public final Look copy(@NotNull Grid grid, @Nullable String tableIndent) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            return new Look(grid, tableIndent);
        }

        public static /* synthetic */ Look copy$default(Look look, Grid grid, String string, int n, Object object) {
            if ((n & 1) != 0) {
                grid = look.grid;
            }
            if ((n & 2) != 0) {
                string = look.tableIndent;
            }
            return look.copy(grid, string);
        }

        @NotNull
        public String toString() {
            return "Look(grid=" + this.grid + ", tableIndent=" + this.tableIndent + ")";
        }

        public int hashCode() {
            int result2 = this.grid.hashCode();
            result2 = result2 * 31 + (this.tableIndent == null ? 0 : this.tableIndent.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Look)) {
                return false;
            }
            Look look = (Look)other;
            if (!Intrinsics.areEqual((Object)this.grid, (Object)look.grid)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tableIndent, (Object)look.tableIndent);
        }

        public Look() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Align.values().length];
            try {
                nArray[Align.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

