/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/util/ObjectPathNamespace;", "", "()V", "InDatabase", "InSchema", "InServer", "Lcom/intellij/database/util/ObjectPathNamespace$InDatabase;", "Lcom/intellij/database/util/ObjectPathNamespace$InSchema;", "Lcom/intellij/database/util/ObjectPathNamespace$InServer;", "intellij.database"})
public abstract class ObjectPathNamespace {
    private ObjectPathNamespace() {
    }

    public /* synthetic */ ObjectPathNamespace(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/database/util/ObjectPathNamespace$InDatabase;", "Lcom/intellij/database/util/ObjectPathNamespace;", "databasePath", "Lcom/intellij/database/util/ObjectPath;", "(Lcom/intellij/database/util/ObjectPath;)V", "getDatabasePath", "()Lcom/intellij/database/util/ObjectPath;", "toString", "", "intellij.database"})
    public static final class InDatabase
    extends ObjectPathNamespace {
        @NotNull
        private final ObjectPath databasePath;

        public InDatabase(@NotNull ObjectPath databasePath) {
            Intrinsics.checkNotNullParameter((Object)databasePath, (String)"databasePath");
            super(null);
            this.databasePath = databasePath;
            boolean bl = Intrinsics.areEqual((Object)this.databasePath.kind, (Object)ObjectKind.DATABASE);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }

        @NotNull
        public final ObjectPath getDatabasePath() {
            return this.databasePath;
        }

        @NotNull
        public String toString() {
            return "In database " + this.databasePath.name;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/database/util/ObjectPathNamespace$InSchema;", "Lcom/intellij/database/util/ObjectPathNamespace;", "schemaPath", "Lcom/intellij/database/util/ObjectPath;", "(Lcom/intellij/database/util/ObjectPath;)V", "getSchemaPath", "()Lcom/intellij/database/util/ObjectPath;", "toString", "", "intellij.database"})
    public static final class InSchema
    extends ObjectPathNamespace {
        @NotNull
        private final ObjectPath schemaPath;

        public InSchema(@NotNull ObjectPath schemaPath) {
            Intrinsics.checkNotNullParameter((Object)schemaPath, (String)"schemaPath");
            super(null);
            this.schemaPath = schemaPath;
            boolean bl = Intrinsics.areEqual((Object)this.schemaPath.kind, (Object)ObjectKind.SCHEMA);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }

        @NotNull
        public final ObjectPath getSchemaPath() {
            return this.schemaPath;
        }

        @NotNull
        public String toString() {
            return "In schema " + this.schemaPath;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/util/ObjectPathNamespace$InServer;", "Lcom/intellij/database/util/ObjectPathNamespace;", "()V", "toString", "", "intellij.database"})
    public static final class InServer
    extends ObjectPathNamespace {
        @NotNull
        public static final InServer INSTANCE = new InServer();

        private InServer() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "In server";
        }
    }
}

