/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SqlDialects;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileAttributes;
import com.intellij.sql.psi.SqlFileResolveMode;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSqlUtilCore {
    private static final FileAttribute ourResolveModeAttribute = new FileAttribute("sql.file.resolve.mode");

    protected DbSqlUtilCore() {
    }

    public static boolean stringsAreEscapedWithSlash(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(0);
        }
        return dbms.isClickHouse() || dbms.isHive() || dbms.is(Dbms.SPARK) || dbms.isMysql() || dbms.isRedshift() || dbms.isSnowflake() || dbms.isMongo() || dbms.isBigQuery();
    }

    public static boolean supportsEscapeStringLiterals(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(1);
        }
        return dbms.isGreenplum() || dbms == Dbms.POSTGRES || dbms.isVertica();
    }

    @Nullable
    public static SqlLanguageDialect getSqlDialect(@Nullable PsiElement element2) {
        SqlLanguageDialect language;
        if (element2 == null) {
            return null;
        }
        PsiFile containingFile = element2.getContainingFile();
        if (containingFile instanceof SqlFile) {
            language = ((SqlFile)containingFile).getSqlLanguage();
        } else if (containingFile instanceof DummyHolder) {
            language = containingFile.getLanguage();
        } else {
            if (element2 instanceof DbElement) {
                return DbSqlUtilCore.getSqlDialect((DbElement)element2);
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
            language = LanguageUtil.getLanguageForPsi((Project)element2.getProject(), (VirtualFile)virtualFile);
        }
        return language instanceof SqlLanguageDialect ? language : null;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DbElement element2) {
        DbDataSource dataSource2 = element2 == null ? null : element2.getDataSource();
        SqlLanguageDialect language = dataSource2 == null ? null : (SqlLanguageDialect)ObjectUtils.tryCast((Object)dataSource2.getQueryLanguage(), SqlLanguageDialect.class);
        SqlLanguageDialect sqlLanguageDialect = language == null ? SqlDialects.getGenericDialect() : language;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(2);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static Language getLanguage(@Nullable DbElement element2) {
        DbDataSource dataSource2 = element2 == null ? null : element2.getDataSource();
        Object object = dataSource2 == null ? SqlDialects.getGenericDialect() : dataSource2.getQueryLanguage();
        if (object == null) {
            DbSqlUtilCore.$$$reportNull$$$0(3);
        }
        return object;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Project project, @NotNull DasDataSource databaseSystem) {
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(4);
        }
        if (databaseSystem == null) {
            DbSqlUtilCore.$$$reportNull$$$0(5);
        }
        if (databaseSystem instanceof DbDataSource) {
            return DbSqlUtilCore.getSqlDialect((DbDataSource)databaseSystem);
        }
        if (databaseSystem instanceof LocalDataSource) {
            return DbSqlUtilCore.getSqlDialect((LocalDataSource)databaseSystem);
        }
        DbDataSource dataSource2 = DbPsiFacade.getInstance(project).findDataSource(databaseSystem.getUniqueId());
        return dataSource2 == null ? SqlDialects.getGenericDialect() : DbSqlUtilCore.getSqlDialect(dataSource2);
    }

    @NotNull
    public static <T> JBIterable.SFun<T, T> checkCancelled(final int every) {
        return new JBIterable.SFun<T, T>(){
            int cnt = 0;

            public T fun(T o2) {
                if (++this.cnt % every == 0) {
                    ProgressManager.checkCanceled();
                }
                return o2;
            }
        };
    }

    @NotNull
    public static <E, T, U> JBIterable.SFun<E, U> track(final @Nullable T init2, final @NotNull PairFunction<Function.Mono<T>, ? super E, ? extends U> fun) {
        if (fun == null) {
            DbSqlUtilCore.$$$reportNull$$$0(6);
        }
        return new JBIterable.SFun<E, U>(){
            T prev;
            {
                this.prev = init2;
            }

            private T track(T t) {
                Object tmp = this.prev;
                this.prev = t;
                return tmp;
            }

            public U fun(E o2) {
                return fun.fun(this::track, o2);
            }
        };
    }

    public static boolean isQuoted(@Nullable DasObject object) {
        if (object instanceof DbElement) {
            return DbSqlUtilCore.isQuoted((DasObject)ObjectUtils.tryCast((Object)((DbElement)object).getDelegate(), DasObject.class));
        }
        if (object instanceof SqlDefinition) {
            return ((SqlDefinition)object).isNameQuoted();
        }
        if (object instanceof SqlNameElement) {
            return DbSqlUtilCore.isQuoted((SqlNameElement)object);
        }
        if (object instanceof BasicElement) {
            return BasicPaths.isQuoted((BasicElement)object);
        }
        return true;
    }

    public static boolean isQuoted(@Nullable SqlNameElement element2) {
        return element2 != null && element2.isQuotedIdentifier();
    }

    @Nullable
    public static DasObject getDasObject(@NotNull DasNamed named) {
        if (named == null) {
            DbSqlUtilCore.$$$reportNull$$$0(7);
        }
        if (named instanceof DasObject) {
            return (DasObject)named;
        }
        if (named instanceof DasSymbol) {
            return ((DasSymbol)named).getDasObject();
        }
        return null;
    }

    @Nullable
    public static PsiElement getPsiDelegate(@Nullable DasObject info2) {
        DasObject delegate = info2 instanceof DbElement ? ((DbElement)info2).getDelegate() : info2;
        return delegate instanceof PsiElement ? (PsiElement)delegate : null;
    }

    public static boolean isSqlObject(@Nullable DasObject object) {
        if (object instanceof DbElement) {
            return DbSqlUtilCore.isSqlObject((DasObject)ObjectUtils.tryCast((Object)((DbElement)object).getDelegate(), DasObject.class));
        }
        if (object instanceof SqlElement) {
            return true;
        }
        if (object instanceof BasicNamedElement) {
            return ((BasicNamedElement)object).isNameScripted();
        }
        return false;
    }

    @NotNull
    public static <C extends DasNamed> Condition<C> byName(@Nullable String name2, boolean quoted, @Nullable String id, @NotNull CasingProvider provider) {
        if (provider == null) {
            DbSqlUtilCore.$$$reportNull$$$0(8);
        }
        if (name2 == null) {
            Condition condition2 = Conditions.alwaysFalse();
            if (condition2 == null) {
                DbSqlUtilCore.$$$reportNull$$$0(9);
            }
            return condition2;
        }
        NameChecker checker = new NameChecker(name2, quoted, provider, null);
        Condition condition3 = named -> {
            DasObject dasObject = DbSqlUtilCore.getDasObject(named);
            return (id == null || dasObject != null && id.equalsIgnoreCase(ObjectPaths.getIdentity(dasObject))) && checker.checkName((DasNamed)named, null);
        };
        if (condition3 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(10);
        }
        return condition3;
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForResolve(@NotNull PsiFile sqlFile) {
        if (sqlFile == null) {
            DbSqlUtilCore.$$$reportNull$$$0(11);
        }
        return DbSqlUtilCore.getAppropriateDataSources(sqlFile, true, true);
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSources(@NotNull PsiFile sqlFile, boolean forResolve, boolean matchingOnly) {
        DatabaseDialect dialect;
        if (sqlFile == null) {
            DbSqlUtilCore.$$$reportNull$$$0(12);
        }
        if (DbSqlUtilCore.isJSLanguage(sqlFile.getLanguage())) {
            dialect = (DatabaseDialect)ObjectUtils.notNull((Object)DatabaseDialect.EP.forDbms(Dbms.MONGO), (Object)SqlDialects.getGenericDialect().getDatabaseDialect());
        } else {
            SqlLanguageDialect sqlDialect2 = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtilCore.getSqlDialect((PsiElement)sqlFile), (Object)SqlDialects.getGenericDialect());
            dialect = sqlDialect2.getDatabaseDialect();
        }
        return DbSqlUtilCore.getAppropriateDataSources(dialect, PsiUtilCore.getVirtualFile((PsiElement)sqlFile), sqlFile.getProject(), forResolve, matchingOnly);
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSources(@NotNull DatabaseDialect databaseDialect2, @Nullable VirtualFile virtualFile, @NotNull Project project, boolean forResolve, boolean matchingOnly) {
        JBIterable sqlDataSources;
        if (databaseDialect2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(13);
        }
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(14);
        }
        DbPsiFacade facade = DbPsiFacade.getInstance(project);
        boolean isReadonly = virtualFile instanceof ReadOnlyLightVirtualFile;
        JBIterable resultAll = JBIterable.from(facade.getDataSources()).filter(ds -> (!isReadonly || !(ds instanceof SqlDataSource)) && ds.isValid());
        JBIterable resultSelected = resultAll.filter(ds -> DbImplUtilCore.getDatabaseDialect(ds).similarTo(databaseDialect2));
        if (!isReadonly && forResolve && virtualFile != null && FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)SqlFileType.INSTANCE) && !(sqlDataSources = resultAll.filterMap(o2 -> o2.getDelegate() instanceof SqlDataSource ? o2 : null).filter(o2 -> ((SqlDataSource)o2.getDelegate()).containsFile(virtualFile)).collect()).isEmpty()) {
            JBIterable jBIterable = sqlDataSources;
            if (jBIterable == null) {
                DbSqlUtilCore.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        JBIterable jBIterable = !matchingOnly && resultSelected.isEmpty() ? resultAll : resultSelected;
        if (jBIterable == null) {
            DbSqlUtilCore.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    public static boolean isJSLanguage(@Nullable Language language) {
        if (language == MongoJSLanguage.INSTANCE) {
            return true;
        }
        while (language != null) {
            if (language.getID().equals("JavaScript")) {
                return true;
            }
            language = language.getBaseLanguage();
        }
        return false;
    }

    public static ObjectName getName(@Nullable DasObject object) {
        return object == null ? null : new ObjectName(object.getName(), DbSqlUtilCore.isQuoted(object));
    }

    public static ObjectName getName(@NotNull SqlReferenceExpression expression) {
        if (expression == null) {
            DbSqlUtilCore.$$$reportNull$$$0(17);
        }
        return new ObjectName(expression.getName(), expression.isQuoted());
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(18);
        }
        return DbSqlUtilCore.findSqlDialect(dialect.getDbms());
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(19);
        }
        return (SqlLanguageDialect)SqlLanguageDialect.EP.forDbms(dbms);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable LocalDataSource dataSource2) {
        SqlLanguageDialect dialect = DbSqlUtilCore.findSqlDialect(dataSource2);
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(20);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DbDataSource dataSource2) {
        return DbSqlUtilCore.getSqlDialect((DbElement)dataSource2);
    }

    @NotNull
    public static List<PsiElement> resolveToColumnList(@NotNull SqlReferenceExpression ref2) {
        String text2;
        if (ref2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(21);
        }
        if (!"*".equals(text2 = StringUtil.notNullize((String)ref2.getText())) && !text2.endsWith(".*")) {
            PsiElement resolve2 = ref2.getReference().resolve();
            List list = ContainerUtil.createMaybeSingletonList((Object)resolve2);
            if (list == null) {
                DbSqlUtilCore.$$$reportNull$$$0(22);
            }
            return list;
        }
        SqlTableType type2 = (SqlTableType)ObjectUtils.tryCast((Object)ref2.getDasType(), SqlTableType.class);
        if (type2 == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                DbSqlUtilCore.$$$reportNull$$$0(23);
            }
            return list;
        }
        ArrayList<PsiElement> res2 = new ArrayList<PsiElement>(type2.getColumnCount());
        for (int i2 = 0; i2 < type2.getColumnCount(); ++i2) {
            res2.add(type2.getColumnElement(i2));
        }
        ArrayList<PsiElement> arrayList = res2;
        if (arrayList == null) {
            DbSqlUtilCore.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    public static Language getLanguage(@Nullable DbDataSource dataSource2) {
        return DbSqlUtilCore.getLanguage((DbElement)dataSource2);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DasDataSource dataSource2) {
        DbDataSource dbDs;
        if (dataSource2 instanceof DbElement) {
            return DbSqlUtilCore.getSqlDialect((DbElement)((Object)dataSource2));
        }
        if (dataSource2 instanceof LocalDataSource) {
            return DbSqlUtilCore.getSqlDialect((LocalDataSource)dataSource2);
        }
        if (dataSource2 instanceof SqlDataSource && (dbDs = DbPsiFacade.getInstance(((SqlDataSource)dataSource2).getProject()).findDataSource(dataSource2.getUniqueId())) != null) {
            return DbSqlUtilCore.getSqlDialect(dbDs);
        }
        SqlLanguageDialect dialect = dataSource2 == null ? null : DbSqlUtilCore.findSqlDialect(dataSource2.getDbms());
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(25);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@Nullable LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            return null;
        }
        String defaultDialect = dataSource2.getDefaultDialect();
        SqlLanguageDialect result2 = StringUtil.isEmpty((String)defaultDialect) ? null : SqlDialects.findDialectById(defaultDialect);
        return result2 != null ? result2 : DbSqlUtilCore.guessSqlDialect(dataSource2);
    }

    @Nullable
    public static SqlLanguageDialect guessSqlDialect(@Nullable RawConnectionConfig connectionInfo) {
        DatabaseDialectEx dbDialect = connectionInfo == null ? null : DbImplUtilCore.guessDatabaseDialect(connectionInfo);
        return dbDialect == null ? null : DbSqlUtilCore.findSqlDialect(dbDialect);
    }

    @NotNull
    public static Dbms getDbms(@Nullable Language language) {
        Dbms dbms = language instanceof SqlLanguageDialect ? ((SqlLanguageDialect)language).getDbms() : (DbSqlUtilCore.isJSLanguage(language) ? Dbms.MONGO : Dbms.UNKNOWN);
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(26);
        }
        return dbms;
    }

    @NotNull
    public static <C extends DasObject> Condition<C> byName(@Nullable DasObject obj2, @Nullable String id, @NotNull CasingProvider provider) {
        if (provider == null) {
            DbSqlUtilCore.$$$reportNull$$$0(27);
        }
        return DbSqlUtilCore.byName(obj2 == null ? null : obj2.getName(), DbSqlUtilCore.isQuoted(obj2), id, provider);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Dbms dbms) {
        SqlLanguageDialect res2;
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(28);
        }
        SqlLanguageDialect sqlLanguageDialect = (res2 = DbSqlUtilCore.findSqlDialect(dbms)) == null ? SqlDialects.getGenericDialect() : res2;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(29);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static Language getLanguage(@Nullable LocalDataSource dataSource2) {
        Language language = DbSqlUtilCore.findLanguage(dataSource2);
        Object object = language == null ? SqlDialects.getGenericDialect() : language;
        if (object == null) {
            DbSqlUtilCore.$$$reportNull$$$0(30);
        }
        return object;
    }

    @Nullable
    public static Language findLanguage(@Nullable LocalDataSource dataSource2) {
        if (dataSource2 != null) {
            String defaultDialect = dataSource2.getDefaultDialect();
            if (MongoJSLanguage.INSTANCE.getID().equals(defaultDialect) || dataSource2.getDbms() == Dbms.MONGO) {
                return MongoJSLanguage.INSTANCE;
            }
        }
        return DbSqlUtilCore.findSqlDialect(dataSource2);
    }

    @Nullable
    @Contract(value="!null, _, _, _, _, _, _ -> !null")
    public static String toStringLiteral(@Nullable String value2, @NotNull Dbms dbms, boolean escapeSqlRegexSymbols, @Nullable String prefix, @Nullable String suffix2, boolean multiline, @NotNull JdbcHelper helper) {
        SqlRegexDecorator sqlRegexDecorator;
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(31);
        }
        if (helper == null) {
            DbSqlUtilCore.$$$reportNull$$$0(32);
        }
        if (value2 == null) {
            return null;
        }
        SqlRegexDecorator sqlRegexDecorator2 = escapeSqlRegexSymbols && helper.supportsEscape() ? SqlRegexDecorator.WITH_ESCAPE_CLAUSE : (sqlRegexDecorator = escapeSqlRegexSymbols ? SqlRegexDecorator.DEFAULT : SqlRegexDecorator.NONE);
        String string = dbms.isMongo() ? (prefix == null && escapeSqlRegexSymbols ? "^" : "") : (prefix = prefix);
        suffix2 = dbms.isMongo() ? (suffix2 == null && escapeSqlRegexSymbols ? "$" : "") : suffix2;
        return DbSqlUtilCore.toStringLiteralInner(value2, dbms, sqlRegexDecorator, StringUtil.notNullize((String)prefix), StringUtil.notNullize((String)suffix2), multiline);
    }

    @NotNull
    private static String toStringLiteralInner(@NotNull String value2, @NotNull Dbms dbms, @NotNull SqlRegexDecorator sqlRegexDecorator, @NotNull String prefix, @NotNull String suffix2, boolean multiline) {
        char quote;
        if (value2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(33);
        }
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(34);
        }
        if (sqlRegexDecorator == null) {
            DbSqlUtilCore.$$$reportNull$$$0(35);
        }
        if (prefix == null) {
            DbSqlUtilCore.$$$reportNull$$$0(36);
        }
        if (suffix2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(37);
        }
        char c2 = quote = dbms.isMongo() ? (char)'\"' : '\'';
        if ((((String)value2).contains("\n") || ((String)value2).contains("\t") || ((String)value2).contains("\r")) && (DbSqlUtilCore.stringsAreEscapedWithSlash(dbms) || DbSqlUtilCore.supportsEscapeStringLiterals(dbms))) {
            value2 = StringUtil.escapeBackSlashes((String)value2);
            value2 = sqlRegexDecorator.decorateInner((String)value2, dbms);
            value2 = StringUtil.escapeChar((String)value2, (char)quote);
            value2 = multiline ? value2 : StringUtil.escapeLineBreak((String)value2);
            value2 = multiline ? value2 : StringUtil.replace((String)value2, (String)"\t", (String)"\\t");
            value2 = quote + prefix + (String)value2 + suffix2 + quote;
            value2 = DbSqlUtilCore.supportsEscapeStringLiterals(dbms) ? "e" + (String)value2 : value2;
        } else {
            String escapeChar;
            value2 = sqlRegexDecorator.decorateInner((String)value2, dbms);
            String string = escapeChar = DbSqlUtilCore.stringsAreEscapedWithSlash(dbms) ? "\\" : "'";
            if (DbSqlUtilCore.stringsAreEscapedWithSlash(dbms)) {
                value2 = StringUtil.escapeBackSlashes((String)value2);
            }
            value2 = StringUtil.replace((String)value2, (String)String.valueOf(quote), (String)(escapeChar + quote));
            value2 = quote + prefix + (String)value2 + suffix2 + quote;
            value2 = dbms.in(Dbms.MSSQL_LIKE) ? "N" + (String)value2 : value2;
        }
        String string = sqlRegexDecorator.decorateOuter((String)value2, dbms);
        if (string == null) {
            DbSqlUtilCore.$$$reportNull$$$0(38);
        }
        return string;
    }

    @Nullable
    public static SqlResultSetExpression parseSqlQueryResultSetExpression(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull String queryText2, @Nullable Language hostLanguage) {
        EvaluationHelper helper;
        PsiElement resultSetExpression;
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(39);
        }
        if (language == null) {
            DbSqlUtilCore.$$$reportNull$$$0(40);
        }
        if (queryText2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(41);
        }
        return (resultSetExpression = (helper = (EvaluationHelper)EvaluationHelper.EP.forLanguage((Language)language)).parseQueryResultSetExpression(project, (Language)language, queryText2, hostLanguage)) instanceof SqlResultSetExpression ? (SqlResultSetExpression)resultSetExpression : null;
    }

    @Nullable
    public static <T> T getSqlFileAttributeAt(@NotNull PsiFile file, @NotNull Key<T> attr, int offset) {
        SqlFile sqlFile;
        if (file == null) {
            DbSqlUtilCore.$$$reportNull$$$0(42);
        }
        if (attr == null) {
            DbSqlUtilCore.$$$reportNull$$$0(43);
        }
        return (T)((sqlFile = (SqlFile)ObjectUtils.tryCast((Object)file, SqlFile.class)) != null ? sqlFile.getAttributeAt(attr, offset) : null);
    }

    @NotNull
    public static String getDelimiterAt(@Nullable PsiFile file, int offset) {
        String delim = file == null ? null : (String)DbSqlUtilCore.getSqlFileAttributeAt(file, SqlFileAttributes.DELIMITER, offset);
        String string = StringUtil.notNullize((String)delim, (String)";");
        if (string == null) {
            DbSqlUtilCore.$$$reportNull$$$0(44);
        }
        return string;
    }

    public static boolean delimiterNeedsSpacing(@NotNull String delim) {
        if (delim == null) {
            DbSqlUtilCore.$$$reportNull$$$0(45);
        }
        return !delim.equals(";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<String> getQueries(@NotNull String text2, @NotNull Project project, @NotNull Language language) {
        if (text2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(46);
        }
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(47);
        }
        if (language == null) {
            DbSqlUtilCore.$$$reportNull$$$0(48);
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)project);
        ScriptModel model2 = facade.createScriptModel(DbSqlUtilCore.createTemporaryFile(text2, project, language));
        List list = model2.statements().transform(ScriptModelUtilCore.TO_QUERY).toList();
        List list2 = list;
        if (list2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(49);
        }
        return list2;
        finally {
            Disposer.dispose((Disposable)model2);
        }
    }

    @NotNull
    @ApiStatus.Internal
    public static PsiFile createTemporaryFile(@NotNull String text2, @NotNull Project project, @NotNull Language language) {
        if (text2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(50);
        }
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(51);
        }
        if (language == null) {
            DbSqlUtilCore.$$$reportNull$$$0(52);
        }
        ReadOnlyLightVirtualFile file = new ReadOnlyLightVirtualFile("a", language, (CharSequence)text2);
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)project), (VirtualFile)file, false);
        PsiFile psi = viewProvider.getPsi(language);
        if (psi == null) {
            throw new AssertionError((Object)("language: " + language.getID() + "; text length: " + text2.length()));
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            DbSqlUtilCore.$$$reportNull$$$0(53);
        }
        return psiFile;
    }

    @NotNull
    public static JBIterable<DasObject> findObjects(@NotNull DbDataSource dbDataSource, @NotNull ObjectPath path) {
        if (dbDataSource == null) {
            DbSqlUtilCore.$$$reportNull$$$0(54);
        }
        if (path == null) {
            DbSqlUtilCore.$$$reportNull$$$0(55);
        }
        JBIterable<DasObject> jBIterable = dbDataSource.findObjects(path);
        if (jBIterable == null) {
            DbSqlUtilCore.$$$reportNull$$$0(56);
        }
        return jBIterable;
    }

    public static boolean referencesTarget(@NotNull DasObject candidate2, @NotNull DasObject target2, @NotNull ObjectKind targetKind) {
        if (candidate2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(57);
        }
        if (target2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(58);
        }
        if (targetKind == null) {
            DbSqlUtilCore.$$$reportNull$$$0(59);
        }
        if (targetKind == ObjectKind.TABLE) {
            DasTable refTable;
            if (candidate2 instanceof DasForeignKey && target2.equals(refTable = ((DasForeignKey)candidate2).getRefTable())) {
                return true;
            }
        } else if (targetKind == ObjectKind.COLUMN) {
            if (candidate2 instanceof DasConstraint) {
                if (ContainerUtil.find(((DasConstraint)candidate2).getColumnsRef().resolveObjects(), (Object)target2) != null) {
                    return true;
                }
                if (candidate2 instanceof DasForeignKey && ContainerUtil.find(((DasForeignKey)candidate2).getRefColumns().resolveObjects(), (Object)target2) != null) {
                    return true;
                }
            } else if (candidate2 instanceof DasIndex && ContainerUtil.find(((DasIndex)candidate2).getColumnsRef().resolveObjects(), (Object)target2) != null) {
                return true;
            }
        } else if (candidate2 instanceof DasSynonym && ((DasSynonym)candidate2).resolveTarget() == target2) {
            return true;
        }
        return candidate2 instanceof BasicElement && target2 instanceof BasicElement && Iterables.contains(((BasicElement)candidate2).getPredecessors(), (Object)target2);
    }

    @Nullable
    public static DbDataSource getDbDataSource(@NotNull Project project, @NotNull DasDataSource dataSource2) {
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(60);
        }
        if (dataSource2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(61);
        }
        if (dataSource2 instanceof DbDataSource) {
            return (DbDataSource)dataSource2;
        }
        return DbPsiFacade.getInstance(project).findDataSource(dataSource2.getUniqueId());
    }

    @Nullable
    public static DbElement findElement(@NotNull DbDataSource dbDataSource, @NotNull ObjectPath path) {
        if (dbDataSource == null) {
            DbSqlUtilCore.$$$reportNull$$$0(62);
        }
        if (path == null) {
            DbSqlUtilCore.$$$reportNull$$$0(63);
        }
        return dbDataSource.findElement(path);
    }

    @Nullable
    private static PsiFile getFileForResolveMode(@NotNull PsiElement element2) {
        PsiElement context;
        PsiFile file;
        if (element2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(64);
        }
        if ((file = element2.getContainingFile()) instanceof SqlCodeFragment && (context = file.getContext()) != null) {
            file = context.getContainingFile();
        }
        return file;
    }

    @NotNull
    public static SqlFileResolveMode getDefaultFileResolveMode(@NotNull PsiElement element2) {
        PsiFile file;
        if (element2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(65);
        }
        if ((file = DbSqlUtilCore.getFileForResolveMode(element2)) == null) {
            SqlFileResolveMode sqlFileResolveMode = SqlFileResolveMode.SCRIPT;
            if (sqlFileResolveMode == null) {
                DbSqlUtilCore.$$$reportNull$$$0(66);
            }
            return sqlFileResolveMode;
        }
        VirtualFile vFile = file.getVirtualFile();
        JdbcConsoleCore console = vFile != null ? JdbcConsoleProviderCore.getConsole(file.getProject(), vFile) : null;
        SqlFileResolveMode sqlFileResolveMode = console != null ? DatabaseSettings.getSettings().defaultConsoleResolveMode : SqlFileResolveMode.SCRIPT;
        if (sqlFileResolveMode == null) {
            DbSqlUtilCore.$$$reportNull$$$0(67);
        }
        return sqlFileResolveMode;
    }

    @NotNull
    public static SqlFileResolveMode getFileResolveMode(@NotNull PsiElement element2) {
        String value2;
        SqlFileResolveMode mode;
        PsiFile file;
        VirtualFile vFile;
        if (element2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(68);
        }
        VirtualFile virtualFile = vFile = (file = DbSqlUtilCore.getFileForResolveMode(element2)) != null ? file.getVirtualFile() : null;
        if (vFile != null && (mode = SqlFileResolveMode.deserialize((String)(value2 = DbImplUtilCore.readVFSAttributeSafe(vFile, ourResolveModeAttribute)))) != null) {
            SqlFileResolveMode sqlFileResolveMode = mode;
            if (sqlFileResolveMode == null) {
                DbSqlUtilCore.$$$reportNull$$$0(69);
            }
            return sqlFileResolveMode;
        }
        return DbSqlUtilCore.getDefaultFileResolveMode(element2);
    }

    public static void setFileResolveMode(@NotNull PsiElement element2, @NotNull SqlFileResolveMode mode) {
        PsiFile file;
        if (element2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(70);
        }
        if (mode == null) {
            DbSqlUtilCore.$$$reportNull$$$0(71);
        }
        if ((file = DbSqlUtilCore.getFileForResolveMode(element2)) == null) {
            return;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return;
        }
        FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{vFile});
        DbImplUtilCore.writeVFSAttributeSafe(file.getVirtualFile(), ourResolveModeAttribute, mode.serialize());
    }

    @NotNull
    public static SqlEditorOptions.QualificationType getQualificationByParentKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            DbSqlUtilCore.$$$reportNull$$$0(72);
        }
        SqlEditorOptions options2 = SqlEditorOptions.getInstance();
        if (kind == SqlDbElementType.LOCAL_ALIAS) {
            SqlEditorOptions.QualificationType qualificationType = options2.getAliasQualification();
            if (qualificationType == null) {
                DbSqlUtilCore.$$$reportNull$$$0(73);
            }
            return qualificationType;
        }
        if (ModelConsts.TABLE_OR_VIEW_KINDS.contains(kind)) {
            SqlEditorOptions.QualificationType qualificationType = options2.getTableQualification();
            if (qualificationType == null) {
                DbSqlUtilCore.$$$reportNull$$$0(74);
            }
            return qualificationType;
        }
        if (kind == ObjectKind.SCHEMA) {
            SqlEditorOptions.QualificationType qualificationType = options2.getSchemaQualification();
            if (qualificationType == null) {
                DbSqlUtilCore.$$$reportNull$$$0(75);
            }
            return qualificationType;
        }
        if (kind == ObjectKind.DATABASE) {
            SqlEditorOptions.QualificationType qualificationType = options2.getDatabaseQualification();
            if (qualificationType == null) {
                DbSqlUtilCore.$$$reportNull$$$0(76);
            }
            return qualificationType;
        }
        SqlEditorOptions.QualificationType qualificationType = SqlEditorOptions.QualificationType.NOT_QUALIFY;
        if (qualificationType == null) {
            DbSqlUtilCore.$$$reportNull$$$0(77);
        }
        return qualificationType;
    }

    @NotNull
    public static SqlEditorOptions.QualificationType getQualification(@NotNull ObjectKind kind, @NotNull Dbms dbms) {
        ObjectKind parentKind;
        if (kind == null) {
            DbSqlUtilCore.$$$reportNull$$$0(78);
        }
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(79);
        }
        SqlEditorOptions.QualificationType qualificationType = (parentKind = (ObjectKind)DbImplUtilCore.getMetaModel(dbms).getParentKinds(kind).first()) != null ? DbSqlUtilCore.getQualificationByParentKind(parentKind) : SqlEditorOptions.QualificationType.NOT_QUALIFY;
        if (qualificationType == null) {
            DbSqlUtilCore.$$$reportNull$$$0(80);
        }
        return qualificationType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 9, 10, 15, 16, 20, 22, 23, 24, 25, 26, 29, 30, 38, 44, 49, 53, 56, 66, 67, 69, 73, 74, 75, 76, 77, 80 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 38: 
            case 44: 
            case 49: 
            case 53: 
            case 56: 
            case 66: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbSqlUtilCore";
                break;
            }
            case 4: 
            case 14: 
            case 39: 
            case 47: 
            case 51: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseSystem";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "named";
                break;
            }
            case 8: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseDialect";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlRegexDecorator";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 40: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delim";
                break;
            }
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 54: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 55: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetKind";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 64: 
            case 65: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 72: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbSqlUtilCore";
                break;
            }
            case 2: 
            case 20: 
            case 25: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 3: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "byName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppropriateDataSources";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToColumnList";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringLiteralInner";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiterAt";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryFile";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjects";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileResolveMode";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileResolveMode";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualificationByParentKind";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringsAreEscapedWithSlash";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "supportsEscapeStringLiterals";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 38: 
            case 44: 
            case 49: 
            case 53: 
            case 56: 
            case 66: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: {
                break;
            }
            case 4: 
            case 5: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "track";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDasObject";
                break;
            }
            case 8: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "byName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesForResolve";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAppropriateDataSources";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSqlDialect";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveToColumnList";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteral";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteralInner";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "parseSqlQueryResultSetExpression";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSqlFileAttributeAt";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "delimiterNeedsSpacing";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryFile";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findObjects";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "referencesTarget";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getDbDataSource";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getFileForResolveMode";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFileResolveMode";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getFileResolveMode";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "setFileResolveMode";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getQualificationByParentKind";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getQualification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 9, 10, 15, 16, 20, 22, 23, 24, 25, 26, 29, 30, 38, 44, 49, 53, 56, 66, 67, 69, 73, 74, 75, 76, 77, 80 -> new IllegalStateException(string);
        };
    }

    public static enum SqlRegexDecorator {
        NONE(false, false),
        DEFAULT(true, false),
        WITH_ESCAPE_CLAUSE(true, true);

        private final boolean escapeSqlRegex;
        private final boolean appendEscapeClause;

        private SqlRegexDecorator(boolean escapeSqlRegex, boolean appendEscapeClause) {
            this.escapeSqlRegex = escapeSqlRegex;
            this.appendEscapeClause = appendEscapeClause;
        }

        @NotNull
        String decorateInner(@NotNull String value2, @NotNull Dbms dbms) {
            if (value2 == null) {
                SqlRegexDecorator.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(1);
            }
            if (!this.escapeSqlRegex) {
                String string = value2;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(2);
                }
                return string;
            }
            JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
            if (!DbSqlUtilCore.stringsAreEscapedWithSlash(dbms) && !helper.supportsEscape()) {
                value2 = StringUtil.escapeBackSlashes((String)value2);
            }
            String string = (String)helper.escapeSqlRegex((Object)value2, true);
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        String decorateOuter(@NotNull String value2, @NotNull Dbms dbms) {
            if (value2 == null) {
                SqlRegexDecorator.$$$reportNull$$$0(4);
            }
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(5);
            }
            if (!this.appendEscapeClause) {
                String string = value2;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(6);
                }
                return string;
            }
            JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
            if (value2.indexOf(helper.getEscapeChar()) == -1) {
                String string = value2;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = value2 + this.getTail(dbms);
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public String getTail(@NotNull Dbms dbms) {
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(9);
            }
            if (!this.appendEscapeClause) {
                return "";
            }
            JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
            String string = " ESCAPE '" + helper.getEscapeChar() + "'";
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 6, 7, 8, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DbSqlUtilCore$SqlRegexDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DbSqlUtilCore$SqlRegexDecorator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorateInner";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorateOuter";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTail";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "decorateInner";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "decorateOuter";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getTail";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 6, 7, 8, 10 -> new IllegalStateException(string);
            };
        }
    }
}

