/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbIndirectReferenceModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbReferenceModelApplier;
import com.intellij.database.schemaEditor.model.state.DbIndirectReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbTextModelState;
import com.intellij.database.schemaEditor.ui.AutoSelectListener;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbTextEditorBase;
import com.intellij.database.schemaEditor.ui.ManualPopupButton;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Font;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbReferenceEditor<E extends BasicElement, T extends BasicElement, S extends DbIndirectReferenceModelState<T, String>>
extends DbTextEditorBase<E, S> {
    protected final TextFieldWithCompletion myTextField;

    public DbReferenceEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> model2) {
        if (controller == null) {
            DbReferenceEditor.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            DbReferenceEditor.$$$reportNull$$$0(1);
        }
        super(controller, model2, DbTextModelState.valueAccessor());
        this.myTextField = new TextFieldWithCompletion(this.getController().getProject(), (TextCompletionProvider)new TextFieldCompletionProvider(true){

            protected void addCompletionVariants(@NotNull String text2, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
                if (text2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                DbReferenceEditor.this.addVariants(result2);
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/schemaEditor/ui/DbReferenceEditor$1";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, "", true, true, true);
        this.myTextField.setPreferredWidth(GraphicsUtil.stringWidth((String)"m", (Font)this.myTextField.getFont()) * 20);
        this.myTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                DbReferenceEditor.this.modified();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/schemaEditor/ui/DbReferenceEditor$2", "documentChanged"));
            }
        });
        AutoSelectListener.INSTANCE.install((JComponent)this.myTextField);
        ManualPopupButton.INSTANCE.install((EditorTextField)this.myTextField, false);
    }

    @Override
    @NotNull
    protected String getText() {
        String string = this.myTextField.getText();
        if (string == null) {
            DbReferenceEditor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void setText(@NotNull String text2) {
        if (text2 == null) {
            DbReferenceEditor.$$$reportNull$$$0(3);
        }
        this.myTextField.setText(text2);
    }

    private void addVariants(@NotNull CompletionResultSet result2) {
        BasicElement e2;
        if (result2 == null) {
            DbReferenceEditor.$$$reportNull$$$0(4);
        }
        DbEditorModelController controller = this.getController().getModelController();
        JBIterable<T> traverser2 = this.createTraverser(controller, (DbIndirectReferenceModelApplier<S, T, ?, ?>)this.getApplier());
        ElementOwner owner = controller.getActualOwner();
        BasicElement s2 = e2 = owner == null ? null : (BasicElement)owner.find(this.getIdentity());
        if (traverser2 != null && e2 != null) {
            NamingService ns = this.getNamingService();
            BasicMetaReference baseRef = ((DbReferenceModelApplier)this.getApplier()).getReference().getReferenceDesc().getBaseRef();
            DasObject base = baseRef == null ? null : (DasObject)BasicMetaUtils.resolve(e2, baseRef.getReferenceDesc(), (BasicReference)baseRef.get(e2), owner.getResolveAssistant());
            ObjectPath mainPath = base != null ? ObjectPaths.of(base) : (ObjectPath)JBIterable.generate(this.getIdentity(), controller.getMatcher()::getParent).filterMap(id -> ObjectPaths.of(owner.find(id))).first();
            Set mainPathItems = JBIterable.generate((Object)mainPath, p2 -> p2.parent).toSet();
            result2.addAllElements((Iterable)traverser2.map(o2 -> DbReferenceEditor.createLookupItem(ns, o2, mainPathItems)).filter(o2 -> ContainerUtil.or((Iterable)o2.getAllLookupStrings(), arg_0 -> ((PrefixMatcher)result2.getPrefixMatcher()).prefixMatches(arg_0))));
        }
        result2.stopHere();
    }

    @NotNull
    public DbIndirectReferenceModelApplier<E, T, String, S> getApplier() {
        DbIndirectReferenceModelApplier dbIndirectReferenceModelApplier = (DbIndirectReferenceModelApplier)super.getApplier();
        if (dbIndirectReferenceModelApplier == null) {
            DbReferenceEditor.$$$reportNull$$$0(5);
        }
        return dbIndirectReferenceModelApplier;
    }

    @NotNull
    private NamingService getNamingService() {
        NamingService namingService2 = NamingServices.getNamingService(this.getDbms());
        if (namingService2 == null) {
            DbReferenceEditor.$$$reportNull$$$0(6);
        }
        return namingService2;
    }

    @NotNull
    private static LookupElement createLookupItem(@NotNull NamingService ns, BasicElement o2, Set<ObjectPath> mainPathItems) {
        if (ns == null) {
            DbReferenceEditor.$$$reportNull$$$0(7);
        }
        String text2 = DbReferenceEditor.getText(ns, o2, mainPathItems);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)text2).withPresentableText(o2.getName()).withLookupString(text2).withIcon(DbPresentationCore.getIcon(o2)).withTypeText(DasUtil.getName(o2.getParent())), (double)DbReferenceEditor.getWeight(o2, mainPathItems));
        if (lookupElement == null) {
            DbReferenceEditor.$$$reportNull$$$0(8);
        }
        return lookupElement;
    }

    private static int getWeight(BasicElement o2, Set<ObjectPath> path) {
        int dist = 0;
        ObjectPath p2 = ObjectPaths.of(o2);
        while (p2 != null && !path.contains(p2)) {
            ++dist;
            p2 = p2.parent;
        }
        return -dist;
    }

    private static String getText(@NotNull NamingService ns, BasicElement o2, Set<ObjectPath> path) {
        if (ns == null) {
            DbReferenceEditor.$$$reportNull$$$0(9);
        }
        StringBuilder res2 = new StringBuilder();
        ObjectPath p2 = ObjectPaths.of(o2);
        while (p2 != null && !path.contains(p2)) {
            if (res2.length() != 0) {
                res2.insert(0, ".");
            }
            res2.insert(0, ns.catToScript(p2.name, p2.kind, !p2.isQuoted()));
            p2 = p2.parent;
        }
        return res2.length() == 0 ? o2.getName() : res2.toString();
    }

    @Nullable
    private <S extends BasicElement> JBIterable<T> createTraverser(DbEditorModelController modelController, DbIndirectReferenceModelApplier<S, T, ?, ?> applier) {
        return DbReferenceEditor.createTraverser(modelController, this.getIdentity(), applier);
    }

    @Nullable
    private static <S extends BasicElement, T extends BasicElement> JBIterable<T> createTraverser(DbEditorModelController modelController, ElementIdentity<S> id, DbIndirectReferenceModelApplier<S, T, ?, ?> applier) {
        ElementOwner owner = modelController.getActualOwner();
        if (owner == null) {
            return null;
        }
        S root2 = owner.find(id);
        if (root2 == null) {
            return null;
        }
        return applier.getReference().getReferenceDesc().candidates((BasicElement)root2, id.getMetaObject(), owner.getResolveAssistant());
    }

    @Nullable
    private static <T extends BasicElement> T findElement(ElementOwner owner, ElementIdentity<?> identity, Class<T> clazz) {
        while (identity != null) {
            BasicElement e2;
            if (identity.getMetaObject().kindOf(clazz) && (e2 = (BasicElement)ObjectUtils.tryCast(owner.find(identity), clazz)) != null) {
                return (T)e2;
            }
            identity = owner.getParent(identity);
        }
        return null;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        TextFieldWithCompletion textFieldWithCompletion = this.myTextField;
        if (textFieldWithCompletion == null) {
            DbReferenceEditor.$$$reportNull$$$0(10);
        }
        return textFieldWithCompletion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbReferenceEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbReferenceEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamingService";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupItem";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addVariants";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 8, 10 -> new IllegalStateException(string);
        };
    }
}

