/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.applier.DbObjectModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbStructureObjectModelApplier;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.util.ObjectUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public class DbModelModifiedCache {
    private final Object2BooleanMap<DbEditorModel<?, ?>> myCache;
    private final DbEditorModelController myController;

    DbModelModifiedCache(@NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbModelModifiedCache.$$$reportNull$$$0(0);
        }
        this.myCache = new Object2BooleanOpenHashMap();
        this.myController = controller;
        this.myController.getEventDispatcher().addListener((EventListener)new DbEditorModelListener(){

            @Override
            public void modified(@NotNull DbEditorModel<?, ?> model2) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DbModelModifiedCache.this.prune(model2);
            }

            @Override
            public void removed(@NotNull DbEditorModel<?, ?> model2) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                DbModelModifiedCache.this.prune(model2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "model";
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DbModelModifiedCache$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean isModified(@NotNull DbEditorModel<?, ?> model2) {
        if (model2 == null) {
            DbModelModifiedCache.$$$reportNull$$$0(1);
        }
        if (this.myCache.containsKey(model2)) {
            return this.myCache.getBoolean(model2);
        }
        boolean res2 = this.isModifiedImpl(model2);
        this.myCache.put(model2, res2);
        return res2;
    }

    public void prune(@NotNull DbEditorModel<?, ?> model2) {
        DbEditorModel<?, DbObjectModelState<?>> om;
        if (model2 == null) {
            DbModelModifiedCache.$$$reportNull$$$0(2);
        }
        this.myCache.removeBoolean(model2);
        BasicMetaId key2 = model2.getModelInternalKey();
        if (key2 == DbObjectModelApplier.ID) {
            DbEditorModel<?, DbStructureObjectModelState<?>> sm = this.myController.getStructureNodeModel(model2.getIdentity());
            if (sm != null) {
                this.prune(sm);
            }
        } else if (key2 != DbStructureObjectModelApplier.ID && (om = this.myController.getObjectModel(model2.getIdentity())) != null) {
            this.prune(om);
        }
    }

    private <E extends BasicElement, S extends DbModelState> boolean isModifiedImpl(@NotNull DbEditorModel<E, S> model2) {
        BasicMetaId key2;
        if (model2 == null) {
            DbModelModifiedCache.$$$reportNull$$$0(3);
        }
        if ((key2 = model2.getModelInternalKey()) == DbObjectModelApplier.ID) {
            return this.isObjectModelModified(model2);
        }
        if (key2 == DbStructureObjectModelApplier.ID) {
            return this.isStructureModelModified(model2);
        }
        ElementIdentity<E> identity = model2.getIdentity();
        if (identity instanceof MultiElementIdentity) {
            return false;
        }
        ElementOwner oOwner = this.myController.getMatcher().getOriginalOwner();
        return oOwner != null && model2.getApplier().differsFrom(model2, oOwner);
    }

    private boolean isObjectModelModified(@NotNull DbEditorModel<?, ?> objectModel) {
        if (objectModel == null) {
            DbModelModifiedCache.$$$reportNull$$$0(4);
        }
        ElementIdentity<?> identity = objectModel.getIdentity();
        boolean modified = false;
        for (DbEditorModel<?, ?> model2 : this.myController.getAllModels()) {
            BasicMetaId key2;
            if (model2.getIdentity() != identity || DbModelModifiedCache.isSkippedModel(key2 = model2.getModelInternalKey())) continue;
            modified |= this.isModified(model2);
        }
        return modified;
    }

    private static boolean isSkippedModel(BasicMetaId key2) {
        return key2 == DbObjectModelApplier.ID || key2 == DbStructureObjectModelApplier.ID || key2 == BasicModArrangedElement.POSITION;
    }

    private boolean isStructureModelModified(@NotNull DbEditorModel<?, ?> model2) {
        DbStructureObjectModelState ss2;
        if (model2 == null) {
            DbModelModifiedCache.$$$reportNull$$$0(5);
        }
        return (ss2 = (DbStructureObjectModelState)ObjectUtils.tryCast(model2.getState(), DbStructureObjectModelState.class)) != null && this.isModified(ss2.getObjectRef().resolve(model2.getController()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/model/DbModelModifiedCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prune";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isModifiedImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isObjectModelModified";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isStructureModelModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

