/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbEditorModelTracker
implements Disposable {
    private final DbEditorModelController myController;
    private final Set<DbModelRef<?, ?>> myModified;
    private String myAssertionOnModification;
    private String myAssertionOnExtraModification;

    public DbEditorModelTracker(@NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbEditorModelTracker.$$$reportNull$$$0(0);
        }
        this.myModified = Collections.synchronizedSet(new LinkedHashSet());
        this.myController = controller;
        Disposer.register((Disposable)this.myController, (Disposable)this);
        this.myController.getEventDispatcher().addListener((EventListener)new DbEditorModelListener(){

            @Override
            public void created(@NotNull DbEditorModel<?, ?> model2) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DbEditorModelTracker.this.add(model2);
            }

            @Override
            public void modified(@NotNull DbEditorModel<?, ?> model2) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                DbEditorModelTracker.this.add(model2);
            }

            @Override
            public void removed(@NotNull DbEditorModel<?, ?> model2) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                DbEditorModelTracker.this.add(model2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "model";
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DbEditorModelTracker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "created";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modified";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    public void addModifications(@NotNull Iterable<DbModelRef<?, ?>> models2) {
        if (models2 == null) {
            DbEditorModelTracker.$$$reportNull$$$0(1);
        }
        ContainerUtil.addAll(this.myModified, models2);
    }

    private void add(@NotNull DbEditorModel<?, ?> model2) {
        if (model2 == null) {
            DbEditorModelTracker.$$$reportNull$$$0(2);
        }
        if (this.myModified.add(new DbModelRef(model2)) && this.myAssertionOnExtraModification != null) {
            throw new AssertionError((Object)this.myAssertionOnExtraModification);
        }
        if (this.myAssertionOnModification != null) {
            throw new AssertionError((Object)this.myAssertionOnModification);
        }
    }

    public void setAssertionOnModification(@Nullable String assertionOnModification) {
        this.myAssertionOnModification = assertionOnModification;
    }

    public void setAssertionOnExtraModification(@Nullable String assertionOnExtraModification) {
        this.myAssertionOnExtraModification = assertionOnExtraModification;
    }

    public void dispose() {
    }

    @NotNull
    public Iterable<DbModelRef<?, ?>> getModified() {
        Set<DbModelRef<?, ?>> set = this.myModified;
        if (set == null) {
            DbEditorModelTracker.$$$reportNull$$$0(3);
        }
        return set;
    }

    public boolean hasModifications() {
        return !this.myModified.isEmpty();
    }

    public void clearModified() {
        this.myModified.clear();
    }

    public void modifyAll() {
        this.myModified.clear();
        ContainerUtil.addAll(this.myModified, this.myController.getAllModelsRefs());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DbEditorModelTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DbEditorModelTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addModifications";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

