/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.actions.DataGridUrlNavigationActionHelper;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.actions.NavigateUrlActionKt;
import com.intellij.database.run.actions.URLResolver;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/run/actions/NavigateUrlAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/database/run/actions/GridAction;", "urlResolver", "Lcom/intellij/database/run/actions/URLResolver;", "(Lcom/intellij/database/run/actions/URLResolver;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.database.impl"})
public class NavigateUrlAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    private final URLResolver urlResolver;

    public NavigateUrlAction(@NotNull URLResolver urlResolver) {
        Intrinsics.checkNotNullParameter((Object)urlResolver, (String)"urlResolver");
        this.urlResolver = urlResolver;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        if (DataGridUrlNavigationActionHelper.INSTANCE.isMouseEventWithModifiers(e2.getInputEvent(), ClientSystemInfo.Companion.isMac() ? 256 : 128)) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Project project = e2.getProject();
        DataGrid dataGrid = (DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (project == null || dataGrid == null) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        URL url = this.urlResolver.tryParseUrl(DataGridUrlNavigationActionHelper.INSTANCE.getSelectedValue(dataGrid));
        boolean enabled = url != null;
        e2.getPresentation().setEnabled(enabled);
        e2.getPresentation().setVisible(enabled || !Intrinsics.areEqual((Object)e2.getPlace(), (Object)"TableFloatingToolbar"));
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Project project = e2.getProject();
        DataGrid dataGrid = (DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (project == null || dataGrid == null) {
            return;
        }
        URL uRL = this.urlResolver.tryParseUrl(DataGridUrlNavigationActionHelper.INSTANCE.getSelectedValue(dataGrid));
        if (uRL == null) {
            return;
        }
        URL url = uRL;
        String string = url.getProtocol();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProtocol(...)");
        if (!NavigateUrlActionKt.access$isPermissionForProtocolGiven(string)) {
            String string2 = url.getProtocol();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProtocol(...)");
            NavigateUrlActionKt.access$showNotificationToAllowUrlProtocolOpening(string2, project);
            return;
        }
        this.urlResolver.navigateUrl(url, project);
    }
}

