/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ConsumerColumnRef;
import com.intellij.database.data.types.CustomPlaceholder;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.GreaterPredicateOperation;
import com.intellij.database.data.types.LessPredicateOperation;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.NotEqualsPredicateOperation;
import com.intellij.database.data.types.NullPredicateValue;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicateValuesKt;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.script.generator.dml.WhereClauseTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.ide.actions.SmartPopupActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnFilterByGroup
extends ActionGroup
implements DumbAware {
    private static final FilterTemplate[] NULL_FILTER_TEMPLATES = new FilterTemplate[]{new NullFilterTemplate(false), new NullFilterTemplate(true)};
    private static final FilterTemplate[] FILTER_TEMPLATES = new FilterTemplate[]{new FilterTemplate(new EqualsPredicateOperation()), new FilterTemplate(NotEqualsPredicateOperation.INSTANCE), new FilterTemplate(GreaterPredicateOperation.INSTANCE), new FilterTemplate(LessPredicateOperation.INSTANCE), new LikeFilterTemplate(false), new LikeFilterTemplate(true)};

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e2) {
        DataGrid dataGrid;
        if (e2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(1);
        }
        boolean enabled = (dataGrid = (DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null && dataGrid.isFilteringSupported();
        e2.getPresentation().setEnabledAndVisible(enabled);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e2) {
        DataGrid dataGrid;
        DataGrid dataGrid2 = dataGrid = e2 == null ? null : (DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            if (EMPTY_ARRAY == null) {
                ColumnFilterByGroup.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        SelectionModel selectionModel = dataGrid.getSelectionModel();
        if (selectionModel.getSelectedColumnCount() == 0 || selectionModel.getSelectedRowCount() == 0) {
            if (EMPTY_ARRAY == null) {
                ColumnFilterByGroup.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        if (selectionModel.getSelectedColumnCount() == 1 && selectionModel.getSelectedRowCount() == 1) {
            return ColumnFilterByGroup.getActionsForOneCell(dataGrid, (SelectionModel<GridRow, GridColumn>)selectionModel);
        }
        AnAction[] anActionArray = ColumnFilterByGroup.getActionsForMultipleCells(dataGrid, (SelectionModel<GridRow, GridColumn>)selectionModel);
        if (anActionArray == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    private static AnAction[] getActionsForMultipleCells(@NotNull DataGrid grid, @NotNull SelectionModel<GridRow, GridColumn> selectionModel) {
        if (grid == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(5);
        }
        if (selectionModel == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(6);
        }
        DasTable databaseTable = (DasTable)ObjectUtils.tryCast((Object)DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)grid), DasTable.class);
        GridModel model2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        ModelIndexSet columnIndexes = selectionModel.getSelectedColumns();
        ModelIndexSet rowIndexes = selectionModel.getSelectedRows();
        if (columnIndexes.size() == 0 || rowIndexes.size() == 0) {
            return EMPTY_ARRAY;
        }
        IntOpenHashSet selectedColumnsSet = new IntOpenHashSet((Collection)columnIndexes.asIterable().map(c2 -> c2.asInteger()).toList());
        List columnsAndValuesList = ExtractorsUtil.collectColumnsAndValuesList((CoreGrid<GridRow, GridColumn>)grid, (ModelIndexSet<GridRow>)rowIndexes, (IntSet)selectedColumnsSet, row -> ColumnFilterByGroup.collectValues(databaseTable, (GridModel<GridRow, GridColumn>)model2, (ModelIndexSet<GridColumn>)columnIndexes, (ModelIndex<GridRow>)row));
        GridModel dataModel = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Dbms dbms = DataGridUtil.getDbms(grid);
        WhereClause whereClause2 = ExtractorsUtil.createWhereClauseTask(false, PredicatesHelperKt.predicatesHelper(dbms).getSupportsInOperator(), columnsAndValuesList, (column2, object) -> PredicateValuesKt.predicateValue(DataGridUtilCore.formatValue((GridColumn)dataModel.getColumn(column2), grid.getObjectFormatter(), dbms, object)));
        WhereClauseTask task = DmlTaskKt.whereClause(whereClause2).table(databaseTable).version(DataGridUtilCore.getDatabaseSystem((CoreGrid<GridRow, GridColumn>)grid).getVersion()).build(DbImplUtilCore.createBuilderForUIExec(dbms, (DasObject)databaseTable));
        @NlsSafe String statement2 = DmlUtilKt.dmlGenerator(dbms).generate(task).getStatement();
        if (StringUtil.isEmptyOrSpaces((String)statement2)) {
            return EMPTY_ARRAY;
        }
        @NlsSafe String presentableText = StringUtil.escapeMnemonics((String)statement2);
        presentableText = StringUtil.trimMiddle((String)presentableText, (int)100);
        PreparedColumnFilterExpression preparedExpression = new PreparedColumnFilterExpression(statement2, presentableText, -1);
        return new AnAction[]{new ColumnFilterAction(preparedExpression)};
    }

    @NotNull
    private static List<Triple<ColumnRef, ModelIndex<GridColumn>, Object>> collectValues(@Nullable DasTable databaseTable, @NotNull GridModel<GridRow, GridColumn> model2, @NotNull ModelIndexSet<GridColumn> columnIndexes, @NotNull ModelIndex<GridRow> row) {
        if (model2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(7);
        }
        if (columnIndexes == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(8);
        }
        if (row == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(9);
        }
        ArrayList<Triple<ColumnRef, ModelIndex<GridColumn>, Object>> columnsAndValues = new ArrayList<Triple<ColumnRef, ModelIndex<GridColumn>, Object>>();
        for (ModelIndex columnIndex : columnIndexes.asIterable()) {
            GridColumn column2 = (GridColumn)model2.getColumn(columnIndex);
            if (column2 == null) continue;
            columnsAndValues.add((Triple<ColumnRef, ModelIndex<GridColumn>, Object>)new Triple((Object)new ConsumerColumnRef(column2, databaseTable), (Object)columnIndex, model2.getValueAt(row, columnIndex)));
        }
        ArrayList<Triple<ColumnRef, ModelIndex<GridColumn>, Object>> arrayList = columnsAndValues;
        if (arrayList == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static @NotNull AnAction @NotNull [] getActionsForOneCell(@NotNull DataGrid dataGrid, @NotNull SelectionModel<GridRow, GridColumn> selectionModel) {
        if (dataGrid == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(11);
        }
        if (selectionModel == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(12);
        }
        GridModel model2 = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        GridRow row = (GridRow)model2.getRow(selectionModel.getSelectedRow());
        GridColumn column2 = (GridColumn)model2.getColumn(selectionModel.getSelectedColumn());
        if (row == null || column2 == null) {
            if (EMPTY_ARRAY == null) {
                ColumnFilterByGroup.$$$reportNull$$$0(13);
            }
            return EMPTY_ARRAY;
        }
        boolean mergeNullAndComparePredicates = DataGridUtil.getDbms(dataGrid).isMongo();
        ArrayList<AnAction> children2 = new ArrayList<AnAction>();
        if (!mergeNullAndComparePredicates) {
            ColumnFilterByGroup.addActions(children2, dataGrid, row, column2);
            children2.add((AnAction)new Separator());
        }
        ColumnFilterByGroup.addGroupedByOperatorActions(children2, dataGrid, row, column2, mergeNullAndComparePredicates);
        AnAction[] anActionArray = children2.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(14);
        }
        return anActionArray;
    }

    private static void addActions(@NotNull List<AnAction> actions, @NotNull DataGrid grid, @NotNull GridRow row, @NotNull GridColumn column2) {
        if (actions == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(15);
        }
        if (grid == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(16);
        }
        if (row == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(17);
        }
        if (column2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(18);
        }
        for (FilterTemplate template : NULL_FILTER_TEMPLATES) {
            ContainerUtil.addIfNotNull(actions, (Object)((Object)ColumnFilterByGroup.createFilterAction(template, grid, new GridOperand(grid, row, column2), column2)));
        }
    }

    private static void addGroupedByOperatorActions(@NotNull List<AnAction> result2, @NotNull DataGrid grid, @NotNull GridRow row, @NotNull GridColumn column2, boolean mergeNullAndComparePredicates) {
        if (result2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(19);
        }
        if (grid == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(20);
        }
        if (row == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(21);
        }
        if (column2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(22);
        }
        for (FilterTemplate template : FILTER_TEMPLATES) {
            DdlBuilder groupNameBuilder = DbImplUtilCore.createBuilderForUIExec(DataGridUtil.getDatabaseDialect(grid), DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)grid));
            Dbms dbms = DataGridUtil.getDbms(grid);
            PredicateValue groupPresentationOperand = dbms.isMongo() ? PlaceholderOperand.INSTANCE.getPresentableValue() : new CustomPlaceholder("");
            ColumnFilterByGroup.produceWhereClause(groupNameBuilder, column2, grid, groupPresentationOperand, template.myOperation);
            @NlsSafe String groupName = groupNameBuilder.getStatement();
            if (groupName.isEmpty() || groupName.equals(grid.getDataHookup().getFilterEmptyText())) continue;
            SmartPopupActionGroup group2 = new SmartPopupActionGroup();
            group2.getTemplatePresentation().setText(StringUtil.escapeMnemonics((String)groupName.trim()));
            ColumnFilterAction placeholderAction = ColumnFilterByGroup.createFilterAction(template, grid, PlaceholderOperand.INSTANCE, column2);
            GridOperand cellOperand = new GridOperand(grid, row, column2);
            ClipboardOperand clipboardOperand = new ClipboardOperand();
            boolean equalOperands = StringUtil.equals((CharSequence)cellOperand.getValue().getStr(), (CharSequence)clipboardOperand.getValue().getStr());
            ColumnFilterAction cellAction = ColumnFilterByGroup.createFilterAction(template, grid, cellOperand, column2);
            boolean addNullOperation = mergeNullAndComparePredicates && (template.myOperation instanceof EqualsPredicateOperation || template.myOperation instanceof NotEqualsPredicateOperation);
            ColumnFilterAction nullAction = addNullOperation ? ColumnFilterByGroup.createFilterAction(template, grid, NullOperand.INSTANCE, column2) : null;
            ColumnFilterAction clipboardAction = equalOperands ? null : ColumnFilterByGroup.createFilterAction(template, grid, clipboardOperand, column2);
            ArrayList actions = new ArrayList();
            ContainerUtil.addIfNotNull(actions, (Object)((Object)cellAction));
            ContainerUtil.addIfNotNull(actions, (Object)((Object)clipboardAction));
            ContainerUtil.addIfNotNull(actions, (Object)((Object)nullAction));
            ContainerUtil.addIfNotNull(actions, (Object)((Object)placeholderAction));
            group2.addAll(actions);
            result2.add((AnAction)group2);
        }
    }

    @Nullable
    private static ColumnFilterAction createFilterAction(@NotNull FilterTemplate template, @NotNull DataGrid grid, @NotNull Operand operand, @NotNull GridColumn column2) {
        PreparedColumnFilterExpression preparedExpression;
        if (template == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(23);
        }
        if (grid == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(24);
        }
        if (operand == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(25);
        }
        if (column2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(26);
        }
        return (preparedExpression = template.prepare(grid, column2, operand)) == null ? null : new ColumnFilterAction(preparedExpression);
    }

    static void produceWhereClause(@NotNull DdlBuilder builder, @NotNull GridColumn column2, @NotNull DataGrid grid, @NotNull PredicateValue value2, @NotNull PredicateOperation operation2) {
        if (builder == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(27);
        }
        if (column2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(28);
        }
        if (grid == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(29);
        }
        if (value2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(30);
        }
        if (operation2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(31);
        }
        DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)grid);
        ValuesWhereClause whereClause2 = new ValuesWhereClause(Collections.singletonList(new Triple((Object)new ConsumerColumnRef(column2, DataGridUtil.getDatabaseTable(grid)), (Object)value2, Set.of(operation2))), "", null);
        DbDataSource system = DataGridUtilCore.getDatabaseSystem((CoreGrid<GridRow, GridColumn>)grid);
        WhereClauseTask task = DmlTaskKt.whereClause(whereClause2).table(table).version(system == null ? null : system.getVersion()).build(builder);
        DmlUtilKt.dmlGenerator(DataGridUtil.getDbms(grid)).generate(task);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 5, 6, 7, 8, 9, 11, 12, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ColumnFilterByGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 16: 
            case 20: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndexes";
                break;
            }
            case 9: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 18: 
            case 22: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ColumnFilterByGroup";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectValues";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionsForOneCell";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getActionsForMultipleCells";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectValues";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getActionsForOneCell";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addGroupedByOperatorActions";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createFilterAction";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "produceWhereClause";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 5, 6, 7, 8, 9, 11, 12, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 -> new IllegalArgumentException(string);
        };
    }

    public static class PreparedColumnFilterExpression {
        private final String myText;
        private final @NlsActions.ActionText String myPresentableText;
        private final int myCompletionOffset;

        PreparedColumnFilterExpression(@NotNull String fullText2, @NotNull @NlsActions.ActionText String presentableText, int completionOffset) {
            if (fullText2 == null) {
                PreparedColumnFilterExpression.$$$reportNull$$$0(0);
            }
            if (presentableText == null) {
                PreparedColumnFilterExpression.$$$reportNull$$$0(1);
            }
            this.myText = fullText2;
            this.myPresentableText = presentableText;
            this.myCompletionOffset = completionOffset;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                PreparedColumnFilterExpression.$$$reportNull$$$0(2);
            }
            return string;
        }

        public int getCompletionOffset() {
            return this.myCompletionOffset;
        }

        @NlsActions.ActionText
        @NotNull
        public String getPresentableText() {
            String string = this.myPresentableText;
            if (string == null) {
                PreparedColumnFilterExpression.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ColumnFilterByGroup$PreparedColumnFilterExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ColumnFilterByGroup$PreparedColumnFilterExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ColumnFilterAction
    extends DumbAwareAction {
        private final PreparedColumnFilterExpression myPreparedExpression;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ColumnFilterAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        private ColumnFilterAction(@NotNull PreparedColumnFilterExpression expression) {
            if (expression == null) {
                ColumnFilterAction.$$$reportNull$$$0(1);
            }
            super(expression.getPresentableText());
            this.myPreparedExpression = expression;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DataGrid dataGrid;
            if (e2 == null) {
                ColumnFilterAction.$$$reportNull$$$0(2);
            }
            if ((dataGrid = (DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return;
            }
            int completionOffset = this.myPreparedExpression.getCompletionOffset();
            GridHelper.get((CoreGrid)dataGrid).setFilterText((CoreGrid)dataGrid, this.myPreparedExpression.getText(), completionOffset);
            if (completionOffset == -1) {
                dataGrid.getFilterComponent().getFilterPanel().apply();
            }
        }

        @NotNull
        public PreparedColumnFilterExpression getPreparedExpression() {
            PreparedColumnFilterExpression preparedColumnFilterExpression = this.myPreparedExpression;
            if (preparedColumnFilterExpression == null) {
                ColumnFilterAction.$$$reportNull$$$0(3);
            }
            return preparedColumnFilterExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ColumnFilterByGroup$ColumnFilterAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ColumnFilterByGroup$ColumnFilterAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreparedExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class FilterTemplate {
        private final PredicateOperation myOperation;

        FilterTemplate(@NotNull PredicateOperation operation2) {
            if (operation2 == null) {
                FilterTemplate.$$$reportNull$$$0(0);
            }
            this.myOperation = operation2;
        }

        @Nullable
        public PreparedColumnFilterExpression prepare(@NotNull DataGrid grid, @NotNull GridColumn column2, @NotNull Operand operand) {
            if (grid == null) {
                FilterTemplate.$$$reportNull$$$0(1);
            }
            if (column2 == null) {
                FilterTemplate.$$$reportNull$$$0(2);
            }
            if (operand == null) {
                FilterTemplate.$$$reportNull$$$0(3);
            }
            if (!this.isAvailableFor(operand, column2)) {
                return null;
            }
            DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)grid);
            DdlBuilder presentableTextBuilder = DbImplUtilCore.createBuilderForUIExec(DataGridUtil.getDatabaseDialect(grid), table);
            DdlBuilder textBuilder = DbImplUtilCore.createBuilderForUIExec(DataGridUtil.getDatabaseDialect(grid), table);
            ColumnFilterByGroup.produceWhereClause(presentableTextBuilder, column2, grid, operand.getPresentableValue(), this.myOperation);
            ColumnFilterByGroup.produceWhereClause(textBuilder, column2, grid, operand.getValue(), this.myOperation);
            String text2 = textBuilder.getStatement();
            String presentableText = StringUtil.escapeMnemonics((String)presentableTextBuilder.getStatement());
            if (text2.isEmpty() || text2.equals(grid.getDataHookup().getFilterEmptyText()) || presentableText.isEmpty() || text2.contains("\n")) {
                return null;
            }
            Dbms dbms = DataGridUtil.getDbms(grid);
            int completionOffset = operand instanceof PlaceholderOperand ? FilterTemplate.guessCompletionOffset(dbms, text2) : -1;
            return new PreparedColumnFilterExpression(text2, presentableText, completionOffset);
        }

        private static int guessCompletionOffset(@NotNull Dbms dbms, @NotNull String text2) {
            if (dbms == null) {
                FilterTemplate.$$$reportNull$$$0(4);
            }
            if (text2 == null) {
                FilterTemplate.$$$reportNull$$$0(5);
            }
            if (dbms.isMongo()) {
                int offset = text2.length() - 1;
                while (text2.charAt(offset) == '}') {
                    --offset;
                }
                while (text2.charAt(offset) == ')') {
                    --offset;
                }
                if (text2.charAt(offset) == '\'' || text2.charAt(offset) == '\"') {
                    --offset;
                }
                return offset + 1;
            }
            return text2.endsWith("'%%'") ? text2.length() - 2 : (text2.endsWith("''") ? text2.length() - 1 : (text2.endsWith("\"\"") ? text2.length() - 1 : text2.length()));
        }

        protected boolean isAvailableFor(@NotNull Operand op, @NotNull GridColumn column2) {
            if (op == null) {
                FilterTemplate.$$$reportNull$$$0(6);
            }
            if (column2 == null) {
                FilterTemplate.$$$reportNull$$$0(7);
            }
            return op.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operand";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "op";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ColumnFilterByGroup$FilterTemplate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepare";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "guessCompletionOffset";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailableFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GridOperand
    implements Operand {
        private final DataGrid myGrid;
        private final GridRow myRow;
        private final GridColumn myColumn;

        GridOperand(@NotNull DataGrid grid, @NotNull GridRow row, @NotNull GridColumn column2) {
            if (grid == null) {
                GridOperand.$$$reportNull$$$0(0);
            }
            if (row == null) {
                GridOperand.$$$reportNull$$$0(1);
            }
            if (column2 == null) {
                GridOperand.$$$reportNull$$$0(2);
            }
            this.myGrid = grid;
            this.myRow = row;
            this.myColumn = column2;
        }

        @Override
        @NotNull
        public StringPredicateValue getValue() {
            ObjectFormatterConfig config = DatabaseObjectFormatterConfig.get((ObjectFormatterMode)PredicatesHelperKt.predicatesHelper(DataGridUtil.getDbms(this.myGrid)).getMode());
            String value2 = this.myGrid.getObjectFormatter().objectToString(this.myColumn.getValue(this.myRow), this.myColumn, config);
            return new StringPredicateValue(Objects.requireNonNullElse(value2, "null"), false);
        }

        @Override
        @NotNull
        public PredicateValue getPresentableValue() {
            ObjectFormatterConfig config = DatabaseObjectFormatterConfig.get((ObjectFormatterMode)PredicatesHelperKt.predicatesHelper(DataGridUtil.getDbms(this.myGrid)).getMode());
            String value2 = this.myGrid.getObjectFormatter().objectToString(this.myColumn.getValue(this.myRow), this.myColumn, config);
            return new StringPredicateValue(StringUtil.trimMiddle((String)Objects.requireNonNullElse(value2, "null"), (int)50), false);
        }

        @Override
        public boolean isValid() {
            Object value2 = this.myColumn.getValue(this.myRow);
            return value2 != null && value2 != ReservedCellValue.UNSET;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "row";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/ColumnFilterByGroup$GridOperand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface Operand {
        @NotNull
        public PredicateValue getValue();

        @NotNull
        default public PredicateValue getPresentableValue() {
            PredicateValue predicateValue = this.getValue();
            if (predicateValue == null) {
                Operand.$$$reportNull$$$0(0);
            }
            return predicateValue;
        }

        public boolean isValid();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ColumnFilterByGroup$Operand", "getPresentableValue"));
        }
    }

    private static class PlaceholderOperand
    implements Operand {
        static final Operand INSTANCE = new PlaceholderOperand();

        private PlaceholderOperand() {
        }

        @Override
        @NotNull
        public StringPredicateValue getValue() {
            return new StringPredicateValue("", false);
        }

        @Override
        @NotNull
        public PredicateValue getPresentableValue() {
            return new CustomPlaceholder("...");
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    private static class ClipboardOperand
    implements Operand {
        private ClipboardOperand() {
        }

        @Override
        @NotNull
        public StringPredicateValue getValue() {
            return new StringPredicateValue((String)ObjectUtils.notNull((Object)ClipboardOperand.getContent(), (Object)""), true);
        }

        @Override
        @NotNull
        public PredicateValue getPresentableValue() {
            return new StringPredicateValue(StringUtil.trimMiddle((String)((String)ObjectUtils.notNull((Object)ClipboardOperand.getContent(), (Object)"")), (int)50), true);
        }

        @Override
        public boolean isValid() {
            return ClipboardOperand.getContent() != null;
        }

        @Nullable
        private static String getContent() {
            return StringUtil.nullize((String)((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)));
        }
    }

    private static class NullOperand
    implements Operand {
        static final Operand INSTANCE = new NullOperand();

        private NullOperand() {
        }

        @Override
        @NotNull
        public NullPredicateValue getValue() {
            NullPredicateValue nullPredicateValue = NullPredicateValue.INSTANCE;
            if (nullPredicateValue == null) {
                NullOperand.$$$reportNull$$$0(0);
            }
            return nullPredicateValue;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ColumnFilterByGroup$NullOperand", "getValue"));
        }
    }

    private static class NullFilterTemplate
    extends FilterTemplate {
        NullFilterTemplate(boolean isNotNull) {
            super(isNotNull ? NotEqualsPredicateOperation.INSTANCE : new EqualsPredicateOperation());
        }

        @Override
        @Nullable
        public PreparedColumnFilterExpression prepare(@NotNull DataGrid grid, @NotNull GridColumn column2, @NotNull Operand operand) {
            if (grid == null) {
                NullFilterTemplate.$$$reportNull$$$0(0);
            }
            if (column2 == null) {
                NullFilterTemplate.$$$reportNull$$$0(1);
            }
            if (operand == null) {
                NullFilterTemplate.$$$reportNull$$$0(2);
            }
            return super.prepare(grid, column2, NullOperand.INSTANCE);
        }

        @Override
        protected boolean isAvailableFor(@NotNull Operand operand, @NotNull GridColumn column2) {
            if (operand == null) {
                NullFilterTemplate.$$$reportNull$$$0(3);
            }
            if (column2 == null) {
                NullFilterTemplate.$$$reportNull$$$0(4);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operand";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ColumnFilterByGroup$NullFilterTemplate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepare";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailableFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LikeFilterTemplate
    extends FilterTemplate {
        LikeFilterTemplate(boolean isNotLike) {
            super(new LikePredicateOperation(LikeOpType.CONTAINS, true, isNotLike));
        }
    }
}

