/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi.documentation;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.psi.documentation.DbElementDocumentationTarget;
import com.intellij.database.run.ui.DataGridDocumentationCommand;
import com.intellij.database.run.ui.DbDocumentationHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Out;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DbTableDocumentationTarget
extends DbElementDocumentationTarget<DbTableImpl> {
    private static final String SHOW_PREVIEW = "show-table-preview";

    public DbTableDocumentationTarget(@NotNull DbTableImpl table) {
        if (table == null) {
            DbTableDocumentationTarget.$$$reportNull$$$0(0);
        }
        super(table);
    }

    @Override
    @NotNull
    protected Function<DbTableImpl, DocumentationTarget> getFactory() {
        Function<DbTableImpl, DocumentationTarget> function2 = DbTableDocumentationTarget::new;
        if (function2 == null) {
            DbTableDocumentationTarget.$$$reportNull$$$0(1);
        }
        return function2;
    }

    @Override
    @Nls
    @NotNull
    protected String getDocumentation() {
        @Nls StringBuilder docs = ((DbTableImpl)this.getDbElement()).getDocumentationBase();
        if (DbImplUtilCore.isDataTable((DasTable)this.getDbElement())) {
            docs.append(DbDocumentationHelper.sectionStart(SHOW_PREVIEW));
            docs.append(HtmlChunk.link((String)DbDocumentationHelper.dbSubstituteUrl(SHOW_PREVIEW), (String)DatabaseBundle.message("show.table.preview", new Object[0])));
            docs.append(DbDocumentationHelper.sectionEnd(SHOW_PREVIEW));
        }
        String string = docs.toString();
        if (string == null) {
            DbTableDocumentationTarget.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String substitute(@NotNull ConnectionProvider provider, @Nls @NotNull String content, @NotNull String section) throws Exception {
        DataGridDocumentationCommand command2;
        if (provider == null) {
            DbTableDocumentationTarget.$$$reportNull$$$0(3);
        }
        if (content == null) {
            DbTableDocumentationTarget.$$$reportNull$$$0(4);
        }
        if (section == null) {
            DbTableDocumentationTarget.$$$reportNull$$$0(5);
        }
        if ((command2 = DataGridDocumentationCommand.getCommand(section, null)) == DataGridDocumentationCommand.COUNT) {
            String rowCountSection = DbDocumentationHelper.loadTableDocumentationRowCount(provider, (DbTable)this.getDbElement());
            return DbTableDocumentationTarget.substitute(content, section, rowCountSection);
        }
        Out.Readable out = new Out.Readable();
        DbDocumentationHelper.loadTableDocumentation(true, (Out)out, provider, (DbTable)this.getDbElement());
        return DbTableDocumentationTarget.substitute(content, section, out.getString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/documentation/DbTableDocumentationTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/documentation/DbTableDocumentationTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

