/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelConvertersKt;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_22;", "Lcom/intellij/database/model/serialization/Converter;", "()V", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "convertPostgres", "intellij.database.core.impl"})
public final class Converter_4_22
extends Converter {
    @NotNull
    public static final Converter_4_22 INSTANCE = new Converter_4_22();

    private Converter_4_22() {
        int[] nArray = new int[]{4, 22};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        if (modelMem.getDbms().isPostgres()) {
            this.convertPostgres(modelMem);
        }
    }

    private final void convertPostgres(ModelMem modelMem) {
        Int2ObjectOpenHashMap routines = new Int2ObjectOpenHashMap();
        for (ModelElementMem node2 : modelMem.getNodes()) {
            Integer n = node2.getId();
            if (n == null) {
                continue;
            }
            int id = n;
            if (!Intrinsics.areEqual((Object)node2.getKind(), (Object)"routine")) continue;
            String rk = ModelConvertersKt.getProperty(node2, "RoutineKind");
            if (rk != null && StringsKt.equals((String)rk, (String)"procedure", (boolean)true)) {
                ModelConvertersKt.setProperty(node2, "PgRoutineKind", "P");
            } else {
                routines.put(id, (Object)node2);
            }
            ModelConvertersKt.removeProperty(node2, "RoutineKind");
        }
        if (routines.isEmpty()) {
            return;
        }
        for (ModelElementMem node2 : modelMem.getNodes()) {
            ModelElementMem routine2;
            String string;
            String dtp;
            if (!Intrinsics.areEqual((Object)node2.getKind(), (Object)"argument") || ModelConvertersKt.getProperty(node2, "DataType") == null) continue;
            String string2 = dtp;
            if (Intrinsics.areEqual((Object)string2, (Object)"trigger")) {
                string = "T";
            } else {
                if (!Intrinsics.areEqual((Object)string2, (Object)"event_trigger")) continue;
                string = "V";
            }
            String x = string;
            Integer n = node2.getParentId();
            if (n == null) {
                continue;
            }
            int routineId = n;
            if ((ModelElementMem)routines.get(routineId) == null) continue;
            ModelConvertersKt.setProperty(routine2, "PgRoutineKind", x);
        }
    }
}

