/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.dir.DTree;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbMigrationAction
extends IconWithTextAction
implements DirDiffModelHolder {
    private final Direction myDirection;
    private DirDiffModel myModel;

    public DbMigrationAction(Direction direction) {
        super(DatabaseBundle.message(direction == Direction.FORWARD ? "apply.right.to.the.left" : "apply.left.to.the.right", new Object[0]));
        this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        this.getTemplatePresentation().setIcon(EmptyIcon.ICON_0);
        this.myDirection = direction;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DbMigrationAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            DbMigrationAction.$$$reportNull$$$0(1);
        }
        e2.getPresentation().setEnabled(!this.myModel.getElements().isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            DbMigrationAction.$$$reportNull$$$0(2);
        }
        DirDiffModel m = this.myModel;
        Project project = e2.getProject();
        if (project == null) {
            return;
        }
        try {
            DbMigrationAction.migrate(m, this.myDirection);
        }
        catch (UnsupportedOperationException uoe) {
            Component source = e2.getInputEvent().getComponent();
            Messages.showErrorDialog((Component)source, (String)GridUtilCore.getMessage((Throwable)uoe), (String)DatabaseBundle.message("dialog.title.migration.available", new Object[0]));
        }
    }

    private static BasicModel getModel(DirDiffModel model2, boolean src2, boolean isPrimary) {
        DbDiffRoot r = ((DbDiffElement)(src2 ? model2.getSourceDir() : model2.getTargetDir())).getRoot();
        if (isPrimary) {
            return r.getModel();
        }
        return (BasicModel)ObjectUtils.notNull((Object)r.getAltModel(), (Object)r.getModel());
    }

    private static BasicElement getElement(DTree d2, boolean src2, boolean isPrimary) {
        DbDiffElement e2 = (DbDiffElement)(src2 ? d2.getSource() : d2.getTarget());
        if (e2 == null) {
            return null;
        }
        return isPrimary ? e2.getValue() : e2.getAltElement();
    }

    public static void migrate(DirDiffModel model2, Direction direction) {
        boolean isFromSrc = direction == Direction.FORWARD;
        DbDiffRoot root2 = ((DbDiffElement)(isFromSrc ? model2.getSourceDir() : model2.getTargetDir())).getRoot();
        SqlDataSource sqlTgt = (SqlDataSource)ObjectUtils.tryCast((Object)root2.getDataSource().getDelegate(), SqlDataSource.class);
        if (sqlTgt != null) {
            DbMigrationAction.performFileMigration(root2.getProject(), model2, isFromSrc, sqlTgt);
        } else {
            DbMigrationAction.performAlterMigration(root2.getProject(), model2, isFromSrc);
        }
    }

    private static void performFileMigration(@NotNull Project project, DirDiffModel model2, boolean isFromSrc, SqlDataSource sqlTgt) {
        if (project == null) {
            DbMigrationAction.$$$reportNull$$$0(3);
        }
        DbMigrationAction.createFileMigration(project, model2, isFromSrc, sqlTgt);
    }

    private static void performAlterMigration(final @NotNull Project project, final DirDiffModel model2, final boolean isFromSrc) {
        if (project == null) {
            DbMigrationAction.$$$reportNull$$$0(4);
        }
        new Task.Modal(project, DatabaseBundle.message("dialog.title.generating.migration.script", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                AlterScriptGenerator generator = new AlterScriptGenerator(project, model2, isFromSrc);
                ScriptingResult initialResult = generator.generate();
                ApplicationManager.getApplication().invokeLater(() -> DbMigrationAction.showAlterScript(initialResult, generator, project, model2, isFromSrc));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/model/diff/DbMigrationAction$1", "run"));
            }
        }.queue();
    }

    private static void showAlterScript(final ScriptingResult initialResult, final AlterScriptGenerator generator, Project project, DirDiffModel model2, boolean isFromSrc) {
        DiffElement source = isFromSrc ? model2.getSourceDir() : model2.getTargetDir();
        DiffElement target2 = isFromSrc ? model2.getTargetDir() : model2.getSourceDir();
        DbDataSource sourceDataSource = ((DbDiffElement)source).getRoot().getDataSource();
        SearchPath sourceSearchPath = DbMigrationAction.getSearchPath((DbDiffElement)source, sourceDataSource);
        String dialogTitle = DatabaseBundle.message("dialog.title.to.migration", source.getPresentablePath(), target2.getPresentablePath());
        DatabaseScriptDialog dialog = new DatabaseScriptDialog(project, sourceDataSource.getDelegateDataSource(), sourceSearchPath, dialogTitle){
            final AlterScriptGenerator myGenerator;
            private ProgressIndicator current;
            {
                super(project, dataSource2, searchPath, title);
                this.myGenerator = generator;
            }

            @Override
            protected void init() {
                super.init();
                this.setOKButtonText(DatabaseBundle.message("dialog.button.migration.script.execute", new Object[0]));
                this.updateText(initialResult);
            }

            @Override
            protected ScriptingTask getTask() {
                return this.myGenerator.createTask();
            }

            @Override
            protected AsyncTask<ScriptingTask> applyAndGetTask() {
                return AsyncTask.completed(this.getTask());
            }

            @Override
            protected void settingsChanged(ScriptingOptions options2) {
                this.myGenerator.setOptions(options2);
                this.generate();
            }

            private synchronized void generate() {
                this.myLoadingPanel.startLoading();
                if (this.current != null) {
                    this.current.cancel();
                }
                this.current = new EmptyProgressIndicator();
                this.generateAsync(this.current);
            }

            private void generateAsync(ProgressIndicator indicator) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    Runnable process2 = () -> {
                        ScriptingResult result2 = this.myGenerator.generate();
                        indicator.checkCanceled();
                        if (this.isDisposed()) {
                            return;
                        }
                        UIUtil.invokeLaterIfNeeded(() -> {
                            this.updateText(result2);
                            this.myLoadingPanel.stopLoading();
                        });
                    };
                    ProgressManager.getInstance().runProcess(process2, indicator);
                });
            }
        };
        dialog.initAndShow();
    }

    @Nullable
    public static SearchPath getSearchPath(DbDiffElement source, DbDataSource sourceDataSource) {
        DasNamespace sourceNamespace = DbImplUtilCore.getSearchPathObjectForSwitch(sourceDataSource, (DasObject)source.getValue());
        return ObjectPaths.searchPathOf((DasObject)ObjectUtils.tryCast((Object)sourceNamespace, BasicNamespace.class));
    }

    @NotNull
    public static ScriptingAlterTask prepareMigrationTask(DirDiffModel model2, boolean isFromSrc, ScriptingOptions options2) {
        BasicModel src2 = DbMigrationAction.getModel(model2, isFromSrc, true);
        BasicModModel tgt = (BasicModModel)DbMigrationAction.getModel(model2, !isFromSrc, false);
        ScriptingAlterTaskBuilder builder = new ScriptingAlterTaskBuilder(src2, tgt);
        DbMigrationAction.consumeChanged(model2, isFromSrc, (PairConsumer<BasicElement, BasicElement>)((PairConsumer)(srcE, tgtE) -> {
            if (srcE != null || tgtE != null) {
                builder.getCorrespondence().add(ElementDelta.create(srcE, tgtE));
            }
        }));
        builder.setOptions(options2);
        ScriptingAlterTask scriptingAlterTask = builder.build();
        if (scriptingAlterTask == null) {
            DbMigrationAction.$$$reportNull$$$0(5);
        }
        return scriptingAlterTask;
    }

    private static void createFileMigration(@NotNull Project project, DirDiffModel model2, boolean isFromSrc, SqlDataSource sqlTgt) {
        if (project == null) {
            DbMigrationAction.$$$reportNull$$$0(6);
        }
        BasicModModel tgt = (BasicModModel)DbMigrationAction.getModel(model2, !isFromSrc, false);
        ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder((BasicModel)tgt, ScriptCategory.CREATE_COMPLETE);
        DbMigrationAction.consumeChanged(model2, isFromSrc, (PairConsumer<BasicElement, BasicElement>)((PairConsumer)(srcE, tgtE) -> {
            if (tgtE != null) {
                builder.getElements().add((BasicElement)tgtE);
            }
        }));
        DumpToDdlDataSourceActionKt.generate(project, sqlTgt, builder, true);
    }

    private static void consumeChanged(DirDiffModel model2, boolean isFromSrc, PairConsumer<BasicElement, BasicElement> consumer2) {
        boolean ignoreAlter;
        List elements2 = model2.getElements();
        Map diffs = ContainerUtil.map2Map((Collection)elements2, e2 -> Pair.create((Object)Couple.of((Object)e2.getSource(), (Object)e2.getTarget()), (Object)e2.getOperation()));
        DTree rt = (DTree)JBIterable.generate((Object)((DirDiffElementImpl)elements2.get(0)).getNode(), DTree::getParent).last();
        boolean ignoreCreate = !model2.getSettings().showNewOnSource;
        boolean ignoreDrop = !model2.getSettings().showNewOnTarget;
        boolean bl = ignoreAlter = !model2.getSettings().showDifferent;
        if (isFromSrc) {
            boolean tmp = ignoreCreate;
            ignoreCreate = ignoreDrop;
            ignoreDrop = tmp;
        }
        for (DTree e3 : (JBTreeTraverser)JBTreeTraverser.from(DTree::getChildren).withRoot((Object)rt)) {
            if (DbMigrationAction.isIgnored(diffs, e3, isFromSrc)) continue;
            BasicElement srcE = DbMigrationAction.getElement(e3, isFromSrc, true);
            BasicElement tgtE = DbMigrationAction.getElement(e3, !isFromSrc, false);
            if (srcE == null && ignoreCreate || tgtE == null && ignoreDrop || srcE != null && tgtE != null && e3.getType() == DiffType.CHANGED && ignoreAlter) continue;
            consumer2.consume((Object)srcE, (Object)tgtE);
        }
    }

    private static boolean isIgnored(Map<Couple<DiffElement>, DirDiffOperation> diffs, DTree e2, boolean isFromSrc) {
        if (DbMigrationAction.getOperation(diffs, e2) == DirDiffOperation.NONE) {
            return true;
        }
        if (DbMigrationAction.getOperation(diffs, e2) == DirDiffOperation.DELETE && isFromSrc == (e2.getSource() == null)) {
            return true;
        }
        Collection children2 = e2.getChildren();
        if (ContainerUtil.find((Iterable)children2, c2 -> c2.getType() != DiffType.EQUAL) == null) {
            return false;
        }
        return ContainerUtil.find((Iterable)children2, c2 -> c2.getType() != DiffType.EQUAL && DbMigrationAction.getOperation(diffs, c2) != DirDiffOperation.NONE) == null;
    }

    private static DirDiffOperation getOperation(Map<Couple<DiffElement>, DirDiffOperation> diffs, DTree e2) {
        return diffs.get(Pair.create((Object)e2.getSource(), (Object)e2.getTarget()));
    }

    public void setModel(DirDiffModel model2) {
        this.myModel = model2;
        String source = this.myModel.getSourceDir().getPresentablePath();
        String target2 = this.myModel.getTargetDir().getPresentablePath();
        this.getTemplatePresentation().setDescription(DatabaseBundle.message("action.DbMigrationAction.migrate.to.state.description", this.myDirection == Direction.FORWARD ? target2 : source, this.myDirection == Direction.FORWARD ? source : target2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/DbMigrationAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/DbMigrationAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareMigrationTask";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performFileMigration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performAlterMigration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFileMigration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }

    private static class AlterScriptGenerator {
        final Project project;
        final ScriptingAlterTaskBuilder builder;

        AlterScriptGenerator(Project project, DirDiffModel model2, boolean isFromSrc) {
            this.project = project;
            BasicModel src2 = DbMigrationAction.getModel(model2, isFromSrc, true);
            BasicModModel tgt = (BasicModModel)DbMigrationAction.getModel(model2, !isFromSrc, false);
            this.builder = new ScriptingAlterTaskBuilder(src2, tgt);
            DbMigrationAction.consumeChanged(model2, isFromSrc, (PairConsumer<BasicElement, BasicElement>)((PairConsumer)(srcE, tgtE) -> {
                if (srcE != null || tgtE != null) {
                    this.builder.getCorrespondence().add(ElementDelta.create(srcE, tgtE));
                }
            }));
            DiffElement source = isFromSrc ? model2.getSourceDir() : model2.getTargetDir();
            this.setOptions(((DbDiffElement)source).getRoot().createOptions());
        }

        synchronized ScriptingTask createTask() {
            return this.builder.build();
        }

        synchronized void setOptions(ScriptingOptions options2) {
            this.builder.setOptions(options2);
        }

        @RequiresBackgroundThread
        ScriptingResult generate() {
            ThreadingAssertions.assertBackgroundThread();
            return ScriptGenerators.INSTANCE.makeScript(this.project, this.createTask());
        }
    }
}

