/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.layoutedQueries;

import com.intellij.database.layoutedQueries.BaseCommandRunner;
import com.intellij.database.layoutedQueries.BaseQueryRunner;
import com.intellij.database.layoutedQueries.BaseScriptRunner;
import com.intellij.database.layoutedQueries.BaseSeanceRunner;
import com.intellij.database.layoutedQueries.DBCommandRunner;
import com.intellij.database.layoutedQueries.DBLeasedSession;
import com.intellij.database.layoutedQueries.DBQueryRunner;
import com.intellij.database.layoutedQueries.DBScriptRunner;
import com.intellij.database.layoutedQueries.DBSession;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.layoutedQueries.impl.IntegralIntermediateSeance;
import com.intellij.database.layoutedQueries.impl.IntegralIntermediateSession;
import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.sql.SqlCommand;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.remote.jdba.sql.SqlScript;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseSession
implements DBSession,
DBLeasedSession,
DBTransaction {
    @NotNull
    private final IntegralIntermediateSession myInterSession;
    private final Queue<BaseSeanceRunner> myRunners;

    protected BaseSession(@NotNull IntegralIntermediateSession interSession) {
        if (interSession == null) {
            BaseSession.$$$reportNull$$$0(0);
        }
        this.myRunners = new LinkedList<BaseSeanceRunner>();
        this.myInterSession = interSession;
    }

    @Override
    @NotNull
    public synchronized DBCommandRunner command(@NotNull SqlCommand command2) {
        if (command2 == null) {
            BaseSession.$$$reportNull$$$0(1);
        }
        IntegralIntermediateSeance interSeance = this.myInterSession.openSeance(command2.getSourceText(), null);
        BaseCommandRunner commandRunner = new BaseCommandRunner(interSeance);
        this.myRunners.add(commandRunner);
        BaseCommandRunner baseCommandRunner = commandRunner;
        if (baseCommandRunner == null) {
            BaseSession.$$$reportNull$$$0(2);
        }
        return baseCommandRunner;
    }

    @Override
    @NotNull
    public synchronized DBCommandRunner command(@NotNull String commandText) {
        if (commandText == null) {
            BaseSession.$$$reportNull$$$0(3);
        }
        IntegralIntermediateSeance interSeance = this.myInterSession.openSeance(commandText, null);
        BaseCommandRunner commandRunner = new BaseCommandRunner(interSeance);
        this.myRunners.add(commandRunner);
        BaseCommandRunner baseCommandRunner = commandRunner;
        if (baseCommandRunner == null) {
            BaseSession.$$$reportNull$$$0(4);
        }
        return baseCommandRunner;
    }

    @NotNull
    public synchronized <S> BaseQueryRunner<S> query(@NotNull SqlQuery<S> query) {
        if (query == null) {
            BaseSession.$$$reportNull$$$0(5);
        }
        IntegralIntermediateSeance interSeance = this.myInterSession.openSeance(query.getSourceText(), null);
        BaseQueryRunner queryRunner = new BaseQueryRunner(interSeance, query.getLayout());
        this.myRunners.add(queryRunner);
        BaseQueryRunner baseQueryRunner = queryRunner;
        if (baseQueryRunner == null) {
            BaseSession.$$$reportNull$$$0(6);
        }
        return baseQueryRunner;
    }

    @NotNull
    public synchronized <S> BaseQueryRunner<S> query(@NotNull String queryText2, @NotNull ResultLayout<S> layout) {
        if (queryText2 == null) {
            BaseSession.$$$reportNull$$$0(7);
        }
        if (layout == null) {
            BaseSession.$$$reportNull$$$0(8);
        }
        SqlQuery query = new SqlQuery(queryText2, layout);
        DBQueryRunner dBQueryRunner = this.query(query);
        if (dBQueryRunner == null) {
            BaseSession.$$$reportNull$$$0(9);
        }
        return dBQueryRunner;
    }

    @Override
    @NotNull
    public synchronized DBScriptRunner script(@NotNull SqlScript script2) {
        if (script2 == null) {
            BaseSession.$$$reportNull$$$0(10);
        }
        return new BaseScriptRunner(this, script2);
    }

    protected synchronized void closeRunners() {
        while (!this.myRunners.isEmpty()) {
            BaseSeanceRunner runner = this.myRunners.poll();
            runner.close();
        }
    }

    @Nullable
    public synchronized <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        if (serviceClass == null) {
            BaseSession.$$$reportNull$$$0(11);
        }
        if (serviceName == null) {
            BaseSession.$$$reportNull$$$0(12);
        }
        return (I)this.myInterSession.getSpecificService(serviceClass, serviceName);
    }

    @Override
    public synchronized boolean isClosed() {
        return this.myInterSession.isClosed();
    }

    @Override
    public synchronized void close() {
        this.closeRunners();
        this.myInterSession.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interSession";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/layoutedQueries/BaseSession";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/layoutedQueries/BaseSession";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "command";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "command";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "query";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "script";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificService";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 9 -> new IllegalStateException(string);
        };
    }
}

