/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.AffectedObjectScriptedMention;
import com.intellij.database.introspection.BelongingAreaKind;
import com.intellij.database.introspection.Impactees;
import com.intellij.database.introspection.ObjectAffectionType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPart;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\tJB\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\tJT\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\tR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/introspection/ImpacteesBuilder;", "", "currentDatabasePath", "Lcom/intellij/database/util/ObjectPart;", "currentSchemaPath", "(Lcom/intellij/database/util/ObjectPart;Lcom/intellij/database/util/ObjectPart;)V", "currentDatabaseName", "", "currentDatabaseNameIsQuoted", "", "currentSchemaName", "currentSchemaNameIsQuoted", "mentions", "", "Lcom/intellij/database/introspection/AffectedObjectScriptedMention;", "build", "Lcom/intellij/database/introspection/Impactees;", "include", "", "affectType", "Lcom/intellij/database/introspection/ObjectAffectionType;", "affectAreaKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectName", "objectNameIsQuoted", "schemaName", "schemaNameIsQuoted", "databaseName", "databaseNameIsQuoted", "intellij.database.core.impl"})
public final class ImpacteesBuilder {
    @NotNull
    private final String currentDatabaseName;
    @NotNull
    private final String currentSchemaName;
    private final boolean currentDatabaseNameIsQuoted;
    private final boolean currentSchemaNameIsQuoted;
    @NotNull
    private final Set<AffectedObjectScriptedMention> mentions;

    public ImpacteesBuilder(@Nullable ObjectPart currentDatabasePath, @Nullable ObjectPart currentSchemaPath) {
        if (currentDatabasePath != null) {
            String string = currentDatabasePath.name;
            if (string == null) {
                string = "@";
            }
            this.currentDatabaseName = string;
            this.currentDatabaseNameIsQuoted = currentDatabasePath.isQuoted();
        } else {
            this.currentDatabaseName = "@";
            this.currentDatabaseNameIsQuoted = false;
        }
        if (currentSchemaPath != null) {
            String string = currentSchemaPath.name;
            if (string == null) {
                string = "@";
            }
            this.currentSchemaName = string;
            this.currentSchemaNameIsQuoted = currentSchemaPath.isQuoted();
        } else {
            this.currentSchemaName = "@";
            this.currentSchemaNameIsQuoted = false;
        }
        this.mentions = new TreeSet();
    }

    public final void include(@NotNull ObjectAffectionType affectType, @Nullable BelongingAreaKind affectAreaKind, @NotNull ObjectKind objectKind, @NotNull String objectName, boolean objectNameIsQuoted) {
        Intrinsics.checkNotNullParameter((Object)((Object)affectType), (String)"affectType");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        String string = this.currentDatabaseName;
        boolean bl = this.currentDatabaseNameIsQuoted;
        String string2 = this.currentSchemaName;
        boolean bl2 = this.currentSchemaNameIsQuoted;
        AffectedObjectScriptedMention m = new AffectedObjectScriptedMention(string, bl, string2, bl2, objectName, objectNameIsQuoted, objectKind, affectAreaKind, affectType);
        this.mentions.add(m);
    }

    public final void include(@NotNull ObjectAffectionType affectType, @Nullable BelongingAreaKind affectAreaKind, @NotNull ObjectKind objectKind, @NotNull String objectName, boolean objectNameIsQuoted, @Nullable String schemaName, boolean schemaNameIsQuoted) {
        Intrinsics.checkNotNullParameter((Object)((Object)affectType), (String)"affectType");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        String string = this.currentDatabaseName;
        boolean bl = this.currentDatabaseNameIsQuoted;
        String string2 = schemaName;
        if (string2 == null) {
            string2 = this.currentSchemaName;
        }
        String string3 = string2;
        boolean bl2 = schemaName != null ? schemaNameIsQuoted : this.currentSchemaNameIsQuoted;
        AffectedObjectScriptedMention m = new AffectedObjectScriptedMention(string, bl, string3, bl2, objectName, objectNameIsQuoted, objectKind, affectAreaKind, affectType);
        this.mentions.add(m);
    }

    public final void include(@NotNull ObjectAffectionType affectType, @Nullable BelongingAreaKind affectAreaKind, @NotNull ObjectKind objectKind, @NotNull String objectName, boolean objectNameIsQuoted, @Nullable String schemaName, boolean schemaNameIsQuoted, @Nullable String databaseName, boolean databaseNameIsQuoted) {
        Intrinsics.checkNotNullParameter((Object)((Object)affectType), (String)"affectType");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        if (databaseName == null || Intrinsics.areEqual((Object)databaseName, (Object)this.currentDatabaseName)) {
            this.include(affectType, affectAreaKind, objectKind, objectName, objectNameIsQuoted, schemaName, schemaNameIsQuoted);
            return;
        }
        String string = schemaName;
        if (string == null) {
            string = "@";
        }
        String string2 = string;
        boolean bl = schemaName != null && schemaNameIsQuoted;
        AffectedObjectScriptedMention m = new AffectedObjectScriptedMention(databaseName, databaseNameIsQuoted, string2, bl, objectName, objectNameIsQuoted, objectKind, affectAreaKind, affectType);
        this.mentions.add(m);
    }

    @NotNull
    public final Impactees build() {
        return switch (this.mentions.size()) {
            case 0 -> Impactees.EMPTY;
            case 1 -> {
                Set<Object> v1 = Collections.singleton(CollectionsKt.first((Iterable)this.mentions));
                Intrinsics.checkNotNullExpressionValue(v1, (String)"singleton(...)");
                yield Impactees.Companion.of(v1);
            }
            default -> Impactees.Companion.of(this.mentions);
        };
    }
}

