/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.introspector;

import com.google.common.collect.ImmutableList;
import com.intellij.database.Dbms;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.sybase.introspector.AseIntroQueries;
import com.intellij.database.dialects.sybase.introspector.AseIntrospector;
import com.intellij.database.dialects.sybase.introspector.AseIntrospectorKt;
import com.intellij.database.dialects.sybase.introspector.SrcText;
import com.intellij.database.dialects.sybase.model.AseArgument;
import com.intellij.database.dialects.sybase.model.AseCheck;
import com.intellij.database.dialects.sybase.model.AseDatabase;
import com.intellij.database.dialects.sybase.model.AseForeignKey;
import com.intellij.database.dialects.sybase.model.AseFunction;
import com.intellij.database.dialects.sybase.model.AseGrantsHolder;
import com.intellij.database.dialects.sybase.model.AseIndex;
import com.intellij.database.dialects.sybase.model.AseKey;
import com.intellij.database.dialects.sybase.model.AseLikeColumn;
import com.intellij.database.dialects.sybase.model.AseLikeTable;
import com.intellij.database.dialects.sybase.model.AseLogin;
import com.intellij.database.dialects.sybase.model.AseMajorObject;
import com.intellij.database.dialects.sybase.model.AseProcedure;
import com.intellij.database.dialects.sybase.model.AseProcedureGroup;
import com.intellij.database.dialects.sybase.model.AseRole;
import com.intellij.database.dialects.sybase.model.AseRoot;
import com.intellij.database.dialects.sybase.model.AseRoutine;
import com.intellij.database.dialects.sybase.model.AseSchema;
import com.intellij.database.dialects.sybase.model.AseSchemaObject;
import com.intellij.database.dialects.sybase.model.AseTable;
import com.intellij.database.dialects.sybase.model.AseTableColumn;
import com.intellij.database.dialects.sybase.model.AseTrigger;
import com.intellij.database.dialects.sybase.model.AseUser;
import com.intellij.database.dialects.sybase.model.AseView;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.references.BasicIdOrNameReference;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicPositionReference;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.remote.jdba.util.StringOperator;
import com.intellij.database.remote.jdba.util.Strings;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Version;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0003!\"#B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0014J&\u0010\u0012\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001H\u0014J\u001c\u0010\u0014\u001a\u00060\u0015R\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0014J\u001c\u0010\u0019\u001a\u00060\u001aR\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0004H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0014J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/sybase/model/AseRoot;", "Lcom/intellij/database/dialects/sybase/model/AseDatabase;", "Lcom/intellij/database/dialects/sybase/model/AseSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "myQueries", "Lcom/intellij/database/dialects/sybase/introspector/AseIntroQueries;", "checkElementsUptodate", "", "Lcom/intellij/database/model/basic/BasicElement;", "", "elements", "", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseSchemaRetriever;", "schema", "introspectTheServerObjects", "", "tran", "retrieveLogins", "retrieveRoles", "AseDatabaseRetriever", "AseSchemaRetriever", "Factory", "intellij.database.dialects.sybase"})
@SourceDebugExtension(value={"SMAP\nAseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,955:1\n1855#2,2:956\n215#3,2:958\n*S KotlinDebug\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector\n*L\n78#1:956,2\n88#1:958,2\n*E\n"})
public final class AseIntrospector
extends BaseMultiDatabaseIntrospector<AseRoot, AseDatabase, AseSchema> {
    @NotNull
    private final AseIntroQueries myQueries;

    public AseIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.SYBASE;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"SYBASE");
        super(context, nature, dbms, modelFactory);
        AseIntroQueries aseIntroQueries = AseIntroQueries.QUERIES;
        Intrinsics.checkNotNullExpressionValue((Object)aseIntroQueries, (String)"QUERIES");
        this.myQueries = aseIntroQueries;
    }

    @Override
    @NotNull
    protected Map<BasicElement, Boolean> checkElementsUptodate(@NotNull Iterable<? extends BasicElement> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        LinkedHashMap<BasicElement, Boolean> res2 = new LinkedHashMap<BasicElement, Boolean>();
        for (BasicDatabase database : JBIterable.from(elements2).transform(arg_0 -> AseIntrospector.checkElementsUptodate$lambda$0(checkElementsUptodate.1.INSTANCE, arg_0)).toSet()) {
            LinkedHashMap ids = new LinkedHashMap();
            Iterable<? extends BasicElement> $this$forEach$iv = elements2;
            boolean $i$f$forEach = false;
            Iterator<? extends BasicElement> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                BasicElement basicElement;
                BasicElement it2 = basicElement = iterator.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getDatabase(), (Object)database) || !AseIntrospectorKt.access$canCheckOutdated(it2)) continue;
                Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type com.intellij.database.dialects.sybase.model.AseSchemaObject");
                AseSchemaObject cfr_ignored_0 = (AseSchemaObject)it2;
                ((Map)ids).put(((AseSchemaObject)it2).getObjectId(), it2);
            }
            if (ids.isEmpty()) continue;
            BasicDatabase basicDatabase = database;
            Intrinsics.checkNotNull((Object)basicDatabase);
            this.setQueryParameter("CAT", AseIntrospectorKt.access$catalogPrefix(basicDatabase));
            Set set = ids.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            this.setQueryParameter("OBJECT_IDS", CollectionsKt.toLongArray((Collection)set));
            BaseNativeIntrospector baseNativeIntrospector = this;
            SqlQuery<List<AseIntroQueries.OneState>> sqlQuery = AseIntroQueries.QUERIES.retrieveStates;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveStates");
            List states2 = (List)BaseNativeIntrospector.performQuery$default(baseNativeIntrospector, sqlQuery, null, 2, null);
            Map $this$forEach$iv2 = ids;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv3;
                Map.Entry entry = element$iv3 = iterator2.next();
                boolean bl = false;
                AseSchemaObject v2 = (AseSchemaObject)entry.getValue();
                ((Map)res2).put(v2, false);
            }
            for (AseIntroQueries.OneState s2 : states2) {
                AseSchemaObject aseSchemaObject;
                if ((AseSchemaObject)ids.get(s2.object_id) == null) continue;
                ((Map)res2).put(aseSchemaObject, aseSchemaObject.getStateNumber() == s2.state_nr);
            }
        }
        this.inModel((Function1)new Function1<AseRoot, Unit>(res2){
            final /* synthetic */ LinkedHashMap<BasicElement, Boolean> $res;
            {
                this.$res = $res;
                super(1);
            }

            public final void invoke(@NotNull AseRoot it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                Set<Map.Entry<BasicElement, Boolean>> set = this.$res.entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)entry);
                    BasicElement obj2 = (BasicElement)entry.getKey();
                    Boolean ok2 = (Boolean)entry.getValue();
                    Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
                    ((BasicModElement)obj2).setOutdated(ok2 == false);
                }
            }
        });
        return res2;
    }

    @Override
    protected void introspectTheServerObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.retrieveLogins(tran);
        this.retrieveRoles(tran);
    }

    private final void retrieveLogins(DBTransaction transaction) {
        SqlQuery<List<AseIntroQueries.OneLogin>> sqlQuery = this.myQueries.retrieveLogins;
        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveLogins");
        List<AseIntroQueries.OneLogin> logins = this.performQuery(transaction, sqlQuery);
        this.inModel((Function1)new Function1<AseRoot, Unit>(logins){
            final /* synthetic */ List<AseIntroQueries.OneLogin> $logins;
            {
                this.$logins = $logins;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull AseRoot r) {
                void $this$modifyAndCleanup_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                ModFamily modFamily = r.getLogins();
                List<AseIntroQueries.OneLogin> list = this.$logins;
                boolean inc$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModNamingIdentifyingFamily it2 = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl = false;
                for (AseIntroQueries.OneLogin l : list) {
                    AseLogin aseLogin;
                    AseLogin $this$invoke_u24lambda_u241_u24lambda_u240 = aseLogin = r.getLogins().renew(l.id, l.name);
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u241_u24lambda_u240.setDefaultDatabaseRef(BasicNameReference.create(l.default_db));
                    $this$invoke_u24lambda_u241_u24lambda_u240.setLanguage(l.language);
                    $this$invoke_u24lambda_u241_u24lambda_u240.setFullName(l.fullname);
                    $this$invoke_u24lambda_u241_u24lambda_u240.setLoginScriptId(l.procid);
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
        });
    }

    private final void retrieveRoles(DBTransaction transaction) {
        block2: {
            try {
                SqlQuery<List<AseIntroQueries.OneRole>> sqlQuery = this.myQueries.retrieveRoles;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveRoles");
                List<AseIntroQueries.OneRole> roles = this.performQuery(transaction, sqlQuery);
                this.inModel((Function1)new Function1<AseRoot, Unit>(roles){
                    final /* synthetic */ List<AseIntroQueries.OneRole> $roles;
                    {
                        this.$roles = $roles;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull AseRoot r) {
                        void $this$modifyAndCleanup_u24default$iv;
                        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                        ModFamily modFamily = r.getRoles();
                        List<AseIntroQueries.OneRole> list = this.$roles;
                        boolean inc$iv = true;
                        boolean $i$f$modifyAndCleanup = false;
                        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                        ModNamingIdentifyingFamily it2 = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                        boolean bl = false;
                        for (AseIntroQueries.OneRole role : list) {
                            AseRole aseRole;
                            AseRole $this$invoke_u24lambda_u241_u24lambda_u240 = aseRole = r.getRoles().renew(role.id, role.name);
                            boolean bl2 = false;
                        }
                        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                        $this$modifyAndCleanup_u24default$iv.sort();
                    }
                });
            }
            catch (DBException e2) {
                this.inModel(retrieveRoles.2.INSTANCE);
                String string = e2.getMessage();
                if (string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"permission denied", (boolean)true) : false) break block2;
                throw e2;
            }
        }
    }

    @NotNull
    protected AseDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull AseDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new AseDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected AseSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull AseSchema schema2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        return new AseSchemaRetriever(transaction, schema2);
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<LongIdName, AseDatabase>(this){
            final /* synthetic */ AseIntrospector this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            protected List<LongIdName> listDatabases(@NotNull DBTransaction tran) {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                List<LongIdName> list = tran.query(AseIntrospector.access$getMyQueries$p((AseIntrospector)this.this$0).listDatabases).runOnce();
                Intrinsics.checkNotNullExpressionValue(list, (String)"runOnce(...)");
                return list;
            }

            @NotNull
            protected AseDatabase applyDatabase(@NotNull ModNamingFamily<?> databases2, @NotNull LongIdName db2) {
                Intrinsics.checkNotNullParameter(databases2, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                return (AseDatabase)this.renew(databases2, db2.id, db2.name);
            }
        };
    }

    private static final BasicDatabase checkElementsUptodate$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicDatabase)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Version access$getServerVersion(AseIntrospector $this) {
        return $this.getServerVersion();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/sybase/model/AseDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/sybase/model/AseRoot;", "Lcom/intellij/database/dialects/sybase/model/AseSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/sybase/model/AseDatabase;)V", "beforeSchemasRetrieval", "", "retrieveGrants", "retrieveSchemas", "retrieveServerAndDatabaseObjects", "retrieveUsers", "intellij.database.dialects.sybase"})
    @SourceDebugExtension(value={"SMAP\nAseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseDatabaseRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,955:1\n1855#2,2:956\n*S KotlinDebug\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseDatabaseRetriever\n*L\n183#1:956,2\n*E\n"})
    protected final class AseDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<AseDatabase> {
        public AseDatabaseRetriever(@NotNull DBTransaction transaction, AseDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)AseIntrospector.this, transaction, (BasicModMateDatabase)database);
        }

        @Override
        protected void beforeSchemasRetrieval() {
            this.setQueryParameter("CAT", AseIntrospectorKt.access$catalogPrefix((BasicDatabase)this.getDatabase()));
        }

        @Override
        public void retrieveSchemas() {
            super.retrieveSchemas();
            this.inDatabase((Function1)new Function1<AseDatabase, Unit>(this, AseIntrospector.this){
                final /* synthetic */ AseDatabaseRetriever this$0;
                final /* synthetic */ AseIntrospector this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull AseDatabase it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    NamingFamily namingFamily = it2.getSchemas();
                    Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
                    SqlQuery<List<LongIdName>> sqlQuery = AseIntrospector.access$getMyQueries$p((AseIntrospector)this.this$1).listSchemas;
                    Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"listSchemas");
                    Object object = AseDatabaseRetriever.access$performQuery(this.this$0, sqlQuery);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"access$performQuery(...)");
                    ModelFun.applyNameIds(namingFamily, (List)object);
                }
            });
        }

        @Override
        public void retrieveServerAndDatabaseObjects() {
            super.retrieveServerAndDatabaseObjects();
            this.retrieveUsers();
            this.retrieveGrants();
        }

        private final void retrieveGrants() {
            SqlQuery<List<AseIntroQueries.OneGrant>> sqlQuery = ((AseIntrospector)AseIntrospector.this).myQueries.retrieveDatabaseGrants;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveDatabaseGrants");
            List<AseIntroQueries.OneGrant> grants = this.performQuery(sqlQuery);
            Intrinsics.checkNotNull(grants);
            Iterable $this$forEach$iv = grants;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseIntroQueries.OneGrant it2 = (AseIntroQueries.OneGrant)element$iv;
                boolean bl = false;
                if (it2.object_id != 0) continue;
                it2.object_id = (int)((AseDatabase)this.getDatabase()).getObjectId();
            }
            this.inDatabase((Function1)new Function1<AseDatabase, Unit>(grants){
                final /* synthetic */ List<AseIntroQueries.OneGrant> $grants;
                {
                    this.$grants = $grants;
                    super(1);
                }

                public final void invoke(@NotNull AseDatabase it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    AseGrantsHolder aseGrantsHolder = it2;
                    List<AseIntroQueries.OneGrant> list = this.$grants;
                    Intrinsics.checkNotNullExpressionValue(list, (String)"$grants");
                    AseIntrospectorKt.access$applyGrants(aseGrantsHolder, list);
                }
            });
        }

        private final void retrieveUsers() {
            SqlQuery<List<AseIntroQueries.OneUser>> sqlQuery = ((AseIntrospector)AseIntrospector.this).myQueries.retrieveUsers;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveUsers");
            List<AseIntroQueries.OneUser> users = this.performQuery(sqlQuery);
            this.inDatabase((Function1)new Function1<AseDatabase, Unit>(users){
                final /* synthetic */ List<AseIntroQueries.OneUser> $users;
                {
                    this.$users = $users;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull AseDatabase db2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                    ModFamily modFamily = db2.getUsers();
                    List<AseIntroQueries.OneUser> list = this.$users;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily it2 = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    for (AseIntroQueries.OneUser user : list) {
                        AseUser aseUser;
                        AseUser $this$invoke_u24lambda_u241_u24lambda_u240 = aseUser = db2.getUsers().renew(user.id, user.name);
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.setGroupRef(BasicIdReference.create(user.group_id));
                        $this$invoke_u24lambda_u241_u24lambda_u240.setLoginRef(BasicIdReference.create(user.login_id));
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        public static final /* synthetic */ Object access$performQuery(AseDatabaseRetriever $this, SqlQuery query) {
            return $this.performQuery(query);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0014J\u001a\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\b\u0010!\u001a\u00020\u0011H\u0014J\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010+\u001a\u00020\u0011H\u0002J\b\u0010,\u001a\u00020\u0011H\u0002J\b\u0010-\u001a\u00020\u0011H\u0002J\b\u0010.\u001a\u00020\u0011H\u0002J\b\u0010/\u001a\u00020\u0011H\u0002J\b\u00100\u001a\u00020\u0011H\u0002J\b\u00101\u001a\u00020\u0011H\u0014J\b\u00102\u001a\u00020\u0011H\u0014J\b\u00103\u001a\u00020\u0011H\u0002J\b\u00104\u001a\u00020\u0011H\u0002J\b\u00105\u001a\u00020\u0011H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/sybase/model/AseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/sybase/model/AseRoot;", "Lcom/intellij/database/dialects/sybase/model/AseDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/sybase/model/AseSchema;)V", "rewriter", "Lcom/intellij/database/remote/jdba/util/StringOperator;", "schemaId", "", "wasProcedures", "", "addRoutineArgument", "", "routine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "ca", "Lcom/intellij/database/dialects/sybase/introspector/AseIntroQueries$OneColumnOrArgument;", "dt", "Lcom/intellij/database/model/DataType;", "adjustDef", "", "def", "analyzeCurrentContent", "cleanupTableDefaults", "table", "Lcom/intellij/database/dialects/sybase/model/AseTable;", "columnsWithDef", "Lit/unimi/dsi/fastutil/ints/IntSet;", "clearSchema", "isPossibleToIntrospectSchemaIncrementally", "tran", "peekColumnPositions", "", "keys", "", "peekIndexColumns", "index", "Lcom/intellij/database/dialects/sybase/model/AseIndex;", "retrieveCheckConstraints", "retrieveColumnsAndArguments", "retrieveDefaults", "retrieveForeignKeys", "retrieveGrants", "retrieveIndicesAndKeys", "retrieveMainContent", "retrieveMajorNames", "retrieveProcedures", "retrieveSources", "retrieveTriggers", "intellij.database.dialects.sybase"})
    @SourceDebugExtension(value={"SMAP\nAseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseSchemaRetriever\n+ 2 NumberFun.kt\ncom/intellij/database/util/common/NumberFun\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 5 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 6 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n*L\n1#1,955:1\n48#2:956\n38#2:957\n288#3,2:958\n1855#3,2:1029\n107#4:960\n79#4,22:961\n107#4:983\n79#4,22:984\n107#4:1006\n79#4,22:1007\n390#5:1031\n391#5,2:1038\n966#6,2:1032\n1061#6,2:1034\n968#6,2:1036\n972#6:1040\n1066#6,2:1041\n973#6,2:1043\n*S KotlinDebug\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseSchemaRetriever\n*L\n374#1:956\n374#1:957\n456#1:958,2\n633#1:1029,2\n622#1:960\n622#1:961,22\n624#1:983\n624#1:984,22\n627#1:1006\n627#1:1007,22\n679#1:1031\n679#1:1038,2\n679#1:1032,2\n679#1:1034,2\n679#1:1036,2\n679#1:1040\n679#1:1041,2\n679#1:1043,2\n*E\n"})
    protected final class AseSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<AseSchema> {
        private final int schemaId;
        @NotNull
        private final StringOperator rewriter;
        private boolean wasProcedures;

        public AseSchemaRetriever(@NotNull DBTransaction transaction, AseSchema schema2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            super((BaseNativeIntrospector)AseIntrospector.this, transaction, (BasicModSchema)schema2);
            this.schemaId = (int)schema2.getObjectId();
            AseDatabase db2 = schema2.getDatabase();
            if (db2 == null || db2.isCurrent()) {
                object = "dbo";
            } else {
                char c2 = '[';
                String string = db2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = string;
                object = c2 + string2 + "].dbo";
            }
            String catalogPrefix = object;
            this.rewriter = arg_0 -> AseSchemaRetriever._init_$lambda$0(catalogPrefix, arg_0);
        }

        @Override
        public boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull AseSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            return false;
        }

        @Override
        protected void clearSchema() {
        }

        @Override
        protected void analyzeCurrentContent() {
        }

        private final void retrieveGrants() {
            Object[] objectArray = new Object[]{this.schemaId};
            List grants = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveSchemaGrants.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema((Function1)new Function1<AseSchema, Unit>((List<AseIntroQueries.OneGrant>)grants){
                final /* synthetic */ List<AseIntroQueries.OneGrant> $grants;
                {
                    this.$grants = $grants;
                    super(1);
                }

                public final void invoke(@NotNull AseSchema it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    AseGrantsHolder aseGrantsHolder = it2;
                    List<AseIntroQueries.OneGrant> list = this.$grants;
                    Intrinsics.checkNotNullExpressionValue(list, (String)"$grants");
                    AseIntrospectorKt.access$applyGrants(aseGrantsHolder, list);
                }
            });
        }

        @Override
        protected void retrieveMajorNames() {
            AseIntrospector.this.reportRetrieving("major object names", "introspection.retrieve.majorObjectNames");
            Object[] objectArray = new Object[]{this.schemaId};
            List ms = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveMajorNames.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema((Function1)new Function1<AseSchema, Unit>((List<AseIntroQueries.OneMajorName>)ms, this){
                final /* synthetic */ List<AseIntroQueries.OneMajorName> $ms;
                final /* synthetic */ AseSchemaRetriever this$0;
                {
                    this.$ms = $ms;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull AseSchema schema2) {
                    void families$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModFamily[] modFamilyArray = new ModFamily[4];
                    Intrinsics.checkNotNullExpressionValue(schema2.getTables(), (String)"getTables(...)");
                    Intrinsics.checkNotNullExpressionValue(schema2.getViews(), (String)"getViews(...)");
                    Intrinsics.checkNotNullExpressionValue(schema2.getFunctions(), (String)"getFunctions(...)");
                    Intrinsics.checkNotNullExpressionValue(schema2.getProcedureGroups(), (String)"getProcedureGroups(...)");
                    List<AseIntroQueries.OneMajorName> list = this.$ms;
                    AseSchemaRetriever aseSchemaRetriever = this.this$0;
                    boolean inc$iv = true;
                    boolean $i$f$modifyFamiliesAndCleanup = false;
                    for (void f$iv : families$iv) {
                        f$iv.markChildrenAsSyncPending();
                    }
                    boolean bl = false;
                    for (AseIntroQueries.OneMajorName m : list) {
                        ModNamingIdentifyingFamily<AseMajorObject> family = null;
                        char c2 = m.type;
                        if (c2 == 'U' ? true : c2 == 'S') {
                            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema2.getTables();
                            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
                            family = modNamingIdentifyingFamily;
                        } else if (c2 == 'V') {
                            ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily = schema2.getViews();
                            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getViews(...)");
                            family = modNamingIdentifyingFamily;
                        } else if (c2 == 'F') {
                            ModNamingIdentifyingFamily<? extends AseFunction> modNamingIdentifyingFamily = schema2.getFunctions();
                            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getFunctions(...)");
                            family = modNamingIdentifyingFamily;
                        } else {
                            if (c2 != 'P') continue;
                            ModNamingIdentifyingFamily<? extends AseProcedureGroup> modNamingIdentifyingFamily = schema2.getProcedureGroups();
                            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getProcedureGroups(...)");
                            family = modNamingIdentifyingFamily;
                        }
                        AseSchemaRetriever.access$setWasProcedures$p(aseSchemaRetriever, AseSchemaRetriever.access$getWasProcedures$p(aseSchemaRetriever) | m.type == 'P');
                        AseMajorObject obj2 = family.renew(m.id, m.name);
                        obj2.setStateNumber(m.state_nr);
                    }
                    for (void f$iv : families$iv) {
                        f$iv.removeSyncPendingChildren();
                        f$iv.sort();
                    }
                }
            });
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveProcedures();
            this.retrieveColumnsAndArguments();
            this.retrieveDefaults();
            this.retrieveIndicesAndKeys();
            this.retrieveForeignKeys();
            this.retrieveCheckConstraints();
            this.retrieveTriggers();
            this.retrieveGrants();
            this.retrieveSources();
            this.finishSchema();
        }

        private final void retrieveProcedures() {
            if (!this.wasProcedures) {
                return;
            }
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List ps = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveProcedures.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema((Function1)new Function1<AseSchema, Unit>((List<AseIntroQueries.OneProcedure>)ps){
                final /* synthetic */ List<AseIntroQueries.OneProcedure> $ps;
                {
                    this.$ps = $ps;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull AseSchema schema2) {
                    void families$iv;
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModNamingIdentifyingFamily<? extends AseProcedureGroup> modNamingIdentifyingFamily = schema2.getProcedureGroups();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getProcedureGroups(...)");
                    ModNamingIdentifyingFamily<? extends AseProcedureGroup> groups2 = modNamingIdentifyingFamily;
                    List<AseIntroQueries.OneProcedure> $this$map$iv = (List<AseIntroQueries.OneProcedure>)((Object)groups2);
                    boolean $i$f$map = false;
                    List<AseIntroQueries.OneProcedure> list = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        AseProcedureGroup aseProcedureGroup = (AseProcedureGroup)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(it2.getProcedures());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    list = this.$ps;
                    boolean inc$iv = true;
                    boolean $i$f$modifyFamiliesAndCleanup = false;
                    void $this$toTypedArray$iv$iv = families$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                    ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
                    ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
                    boolean $i$f$modifyFamiliesAndCleanup2 = false;
                    for (ModFamily f$iv$iv : families$iv$iv) {
                        f$iv$iv.markChildrenAsSyncPending();
                    }
                    boolean bl = false;
                    for (AseIntroQueries.OneProcedure p2 : list) {
                        AseProcedureGroup group2;
                        if ((AseProcedureGroup)groups2.getByObjectId((long)p2.id) == null) continue;
                        group2.getProcedures().createOrGetAt(p2.procedure_position);
                    }
                    for (ModFamily f$iv$iv : families$iv$iv) {
                        f$iv$iv.removeSyncPendingChildren();
                        f$iv$iv.sort();
                    }
                }
            });
        }

        private final void retrieveColumnsAndArguments() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List cas = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveColumnsAndArguments.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema((Function1)new Function1<AseSchema, Unit>((List<AseIntroQueries.OneColumnOrArgument>)cas, AseIntrospector.this, this){
                final /* synthetic */ List<AseIntroQueries.OneColumnOrArgument> $cas;
                final /* synthetic */ AseIntrospector this$0;
                final /* synthetic */ AseSchemaRetriever this$1;
                {
                    this.$cas = $cas;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull AseSchema schema2) {
                    Iterator<Object> $this$flatMapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModNamingIdentifyingFamily<? extends AseProcedureGroup> modNamingIdentifyingFamily = schema2.getProcedureGroups();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getProcedureGroups(...)");
                    Iterable $this$flatMap$iv = modNamingIdentifyingFamily;
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    Iterator<T> iterator = $this$flatMapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv$iv = iterator.next();
                        AseProcedureGroup it2 = (AseProcedureGroup)element$iv$iv;
                        boolean bl = false;
                        ModPositioningNamingFamily<? extends AseProcedure> modPositioningNamingFamily = it2.getProcedures();
                        Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getProcedures(...)");
                        Iterable list$iv$iv = modPositioningNamingFamily;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    Iterable procedures = (List)destination$iv$iv;
                    ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily2 = schema2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
                    Iterable iterable2 = modNamingIdentifyingFamily2;
                    ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily3 = schema2.getViews();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getViews(...)");
                    Iterable $this$forEach$iv = CollectionsKt.plus((Iterable)iterable2, (Iterable)modNamingIdentifyingFamily3);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        AseLikeTable it3 = (AseLikeTable)element$iv;
                        boolean bl = false;
                        it3.getColumns().markChildrenAsSyncPending();
                    }
                    ModNamingIdentifyingFamily<? extends AseFunction> modNamingIdentifyingFamily4 = schema2.getFunctions();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getFunctions(...)");
                    $this$forEach$iv = CollectionsKt.plus((Iterable)modNamingIdentifyingFamily4, (Iterable)procedures);
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        AseRoutine it4 = (AseRoutine)element$iv;
                        boolean bl = false;
                        it4.getArguments().markChildrenAsSyncPending();
                    }
                    AseMajorObject obj2 = null;
                    int objId = Integer.MIN_VALUE;
                    for (AseIntroQueries.OneColumnOrArgument ca : this.$cas) {
                        if (obj2 == null || objId != ca.id) {
                            obj2 = AseIntrospectorKt.access$findObjectById(schema2, ca.id);
                            objId = ca.id;
                            if (obj2 == null) continue;
                        }
                        DataType dt = AseIntrospectorKt.access$makeDataType(ca.type_name, ca.length, ca.prec, ca.scale, ca.variable, AseIntrospector.access$getServerVersion(this.this$0));
                        if (obj2 instanceof AseLikeTable) {
                            short $this$and$iv;
                            AseLikeColumn column2 = (AseLikeColumn)((AseLikeTable)obj2).getColumns().createOrGet(ca.name);
                            column2.setPosition(ca.colid);
                            column2.setStoredType(DasUnresolvedTypeReference.Companion.of(dt));
                            short element$iv$iv = ca.bits1;
                            short that$iv = 8;
                            boolean $i$f$and = false;
                            short $this$toUnsignedInt$iv$iv = $this$and$iv;
                            boolean $i$f$toUnsignedInt = false;
                            int n = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                            $this$toUnsignedInt$iv$iv = that$iv;
                            $i$f$toUnsignedInt = false;
                            column2.setNotNull((short)(n & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) == 0);
                            $this$and$iv = ca.bits2;
                            that$iv = 16;
                            $i$f$and = false;
                            $this$toUnsignedInt$iv$iv = $this$and$iv;
                            $i$f$toUnsignedInt = false;
                            int n3 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                            $this$toUnsignedInt$iv$iv = that$iv;
                            $i$f$toUnsignedInt = false;
                            column2.setComputed((short)(n3 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0);
                            if (column2 instanceof AseTableColumn) {
                                $this$and$iv = ca.bits1;
                                that$iv = 128;
                                $i$f$and = false;
                                $this$toUnsignedInt$iv$iv = $this$and$iv;
                                $i$f$toUnsignedInt = false;
                                int n4 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                                $this$toUnsignedInt$iv$iv = that$iv;
                                $i$f$toUnsignedInt = false;
                                ((AseTableColumn)column2).setSequenceIdentity((short)(n4 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0 ? SequenceIdentity.UNKNOWN : null);
                            }
                        }
                        if (obj2 instanceof BasicModRoutine) {
                            BasicModRoutine basicModRoutine = (BasicModRoutine)((Object)obj2);
                            Intrinsics.checkNotNull((Object)ca);
                            AseSchemaRetriever.access$addRoutineArgument(this.this$1, basicModRoutine, ca, dt);
                        }
                        if (!(obj2 instanceof AseProcedureGroup)) continue;
                        AseProcedure procedure = (AseProcedure)((AseProcedureGroup)obj2).getProcedures().createOrGetAt(ca.procedure_position);
                        Intrinsics.checkNotNull((Object)procedure);
                        BasicModRoutine basicModRoutine = procedure;
                        Intrinsics.checkNotNull((Object)ca);
                        AseSchemaRetriever.access$addRoutineArgument(this.this$1, basicModRoutine, ca, dt);
                    }
                    ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily5 = schema2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getTables(...)");
                    Iterable iterable3 = modNamingIdentifyingFamily5;
                    ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily6 = schema2.getViews();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"getViews(...)");
                    Iterable $this$forEach$iv2 = CollectionsKt.plus((Iterable)iterable3, (Iterable)modNamingIdentifyingFamily6);
                    boolean $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv2) {
                        AseLikeTable it5 = (AseLikeTable)element$iv;
                        boolean bl = false;
                        PositioningNamingFamily positioningNamingFamily = it5.getColumns();
                        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                        AseIntrospectorKt.access$finish((ModFamily)((Object)positioningNamingFamily));
                    }
                    ModNamingIdentifyingFamily<? extends AseFunction> modNamingIdentifyingFamily7 = schema2.getFunctions();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily7, (String)"getFunctions(...)");
                    $this$forEach$iv2 = CollectionsKt.plus((Iterable)modNamingIdentifyingFamily7, (Iterable)procedures);
                    $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv2) {
                        AseRoutine it6 = (AseRoutine)element$iv;
                        boolean bl = false;
                        PositioningNamingFamily positioningNamingFamily = it6.getArguments();
                        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
                        AseIntrospectorKt.access$finish((ModFamily)((Object)positioningNamingFamily));
                    }
                    ModNamingIdentifyingFamily<? extends AseProcedureGroup> modNamingIdentifyingFamily8 = schema2.getProcedureGroups();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily8, (String)"getProcedureGroups(...)");
                    $this$forEach$iv2 = modNamingIdentifyingFamily8;
                    $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv2) {
                        AseProcedureGroup it7 = (AseProcedureGroup)element$iv;
                        boolean bl = false;
                        it7.getProcedures().sort();
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void addRoutineArgument(BasicModRoutine routine2, AseIntroQueries.OneColumnOrArgument ca, DataType dt) {
            BasicModArgument basicModArgument;
            boolean result2;
            void $this$and$iv;
            short s2 = ca.bits2;
            short that$iv = 2;
            boolean $i$f$and = false;
            short $this$toUnsignedInt$iv$iv = $this$and$iv;
            boolean $i$f$toUnsignedInt = false;
            int n = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
            $this$toUnsignedInt$iv$iv = that$iv;
            $i$f$toUnsignedInt = false;
            boolean out = (short)(n & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0;
            boolean bl = result2 = out && Strings.eq((String)ca.name, (String)"Return Type", (boolean)false);
            if (result2) {
                basicModArgument = routine2.createOrGetReturnArgument();
            } else {
                AseArgument aseArgument;
                BasicModRoutine basicModRoutine = routine2;
                if (basicModRoutine instanceof AseFunction) {
                    PositioningNamingFamily positioningNamingFamily = ((AseFunction)routine2).getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
                    ModFamily modFamily = (ModFamily)((Object)positioningNamingFamily);
                    String string = ca.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    aseArgument = AseIntrospectorKt.access$createOrGetByName(modFamily, string);
                } else if (basicModRoutine instanceof AseProcedure) {
                    PositioningNamingFamily positioningNamingFamily = ((AseProcedure)routine2).getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
                    ModFamily modFamily = (ModFamily)((Object)positioningNamingFamily);
                    String string = ca.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    aseArgument = AseIntrospectorKt.access$createOrGetByName(modFamily, string);
                } else {
                    return;
                }
                basicModArgument = aseArgument;
            }
            BasicModArgument basicModArgument2 = basicModArgument;
            Intrinsics.checkNotNull((Object)basicModArgument2);
            BasicModArgument argument = basicModArgument2;
            argument.setPosition(ca.colid);
            argument.setStoredType(DasUnresolvedTypeReference.Companion.of(dt));
            if (!result2) {
                argument.setArgumentDirection(out ? ArgumentDirection.OUT : ArgumentDirection.IN);
            }
        }

        private final void retrieveIndicesAndKeys() {
            if (((AseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List inds = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveIndices.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema((Function1)new Function1<AseSchema, Unit>((List<AseIntroQueries.OneIndex>)inds, this){
                final /* synthetic */ List<AseIntroQueries.OneIndex> $inds;
                final /* synthetic */ AseSchemaRetriever this$0;
                {
                    this.$inds = $inds;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull AseSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    AseTable table = null;
                    int tableId = Integer.MIN_VALUE;
                    ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
                    Object $this$forEach$iv = modNamingIdentifyingFamily;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv = iterator.next();
                        AseTable it2 = (AseTable)element$iv;
                        boolean bl = false;
                        it2.getIndices().markChildrenAsSyncPending();
                        it2.getKeys().markChildrenAsSyncPending();
                    }
                    for (AseIntroQueries.OneIndex ind : this.$inds) {
                        void $this$and$iv;
                        short $this$and$iv2;
                        if (table == null || tableId != ind.id) {
                            if ((AseTable)schema2.getTables().getByObjectId((long)ind.id) == null) continue;
                            tableId = ind.id;
                        }
                        AseIndex index2 = (AseIndex)table.getIndices().createOrGet(ind.name);
                        index2.setPosition(ind.position);
                        short element$iv = ind.bits2;
                        short that$iv = 8;
                        boolean $i$f$and = false;
                        short $this$toUnsignedInt$iv$iv = $this$and$iv2;
                        boolean $i$f$toUnsignedInt = false;
                        int n = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                        $this$toUnsignedInt$iv$iv = that$iv;
                        $i$f$toUnsignedInt = false;
                        index2.setNameSurrogate((short)(n & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0);
                        $this$and$iv2 = ind.bits1;
                        that$iv = 16;
                        $i$f$and = false;
                        $this$toUnsignedInt$iv$iv = $this$and$iv2;
                        $i$f$toUnsignedInt = false;
                        int n3 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                        $this$toUnsignedInt$iv$iv = that$iv;
                        $i$f$toUnsignedInt = false;
                        index2.setClustering((short)(n3 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0);
                        $this$and$iv2 = ind.bits1;
                        that$iv = 2;
                        $i$f$and = false;
                        $this$toUnsignedInt$iv$iv = $this$and$iv2;
                        $i$f$toUnsignedInt = false;
                        int n4 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                        $this$toUnsignedInt$iv$iv = that$iv;
                        $i$f$toUnsignedInt = false;
                        index2.setUnique((short)(n4 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0);
                        if (ind.keys1 != null) {
                            byte[] keys2 = null;
                            Object object = ind.keys1;
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                            byte[] keys1 = (byte[])object;
                            if (ind.keys2 == null) {
                                keys2 = keys1;
                            } else {
                                Object object2 = ind.keys2;
                                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                                byte[] keys22 = (byte[])object2;
                                keys2 = new byte[keys1.length + keys22.length];
                                System.arraycopy(keys1, 0, keys2, 0, keys1.length);
                                System.arraycopy(keys22, 0, keys2, keys1.length, keys22.length);
                            }
                            Intrinsics.checkNotNull((Object)index2);
                            AseSchemaRetriever.access$peekIndexColumns(this.this$0, index2, keys2);
                        }
                        short keys2 = ind.bits2;
                        that$iv = 2;
                        $i$f$and = false;
                        $this$toUnsignedInt$iv$iv = $this$and$iv;
                        $i$f$toUnsignedInt = false;
                        int n5 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                        $this$toUnsignedInt$iv$iv = that$iv;
                        $i$f$toUnsignedInt = false;
                        if ((short)(n5 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) == 0) continue;
                        AseKey key2 = (AseKey)table.getKeys().createOrGet(ind.name);
                        key2.setNameSurrogate(index2.isNameSurrogate());
                        key2.setUnderlyingIndexRef(BasicNameReference.create(ind.name));
                        that$iv = ind.bits1;
                        short that$iv2 = 2048;
                        boolean $i$f$and2 = false;
                        short $this$toUnsignedInt$iv$iv2 = $this$and$iv;
                        boolean $i$f$toUnsignedInt2 = false;
                        int n6 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv2);
                        $this$toUnsignedInt$iv$iv2 = that$iv2;
                        $i$f$toUnsignedInt2 = false;
                        key2.setPrimary((short)(n6 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv2)) != 0);
                    }
                    ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily2 = schema2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
                    $this$forEach$iv = modNamingIdentifyingFamily2;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv = iterator.next();
                        AseTable it3 = (AseTable)element$iv;
                        boolean bl = false;
                        Family family = it3.getIndices();
                        Intrinsics.checkNotNullExpressionValue((Object)family, (String)"getIndices(...)");
                        AseIntrospectorKt.access$finish((ModFamily)family);
                        NamingFamily namingFamily = it3.getKeys();
                        Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getKeys(...)");
                        AseIntrospectorKt.access$finish((ModFamily)((Object)namingFamily));
                    }
                }
            });
        }

        private final void peekIndexColumns(AseIndex index2, byte[] keys2) {
            short[] positions = this.peekColumnPositions(keys2);
            ImmutableList.Builder names2 = ImmutableList.builder();
            for (short position : positions) {
                Object v2;
                block2: {
                    if (position == 0) break;
                    AseTable aseTable = index2.getTable();
                    Intrinsics.checkNotNull((Object)aseTable);
                    PositioningNamingFamily positioningNamingFamily = aseTable.getColumns();
                    Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                    Iterable $this$firstOrNull$iv = positioningNamingFamily;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        AseTableColumn column2 = (AseTableColumn)element$iv;
                        boolean bl = false;
                        if (!(column2.getPosition() == position)) continue;
                        v2 = element$iv;
                        break block2;
                    }
                    v2 = null;
                }
                AseTableColumn column3 = v2;
                if (column3 == null) continue;
                names2.add((Object)column3.getName());
            }
            index2.setColNames((List)names2.build());
        }

        private final short[] peekColumnPositions(byte[] keys2) {
            int n = (keys2.length + 7) / 16;
            short[] positions = new short[n];
            for (int i2 = 0; i2 < n; ++i2) {
                short position;
                int offset = i2 << 4 | 4;
                positions[i2] = position = AseIntrospectorKt.peek16(keys2, offset);
                if (position == 0) break;
            }
            return positions;
        }

        private final void retrieveForeignKeys() {
            if (((AseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"FOREIGN_KEY");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List fks = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveForeignKeys.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            Ref.BooleanRef wides = new Ref.BooleanRef();
            this.inSchema((Function1)new Function1<AseSchema, Unit>((List<AseIntroQueries.OneForeignKey>)fks, wides){
                final /* synthetic */ List<AseIntroQueries.OneForeignKey> $fks;
                final /* synthetic */ Ref.BooleanRef $wides;
                {
                    this.$fks = $fks;
                    this.$wides = $wides;
                    super(1);
                }

                public final void invoke(@NotNull AseSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
                    Iterable $this$forEach$iv = modNamingIdentifyingFamily;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        AseTable it2 = (AseTable)element$iv;
                        boolean bl = false;
                        it2.getForeignKeys().markChildrenAsSyncPending();
                    }
                    for (AseIntroQueries.OneForeignKey fk : this.$fks) {
                        AseTable table;
                        if ((AseTable)schema2.getTables().getByObjectId(fk.source_table_id) == null) continue;
                        AseForeignKey foreignKey = (AseForeignKey)table.getForeignKeys().renew(fk.source_constraint_id, fk.source_constraint_name);
                        foreignKey.setNameSurrogate(AseIntrospectorKt.access$detectSurrogateName(fk.source_constraint_name, fk.source_constraint_id));
                        BasicIdReference idRef = BasicIdReference.create(fk.target_table_id);
                        foreignKey.setRefTableRef(BasicIdOrNameReference.create(idRef, BasicMetaUtils.createPortableReference((BasicElement)foreignKey, BasicModForeignKey.REF_TABLE_REF, (BasicReference)idRef)));
                        foreignKey.setRefIndexRef(BasicPositionReference.create(fk.target_index_position));
                        short n = fk.involved_columns_count;
                        if (n <= 4) {
                            short[] columnPositions = new short[n];
                            if (n >= 1) {
                                columnPositions[0] = fk.column_position_1;
                            }
                            if (n >= 2) {
                                columnPositions[1] = fk.column_position_2;
                            }
                            if (n >= 3) {
                                columnPositions[2] = fk.column_position_3;
                            }
                            if (n >= 4) {
                                columnPositions[3] = fk.column_position_4;
                            }
                            Intrinsics.checkNotNull((Object)foreignKey);
                            AseIntrospectorKt.access$assignForeignKeyColumns(foreignKey, columnPositions);
                            continue;
                        }
                        this.$wides.element = true;
                    }
                }
            });
            if (wides.element) {
                Object[] objectArray2 = new Object[]{this.schemaId};
                List wfks = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveForeignKeysWideColumnLists.rewrite(this.rewriter)).withParams(objectArray2).runOnce();
                this.inSchema((Function1)new Function1<AseSchema, Unit>((List<int[]>)wfks){
                    final /* synthetic */ List<int[]> $wfks;
                    {
                        this.$wfks = $wfks;
                        super(1);
                    }

                    public final void invoke(@NotNull AseSchema schema2) {
                        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                        for (int[] wfk : this.$wfks) {
                            AseForeignKey foreignKey;
                            int n;
                            int constraintId = wfk[0];
                            if (AseIntrospectorKt.access$findForeignKeyById(schema2, constraintId) == null) continue;
                            for (n = 0; n < 16 && wfk[n + 1] > 0; ++n) {
                            }
                            short[] columnPositions = new short[n];
                            int n3 = n;
                            for (int i2 = 0; i2 < n3; ++i2) {
                                columnPositions[i2] = (short)wfk[i2 + 1];
                            }
                            AseIntrospectorKt.access$assignForeignKeyColumns(foreignKey, columnPositions);
                        }
                    }
                });
            }
            this.inSchema(retrieveForeignKeys.3.INSTANCE);
        }

        private final void retrieveCheckConstraints() {
            if (((AseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.CHECK;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CHECK");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List cs = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveChecks.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema((Function1)new Function1<AseSchema, Unit>((List<AseIntroQueries.OneCheck>)cs){
                final /* synthetic */ List<AseIntroQueries.OneCheck> $cs;
                {
                    this.$cs = $cs;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull AseSchema schema2) {
                    AseTable it2;
                    T element$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
                    Object $this$forEach$iv = modNamingIdentifyingFamily;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv = iterator.next();
                        it2 = (AseTable)element$iv;
                        boolean bl = false;
                        it2.getChecks().markChildrenAsSyncPending();
                    }
                    for (AseIntroQueries.OneCheck c2 : this.$cs) {
                        BasicNamedElement basicNamedElement;
                        AseTable table;
                        if ((AseTable)schema2.getTables().getByObjectId(c2.table_id) == null) continue;
                        AseCheck check = (AseCheck)table.getChecks().renew(c2.constraint_id, c2.constraint_name);
                        check.setNameSurrogate(AseIntrospectorKt.access$detectSurrogateName(c2.constraint_name, c2.constraint_id));
                        if (c2.definition != null) {
                            String s2;
                            int len;
                            void $this$trim$iv;
                            String string = c2.definition;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"definition");
                            int p2 = StringsKt.indexOf$default((CharSequence)string, (String)"CHECK", (int)0, (boolean)false, (int)6, null);
                            p2 = p2 >= 0 ? p2 + 5 : 0;
                            String string2 = c2.definition;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"definition");
                            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(p2), (String)"substring(...)");
                            boolean $i$f$trim = false;
                            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                            boolean $i$f$trim2 = false;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                char it3 = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it3, (int)32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            if ((len = (s2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length()) >= 3 && s2.charAt(0) == '(' && s2.charAt(len - 1) == ')') {
                                void $this$trim$iv2;
                                Intrinsics.checkNotNullExpressionValue((Object)s2.substring(1, len - 1), (String)"substring(...)");
                                boolean $i$f$trim3 = false;
                                CharSequence $this$trim$iv$iv2 = (CharSequence)$this$trim$iv2;
                                boolean $i$f$trim4 = false;
                                int startIndex$iv$iv2 = 0;
                                int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                                boolean startFound$iv$iv2 = false;
                                while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                                    boolean match$iv$iv;
                                    int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                                    char it4 = $this$trim$iv$iv2.charAt(index$iv$iv);
                                    boolean bl = false;
                                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it4, (int)32) <= 0;
                                    if (!startFound$iv$iv2) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv2 = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv2;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv2;
                                }
                                s2 = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                            }
                            check.setPredicate(s2);
                        } else {
                            check.setPredicate(null);
                        }
                        if (c2.column_position > 0) {
                            Object v7;
                            block15: {
                                AseTable aseTable = check.getTable();
                                Intrinsics.checkNotNull((Object)aseTable);
                                PositioningNamingFamily positioningNamingFamily = aseTable.getColumns();
                                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                                Iterable $this$firstOrNull$iv = positioningNamingFamily;
                                boolean $i$f$firstOrNull = false;
                                for (T element$iv2 : $this$firstOrNull$iv) {
                                    AseTableColumn col = (AseTableColumn)element$iv2;
                                    boolean bl = false;
                                    if (!(col.getPosition() == c2.column_position)) continue;
                                    v7 = element$iv2;
                                    break block15;
                                }
                                v7 = null;
                            }
                            basicNamedElement = v7;
                        } else {
                            basicNamedElement = null;
                        }
                        BasicNamedElement column2 = basicNamedElement;
                        BasicNamedElement basicNamedElement2 = column2;
                        check.setColNames(basicNamedElement2 != null ? Collections.singletonList(basicNamedElement2.getName()) : CollectionsKt.emptyList());
                    }
                    ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily2 = schema2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
                    $this$forEach$iv = modNamingIdentifyingFamily2;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv = iterator.next();
                        it2 = (AseTable)element$iv;
                        boolean bl = false;
                        NamingFamily namingFamily = it2.getChecks();
                        Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getChecks(...)");
                        AseIntrospectorKt.access$finish((ModFamily)((Object)namingFamily));
                    }
                }
            });
        }

        private final void retrieveDefaults() {
            ObjectKind objectKind = ObjectKind.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"DEFAULT");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List ds = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveDefaults.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema((Function1)new Function1<AseSchema, Unit>((List<AseIntroQueries.OneDefault>)ds, this){
                final /* synthetic */ List<AseIntroQueries.OneDefault> $ds;
                final /* synthetic */ AseSchemaRetriever this$0;
                {
                    this.$ds = $ds;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull AseSchema schema2) {
                    void $this$forEach$iv;
                    AseSchemaRetriever aseSchemaRetriever;
                    Object def;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    Object obj2 = null;
                    int objectId = Integer.MIN_VALUE;
                    IntOpenHashSet tablesWithDefs = new IntOpenHashSet();
                    IntOpenHashSet columnsWithDefs = new IntOpenHashSet();
                    for (AseIntroQueries.OneDefault d2 : this.$ds) {
                        AseSchemaRetriever aseSchemaRetriever2;
                        if (obj2 == null || objectId != d2.id) {
                            if (obj2 != null) {
                                Object object;
                                aseSchemaRetriever2 = this.this$0;
                                AseSchemaRetriever it2 = object;
                                boolean bl = false;
                                AseSchemaRetriever.access$cleanupTableDefaults(aseSchemaRetriever2, (AseTable)((Object)it2), (IntSet)columnsWithDefs);
                            }
                            obj2 = (AseTable)schema2.getTables().getByObjectId(d2.id);
                            objectId = d2.id;
                            if (obj2 == null) continue;
                            columnsWithDefs.clear();
                            tablesWithDefs.add(objectId);
                        }
                        columnsWithDefs.add((int)d2.position);
                        String string = d2.text;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                        def = AseSchemaRetriever.access$adjustDef(this.this$0, string);
                        if ((AseTableColumn)obj2.getColumns().getByNaturalPosition(d2.position) == null) continue;
                        AseSchemaRetriever $this$invoke_u24lambda_u241 = aseSchemaRetriever2;
                        boolean bl = false;
                        $this$invoke_u24lambda_u241.setDefaultExpression((String)def);
                    }
                    AseSchemaRetriever aseSchemaRetriever3 = obj2;
                    if (aseSchemaRetriever3 != null) {
                        aseSchemaRetriever = aseSchemaRetriever3;
                        def = this.this$0;
                        AseSchemaRetriever it3 = aseSchemaRetriever;
                        boolean bl = false;
                        AseSchemaRetriever.access$cleanupTableDefaults((AseSchemaRetriever)def, (AseTable)((Object)it3), (IntSet)columnsWithDefs);
                    }
                    ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
                    Iterable iterable = modNamingIdentifyingFamily;
                    aseSchemaRetriever = this.this$0;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        AseTable tab2 = (AseTable)element$iv;
                        boolean bl = false;
                        if (tablesWithDefs.contains((int)tab2.getObjectId())) continue;
                        Intrinsics.checkNotNull((Object)tab2);
                        AseSchemaRetriever.access$cleanupTableDefaults(aseSchemaRetriever, tab2, null);
                    }
                }
            });
        }

        private final String adjustDef(String def) {
            boolean match$iv$iv;
            char it2;
            int index$iv$iv;
            String res2;
            String $this$trim$iv = res2 = def;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringsKt.startsWith$default((String)(res2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"DEFAULT", (boolean)false, (int)2, null)) {
                String string = res2.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$trim$iv = string;
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim2 = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                res2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            } else if (StringsKt.startsWith$default((String)res2, (String)"AS", (boolean)false, (int)2, null)) {
                String string = res2.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$trim$iv = string;
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim2 = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl4 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                res2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            }
            return res2;
        }

        private final void cleanupTableDefaults(AseTable table, IntSet columnsWithDef) {
            PositioningNamingFamily positioningNamingFamily = table.getColumns();
            Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
            Iterable $this$forEach$iv = positioningNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseTableColumn c2 = (AseTableColumn)element$iv;
                boolean bl = false;
                if (columnsWithDef != null && columnsWithDef.contains((int)c2.getPosition())) continue;
                c2.setDefaultExpression(null);
            }
        }

        private final void retrieveTriggers() {
            if (((AseSchema)this.getSchema()).getTables().isEmpty() && ((AseSchema)this.getSchema()).getViews().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId, this.schemaId, this.schemaId};
            List ts2 = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveTriggers.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema((Function1)new Function1<AseSchema, Unit>((List<AseIntroQueries.OneTrigger>)ts2){
                final /* synthetic */ List<AseIntroQueries.OneTrigger> $ts;
                {
                    this.$ts = $ts;
                    super(1);
                }

                public final void invoke(@NotNull AseSchema schema2) {
                    AseLikeTable it2;
                    T element$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
                    Iterable iterable = modNamingIdentifyingFamily;
                    ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily2 = schema2.getViews();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getViews(...)");
                    Object $this$forEach$iv = CollectionsKt.plus((Iterable)iterable, (Iterable)modNamingIdentifyingFamily2);
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv = iterator.next();
                        it2 = (AseLikeTable)element$iv;
                        boolean bl = false;
                        it2.getTriggers().markChildrenAsSyncPending();
                    }
                    for (AseIntroQueries.OneTrigger t : this.$ts) {
                        AseLikeTable aseLikeTable;
                        AseTable aseTable = (AseTable)schema2.getTables().getByObjectId(t.table_id);
                        if (aseTable != null) {
                            aseLikeTable = aseTable;
                        } else {
                            AseView aseView = (AseView)schema2.getViews().getByObjectId(t.table_id);
                            if (aseView == null) continue;
                            aseLikeTable = aseView;
                        }
                        AseLikeTable table = aseLikeTable;
                        AseTrigger trigger2 = table.getTriggers().renew(t.trig_id, t.trig_name);
                        TrigEvent event = TrigEvent.of(t.event_code);
                        Intrinsics.checkNotNull((Object)trigger2);
                        AseIntrospectorKt.access$addEvent(trigger2, event);
                        trigger2.setStateNumber(t.state_nr);
                        trigger2.setTurn(t.turn_code == 'I' ? TrigTurn.INSTEAD_OF : TrigTurn.ALSO);
                    }
                    ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily3 = schema2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getTables(...)");
                    Iterable iterable2 = modNamingIdentifyingFamily3;
                    ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily4 = schema2.getViews();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getViews(...)");
                    $this$forEach$iv = CollectionsKt.plus((Iterable)iterable2, (Iterable)modNamingIdentifyingFamily4);
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv = iterator.next();
                        it2 = (AseLikeTable)element$iv;
                        boolean bl = false;
                        ModNamingIdentifyingFamily<? extends AseTrigger> modNamingIdentifyingFamily5 = it2.getTriggers();
                        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getTriggers(...)");
                        AseIntrospectorKt.access$finish(modNamingIdentifyingFamily5);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void retrieveSources() {
            void this_$iv$iv;
            if (AseIntrospector.this.getOptions().getSources() == DBIntrospectionOptions.SourceLoading.NO_SOURCES) {
                return;
            }
            if (((AseSchema)this.getSchema()).getTables().isEmpty() && ((AseSchema)this.getSchema()).getViews().isEmpty() && ((AseSchema)this.getSchema()).getProcedureGroups().isEmpty() && ((AseSchema)this.getSchema()).getFunctions().isEmpty()) {
                return;
            }
            Object[] objectArray = new Object[]{this.schemaId, this.schemaId, this.schemaId};
            List ss2 = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveSources.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            if (ss2.isEmpty()) {
                return;
            }
            Intrinsics.checkNotNull((Object)ss2);
            Iterable ts2 = BaseIntrospectionFunctions.group(ss2, retrieveSources.ts.1.INSTANCE, retrieveSources.ts.2.INSTANCE, retrieveSources.ts.3.INSTANCE);
            BaseNativeIntrospector this_$iv = AseIntrospector.this;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this, ts2){
                    final /* synthetic */ AseSchemaRetriever this$0;
                    final /* synthetic */ Iterable $ts$inlined;
                    {
                        this.this$0 = aseSchemaRetriever;
                        this.$ts$inlined = iterable;
                    }

                    public final void run() {
                        boolean bl = false;
                        AseSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<AseSchema, Unit>((Iterable<SrcText>)this.$ts$inlined){
                            final /* synthetic */ Iterable<SrcText> $ts;
                            {
                                this.$ts = $ts;
                                super(1);
                            }

                            public final void invoke(@NotNull AseSchema schema2) {
                                Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                                for (SrcText t : this.$ts) {
                                    BasicNode basicNode;
                                    BasicNode basicNode2;
                                    BasicModSourceAware o2 = t.getMinor_kind() == 'G' ? (BasicModSourceAware)((basicNode2 = AseIntrospectorKt.access$findTableOrView(schema2, t.getMajor_kind(), t.getMajor_id())) != null && (basicNode2 = basicNode2.getTriggers()) != null ? (AseTrigger)basicNode2.getByObjectId(t.getMinor_id()) : null) : (t.getMajor_kind() == 'V' ? (BasicModSourceAware)schema2.getViews().getByObjectId(t.getMajor_id()) : (t.getMajor_kind() == 'F' ? (BasicModSourceAware)schema2.getFunctions().getByObjectId(t.getMajor_id()) : (t.getMajor_kind() == 'P' ? (BasicModSourceAware)((basicNode = (AseProcedureGroup)schema2.getProcedureGroups().getByObjectId(t.getMajor_id())) != null && (basicNode = basicNode.getProcedures()) != null ? (AseProcedure)basicNode.getByNaturalPosition((short)t.getMinor_id()) : null) : null)));
                                    if (o2 == null) continue;
                                    String string = t.getText();
                                    o2.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null);
                                }
                            }
                        });
                    }
                });
            }
            finally {
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (ref$iv$iv != null) {
                    DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                    if (dataSourceDiagnosticRecorder2 != null) {
                        DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv$iv, null, 2, null);
                    }
                }
            }
        }

        private static final String _init_$lambda$0(String $catalogPrefix, String arg) {
            Intrinsics.checkNotNullParameter((Object)$catalogPrefix, (String)"$catalogPrefix");
            return Strings.replace((String)arg, (String)"#CAT", (String)$catalogPrefix);
        }

        public static final /* synthetic */ void access$setWasProcedures$p(AseSchemaRetriever $this, boolean bl) {
            $this.wasProcedures = bl;
        }

        public static final /* synthetic */ boolean access$getWasProcedures$p(AseSchemaRetriever $this) {
            return $this.wasProcedures;
        }

        public static final /* synthetic */ void access$addRoutineArgument(AseSchemaRetriever $this, BasicModRoutine routine2, AseIntroQueries.OneColumnOrArgument ca, DataType dt) {
            $this.addRoutineArgument(routine2, ca, dt);
        }

        public static final /* synthetic */ void access$peekIndexColumns(AseSchemaRetriever $this, AseIndex index2, byte[] keys2) {
            $this.peekIndexColumns(index2, keys2);
        }

        public static final /* synthetic */ String access$adjustDef(AseSchemaRetriever $this, String def) {
            return $this.adjustDef(def);
        }

        public static final /* synthetic */ void access$cleanupTableDefaults(AseSchemaRetriever $this, AseTable table, IntSet columnsWithDef) {
            $this.cleanupTableDefaults(table, columnsWithDef);
        }

        public static final /* synthetic */ void access$inSchema(AseSchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isIncremental", "", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.sybase"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{15};
            return version.isOrGreater(nArray);
        }

        @Override
        public boolean isIncremental() {
            return true;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new AseIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return AseIntrospectorKt.access$canCheckOutdated(e2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.sybase"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

