/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.redis.RedisDbms;
import com.intellij.database.dialects.redis.RedisDefaultKeyFilterOption;
import com.intellij.database.dialects.redis.RedisScanCountOption;
import com.intellij.database.dialects.redis.introspector.RedisIntroQueries;
import com.intellij.database.dialects.redis.introspector.RedisIntrospector;
import com.intellij.database.dialects.redis.introspector.RedisIntrospector$applySchemas$3$invoke$;
import com.intellij.database.dialects.redis.model.RedisKey;
import com.intellij.database.dialects.redis.model.RedisRoot;
import com.intellij.database.dialects.redis.model.RedisSchema;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementCacheOptimizersKt;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.ElementSearcherNN;
import com.intellij.database.model.FamilySearcher;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.remote.jdba.exceptions.DBFetchingException;
import com.intellij.database.remote.jdba.exceptions.DBSchemaAccessDeniedException;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.util.text.StringKt;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0004QRSTB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\u00142\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0002J0\u0010 \u001a\u00020\u001f\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0\n2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u00020\r0(H\u0002J4\u0010)\u001a\u001e\u0012\u0004\u0012\u00020\u00020*R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0002H\u0014J4\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\u000300R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030+2\u0006\u0010,\u001a\u00020-2\u0006\u00101\u001a\u00020\u0003H\u0014J\u0010\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u000204H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010\u000f2\u0006\u00106\u001a\u000207H\u0002J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u00109\u001a\u00020:H\u0002J\u000f\u0010;\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b<H\u0002J$\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010>2\u0006\u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010CH\u0016J\b\u0010D\u001a\u00020\u001fH\u0014J\b\u0010E\u001a\u00020\u001fH\u0002J\b\u0010F\u001a\u00020\u001fH\u0002J\u0010\u0010G\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020-H\u0014J&\u0010I\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020-2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010K\u001a\u00020\u0014H\u0014J\u0010\u0010L\u001a\u00020\u00142\u0006\u0010M\u001a\u00020\rH\u0002J\b\u0010N\u001a\u00020\u001fH\u0016J\u0010\u0010O\u001a\u00020\u001f2\u0006\u0010M\u001a\u00020\rH\u0002J\u000e\u0010P\u001a\u00020\u0014*\u0004\u0018\u00010\rH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0016R\u0018\u0010\u001c\u001a\u00020\u0014*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006U"}, d2={"Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/redis/model/RedisRoot;", "Lcom/intellij/database/dialects/redis/model/RedisSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "clusterNodes", "", "Lcom/intellij/database/dataSource/url/HostPort;", "keyPattern", "", "mode", "Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$Mode;", "modules", "", "Lcom/intellij/database/model/ObjectKind;", "requiresAllClusterNodesIntrospection", "", "getRequiresAllClusterNodesIntrospection", "()Z", "scanCount", "", "Ljava/lang/Long;", "supportsKeysScanWithType", "getSupportsKeysScanWithType", "isSupported", "(Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$Mode;)Z", "applyClusterSchema", "", "applySchemas", "dbCountInfo", "Lcom/intellij/database/dialects/redis/introspector/RedisIntroQueries$DbCountInfo;", "keyspaceInfo", "Lcom/intellij/database/dialects/redis/introspector/RedisIntroQueries$KeyspaceInfo;", "T", "dbs", "nameGetter", "Lkotlin/Function1;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "schema", "extractMasterNode", "slotsInfo", "Lcom/intellij/database/dialects/redis/introspector/RedisIntroQueries$SlotsInfo;", "extractMode", "serverInfo", "Lcom/intellij/database/dialects/redis/introspector/RedisIntroQueries$ServerInfo;", "extractModules", "modulesInfo", "Lcom/intellij/database/dialects/redis/introspector/RedisIntroQueries$ModulesInfo;", "getSchema", "Lorg/jetbrains/annotations/Nullable;", "init", "Lcom/intellij/database/model/basic/BasicModModel;", "model", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "introspectionScope", "Lcom/intellij/database/util/TreePattern;", "initConnectionRelatedState", "initServerConfiguration", "initVersionParameters", "introspectNamespacesInTran", "tran", "introspectSchemasAuto", "schemas", "whole", "isCurrentSchema", "name", "retrieveAndApplySchemas", "setSchema", "isClusterCompliantKeyPattern", "DefaultNature", "Factory", "Mode", "RedisSchemaRetriever", "intellij.database.dialects.redis"})
@SourceDebugExtension(value={"SMAP\nRedisIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisIntrospector.kt\ncom/intellij/database/dialects/redis/introspector/RedisIntrospector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n1#2:360\n1549#3:361\n1620#3,3:362\n*S KotlinDebug\n*F\n+ 1 RedisIntrospector.kt\ncom/intellij/database/dialects/redis/introspector/RedisIntrospector\n*L\n131#1:361\n131#1:362,3\n*E\n"})
public final class RedisIntrospector
extends BaseSingleDatabaseIntrospector<RedisRoot, RedisSchema> {
    @Nullable
    private String keyPattern;
    @Nullable
    private Long scanCount;
    @Nullable
    private Mode mode;
    @NotNull
    private Set<? extends ObjectKind> modules;
    @NotNull
    private List<? extends HostPort> clusterNodes;

    public RedisIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = DefaultNature.INSTANCE;
        Dbms dbms = RedisDbms.REDIS;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"REDIS");
        super(context, nature, dbms, modelFactory);
        this.modules = SetsKt.emptySet();
        this.clusterNodes = CollectionsKt.emptyList();
    }

    private final boolean isSupported(Mode $this$isSupported) {
        Version supportedSinceDriverVersion = switch (WhenMappings.$EnumSwitchMapping$0[$this$isSupported.ordinal()]) {
            case 1 -> Version.ZERO;
            case 2 -> {
                int[] var3_2 = new int[]{1, 4};
                yield Version.of(var3_2);
            }
            case 3 -> Version.INFINITY;
            default -> throw new NoWhenBranchMatchedException();
        };
        return this.getDriverVersion().isOrGreater(supportedSinceDriverVersion);
    }

    private final boolean getSupportsKeysScanWithType() {
        int[] nArray = new int[]{6};
        return this.getServerVersion().isOrGreater(nArray);
    }

    private final boolean getRequiresAllClusterNodesIntrospection() {
        return this.mode == Mode.CLUSTER && !this.isClusterCompliantKeyPattern(this.keyPattern);
    }

    private final boolean isClusterCompliantKeyPattern(String $this$isClusterCompliantKeyPattern) {
        if ($this$isClusterCompliantKeyPattern == null) {
            return false;
        }
        Integer n = StringsKt.indexOf$default((CharSequence)$this$isClusterCompliantKeyPattern, (String)"{", (int)0, (boolean)false, (int)6, null);
        int it2 = ((Number)n).intValue();
        boolean bl = false;
        Integer n3 = it2 != -1 ? n : null;
        if (n3 == null) {
            return false;
        }
        int hashTagStart = n3;
        Integer n4 = StringsKt.indexOf$default((CharSequence)$this$isClusterCompliantKeyPattern, (String)"}", (int)(hashTagStart + 1), (boolean)false, (int)4, null);
        int it3 = ((Number)n4).intValue();
        boolean bl2 = false;
        Integer n5 = it3 != -1 ? n4 : null;
        if (n5 == null) {
            return false;
        }
        int hashTagEnd = n5;
        return hashTagEnd != hashTagStart + 1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public BasicModModel init(@Nullable BasicModModel model, @NotNull LocalDataSource dataSource, @Nullable TreePattern introspectionScope) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        v0 = this;
        var4_4 = (String)DbOptionProvider.getOptionValue(dataSource, RedisDefaultKeyFilterOption.class);
        if (var4_4 == null) ** GOTO lbl-1000
        var7_5 = var4_4;
        var9_6 = v0;
        $i$a$-let-RedisIntrospector$init$1 = false;
        v0 = var9_6;
        var5_8 = StringKt.nullize$default((String)StringsKt.trim((CharSequence)it).toString(), (boolean)false, (int)1, null);
        if (var5_8 != null) {
            it = var6_9 = var5_8;
            var9_6 = v0;
            $i$a$-takeIf-RedisIntrospector$init$2 = false;
            var10_10 = Intrinsics.areEqual((Object)it, (Object)RedisDefaultKeyFilterOption.getDefault()) == false;
            v0 = var9_6;
            v1 = var10_10 ? var6_9 : null;
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        v0.keyPattern = v1;
        this.scanCount = (Long)DbOptionProvider.getOptionValue(dataSource, RedisScanCountOption.class);
        return super.init(model, dataSource, introspectionScope);
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        this.initVersionParameters();
        this.initServerConfiguration();
    }

    private final void initVersionParameters() {
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 5, this.getParametersMap());
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 6, this.getParametersMap());
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 7, this.getParametersMap());
    }

    /*
     * WARNING - void declaration
     */
    private final void initServerConfiguration() {
        RedisIntroQueries.ServerInfo serverInfo2 = (RedisIntroQueries.ServerInfo)this.inTransaction(initServerConfiguration.serverInfo.1.INSTANCE);
        this.mode = this.extractMode(serverInfo2);
        RedisIntroQueries.ModulesInfo modulesInfo2 = (RedisIntroQueries.ModulesInfo)this.inTransaction(initServerConfiguration.modulesInfo.1.INSTANCE);
        this.modules = this.extractModules(modulesInfo2);
        if (this.getRequiresAllClusterNodesIntrospection()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List slotsInfos2 = (List)this.inTransaction(initServerConfiguration.slotsInfos.1.INSTANCE);
            Iterable iterable = slotsInfos2;
            RedisIntrospector redisIntrospector = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                RedisIntroQueries.SlotsInfo slotsInfo = (RedisIntroQueries.SlotsInfo)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(this.extractMasterNode((RedisIntroQueries.SlotsInfo)it2));
            }
            redisIntrospector.clusterNodes = (List)destination$iv$iv;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Mode extractMode(RedisIntroQueries.ServerInfo serverInfo2) {
        Mode mode;
        Mode mode2;
        String string;
        block7: {
            block6: {
                Pattern pattern2 = Pattern.compile("redis_mode:(.+)");
                Matcher matcher = pattern2.matcher(serverInfo2.value);
                if (!matcher.find()) return null;
                string = matcher.group(1);
                if (string == null) return null;
                switch (string.hashCode()) {
                    case 872092154: {
                        if (string.equals("cluster")) break;
                        return null;
                    }
                    case 1262856228: {
                        if (!string.equals("sentinel")) {
                            return null;
                        }
                        break block6;
                    }
                    case -1284644795: {
                        if (!string.equals("standalone")) return null;
                        mode2 = Mode.STANDALONE;
                        break block7;
                    }
                }
                mode2 = Mode.CLUSTER;
                break block7;
            }
            mode2 = Mode.SENTINEL;
            break block7;
            return null;
        }
        Mode mode3 = mode = mode2;
        if (mode3 == null) return null;
        String it2 = string = mode3;
        boolean bl = false;
        if (!this.isSupported((Mode)((Object)it2))) return null;
        String string2 = string;
        return string2;
    }

    private final Set<ObjectKind> extractModules(RedisIntroQueries.ModulesInfo modulesInfo2) {
        Pattern pattern2 = Pattern.compile("module:name=([^,]+)");
        Matcher matcher = pattern2.matcher(modulesInfo2.value);
        Set modules = new LinkedHashSet();
        while (matcher.find()) {
            if (!Intrinsics.areEqual((Object)matcher.group(1), (Object)"ReJSON")) continue;
            ObjectKind objectKind = ObjectKind.JSON_DOCUMENT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"JSON_DOCUMENT");
            modules.add(objectKind);
        }
        return modules;
    }

    private final HostPort extractMasterNode(RedisIntroQueries.SlotsInfo slotsInfo) {
        Long masterNodePort;
        List masterNodeInfo;
        Object object = ArraysKt.getOrNull((Object[])slotsInfo.value, (int)2);
        List list = masterNodeInfo = object instanceof List ? (List)object : null;
        Object object2 = list != null ? CollectionsKt.getOrNull((List)list, (int)0) : null;
        String masterNodeHost = object2 instanceof String ? (String)object2 : null;
        List list2 = masterNodeInfo;
        Object object3 = list2 != null ? CollectionsKt.getOrNull((List)list2, (int)1) : null;
        Long l = masterNodePort = object3 instanceof Long ? (Long)object3 : null;
        if (masterNodeHost == null || masterNodePort == null) {
            throw new DBFetchingException("Failed to process cluster slots information", null);
        }
        return new HostPort(masterNodeHost, (int)masterNodePort.longValue());
    }

    private final boolean isCurrentSchema(String name2) {
        return Intrinsics.areEqual((Object)name2, (Object)this.getSchema());
    }

    private final String getSchema() {
        return (String)JdbcNativeUtil.computeSafe(() -> RedisIntrospector.getSchema$lambda$6(this));
    }

    private final void setSchema(String name2) {
        JdbcNativeUtil.performSafe(() -> RedisIntrospector.setSchema$lambda$8(this, name2));
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends RedisSchema> schemas2, boolean whole) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
        for (RedisSchema redisSchema : schemas2) {
            this.handleErrors("Introspect schema " + redisSchema.getName(), (Function0<Unit>)((Function0)new Function0<Unit>(this, tran, redisSchema){
                final /* synthetic */ RedisIntrospector this$0;
                final /* synthetic */ DBTransaction $tran;
                final /* synthetic */ RedisSchema $schema;
                {
                    this.this$0 = $receiver;
                    this.$tran = $tran;
                    this.$schema = $schema;
                    super(0);
                }

                public final void invoke() {
                    BaseNativeIntrospector.AbstractSchemaRetriever<RedisSchema> retriever = this.this$0.createSchemaRetriever(this.$tran, this.$schema);
                    retriever.process();
                }
            }));
        }
    }

    @Override
    public void retrieveAndApplySchemas() {
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ RedisIntrospector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DBTransaction it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                this.this$0.introspectNamespacesInTran(it2);
            }
        }));
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        if (this.mode == Mode.CLUSTER) {
            this.applyClusterSchema();
            return;
        }
        RedisIntroQueries.DbCountInfo dbCountInfo = (RedisIntroQueries.DbCountInfo)JdbcNativeUtil.computeSafe(() -> RedisIntrospector.introspectNamespacesInTran$lambda$9(tran));
        if (this.applySchemas(dbCountInfo)) {
            return;
        }
        RedisIntroQueries.KeyspaceInfo keyspaceInfo = RedisIntroQueries.INSTANCE.retrieveKeyspaceInfo(tran);
        this.applySchemas(keyspaceInfo);
    }

    private final void applyClusterSchema() {
        List<Integer> list = Collections.singletonList(0);
        Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
        this.applySchemas(list, applyClusterSchema.1.INSTANCE);
    }

    private final boolean applySchemas(RedisIntroQueries.DbCountInfo dbCountInfo) {
        if (dbCountInfo == null) {
            return false;
        }
        Integer n = StringsKt.toIntOrNull((String)dbCountInfo.value);
        if (n == null) {
            return false;
        }
        int dbCount = n;
        List dbs2 = CollectionsKt.toList((Iterable)((Iterable)RangesKt.until((int)0, (int)dbCount)));
        this.applySchemas(dbs2, applySchemas.1.INSTANCE);
        return true;
    }

    private final void applySchemas(RedisIntroQueries.KeyspaceInfo keyspaceInfo) {
        Pattern pattern2 = Pattern.compile("db(\\d+):");
        Matcher matcher = pattern2.matcher(keyspaceInfo.value);
        List dbs2 = new ArrayList();
        while (matcher.find()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            dbs2.add(string);
        }
        this.applySchemas(dbs2, applySchemas.2.INSTANCE);
    }

    private final <T> void applySchemas(List<? extends T> dbs2, Function1<? super T, String> nameGetter) {
        this.inModel((Function1)new Function1<RedisRoot, Unit>(dbs2, nameGetter, this){
            final /* synthetic */ List<T> $dbs;
            final /* synthetic */ Function1<T, String> $nameGetter;
            final /* synthetic */ RedisIntrospector this$0;
            {
                this.$dbs = $dbs;
                this.$nameGetter = $nameGetter;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull RedisRoot r) {
                void $this$iv$iv$iv;
                void $this$applySchemasNamed$iv$iv;
                void name$iv;
                void $this$applySchemasNamed$iv;
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                NamingFamily namingFamily = r.getSchemas();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
                NamingFamily namingFamily2 = namingFamily;
                List<T> list = this.$dbs;
                Function1<T, String> function1 = this.$nameGetter;
                RedisIntrospector redisIntrospector = this.this$0;
                boolean $i$f$applySchemasNamed = false;
                void var7_7 = $this$applySchemasNamed$iv;
                ElementSearchCache searchCache$iv$iv = new ElementSearchCache();
                boolean $i$f$applySchemasNamed2 = false;
                FamilySearcher<T, D> familySearcher = ElementCacheOptimizersKt.byName(ElementCacheKt.searchElement(searchCache$iv$iv), (Function1)new Function1<T, String>((Function1)name$iv){
                    final /* synthetic */ Function1 $name;
                    {
                        this.$name = $name;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(T $this$byName) {
                        return (String)this.$name.invoke($this$byName);
                    }
                }).inFamily((Family)$this$applySchemasNamed$iv$iv);
                Function2 filler$iv$iv$iv = applySchemas$3$invoke$$inlined$applySchemasNamed$2.INSTANCE;
                boolean $i$f$orCreateBulk = false;
                ArrayList<E> items$iv$iv$iv = new ArrayList<E>();
                ElementSearcherNN<T, void> searcher$iv$iv$iv = ElementCacheKt.orCreateElement((ElementSearcher)$this$iv$iv$iv, (Function1)new Function1<D, T>((FamilySearcher)$this$iv$iv$iv, filler$iv$iv$iv, items$iv$iv$iv){
                    final /* synthetic */ FamilySearcher this$0;
                    final /* synthetic */ Function2 $filler;
                    final /* synthetic */ ArrayList $items;
                    {
                        this.this$0 = $receiver;
                        this.$filler = $filler;
                        this.$items = $items;
                        super(1);
                    }

                    @NotNull
                    public final T invoke(D it2) {
                        T t = BasicMetaUtils.getMetaObject(this.this$0.getFamily()).newDataObject();
                        FamilySearcher familySearcher = this.this$0;
                        Function2 function2 = this.$filler;
                        ArrayList arrayList = this.$items;
                        T $this$invoke_u24lambda_u240 = t;
                        boolean bl = false;
                        Intrinsics.checkNotNull($this$invoke_u24lambda_u240);
                        familySearcher.fillImpl($this$invoke_u24lambda_u240, it2, function2);
                        ((Collection)arrayList).add($this$invoke_u24lambda_u240);
                        T t2 = t;
                        Intrinsics.checkNotNullExpressionValue(t2, (String)"apply(...)");
                        return t2;
                    }
                });
                try {
                    void scs$iv;
                    ElementSearcherNN<T, void> schemas$iv$iv = searcher$iv$iv$iv;
                    boolean bl = false;
                    void $this$applySchemasImpl$iv$iv$iv = $this$applySchemasNamed$iv$iv;
                    boolean $i$f$applySchemasImpl = false;
                    $this$applySchemasImpl$iv$iv$iv.markChildrenAsSyncPending();
                    Iterable $this$forEach$iv$iv$iv$iv = (Iterable)scs$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void sc$iv$iv;
                        T element$iv$iv$iv$iv;
                        T sc$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        T t = sc$iv$iv$iv;
                        void $this$applySchemasNamed_u24lambda_u249_u24lambda_u248$iv$iv = $this$applySchemasImpl$iv$iv$iv;
                        boolean bl3 = false;
                        BasicModMateNamespace $this$applySchemasNamed_u24lambda_u249_u24lambda_u248_u24lambda_u247$iv$iv = (BasicModMateNamespace)schemas$iv$iv.find(sc$iv$iv);
                        boolean bl4 = false;
                        void var30_30 = sc$iv$iv;
                        RedisSchema $this$invoke_u24lambda_u240 = (RedisSchema)$this$applySchemasNamed_u24lambda_u249_u24lambda_u248_u24lambda_u247$iv$iv;
                        boolean bl5 = false;
                        String string = $this$invoke_u24lambda_u240.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        $this$invoke_u24lambda_u240.setCurrent(RedisIntrospector.access$isCurrentSchema(redisIntrospector, string));
                    }
                    $this$applySchemasImpl$iv$iv$iv.removeSyncPendingChildren();
                    $this$applySchemasImpl$iv$iv$iv.sort();
                }
                finally {
                    Family<T> family = $this$iv$iv$iv.getFamily();
                    Intrinsics.checkNotNull(family, (String)"null cannot be cast to non-null type com.intellij.database.model.families.Family<T of com.intellij.database.model.FamilySearcher>");
                    BaseModel.createBulk(family, (Iterable)items$iv$iv$iv);
                }
            }
        });
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseRetriever<RedisRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull RedisRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new BaseNativeIntrospector.AbstractDatabaseRetriever<RedisRoot>(this, transaction, database){

            public void process() {
            }
        };
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<RedisSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull RedisSchema schema2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        return new RedisSchemaRetriever(transaction, schema2);
    }

    private static final String getSchema$lambda$6(RedisIntrospector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseConnectionCore databaseConnectionCore = this$0.getDbConnection();
        return databaseConnectionCore != null && (databaseConnectionCore = databaseConnectionCore.getRemoteConnection()) != null ? databaseConnectionCore.getSchema() : null;
    }

    private static final void setSchema$lambda$8(RedisIntrospector this$0, String $name) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
            DatabaseConnectionCore databaseConnectionCore = this$0.getDbConnection();
            if (databaseConnectionCore == null) break block0;
            DatabaseConnectionCore it2 = databaseConnectionCore;
            boolean bl = false;
            it2.getRemoteConnection().setSchema($name);
        }
    }

    private static final RedisIntroQueries.DbCountInfo introspectNamespacesInTran$lambda$9(DBTransaction $tran) {
        Intrinsics.checkNotNullParameter((Object)$tran, (String)"$tran");
        return RedisIntroQueries.INSTANCE.retrieveDbCount($tran);
    }

    public static final /* synthetic */ void access$reportRetrieving(RedisIntrospector $this, ObjectKind kind) {
        $this.reportRetrieving(kind);
    }

    public static final /* synthetic */ Set access$getModules$p(RedisIntrospector $this) {
        return $this.modules;
    }

    public static final /* synthetic */ boolean access$getRequiresAllClusterNodesIntrospection(RedisIntrospector $this) {
        return $this.getRequiresAllClusterNodesIntrospection();
    }

    public static final /* synthetic */ List access$getClusterNodes$p(RedisIntrospector $this) {
        return $this.clusterNodes;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$DefaultNature;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "()V", "supportFragmentIntrospection", "", "getSupportFragmentIntrospection", "()Z", "supportFragmentKinds", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportFragmentKinds", "()Ljava/util/Set;", "supportServerObjects", "getSupportServerObjects", "intellij.database.dialects.redis"})
    private static final class DefaultNature
    implements BaseIntrospector.Nature {
        @NotNull
        public static final DefaultNature INSTANCE = new DefaultNature();

        private DefaultNature() {
        }

        @Override
        public boolean getSupportServerObjects() {
            return false;
        }

        @Override
        public boolean getSupportFragmentIntrospection() {
            return false;
        }

        @Override
        @NotNull
        public Set<ObjectKind> getSupportFragmentKinds() {
            return SetsKt.emptySet();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.redis"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return true;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new RedisIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return false;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.redis"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$Mode;", "", "(Ljava/lang/String;I)V", "STANDALONE", "CLUSTER", "SENTINEL", "intellij.database.dialects.redis"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode STANDALONE = new Mode();
        public static final /* enum */ Mode CLUSTER = new Mode();
        public static final /* enum */ Mode SENTINEL = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value2) {
            return Enum.valueOf(Mode.class, value2);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.STANDALONE, Mode.CLUSTER, Mode.SENTINEL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J@\u0010\u0013\u001a\u00020\u0012\"\b\b\u0000\u0010\u0014*\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\u000f2\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\u001a0\u0019H\u0002J\u0016\u0010\u001b\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0002J0\u0010\u001e\u001a\u0004\u0018\u00010\u0015*\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0019H\u0002J@\u0010#\u001a\u00020\u0012\"\b\b\u0000\u0010\u0014*\u00020\u0015*\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u00140\u001a2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000f2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0002R\u001a\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector$RedisSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/redis/model/RedisSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/redis/model/RedisRoot;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/redis/introspector/RedisIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/redis/model/RedisSchema;)V", "keyType", "", "Lcom/intellij/database/model/ObjectKind;", "getKeyType", "(Lcom/intellij/database/model/ObjectKind;)Ljava/lang/String;", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "process", "", "retrieveKeys", "T", "Lcom/intellij/database/dialects/redis/model/RedisKey;", "fromModule", "isDefaultFamily", "familyInvoker", "Lkotlin/Function1;", "Lcom/intellij/database/model/families/ModNamingFamily;", "withCorrectSearchPath", "action", "Lkotlin/Function0;", "getKey", "modelObjectsWithKeyName", "", "Lcom/intellij/database/model/DasObject;", "checkKind", "retrieveKeysImpl", "family", "familyKind", "node", "Lcom/intellij/database/dataSource/url/HostPort;", "intellij.database.dialects.redis"})
    @SourceDebugExtension(value={"SMAP\nRedisIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisIntrospector.kt\ncom/intellij/database/dialects/redis/introspector/RedisIntrospector$RedisSchemaRetriever\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,359:1\n1#2:360\n*E\n"})
    private final class RedisSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<RedisSchema> {
        public RedisSchemaRetriever(@NotNull DBTransaction transaction, RedisSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            super((BaseNativeIntrospector)RedisIntrospector.this, transaction, (BasicModSchema)schema2);
        }

        @Override
        public boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull RedisSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            return false;
        }

        @Override
        public void process() {
            BaseIntrospector baseIntrospector = RedisIntrospector.this;
            String string = ((RedisSchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            BaseIntrospector.reportIntrospectingSchema$default(baseIntrospector, string, null, null, 6, null);
            this.withCorrectSearchPath((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ RedisSchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.prepareParameters();
                    RedisSchemaRetriever.access$retrieveKeys(this.this$0);
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void withCorrectSearchPath(Function0<Unit> action) {
            if (((RedisSchema)this.getSchema()).isCurrent()) {
                action.invoke();
                return;
            }
            String string = ((RedisSchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name2 = string;
            String currentName = RedisIntrospector.this.getSchema();
            RedisIntrospector.this.setSchema(name2);
            try {
                if (!RedisIntrospector.this.isCurrentSchema(name2)) {
                    throw new DBSchemaAccessDeniedException(new SQLException("Failed to connect to db " + name2 + " for introspection"), null);
                }
                action.invoke();
            }
            finally {
                String string2 = currentName;
                if (string2 != null) {
                    String string3 = string2;
                    RedisIntrospector redisIntrospector = RedisIntrospector.this;
                    String it2 = string3;
                    boolean bl = false;
                    redisIntrospector.setSchema(it2);
                }
            }
        }

        private final void retrieveKeys() {
            if (!RedisIntrospector.this.getSupportsKeysScanWithType()) {
                RedisSchemaRetriever.retrieveKeys$default(this, false, false, retrieveKeys.1.INSTANCE, 3, null);
                return;
            }
            RedisSchemaRetriever.retrieveKeys$default(this, false, false, retrieveKeys.2.INSTANCE, 3, null);
            RedisSchemaRetriever.retrieveKeys$default(this, false, false, retrieveKeys.3.INSTANCE, 3, null);
            RedisSchemaRetriever.retrieveKeys$default(this, false, false, retrieveKeys.4.INSTANCE, 3, null);
            RedisSchemaRetriever.retrieveKeys$default(this, false, false, retrieveKeys.5.INSTANCE, 3, null);
            RedisSchemaRetriever.retrieveKeys$default(this, false, false, retrieveKeys.6.INSTANCE, 3, null);
            RedisSchemaRetriever.retrieveKeys$default(this, false, false, retrieveKeys.7.INSTANCE, 3, null);
            RedisSchemaRetriever.retrieveKeys$default(this, true, false, retrieveKeys.8.INSTANCE, 2, null);
            RedisSchemaRetriever.retrieveKeys$default(this, false, true, retrieveKeys.9.INSTANCE, 1, null);
        }

        private final <T extends RedisKey> void retrieveKeys(boolean fromModule, boolean isDefaultFamily, Function1<? super RedisSchema, ? extends ModNamingFamily<T>> familyInvoker) {
            this.inSchema((Function1)new Function1<RedisSchema, Unit>(familyInvoker, RedisIntrospector.this, fromModule, this, isDefaultFamily){
                final /* synthetic */ Function1<RedisSchema, ModNamingFamily<T>> $familyInvoker;
                final /* synthetic */ RedisIntrospector this$0;
                final /* synthetic */ boolean $fromModule;
                final /* synthetic */ RedisSchemaRetriever this$1;
                final /* synthetic */ boolean $isDefaultFamily;
                {
                    this.$familyInvoker = $familyInvoker;
                    this.this$0 = $receiver;
                    this.$fromModule = $fromModule;
                    this.this$1 = $receiver2;
                    this.$isDefaultFamily = $isDefaultFamily;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull RedisSchema s2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                    ModNamingFamily family = (ModNamingFamily)this.$familyInvoker.invoke((Object)s2);
                    ObjectKind familyKind = family.getMetaObject().kind;
                    Intrinsics.checkNotNull((Object)familyKind);
                    RedisIntrospector.access$reportRetrieving(this.this$0, familyKind);
                    ModFamily modFamily = family;
                    boolean bl = this.$fromModule;
                    RedisIntrospector redisIntrospector = this.this$0;
                    RedisSchemaRetriever redisSchemaRetriever = this.this$1;
                    boolean bl2 = this.$isDefaultFamily;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingFamily f = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl3 = false;
                    if (!bl || RedisIntrospector.access$getModules$p(redisIntrospector).contains(familyKind)) {
                        if (RedisIntrospector.access$getRequiresAllClusterNodesIntrospection(redisIntrospector)) {
                            Iterable $this$forEach$iv = RedisIntrospector.access$getClusterNodes$p(redisIntrospector);
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                HostPort it2 = (HostPort)element$iv;
                                boolean bl4 = false;
                                RedisSchemaRetriever.access$retrieveKeysImpl(redisSchemaRetriever, s2, f, familyKind, bl2, it2);
                            }
                        } else {
                            RedisSchemaRetriever.retrieveKeysImpl$default(redisSchemaRetriever, s2, f, familyKind, bl2, null, 8, null);
                        }
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        static /* synthetic */ void retrieveKeys$default(RedisSchemaRetriever redisSchemaRetriever, boolean bl, boolean bl2, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            redisSchemaRetriever.retrieveKeys(bl, bl2, function1);
        }

        private final <T extends RedisKey> void retrieveKeysImpl(RedisSchema $this$retrieveKeysImpl, ModNamingFamily<T> family, ObjectKind familyKind, boolean isDefaultFamily, HostPort node2) {
            Ref.LongRef cursor2 = new Ref.LongRef();
            do {
                RedisIntroQueries.INSTANCE.processKeysScan(this.getTransaction(), node2, cursor2.element, RedisIntrospector.this.keyPattern, RedisIntrospector.this.scanCount, this.getKeyType(familyKind), (Function1<? super RedisIntroQueries.KeysScanInfo, Unit>)((Function1)new Function1<RedisIntroQueries.KeysScanInfo, Unit>(cursor2, $this$retrieveKeysImpl, isDefaultFamily, this, family, familyKind){
                    final /* synthetic */ Ref.LongRef $cursor;
                    final /* synthetic */ RedisSchema $this_retrieveKeysImpl;
                    final /* synthetic */ boolean $isDefaultFamily;
                    final /* synthetic */ RedisSchemaRetriever this$0;
                    final /* synthetic */ ModNamingFamily<T> $family;
                    final /* synthetic */ ObjectKind $familyKind;
                    {
                        this.$cursor = $cursor;
                        this.$this_retrieveKeysImpl = $receiver;
                        this.$isDefaultFamily = $isDefaultFamily;
                        this.this$0 = $receiver2;
                        this.$family = $family;
                        this.$familyKind = $familyKind;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull RedisIntroQueries.KeysScanInfo keysScan) {
                        void $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)keysScan, (String)"keysScan");
                        Long l = StringsKt.toLongOrNull((String)keysScan.cursor);
                        this.$cursor.element = l != null ? l : 0L;
                        String[] stringArray = keysScan.results;
                        RedisSchema redisSchema = this.$this_retrieveKeysImpl;
                        boolean bl = this.$isDefaultFamily;
                        RedisSchemaRetriever redisSchemaRetriever = this.this$0;
                        ModNamingFamily<T> modNamingFamily = this.$family;
                        ObjectKind objectKind = this.$familyKind;
                        boolean $i$f$forEach = false;
                        int n = ((void)$this$forEach$iv).length;
                        for (int j = 0; j < n; ++j) {
                            Collection<DasObject> modelObjectWithKeyName;
                            RedisKey key2;
                            void element$iv;
                            void keyName = element$iv = $this$forEach$iv[j];
                            boolean bl2 = false;
                            Intrinsics.checkNotNullExpressionValue(((BasicModModel)redisSchema.getModel()).getNameIndex().getObjectsByName((String)keyName), (String)"getObjectsByName(...)");
                            if (bl && (key2 = RedisSchemaRetriever.access$getKey(redisSchemaRetriever, redisSchema, modelObjectWithKeyName, (Function1)new Function1<ObjectKind, Boolean>(objectKind){
                                final /* synthetic */ ObjectKind $familyKind;
                                {
                                    this.$familyKind = $familyKind;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull ObjectKind it2) {
                                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                                    return !Intrinsics.areEqual((Object)it2, (Object)this.$familyKind);
                                }
                            })) != null) continue;
                            key2 = RedisSchemaRetriever.access$getKey(redisSchemaRetriever, redisSchema, modelObjectWithKeyName, (Function1)new Function1<ObjectKind, Boolean>(objectKind){
                                final /* synthetic */ ObjectKind $familyKind;
                                {
                                    this.$familyKind = $familyKind;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull ObjectKind it2) {
                                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                                    return Intrinsics.areEqual((Object)it2, (Object)this.$familyKind);
                                }
                            });
                            if (key2 != null) {
                                if (!key2.isSyncPending()) continue;
                                key2.resetSyncPending();
                                continue;
                            }
                            E e2 = modNamingFamily.createNewOne();
                            RedisKey $this$invoke_u24lambda_u241_u24lambda_u240 = (RedisKey)e2;
                            boolean bl3 = false;
                            $this$invoke_u24lambda_u241_u24lambda_u240.setName((String)keyName);
                        }
                    }
                }));
            } while (cursor2.element != 0L);
        }

        static /* synthetic */ void retrieveKeysImpl$default(RedisSchemaRetriever redisSchemaRetriever, RedisSchema redisSchema, ModNamingFamily modNamingFamily, ObjectKind objectKind, boolean bl, HostPort hostPort, int n, Object object) {
            if ((n & 8) != 0) {
                hostPort = null;
            }
            redisSchemaRetriever.retrieveKeysImpl(redisSchema, modNamingFamily, objectKind, bl, hostPort);
        }

        /*
         * Unable to fully structure code
         */
        private final RedisKey getKey(RedisSchema $this$getKey, Iterable<? extends DasObject> modelObjectsWithKeyName, Function1<? super ObjectKind, Boolean> checkKind) {
            block3: {
                var5_4 = modelObjectsWithKeyName;
                var6_5 = var5_4.iterator();
                while (var6_5.hasNext()) {
                    it = var7_6 = var6_5.next();
                    $i$a$-find-RedisIntrospector$RedisSchemaRetriever$getKey$1 = false;
                    if (!(it instanceof RedisKey) || !Intrinsics.areEqual((Object)((RedisKey)it).getSchema(), (Object)$this$getKey)) ** GOTO lbl-1000
                    v0 = ((RedisKey)it).getKind();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getKind(...)");
                    if (((Boolean)checkKind.invoke((Object)v0)).booleanValue()) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = var7_6;
                    break block3;
                }
                v2 = null;
            }
            var4_9 = v2;
            return var4_9 instanceof RedisKey != false ? (RedisKey)var4_9 : null;
        }

        private final String getKeyType(ObjectKind $this$keyType) {
            ObjectKind objectKind = $this$keyType;
            return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.STRING) ? "string" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.LIST) ? "list" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SET) ? "set" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SORTED_SET) ? "zset" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.HASH_TABLE) ? "hash" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.STREAM) ? "stream" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.JSON_DOCUMENT) ? "rejson-rl" : null))))));
        }

        public static final /* synthetic */ void access$retrieveKeys(RedisSchemaRetriever $this) {
            $this.retrieveKeys();
        }

        public static final /* synthetic */ void access$retrieveKeysImpl(RedisSchemaRetriever $this, RedisSchema $receiver, ModNamingFamily family, ObjectKind familyKind, boolean isDefaultFamily, HostPort node2) {
            $this.retrieveKeysImpl($receiver, family, familyKind, isDefaultFamily, node2);
        }

        public static final /* synthetic */ RedisKey access$getKey(RedisSchemaRetriever $this, RedisSchema $receiver, Iterable modelObjectsWithKeyName, Function1 checkKind) {
            return $this.getKey($receiver, modelObjectsWithKeyName, (Function1<? super ObjectKind, Boolean>)checkKind);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.STANDALONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.CLUSTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.SENTINEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

