/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.project.Project;
import com.intellij.sql.psi.SqlElement;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public final class RedisExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @Override
    @NotNull
    protected String generateSelectStatement(@NotNull String text2, @NotNull SqlElement sqlElement) {
        if (text2 == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(0);
        }
        if (sqlElement == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(1);
        }
        String string = String.format("ECHO %s", text2);
        if (string == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getKeepAliveQuery(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(3);
        }
        if (dataSource2 == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(4);
        }
        return "PING";
    }

    @Override
    @NotNull
    public ObjectKind getTableKind(@NotNull RemoteResultSet resultSet) throws RemoteException, SQLException {
        if (resultSet == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(5);
        }
        if (!resultSet.next()) {
            throw new AssertionError((Object)"Incorrect table kind query!");
        }
        String kind = resultSet.getString(1);
        if (kind == null) {
            throw new AssertionError((Object)"Empty table kind!");
        }
        ObjectKind objectKind = switch (kind.toLowerCase(Locale.ENGLISH)) {
            case "string" -> ObjectKind.STRING;
            case "list" -> ObjectKind.LIST;
            case "set" -> ObjectKind.SET;
            case "zset" -> ObjectKind.SORTED_SET;
            case "hash" -> ObjectKind.HASH_TABLE;
            case "stream" -> ObjectKind.STREAM;
            case "rejson-rl" -> ObjectKind.JSON_DOCUMENT;
            case "none" -> throw new SQLException(DatabaseBundle.message("error.message.redis.the.key.does.not.exist", new Object[0]));
            default -> throw new SQLException(String.format(DatabaseBundle.message("error.message.redis.the.key.cannot.be.represented.as.a.table", kind), new Object[0]));
        };
        if (objectKind == null) {
            RedisExecutionEnvironmentHelper.$$$reportNull$$$0(6);
        }
        return objectKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlElement";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/redis/RedisExecutionEnvironmentHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/redis/RedisExecutionEnvironmentHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSelectStatement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateSelectStatement";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKeepAliveQuery";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTableKind";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }
}

