/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IdCache;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.postgres.introspector.PgIntroQueries;
import com.intellij.database.dialects.postgres.model.PgAggregate;
import com.intellij.database.dialects.postgres.model.PgDatabase;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.dialects.postgres.model.PgEventTrigger;
import com.intellij.database.dialects.postgres.model.PgIndex;
import com.intellij.database.dialects.postgres.model.PgLikeStoredTable;
import com.intellij.database.dialects.postgres.model.PgLocalTable;
import com.intellij.database.dialects.postgres.model.PgLocalTableColumn;
import com.intellij.database.dialects.postgres.model.PgMatView;
import com.intellij.database.dialects.postgres.model.PgModelHelper;
import com.intellij.database.dialects.postgres.model.PgRole;
import com.intellij.database.dialects.postgres.model.PgRoot;
import com.intellij.database.dialects.postgres.model.PgRoutine;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgres.model.PgSecurityPolicy;
import com.intellij.database.dialects.postgres.model.PgTable;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.dialects.postgres.model.PgView;
import com.intellij.database.dialects.postgres.model.properties.PgCheckOption;
import com.intellij.database.dialects.postgres.model.properties.PgDataTypeSubCategory;
import com.intellij.database.dialects.postgres.model.properties.PgIdentityKind;
import com.intellij.database.dialects.postgres.model.properties.PgRoutineConcurrencyKind;
import com.intellij.database.dialects.postgres.model.properties.PgSecurityPolicyOperationType;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospectorKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseAggregate;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefType;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntroQueries;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntrospector;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDatabase;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseIndex;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTrigger;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.Scriptum;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.sql.psi.SqlCreateStatement;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0005&'()*B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0012\u001a\u00060\u0013R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u001c\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u001c\u0010\u0019\u001a\u00060\u001aR\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0004H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020 H\u0014J\u0018\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "queries", "Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createNativeRetriever", "Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyNativeRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MySchemaRetriever;", "schema", "generateDbAge", "", "tx", "initConnectionRelatedState", "", "processRole", "role", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRole;", "r", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneRole;", "Companion", "Factory", "MyDatabaseRetriever", "MyNativeRetriever", "MySchemaRetriever", "intellij.database.dialects.postgres"})
public final class PgIntrospector
extends PgGPlumBaseIntrospector<PgRoot, PgDatabase, PgSchema> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final PgIntroQueries QUERIES;

    @Override
    @NotNull
    protected PgGPlumBaseModelHelper getHelper() {
        return PgModelHelper.INSTANCE;
    }

    public PgIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        Dbms dbms = Dbms.POSTGRES;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"POSTGRES");
        super(context, dbms, modelFactory);
    }

    @Override
    @NotNull
    protected PgIntroQueries getQueries() {
        return QUERIES;
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        Companion.setVersionParameters(this.getServerVersion(), this.getParametersMap());
    }

    @Override
    @NotNull
    public String generateDbAge(@NotNull String tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        return "pg_catalog.age(" + tx + "::varchar::xid)";
    }

    @Override
    protected void processRole(@NotNull PgGPlumBaseRole role, @NotNull PgGPlumBaseIntroQueries.OneRole r) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        super.processRole(role, r);
        if (!(role instanceof PgRole)) {
            return;
        }
        ((PgRole)role).setReplication(r.is_replication);
        ((PgRole)role).setBypassRls(r.bypass_rls);
    }

    @NotNull
    protected MyDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull PgDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MyDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected MyNativeRetriever createNativeRetriever(@NotNull DBTransaction transaction, @NotNull PgDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MyNativeRetriever(transaction, database);
    }

    @NotNull
    protected MySchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull PgSchema schema2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        return new MySchemaRetriever(transaction, schema2);
    }

    static {
        Scriptum scriptum = Scriptum.of(PgIntroQueries.class);
        Intrinsics.checkNotNullExpressionValue((Object)scriptum, (String)"of(...)");
        QUERIES = new PgIntroQueries(scriptum);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Companion;", "", "()V", "QUERIES", "Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "setVersionParameters", "", "version", "Lcom/intellij/database/util/Version;", "parameters", "", "", "intellij.database.dialects.postgres"})
    public static final class Companion {
        private Companion() {
        }

        public final void setVersionParameters(@NotNull Version version, @NotNull Map<String, Object> parameters2) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 8, new IntRange(1, 4), parameters2);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 9, new IntRange(0, 9), parameters2);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 10, new IntRange(0, 0), parameters2);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 11, new IntRange(0, 0), parameters2);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 12, new IntRange(0, 0), parameters2);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 14, new IntRange(0, 0), parameters2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isIncremental", "", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.postgres"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{9};
            return version.isOrGreater(nArray);
        }

        @Override
        public boolean isIncremental() {
            return true;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new PgIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return PgBaseIntrospectorKt.canCheckOutdated(e2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.postgres"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u000bH\u0014J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyDatabaseRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgDatabase;)V", "retrieveEventTriggers", "", "detectDropped", "", "loadNew", "retrieveExtensionMembers", "retrieveExtensions", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "intellij.database.dialects.postgres"})
    protected final class MyDatabaseRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseDatabaseRetriever<PgDatabase> {
        public MyDatabaseRetriever(@NotNull DBTransaction tran, PgDatabase database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((PgGPlumBaseIntrospector)PgIntrospector.this, tran, (PgGPlumBaseDatabase)database);
        }

        @Override
        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add(super.steps(), 1, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ MyDatabaseRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    boolean bl;
                    Version version = MyDatabaseRetriever.access$getModel(this.this$0).getRoot().getServerVersion();
                    if (version != null) {
                        int[] nArray = new int[]{9, 3};
                        bl = version.isOrGreater(nArray);
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        MyDatabaseRetriever.access$retrieveEventTriggers(this.this$0, detectDropped, loadNew);
                    }
                }
            }));
        }

        @Override
        protected void retrieveExtensions(boolean detectDropped, boolean loadNew) {
            int[] nArray = new int[]{9, 1};
            boolean supported = PgIntrospector.this.getServerVersion().isOrGreater(nArray);
            super.retrieveExtensions(detectDropped && supported, loadNew && supported);
        }

        @Override
        protected void retrieveExtensionMembers() {
            int[] nArray = new int[]{9, 1};
            boolean supported = PgIntrospector.this.getServerVersion().isOrGreater(nArray);
            if (supported) {
                super.retrieveExtensionMembers();
            }
        }

        private final void retrieveEventTriggers(boolean detectDropped, boolean loadNew) {
            PgIntrospector.this.reportRetrieving("event triggers", "introspection.retrieve.event.triggers");
            this.inDatabase((Function1)new Function1<PgDatabase, Unit>(PgIntrospector.this, detectDropped, this, loadNew){
                final /* synthetic */ PgIntrospector this$0;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ MyDatabaseRetriever this$1;
                final /* synthetic */ boolean $loadNew;
                {
                    this.this$0 = $receiver;
                    this.$detectDropped = $detectDropped;
                    this.this$1 = $receiver2;
                    this.$loadNew = $loadNew;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull PgDatabase db2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                    ModFamily modFamily = db2.getEventTriggers();
                    PgIntrospector pgIntrospector = this.this$0;
                    boolean bl = this.$detectDropped;
                    MyDatabaseRetriever myDatabaseRetriever = this.this$1;
                    boolean bl2 = this.$loadNew;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily eventTriggers = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl3 = false;
                    BaseNativeIntrospector this_$iv = pgIntrospector;
                    boolean $i$f$continueOnDbError = false;
                    try {
                        boolean bl4 = false;
                        if (bl) {
                            long[] $this$forEach$iv = (long[])MyDatabaseRetriever.access$performQuery(myDatabaseRetriever, pgIntrospector.getQueries().getRetrieveExistentEventTriggers());
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int j = 0; j < n; ++j) {
                                long element$iv;
                                long it2 = element$iv = $this$forEach$iv[j];
                                boolean bl5 = false;
                                PgEventTrigger pgEventTrigger = (PgEventTrigger)eventTriggers.getByObjectId(it2);
                                if (pgEventTrigger != null) {
                                    pgEventTrigger.resetSyncPending();
                                }
                            }
                        }
                        if (bl2) {
                            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(myDatabaseRetriever, PgIntrospector.QUERIES.getRetrieveEventTriggers(), 0, (Function1)new Function1<PgIntroQueries.OneEventTrigger, Unit>((ModNamingIdentifyingFamily<? extends PgEventTrigger>)eventTriggers){
                                final /* synthetic */ ModNamingIdentifyingFamily<? extends PgEventTrigger> $eventTriggers;
                                {
                                    this.$eventTriggers = $eventTriggers;
                                    super(1);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke(@NotNull PgIntroQueries.OneEventTrigger et) {
                                    Object object;
                                    PgEventTrigger pgEventTrigger;
                                    PgEventTrigger $this$invoke_u24lambda_u241;
                                    block3: {
                                        block2: {
                                            void it2;
                                            PgEventTrigger pgEventTrigger2;
                                            Intrinsics.checkNotNullParameter((Object)et, (String)"et");
                                            $this$invoke_u24lambda_u241 = pgEventTrigger2 = this.$eventTriggers.renew(et.id, et.name);
                                            boolean bl = false;
                                            $this$invoke_u24lambda_u241.setStateNumber(et.state_number);
                                            pgEventTrigger = $this$invoke_u24lambda_u241;
                                            object = et.tags;
                                            if (et.tags == null) break block2;
                                            String[] stringArray = object;
                                            PgEventTrigger pgEventTrigger3 = pgEventTrigger;
                                            boolean bl2 = false;
                                            Set set = SetsKt.setOf((Object[])Arrays.copyOf(it2, ((void)it2).length));
                                            pgEventTrigger = pgEventTrigger3;
                                            object = set;
                                            if (set != null) break block3;
                                        }
                                        object = SetsKt.emptySet();
                                    }
                                    pgEventTrigger.setTags((Set<String>)object);
                                    $this$invoke_u24lambda_u241.setEvent(et.event);
                                    $this$invoke_u24lambda_u241.setCallRoutineRef(BasicIdReference.create(et.routine_id));
                                    $this$invoke_u24lambda_u241.setDisabled(et.is_disabled);
                                }
                            }, 2, null);
                        }
                    }
                    catch (DBException e$iv) {
                        this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        public static final /* synthetic */ BasicModModel access$getModel(MyDatabaseRetriever $this) {
            return $this.getModel();
        }

        public static final /* synthetic */ void access$retrieveEventTriggers(MyDatabaseRetriever $this, boolean detectDropped, boolean loadNew) {
            $this.retrieveEventTriggers(detectDropped, loadNew);
        }

        public static final /* synthetic */ Object access$performQuery(MyDatabaseRetriever $this, SqlQuery query) {
            return $this.performQuery(query);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyNativeRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseNativeRetriever;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgDatabase;)V", "getNativeDefinitionQuery", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.postgres"})
    protected final class MyNativeRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseNativeRetriever<PgDatabase> {
        public MyNativeRetriever(@NotNull DBTransaction tran, PgDatabase database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((PgGPlumBaseIntrospector)PgIntrospector.this, tran, (PgGPlumBaseDatabase)database);
        }

        @Override
        @Nullable
        protected String getNativeDefinitionQuery(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            String string = super.getNativeDefinitionQuery(kind);
            if (string == null) {
                string = Intrinsics.areEqual((Object)kind, (Object)ObjectKind.ROUTINE) ? "select pg_get_functiondef(?)" : null;
            }
            return string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0014\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0017H\u0014J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J0\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0*2\u0006\u0010+\u001a\u00020,H\u0014J \u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010\b\u001a\u00020\u0002H\u0014J\u0018\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u0002042\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0014J\u0018\u0010:\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0014J\u0018\u0010>\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,2\u0006\u0010<\u001a\u00020=H\u0014J \u0010?\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010@\u001a\u00020=H\u0014J\u0018\u0010A\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020C2\u0006\u0010<\u001a\u00020DH\u0014J$\u0010E\u001a\u00020\u001f2\u0012\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0H0G2\u0006\u0010J\u001a\u00020KH\u0014J\u0018\u0010L\u001a\u00020\u001f2\u0006\u0010M\u001a\u00020\u00172\u0006\u0010N\u001a\u00020\u0017H\u0014J\b\u0010O\u001a\u00020\u001fH\u0014J\u0018\u0010P\u001a\u00020\u001f2\u0006\u0010M\u001a\u00020\u00172\u0006\u0010N\u001a\u00020\u0017H\u0002J\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0\u0014H\u0014J\b\u0010S\u001a\u00020\u0017H\u0002\u00a8\u0006T"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MySchemaRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgSchema;)V", "createRoutine", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;", "r", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;", "getFunSourceText", "Lcom/intellij/database/model/properties/CompositeText;", "fs", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneFunctionSource;", "getSequencesQuery", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneSequence;", "hasReference", "", "con", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;", "incrementalViewSources", "isTableKind", "kind", "", "processAggregate", "", "agg", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneAggregate;", "aggregate", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseAggregate;", "processColumn", "col", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneColumn;", "column", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeColumn;", "columns", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "table", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "processDataType", "dataType", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;", "oneType", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;", "processFunSourceAttributes", "function", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoutine;", "processIndex", "index", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseIndex;", "ind", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneIndex;", "processModTable", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "processModView", "processTable", "oneTable", "processTrigger", "trigger", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTrigger;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneTrigger;", "removeComments", "existentComments", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "", "", "e", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "retrieveCollations", "detectDropped", "loadNew", "retrieveForeignTablesInfo", "retrieveSecurityPolicies", "steps", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "supportsAdvancedSequences", "intellij.database.dialects.postgres"})
    @SourceDebugExtension(value={"SMAP\nPgIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgIntrospector.kt\ncom/intellij/database/dialects/postgres/introspector/PgIntrospector$MySchemaRetriever\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 4 IntrospectorSqlHelper.kt\ncom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n1#2:346\n129#3,2:347\n132#3,8:350\n26#4:349\n1855#5,2:358\n1549#5:360\n1620#5,3:361\n*S KotlinDebug\n*F\n+ 1 PgIntrospector.kt\ncom/intellij/database/dialects/postgres/introspector/PgIntrospector$MySchemaRetriever\n*L\n248#1:347,2\n248#1:350,8\n248#1:349\n284#1:358,2\n291#1:360\n291#1:361,3\n*E\n"})
    protected final class MySchemaRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseSchemaRetriever<PgSchema> {
        public MySchemaRetriever(@NotNull DBTransaction transaction, PgSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            super((PgGPlumBaseIntrospector)PgIntrospector.this, transaction, (PgGPlumBaseSchema)schema2);
        }

        @Override
        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add(super.steps(), 81, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(PgIntrospector.this, this){
                final /* synthetic */ PgIntrospector this$0;
                final /* synthetic */ MySchemaRetriever this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    int[] nArray = new int[]{9, 5};
                    boolean isSupported = PgIntrospector.access$getServerVersion(this.this$0).isOrGreater(nArray);
                    MySchemaRetriever.access$retrieveSecurityPolicies(this.this$1, detectDropped && isSupported, loadNew && isSupported);
                }
            }));
        }

        private final boolean supportsAdvancedSequences() {
            int[] nArray = new int[]{10, -10};
            return PgIntrospector.this.getServerVersion().isOrGreater(nArray);
        }

        @Override
        @NotNull
        protected SqlQuery<List<PgGPlumBaseIntroQueries.OneSequence>> getSequencesQuery() {
            return this.supportsAdvancedSequences() ? QUERIES.getRetrieveSequences10() : super.getSequencesQuery();
        }

        @Override
        protected void retrieveForeignTablesInfo() {
            int[] nArray = new int[]{9, 1};
            if (PgIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                super.retrieveForeignTablesInfo();
            }
        }

        @Override
        protected void retrieveCollations(boolean detectDropped, boolean loadNew) {
            int[] nArray = new int[]{9, 1};
            boolean isSupported = PgIntrospector.this.getServerVersion().isOrGreater(nArray);
            super.retrieveCollations(detectDropped && isSupported, loadNew && isSupported);
        }

        @Override
        protected void processDataType(@NotNull PgBaseDefType dataType, @NotNull PgBaseIntroQueries.OneDataType oneType, @NotNull PgSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
            Intrinsics.checkNotNullParameter((Object)oneType, (String)"oneType");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            super.processDataType(dataType, oneType, (PgGPlumBaseSchema)schema2);
            if (!(dataType instanceof PgDefType)) {
                return;
            }
            ((PgDefType)dataType).setSubCategory(PgDataTypeSubCategory.of(oneType.type_category));
        }

        @Override
        protected void processTable(@NotNull PgBaseLikeStoredTable table, @NotNull PgSchema schema2, @NotNull PgBaseIntroQueries.OneTable oneTable) {
            boolean bl;
            long it2;
            PgLikeStoredTable pgLikeStoredTable;
            Long l;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)oneTable, (String)"oneTable");
            super.processTable(table, (PgGPlumBaseSchema)schema2, oneTable);
            if (table instanceof PgMatView) {
                BasicIdReference basicIdReference;
                l = oneTable.tablespace_id;
                long l2 = ((Number)l).longValue();
                pgLikeStoredTable = (PgMatView)table;
                boolean bl2 = false;
                bl = it2 != 0L;
                PgLikeStoredTable pgLikeStoredTable2 = pgLikeStoredTable;
                Long l3 = bl ? l : null;
                if (l3 != null) {
                    it2 = ((Number)l3).longValue();
                    pgLikeStoredTable = pgLikeStoredTable2;
                    boolean bl3 = false;
                    basicIdReference = BasicIdReference.create(it2);
                    pgLikeStoredTable2 = pgLikeStoredTable;
                } else {
                    basicIdReference = null;
                }
                pgLikeStoredTable2.setTablespaceRef(basicIdReference);
            }
            if (table instanceof PgLocalTable) {
                BasicIdReference basicIdReference;
                l = oneTable.am_id;
                it2 = ((Number)l).longValue();
                pgLikeStoredTable = (PgLocalTable)table;
                boolean bl4 = false;
                bl = it2 != 0L;
                PgLikeStoredTable pgLikeStoredTable3 = pgLikeStoredTable;
                Long l4 = bl ? l : null;
                if (l4 != null) {
                    it2 = ((Number)l4).longValue();
                    pgLikeStoredTable = pgLikeStoredTable3;
                    boolean bl5 = false;
                    basicIdReference = BasicIdReference.create(it2);
                    pgLikeStoredTable3 = pgLikeStoredTable;
                } else {
                    basicIdReference = null;
                }
                pgLikeStoredTable3.setAccessMethodRef(basicIdReference);
            }
        }

        @Override
        protected void processModTable(@NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super.processModTable(table, t);
            if (table instanceof PgTable) {
                ((PgTable)table).setPartitionExpression(t.partition_expression);
                if (table instanceof PgLocalTable) {
                    ((PgLocalTable)table).setPartitionKey(t.partition_key);
                }
            }
        }

        @Override
        protected void processModView(@NotNull PgBaseLikeStoredTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (!(table instanceof PgView)) {
                return;
            }
            ((PgView)table).setCheckOption(ArraysKt.contains((Object[])t.options, (Object)"check_option=local") ? PgCheckOption.LOCAL : (ArraysKt.contains((Object[])t.options, (Object)"check_option=cascaded") ? PgCheckOption.CASCADED : PgCheckOption.NONE));
        }

        @Override
        protected void processColumn(@NotNull PgBaseIntroQueries.OneColumn col, @NotNull PgBaseLikeColumn column2, @NotNull ModPositioningNamingFamily<? extends PgBaseLikeColumn> columns2, @NotNull PgBaseLikeStoredTable table) {
            Object object;
            block5: {
                PgIdentityKind pgIdentityKind;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)col, (String)"col");
                    Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
                    Intrinsics.checkNotNullParameter(columns2, (String)"columns");
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    super.processColumn(col, column2, columns2, table);
                    if (!(column2 instanceof PgLocalTableColumn)) {
                        return;
                    }
                    object = col.identity_kind;
                    if (object == null) break block4;
                    char it2 = object.charValue();
                    boolean bl = false;
                    PgIdentityKind pgIdentityKind2 = PgIdentityKind.Companion.valueFor(it2);
                    object = pgIdentityKind2;
                    if (pgIdentityKind2 != null) break block5;
                }
                PgIdentityKind it3 = pgIdentityKind = PgIdentityKind.ALWAYS;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)col.generated, (Object)"s") ? pgIdentityKind : null;
            }
            Object kind = object;
            ((PgLocalTableColumn)column2).setIdentityKind((PgIdentityKind)((Object)kind));
        }

        @Override
        protected boolean hasReference(@NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            return con.ref_table_id > 0L && con.index_id > 0L;
        }

        @Override
        @NotNull
        protected PgGPlumBaseRoutine createRoutine(@NotNull PgSchema schema2, @NotNull PgBaseIntroQueries.OneRoutine r) {
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            PgGPlumBaseRoutine pgGPlumBaseRoutine = super.createRoutine((PgGPlumBaseSchema)schema2, r);
            Intrinsics.checkNotNull((Object)pgGPlumBaseRoutine, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgres.model.PgRoutine");
            PgRoutine routine2 = (PgRoutine)pgGPlumBaseRoutine;
            routine2.setConcurrencyKind(PgRoutineConcurrencyKind.of(r.concurrency_kind));
            routine2.setWindow(r.kind == 'w');
            routine2.setRows(r.rows);
            return routine2;
        }

        @Override
        protected void processTrigger(@NotNull PgGPlumBaseTrigger trigger2, @NotNull PgGPlumBaseIntroQueries.OneTrigger t) {
            SqlCreateStatement createTrigger;
            Intrinsics.checkNotNullParameter((Object)trigger2, (String)"trigger");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super.processTrigger(trigger2, t);
            if (!(trigger2 instanceof PgTrigger)) {
                return;
            }
            ((PgTrigger)trigger2).setDeferrable(t.is_deferrable);
            ((PgTrigger)trigger2).setInitiallyDeferred(t.is_init_deferred);
            ((PgTrigger)trigger2).setColumnIndices(PgIntrospector.this.parseListOfLongs(t.columns));
            ((PgTrigger)trigger2).setConstraint(t.is_constraint);
            ((PgTrigger)trigger2).setOldTableName(t.old_table_name);
            ((PgTrigger)trigger2).setNewTableName(t.new_table_name);
            String string = t.source_code;
            if (string != null) {
                Object object;
                String string2 = string;
                PgIntrospector pgIntrospector = PgIntrospector.this;
                String it2 = string2;
                boolean bl = false;
                BaseNativeIntrospector this_$iv = pgIntrospector;
                boolean $i$f$parseStatement = false;
                try {
                    IntrospectorSqlHelper this_$iv$iv = BaseNativeIntrospector.access$getSqlHelper(this_$iv);
                    boolean $i$f$statements = false;
                    object = this_$iv$iv.statements(it2, SqlCreateStatement.class).first();
                }
                catch (ProcessCanceledException pce$iv) {
                    throw pce$iv;
                }
                catch (Exception e$iv) {
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        this_$iv.log.error((Throwable)e$iv);
                    }
                    this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                    object = null;
                }
                v1 = (SqlCreateStatement)object;
            } else {
                v1 = createTrigger = null;
            }
            if (createTrigger != null) {
                PgIntrospector.this.getSqlHelper().getBuilder().build(trigger2, (DasObject)createTrigger, PgIntrospector.this.getSqlHelper().getBuilderContext());
            }
        }

        @Override
        protected void processAggregate(@NotNull PgBaseIntroQueries.OneAggregate agg, @NotNull PgBaseAggregate aggregate) {
            Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
            Intrinsics.checkNotNullParameter((Object)aggregate, (String)"aggregate");
            super.processAggregate(agg, aggregate);
            PgAggregate cfr_ignored_0 = (PgAggregate)aggregate;
            ((PgAggregate)aggregate).setStateSize(agg.state_size);
            ((PgAggregate)aggregate).setFinalExtra(agg.final_extra);
            ((PgAggregate)aggregate).setMovingTransitionRef(PgIntrospector.this.createIdOrQNameRef(agg.moving_transition_id, agg.moving_transition_name, ((PgIntrospector)PgIntrospector.this).getDbConnectionInfo().schemaName));
            ((PgAggregate)aggregate).setInverseTransitionRef(PgIntrospector.this.createIdOrQNameRef(agg.inverse_transition_id, agg.inverse_transition_name, ((PgIntrospector)PgIntrospector.this).getDbConnectionInfo().schemaName));
            PgAggregate pgAggregate = (PgAggregate)aggregate;
            DasType dasType = this.getMyTypes().get(agg.moving_state_type);
            if (dasType == null) {
                dasType = DasTypeSystemBase.UNKNOWN;
            }
            pgAggregate.setMovingStateStoredType(dasType);
            ((PgAggregate)aggregate).setMovingStateSize(agg.moving_state_size);
            ((PgAggregate)aggregate).setMovingFinalRef(PgIntrospector.this.createIdOrQNameRef(agg.moving_final_id, agg.moving_final_name, ((PgIntrospector)PgIntrospector.this).getDbConnectionInfo().schemaName));
            ((PgAggregate)aggregate).setMovingFinalExtra(agg.moving_final_extra);
            ((PgAggregate)aggregate).setMovingInitialValue(agg.moving_initial_value);
            ((PgAggregate)aggregate).setCombineRef(PgIntrospector.this.createIdOrQNameRef(agg.combine_function_id, agg.combine_function_name, ((PgIntrospector)PgIntrospector.this).getDbConnectionInfo().schemaName));
            ((PgAggregate)aggregate).setSerializationRef(PgIntrospector.this.createIdOrQNameRef(agg.serialization_function_id, agg.serialization_function_name, ((PgIntrospector)PgIntrospector.this).getDbConnectionInfo().schemaName));
            ((PgAggregate)aggregate).setDeserializationRef(PgIntrospector.this.createIdOrQNameRef(agg.deserialization_function_id, agg.deserialization_function_name, ((PgIntrospector)PgIntrospector.this).getDbConnectionInfo().schemaName));
            ((PgAggregate)aggregate).setConcurrencyKind(PgRoutineConcurrencyKind.of(agg.concurrency_kind));
            ((PgAggregate)aggregate).setOwnerRef(BasicNameReference.create(agg.getOwnerName()));
        }

        @Override
        protected void processFunSourceAttributes(@NotNull PgBaseRoutine function2, @NotNull PgBaseIntroQueries.OneFunctionSource fs) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            super.processFunSourceAttributes(function2, fs);
            PgRoutine cfr_ignored_0 = (PgRoutine)function2;
            ((PgRoutine)function2).setWithSqlBody(fs.sqlbody_def != null);
        }

        @Override
        @Nullable
        protected CompositeText getFunSourceText(@NotNull PgBaseIntroQueries.OneFunctionSource fs) {
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            Object object = fs.sqlbody_def;
            return object != null && (object = BaseIntrospectionFunctions.toCompositeText((String)object, CompositeText.Kind.DECOMPILED_TEXT)) != null ? (CompositeText)object : super.getFunSourceText(fs);
        }

        @Override
        protected void removeComments(@NotNull Long2ObjectMap<Short[]> existentComments, @NotNull BasicModIdentifiedElement e2) {
            Intrinsics.checkNotNullParameter(existentComments, (String)"existentComments");
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            super.removeComments(existentComments, e2);
            if (e2 instanceof PgLocalTable) {
                ModNamingIdentifyingFamily<? extends PgSecurityPolicy> modNamingIdentifyingFamily = ((PgLocalTable)e2).getSecurityPolicies();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getSecurityPolicies(...)");
                Iterable $this$forEach$iv = modNamingIdentifyingFamily;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PgSecurityPolicy it2 = (PgSecurityPolicy)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it2);
                    this.removeComments(existentComments, it2);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void processIndex(@NotNull PgGPlumBaseIndex index2, @NotNull PgGPlumBaseIntroQueries.OneIndex ind) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            Intrinsics.checkNotNullParameter((Object)ind, (String)"ind");
            super.processIndex(index2, ind);
            PgIndex cfr_ignored_0 = (PgIndex)index2;
            Iterable iterable = PgIntrospector.this.parseListOfLongs(ind.ancestors);
            PgIndex pgIndex = (PgIndex)index2;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(BasicIdReference.create((long)it2));
            }
            pgIndex.setAncestorRefs((List)destination$iv$iv);
        }

        @Override
        protected boolean incrementalViewSources() {
            int[] nArray = new int[]{9, 2};
            return PgIntrospector.this.getServerVersion().isOrGreater(nArray);
        }

        @Override
        protected boolean isTableKind(char kind) {
            return super.isTableKind(kind) || kind == 'p';
        }

        private final void retrieveSecurityPolicies(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.SECURITY_POLICY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SECURITY_POLICY");
            PgIntrospector.this.reportRetrieving(objectKind);
            this.inSchema((Function1)new Function1<PgSchema, Unit>(PgIntrospector.this, detectDropped, this, loadNew){
                final /* synthetic */ PgIntrospector this$0;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ MySchemaRetriever this$1;
                final /* synthetic */ boolean $loadNew;
                {
                    this.this$0 = $receiver;
                    this.$detectDropped = $detectDropped;
                    this.this$1 = $receiver2;
                    this.$loadNew = $loadNew;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull PgSchema schema2) {
                    void families$iv;
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModNamingIdentifyingFamily<? extends PgLocalTable> modNamingIdentifyingFamily = schema2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
                    ModNamingIdentifyingFamily<? extends PgLocalTable> tables2 = modNamingIdentifyingFamily;
                    Iterable $this$map$iv = tables2;
                    boolean $i$f$map = false;
                    Object object = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        PgLocalTable pgLocalTable = (PgLocalTable)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(it2.getSecurityPolicies());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    object = this.this$0;
                    boolean bl = this.$detectDropped;
                    MySchemaRetriever mySchemaRetriever = this.this$1;
                    boolean bl2 = this.$loadNew;
                    boolean inc$iv = true;
                    boolean $i$f$modifyFamiliesAndCleanup = false;
                    void $this$toTypedArray$iv$iv = families$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                    ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingIdentifyingFamily[0]);
                    ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
                    boolean $i$f$modifyFamiliesAndCleanup2 = false;
                    for (ModFamily f$iv$iv : families$iv$iv) {
                        f$iv$iv.markChildrenAsSyncPending();
                    }
                    boolean bl3 = false;
                    BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
                    boolean $i$f$continueOnDbError = false;
                    try {
                        boolean bl4 = false;
                        if (bl) {
                            LongOpenHashSet ids = new LongOpenHashSet((long[])MySchemaRetriever.access$performQuery(mySchemaRetriever, ((PgIntrospector)object).getQueries().getRetrieveExistentSecurityPolices()));
                            Iterable $this$forEach$iv = tables2;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                PgLocalTable t = (PgLocalTable)element$iv;
                                boolean bl5 = false;
                                ModNamingIdentifyingFamily<? extends PgSecurityPolicy> modNamingIdentifyingFamily2 = t.getSecurityPolicies();
                                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getSecurityPolicies(...)");
                                Iterable $this$forEach$iv2 = modNamingIdentifyingFamily2;
                                boolean $i$f$forEach2 = false;
                                for (T element$iv2 : $this$forEach$iv2) {
                                    PgSecurityPolicy sp = (PgSecurityPolicy)element$iv2;
                                    boolean bl6 = false;
                                    if (!ids.contains(sp.getObjectId())) continue;
                                    sp.resetSyncPending();
                                }
                            }
                        }
                        if (bl2) {
                            IdCache<PgLocalTable> tableCache2 = new IdCache<PgLocalTable>();
                            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(mySchemaRetriever, ((PgIntrospector)object).getQueries().getRetrieveSecurityPolices(), 0, (Function1)new Function1<PgIntroQueries.OneSecurityPolicy, Unit>(tableCache2, tables2){
                                final /* synthetic */ IdCache<PgLocalTable> $tableCache;
                                final /* synthetic */ ModNamingIdentifyingFamily<? extends PgLocalTable> $tables;
                                {
                                    this.$tableCache = $tableCache;
                                    this.$tables = $tables;
                                    super(1);
                                }

                                /*
                                 * Unable to fully structure code
                                 * Could not resolve type clashes
                                 */
                                public final void invoke(@NotNull PgIntroQueries.OneSecurityPolicy p) {
                                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                                    var4_2 = this.$tableCache;
                                    var5_3 = p.table_id;
                                    var7_5 = this.$tables;
                                    $i$f$get = false;
                                    this_$iv$iv = this_$iv;
                                    $i$f$getOrCache = false;
                                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                                    v0 = this_$iv$iv.getV();
                                    Intrinsics.checkNotNull(v0);
                                    if (v0.getObjectId() == id$iv) {
                                        v1 = this_$iv$iv.getV();
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        var11_12 = id$iv;
                                        var13_14 = this_$iv$iv;
                                        var14_16 = this_$iv$iv;
                                        $i$a$-getOrCache-IdCache$get$1$iv = false;
                                        var16_20 = (Function1)new Function1<ModIdentifyingFamily<? extends T>, T>((long)id$iv){
                                            final /* synthetic */ long $id;
                                            {
                                                this.$id = $id;
                                                super(1);
                                            }

                                            @Nullable
                                            public final T invoke(@NotNull ModIdentifyingFamily<? extends T> $this$invoke) {
                                                Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                                return (T)((BasicModIdentifiedElement)$this$invoke.getByObjectId(this.$id));
                                            }
                                        };
                                        $this$invoke_u24lambda_u240 = $this$get_u24lambda_u240$iv;
                                        $i$a$-get-PgIntrospector$MySchemaRetriever$retrieveSecurityPolicies$1$2$1$2$table$1 = false;
                                        var14_16.setV((BasicModIdentifiedElement)((PgLocalTable)it.invoke(var7_5)));
                                        v1 = this_$iv$iv.getV();
                                    }
                                    v2 = (PgLocalTable)v1;
                                    if (v2 == null) {
                                        return;
                                    }
                                    table = v2;
                                    $this$invoke_u24lambda_u243 = var3_26 = table.getSecurityPolicies().renew(p.id, p.policyname);
                                    $i$a$-apply-PgIntrospector$MySchemaRetriever$retrieveSecurityPolicies$1$2$1$2$1 = false;
                                    $this$invoke_u24lambda_u243.setStateNumber(p.state_number);
                                    $this$invoke_u24lambda_u243.setPermissive(p.permissive);
                                    v3 = $this$invoke_u24lambda_u243;
                                    v4 /* !! */  = p.roles;
                                    if (p.roles == null) ** GOTO lbl-1000
                                    var7_5 = var6_27 = v4 /* !! */ ;
                                    var8_7 = v3;
                                    $i$a$-takeIf-PgIntrospector$MySchemaRetriever$retrieveSecurityPolicies$1$2$1$2$1$1 = false;
                                    v3 = var8_7;
                                    v4 /* !! */  = Boolean.valueOf(it.length != 1 || it[0].longValue() != 0L) != false ? var6_27 : null;
                                    if (v4 /* !! */  != null) {
                                        it = v4 /* !! */ ;
                                        var8_7 = v3;
                                        $i$f$map = false;
                                        $i$f$getOrCache = $this$map$iv;
                                        destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                                        $i$f$mapTo = false;
                                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                                            it = ((Number)item$iv$iv).longValue();
                                            var18_24 = destination$iv$iv;
                                            $i$a$-map-PgIntrospector$MySchemaRetriever$retrieveSecurityPolicies$1$2$1$2$1$2 = false;
                                            var18_24.add(BasicIdReference.create(it));
                                        }
                                        v5 = (List)destination$iv$iv;
                                        v3 = var8_7;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v5 = CollectionsKt.emptyList();
                                    }
                                    v3.setRoleRefs(v5);
                                    var20_30 = p.cmd;
                                    if (var20_30 == null) ** GOTO lbl-1000
                                    tmp = -1;
                                    switch (var20_30.hashCode()) {
                                        case 97: {
                                            if (var20_30.equals("a")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 114: {
                                            if (var20_30.equals("r")) {
                                                tmp = 2;
                                            }
                                            break;
                                        }
                                        case 100: {
                                            if (var20_30.equals("d")) {
                                                tmp = 3;
                                            }
                                            break;
                                        }
                                        case 119: {
                                            if (var20_30.equals("w")) {
                                                tmp = 4;
                                            }
                                            break;
                                        }
                                    }
                                    switch (tmp) {
                                        case 2: {
                                            v6 = PgSecurityPolicyOperationType.SELECT;
                                            break;
                                        }
                                        case 1: {
                                            v6 = PgSecurityPolicyOperationType.INSERT;
                                            break;
                                        }
                                        case 4: {
                                            v6 = PgSecurityPolicyOperationType.UPDATE;
                                            break;
                                        }
                                        case 3: {
                                            v6 = PgSecurityPolicyOperationType.DELETE;
                                            break;
                                        }
                                        default: lbl-1000:
                                        // 2 sources

                                        {
                                            v6 = PgSecurityPolicyOperationType.ALL;
                                        }
                                    }
                                    $this$invoke_u24lambda_u243.setOperationType(v6);
                                    $this$invoke_u24lambda_u243.setUsingExpression(p.qual);
                                    $this$invoke_u24lambda_u243.setCheckExpression(p.with_check);
                                }
                            }, 2, null);
                        }
                    }
                    catch (DBException e$iv) {
                        this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                    }
                    for (ModFamily f$iv$iv : families$iv$iv) {
                        f$iv$iv.removeSyncPendingChildren();
                        f$iv$iv.sort();
                    }
                }
            });
        }

        public static final /* synthetic */ void access$retrieveSecurityPolicies(MySchemaRetriever $this, boolean detectDropped, boolean loadNew) {
            $this.retrieveSecurityPolicies(detectDropped, loadNew);
        }

        public static final /* synthetic */ Object access$performQuery(MySchemaRetriever $this, SqlQuery query) {
            return $this.performQuery(query);
        }
    }
}

