/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.base.plan.AbstractExplainPlanProvider;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.oracle.plan.OraPlanModelBuilder;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OraExplainPlanProvider
extends AbstractExplainPlanProvider {
    public OraExplainPlanProvider() {
        super(Dbms.ORACLE);
    }

    @Override
    @NotNull
    public <V> ScriptModel<V> adjustModel(@NotNull ScriptModel<V> model2) {
        if (model2 == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(0);
        }
        ScriptModel scriptModel = model2.rawTransform(st -> {
            SyntaxTraverser.Api api = st.api;
            return (SyntaxTraverser)st.forceIgnore(v2 -> {
                if (api.typeOf(v2) != SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE) {
                    return false;
                }
                CharSequence text2 = api.textOf(v2);
                return text2.equals("?") || StringUtil.startsWith((CharSequence)text2, (CharSequence)":");
            });
        });
        if (scriptModel == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(1);
        }
        return scriptModel;
    }

    @Override
    public AbstractPlanModelBuilder<?, ?> createBuilder(@NotNull Version version, boolean run2) {
        if (version == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(2);
        }
        return new OraPlanModelBuilder();
    }

    @Override
    @Nullable
    public ExplainPlanProvider.RawExplainTask createRawExplainTask(@NotNull LocalDataSource dataSource2, boolean analyze) {
        if (dataSource2 == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(3);
        }
        if (analyze) {
            throw new UnsupportedOperationException("Oracle does not support EXPLAIN ANALYZE");
        }
        return new ExplainPlanProvider.RawExplainTask(){

            @Override
            public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement2) throws UnsupportedOperationException, IllegalArgumentException {
                if (builder == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (statement2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                String uid = AbstractPlanModelBuilder.randomShorterUUID();
                builder.keywords("explain", "plan").space().keyword("set").space().plain("statement_id").symbol("=").symbol("'").plain(uid).symbol("'").space().keyword("for").space().plain(statement2).newStatement();
                builder.keyword("select").space().symbol("*").space().keyword("from").space().keyword("table").symbol("(").plain("DBMS_XPLAN.DISPLAY").symbol("(").symbol("'").plain("PLAN_TABLE").symbol("'").symbol(",").symbol("'").plain(uid).symbol("'").symbol(")").symbol(")");
                return builder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "builder";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "statement";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dialects/oracle/plan/OraExplainPlanProvider$1";
                objectArray[2] = "sqlExplainPlan";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/plan/OraExplainPlanProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/plan/OraExplainPlanProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustModel";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRawExplainTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

