/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.oracle.generator.producers.OraMatViewProducersKt;
import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraClusterIndex;
import com.intellij.database.dialects.oracle.model.OraDataFile;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.dialects.oracle.model.OraDescriptionService;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraInnerRoutine;
import com.intellij.database.dialects.oracle.model.OraMatLog;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraSynonym;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.dialects.oracle.model.OraTablespace;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.OraUser;
import com.intellij.database.dialects.oracle.model.properties.OraDataFileAvailabilityStatus;
import com.intellij.database.dialects.oracle.model.properties.OraDataFileOnlineStatus;
import com.intellij.database.dialects.oracle.model.properties.OraTableType;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceContentCategory;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceLogging;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceStatus;
import com.intellij.database.dialects.oracle.model.properties.OraTenantCategory;
import com.intellij.database.dialects.oracle.model.properties.TableOrganization;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionOptions;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.DvTreeNodeDecoration;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicMixinTypedElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.Level;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbSynonym;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.common.StringFun;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import icons.DatabaseIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 g2\u00020\u0001:\u0001gB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0003J\u0018\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010 \u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020!2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010%\u001a\u00020\t2\u0006\u0010#\u001a\u00020&2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)2\u0006\u0010\f\u001a\u00020\rH\u0003J\u0018\u0010'\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010*\u001a\u00020)H\u0002J\u0018\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020-2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u00101\u001a\u00020\t2\u0006\u00102\u001a\u0002032\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u00104\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010*\u001a\u000205H\u0002J\u0018\u00106\u001a\u00020\t2\u0006\u00107\u001a\u0002082\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u00106\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00107\u001a\u000208H\u0002J\u0018\u00109\u001a\u00020\t2\u0006\u0010(\u001a\u00020:2\u0006\u0010\f\u001a\u00020\rH\u0003J\u0018\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020=2\u0006\u0010\f\u001a\u00020\rH\u0003J \u0010;\u001a\u00020\u00112\u0006\u0010>\u001a\u00020?2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010@\u001a\u00020\t2\u0006\u0010A\u001a\u00020B2\u0006\u0010\f\u001a\u00020\rH\u0003J\u0018\u0010@\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010C\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020D2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010E\u001a\u00020\t2\u0006\u0010F\u001a\u00020G2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010E\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020\t2\u0006\u0010F\u001a\u00020GH\u0003J.\u0010I\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010J\u001a\u0006\u0012\u0002\b\u00030K2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010N\u001a\u00020OH\u0016J\u001e\u0010P\u001a\b\u0012\u0004\u0012\u00020\t0Q2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0010\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u000bH\u0016J\u0012\u0010U\u001a\u0004\u0018\u00010\t2\u0006\u0010V\u001a\u00020WH\u0016J\u0018\u0010N\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010X\u001a\u00020\u00042\n\u0010J\u001a\u0006\u0012\u0002\b\u00030YH\u0014J(\u0010Z\u001a\u00020\u00112\u0006\u0010>\u001a\u00020?2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010_\u001a\u00020\u0004*\u00020\u00052\u0006\u0010`\u001a\u00020\u0005H\u0082\u0004J\u000e\u0010a\u001a\u0004\u0018\u00010\t*\u000208H\u0003J\f\u0010b\u001a\u00020\t*\u00020\u0019H\u0003J\u000e\u0010c\u001a\u0004\u0018\u00010\t*\u00020\u0019H\u0003J\u001e\u0010d\u001a\u00020\t*\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010e\u001a\u00020\u0004H\u0003J\u0018\u0010f\u001a\u0004\u0018\u00010\\*\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006h"}, d2={"Lcom/intellij/database/dialects/oracle/model/OraDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "exists", "", "Ljava/util/Date;", "getExists", "(Ljava/util/Date;)Z", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeDataFile", "dataFile", "Lcom/intellij/database/dialects/oracle/model/OraDataFile;", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "describeDataFileDetails", "df", "withSurrogates", "describeDbLink", "dbLink", "Lcom/intellij/database/dialects/oracle/model/OraDbLink;", "describeIdentity", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "describeOraCluster", "cluster", "Lcom/intellij/database/dialects/oracle/model/OraCluster;", "describeOraClusterColumn", "Lcom/intellij/database/dialects/oracle/model/OraClusterColumn;", "describeOraClusterIndex", "index", "Lcom/intellij/database/dialects/oracle/model/OraClusterIndex;", "describeOraIndex", "Lcom/intellij/database/dialects/oracle/model/OraIndex;", "describeOraInnerRoutine", "routine", "Lcom/intellij/database/dialects/oracle/model/OraInnerRoutine;", "r", "describeOraMatLog", "ml", "Lcom/intellij/database/dialects/oracle/model/OraMatLog;", "describeOraMatView", "view", "Lcom/intellij/database/dialects/oracle/model/OraMatView;", "describeOraRoot", "root", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "describeOraRoutine", "Lcom/intellij/database/dialects/oracle/model/OraRoutine;", "describeOraSequence", "sequence", "Lcom/intellij/database/dialects/oracle/model/OraSequence;", "describeOraSingleRoutine", "Lcom/intellij/database/dialects/oracle/model/OraSingleRoutine;", "describeOraSynonym", "synonym", "Lcom/intellij/database/dialects/oracle/model/OraSynonym;", "project", "Lcom/intellij/openapi/project/Project;", "describeOraTable", "table", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "describeOraTableColumn", "Lcom/intellij/database/dialects/oracle/model/OraTableColumn;", "describeTablespace", "tablespace", "Lcom/intellij/database/dialects/oracle/model/OraTablespace;", "describeTablespaceDetails", "formatAdditionalPropertyValue", "property", "Lcom/intellij/database/model/meta/BasicMetaPropertyId;", "value", "", "options", "Lcom/intellij/database/model/DescriptionOptions;", "getDependsOnNames", "", "getElementDecoration", "Lcom/intellij/database/model/DvTreeNodeDecoration;", "element", "getMinorObjectSchemaName", "obj", "Lcom/intellij/database/model/basic/BasicMinorObject;", "shouldAutoDescribe", "Lcom/intellij/database/model/meta/BasicMetaField;", "updatePresentation", "o", "Lcom/intellij/database/model/DasObject;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "ge", "that", "presentInfo", "presentRemote", "presentRemoteDB", "presentTarget", "forceKind", "resolveWithCache", "Companion", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraDescriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraDescriptionService.kt\ncom/intellij/database/dialects/oracle/model/OraDescriptionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 6 DescriptionService.kt\ncom/intellij/database/model/DescriptionService$Context\n*L\n1#1,567:1\n1611#2:568\n1855#2:569\n1856#2:571\n1612#2:572\n1#3:570\n1#3:574\n14#4:573\n14#5:575\n73#6:576\n*S KotlinDebug\n*F\n+ 1 OraDescriptionService.kt\ncom/intellij/database/dialects/oracle/model/OraDescriptionService\n*L\n155#1:568\n155#1:569\n155#1:571\n155#1:572\n155#1:570\n260#1:573\n409#1:575\n526#1:576\n*E\n"})
public final class OraDescriptionService
extends DescriptionService {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<RegexOption> REGEX_OPTIONS;
    @NotNull
    private static final Regex REMOTE_DESC_HOST_PATTERN;
    @NotNull
    private static final Regex REMOTE_DESC_PORT_PATTERN;
    @NotNull
    private static final Regex REMOTE_DESC_SERV_PATTERN;
    @NotNull
    private static final Regex SPACES_PATTERN;
    @NotNull
    private static final Regex HEX_PATTERN;

    @Override
    @NotNull
    public String options(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ((Collection)context.getDescribed()).add(OraSourceAware.OBFUSCATED);
        ((Collection)context.getDescribed()).add(OraMatView.PREBUILT);
        ((Collection)context.getDescribed()).add(OraSynonym.INVALID);
        ((Collection)context.getDescribed()).add(OraTableColumn.HIDDEN);
        return super.options(e2, context) + (e2 instanceof OraSourceAware && ((OraSourceAware)e2).isObfuscated() ? " [obfuscated]" : "") + (e2 instanceof OraMatView && ((OraMatView)e2).isPrebuilt() ? " [prebuilt]" : "") + (e2 instanceof OraSynonym && ((OraSynonym)e2).isInvalid() ? " [invalid]" : "") + (e2 instanceof OraTableColumn && ((OraTableColumn)e2).isHidden() ? " [hidden]" : "");
    }

    @Override
    @Nullable
    protected String describeIdentity(@NotNull BasicLikeColumn column2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ((Collection)context.getDescribed()).add(OraTableColumn.SEQUENCE_REF);
        return super.describeIdentity(column2, context);
    }

    @Override
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof OraCluster ? this.describeOraCluster((OraCluster)e2, context) : (basicElement instanceof OraClusterColumn ? this.describeOraClusterColumn((OraClusterColumn)e2, context) : (basicElement instanceof OraTable ? this.describeOraTable((OraTable)e2, context) : (basicElement instanceof OraTableColumn ? this.describeOraTableColumn((OraTableColumn)e2, context) : (basicElement instanceof OraMatLog ? this.describeOraMatLog((OraMatLog)e2, context) : (basicElement instanceof OraMatView ? this.describeOraMatView((OraMatView)e2, context) : (basicElement instanceof OraIndex ? this.describeOraIndex((OraIndex)e2, context) : (basicElement instanceof OraClusterIndex ? this.describeOraClusterIndex((OraClusterIndex)e2, context) : (basicElement instanceof OraSequence ? this.describeOraSequence((OraSequence)e2, context) : (basicElement instanceof OraSingleRoutine ? this.describeOraSingleRoutine((OraSingleRoutine)e2, context) : (basicElement instanceof OraInnerRoutine ? this.describeOraInnerRoutine((OraInnerRoutine)e2, context) : (basicElement instanceof OraSynonym ? this.describeOraSynonym((OraSynonym)e2, context) : (basicElement instanceof OraDbLink ? this.describeDbLink((OraDbLink)e2, context) : (basicElement instanceof OraTablespace ? this.describeTablespace((OraTablespace)e2, context) : (basicElement instanceof OraDataFile ? this.describeDataFile((OraDataFile)e2, context) : (basicElement instanceof OraRoot ? this.describeOraRoot((OraRoot)e2, context) : super.content(e2, context))))))))))))))));
    }

    @Override
    @NotNull
    public DvTreeNodeDecoration getElementDecoration(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        DvTreeNodeDecoration d2 = super.getElementDecoration(element2);
        if (element2 instanceof OraUser && (((OraUser)element2).isExpired() || ((OraUser)element2).isLocked())) {
            d2 = DvTreeNodeDecoration.copy$default(d2, true, null, 2, null);
        }
        return d2;
    }

    @Override
    public void updatePresentation(@NotNull Project project, @NotNull DasObject o2, @NotNull DvViewOptions viewOptions, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        DasObject dasObject = o2;
        if (dasObject instanceof OraTable) {
            this.describeOraTable(presentation, (OraTable)o2);
        } else if (dasObject instanceof OraSequence) {
            this.describeOraSequence(presentation, (OraSequence)o2);
        } else if (dasObject instanceof OraInnerRoutine) {
            this.describeOraInnerRoutine(presentation, (OraInnerRoutine)o2);
        } else if (dasObject instanceof OraRoutine) {
            this.describeOraRoutine(presentation, (OraRoutine)o2);
        } else if (dasObject instanceof OraSynonym) {
            this.describeOraSynonym(project, presentation, (OraSynonym)o2);
        } else if (dasObject instanceof OraDbLink) {
            this.describeDbLink(presentation, (OraDbLink)o2);
        } else if (dasObject instanceof OraTablespace) {
            this.describeTablespace(presentation, (OraTablespace)o2);
        } else if (dasObject instanceof OraDataFile) {
            this.describeDataFile(presentation, (OraDataFile)o2);
        } else {
            super.updatePresentation(project, o2, viewOptions, presentation);
        }
    }

    private final boolean ge(Date $this$ge, Date that) {
        return this.getExists($this$ge) && $this$ge.getTime() >= that.getTime();
    }

    private final boolean getExists(Date $this$exists) {
        return $this$exists.getTime() > BaseIntrospectionFunctions.AGES_AGO.getTime();
    }

    @Override
    @NotNull
    public String formatAdditionalPropertyValue(@NotNull BasicElement e2, @NotNull BasicMetaPropertyId<?> property, @Nullable Object value2, @NotNull DescriptionOptions options2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        BasicMetaPropertyId<?> basicMetaPropertyId = property;
        if (Intrinsics.areEqual(basicMetaPropertyId, OraDbLink.CONNECT_USER_PASSWORD) ? true : Intrinsics.areEqual(basicMetaPropertyId, OraDbLink.AUTH_USER_PASSWORD)) {
            CharSequence charSequence;
            String s2 = String.valueOf(value2);
            string = !options2.getWithSurrogates() && HEX_PATTERN.matches(charSequence = (CharSequence)s2) ? "hashed password" : s2;
        } else {
            string = super.formatAdditionalPropertyValue(e2, property, value2, options2);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getDependsOnNames(@NotNull BasicElement e2, boolean withSurrogates) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        OraSourceAware oraSourceAware = e2 instanceof OraSourceAware ? (OraSourceAware)e2 : null;
        if (oraSourceAware == null) {
            return SetsKt.emptySet();
        }
        OraSourceAware oraSourceAware2 = oraSourceAware;
        Set<Long> set = oraSourceAware2.getDependsOnIds();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getDependsOnIds(...)");
        Set<Long> ids = set;
        if (ids.isEmpty()) {
            return SetsKt.emptySet();
        }
        BasicDatabase basicDatabase = oraSourceAware2.getDatabase();
        Intrinsics.checkNotNull((Object)basicDatabase);
        BasicDatabase database = basicDatabase;
        BasicSchema basicSchema = oraSourceAware2.getSchema();
        Intrinsics.checkNotNull((Object)basicSchema);
        BasicSchema schema2 = basicSchema;
        Iterable iterable = ids;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Long it2 = (Long)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2);
            BasicIdentifiedElement o2 = database.findIdentifiedElement(it2);
            if (o2 == null) {
                object = withSurrogates ? String.valueOf(it2) : null;
            } else if (o2.getSchema() == schema2) {
                object = o2.getName();
            } else {
                Object object2 = o2.getSchema();
                if (object2 == null || (object2 = object2.getName()) == null) {
                    object2 = "<unknown-schema>";
                }
                object = (String)object2 + "." + o2.getName();
            }
            if (object == null) continue;
            String it$iv = object;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        ArrayList items2 = (ArrayList)destination$iv;
        CollectionsKt.sort((List)items2);
        return items2;
    }

    private final String describeOraCluster(OraCluster cluster, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraCluster.CLUSTER_TYPE);
        ((Collection)context.getDescribed()).add(OraCluster.HASH_CARDINALITY);
        ((Collection)context.getDescribed()).add(OraCluster.HASH_EXPRESSION);
        ((Collection)context.getDescribed()).add(OraCluster.SINGLE_TABLE);
        ((Collection)context.getDescribed()).add(OraCluster.BLOCK_SIZE);
        ((Collection)context.getDescribed()).add(OraCluster.TABLESPACE_REF);
        ModPositioningNamingFamily<? extends OraClusterColumn> modPositioningNamingFamily = cluster.getColumns();
        Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
        String columns2 = CollectionsKt.joinToString$default((Iterable)modPositioningNamingFamily, null, null, null, (int)0, null, (Function1)describeOraCluster.columns.1.INSTANCE, (int)31, null);
        String s2 = null;
        switch (WhenMappings.$EnumSwitchMapping$0[cluster.getClusterType().ordinal()]) {
            case 1: {
                s2 = "index cluster (" + columns2 + ") block size " + cluster.getBlockSize();
                break;
            }
            case 2: {
                String exp = cluster.getHashExpression();
                String string = s2 = exp == null ? "hash cluster (" + columns2 + ") hash by column cardinality " + cluster.getHashCardinality() : "hash cluster (" + columns2 + ") hash by (" + exp + ") cardinality " + cluster.getHashCardinality();
                if (!cluster.isSingleTable()) break;
                s2 = (String)s2 + " (single table)";
                break;
            }
            default: {
                s2 = "cluster (" + columns2 + ")";
            }
        }
        return s2;
    }

    private final String describeOraClusterColumn(OraClusterColumn column2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraClusterColumn.STORED_TYPE);
        ((Collection)context.getDescribed()).add(OraClusterColumn.SORTED);
        Object s2 = this.typeSpec(column2, context);
        if (column2.isSorted()) {
            s2 = (String)s2 + " sort";
        }
        return s2;
    }

    @NonNls
    private final String describeOraTable(OraTable table, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraTable.ORGANIZATION);
        ((Collection)context.getDescribed()).add(OraTable.TEMPORARY);
        ((Collection)context.getDescribed()).add(OraTable.TEMPORARY_PRESERVE);
        ((Collection)context.getDescribed()).add(OraTable.TABLE_TYPE);
        ((Collection)context.getDescribed()).add(OraTable.SECONDARY);
        ((Collection)context.getDescribed()).add(OraTable.TABLESPACE_REF);
        Object d2 = table.getOrganization() == TableOrganization.ORA_CLUSTERED_BY_INDEX ? "cluster table" : (table.getOrganization() == TableOrganization.ORA_CLUSTERED_BY_HASH ? "cluster table" : (table.isTemporary() && table.isTemporaryPreserve() ? "temporary table (preserve rows)" : (table.isTemporary() && !table.isTemporaryPreserve() ? "temporary table" : this.describeTable(table, context))));
        switch (WhenMappings.$EnumSwitchMapping$1[table.getTableType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                d2 = (String)d2 + " (mat.log)";
                break;
            }
            case 3: {
                d2 = (String)d2 + " (mat.log.temp)";
                break;
            }
            case 4: {
                d2 = (String)d2 + " (mat.view)";
            }
        }
        if (table.isSecondary()) {
            d2 = (String)d2 + " secondary";
        }
        return d2;
    }

    @Override
    protected boolean shouldAutoDescribe(@NotNull BasicMetaField<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return Intrinsics.areEqual((Object)property.getId(), OraTable.MASTER_TABLE_REF) || Intrinsics.areEqual((Object)property.getId(), (Object)OraIndex.CLUSTERING) || super.shouldAutoDescribe(property);
    }

    private final void describeOraTable(PresentationData presentation, OraTable table) {
        switch (WhenMappings.$EnumSwitchMapping$1[table.getTableType().ordinal()]) {
            case 1: {
                break;
            }
            case 4: {
                presentation.setIcon(DatabaseIcons.MaterializedView);
                break;
            }
            case 2: {
                presentation.setIcon(DatabaseIcons.MaterializedLog);
                break;
            }
            case 3: {
                presentation.setIcon(DatabaseIcons.MaterializedLog);
            }
        }
        if (table.getTableType() == OraTableType.MAT_VIEW) {
            boolean pb;
            OraSchema schema2 = table.getSchema();
            BasicNode basicNode = schema2;
            OraMatView mv = basicNode != null && (basicNode = basicNode.getMatViews()) != null ? (OraMatView)basicNode.get(table.getName()) : null;
            boolean bl = pb = mv != null && mv.isPrebuilt();
            if (pb) {
                presentation.addText("(pre-built)", DbPresentationCore.INFO_ATTRS);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String describeOraTableColumn(OraTableColumn column2, DescriptionService.Context context) {
        void _true_$iv;
        void $this$choose$iv;
        ((Collection)context.getDescribed()).add(OraTableColumn.COMPUTED);
        ((Collection)context.getDescribed()).add(OraTableColumn.EXPLICIT_PRECISION);
        boolean computed = column2.isComputed();
        boolean bl = computed;
        String string = "computed";
        String _false_$iv = "default";
        boolean $i$f$choose = false;
        Object s2 = this.describeColumn(column2, context, (String)($this$choose$iv != false ? _true_$iv : _false_$iv));
        if (column2.isExplicitPrecision()) {
            s2 = (String)s2 + " (explicit precision)";
        }
        return s2;
    }

    private final String describeOraMatLog(OraMatLog ml, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraMatLog.WITH_NEW_VALUES);
        ((Collection)context.getDescribed()).add(OraMatLog.WITH_OBJECT_ID);
        ((Collection)context.getDescribed()).add(OraMatLog.WITH_PRIMARY_KEY);
        ((Collection)context.getDescribed()).add(OraMatLog.WITH_ROW_ID);
        ((Collection)context.getDescribed()).add(OraMatLog.WITH_SEQUENCE);
        Object s2 = ml.withOptions();
        if (ml.isWithNewValues()) {
            s2 = (String)s2 + " including new values";
        }
        String string = s2;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final String describeOraMatView(OraMatView view2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraMatView.REFRESH_METHOD);
        ((Collection)context.getDescribed()).add(OraMatView.REFRESH_MODE);
        return this.describeView(view2, context) + " " + OraMatViewProducersKt.getRefreshSpecification(view2);
    }

    private final String describeOraIndex(OraIndex index2, DescriptionService.Context context) {
        Object desc;
        block1: {
            ((Collection)context.getDescribed()).add(OraIndex.INDEXTYPE_REF);
            ((Collection)context.getDescribed()).add(OraIndex.TABLESPACE_REF);
            ((Collection)context.getDescribed()).add(OraIndex.FUNCTION_BASED);
            desc = null;
            desc = super.describeIndex(index2, context);
            BasicReference basicReference = index2.getIndextypeRef();
            if (basicReference == null) break block1;
            BasicReference it2 = basicReference;
            boolean bl = false;
            desc = desc + " indextype: ";
            if (it2.getParentName() != null) {
                desc = desc + it2.getParentName() + ".";
            }
            desc = desc + it2.getName();
        }
        return desc;
    }

    private final String describeOraClusterIndex(OraClusterIndex index2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraIndex.TABLESPACE_REF);
        return super.describeBasicElement(index2);
    }

    private final String describeOraSequence(OraSequence sequence, DescriptionService.Context context) {
        String sequenceInfo;
        ((Collection)context.getDescribed()).add(OraSequence.SEQUENCE_IDENTITY);
        String string = sequenceInfo = this.presentInfo(sequence);
        return string != null ? "sequence: " + string : "sequence";
    }

    private final void describeOraSequence(PresentationData presentation, OraSequence sequence) {
        String sequenceInfo = this.presentInfo(sequence);
        if (sequenceInfo != null) {
            presentation.addText(sequenceInfo, DbPresentationCore.INFO_ATTRS);
        }
    }

    @NlsSafe
    private final String presentInfo(OraSequence $this$presentInfo) {
        OraTableColumn hostColumn;
        Object s2;
        if ($this$presentInfo.getDetailsLevel() == Level.L1) {
            return null;
        }
        Object object = $this$presentInfo.getSequenceIdentity().getSpecification();
        if (object == null) {
            object = s2 = "???";
        }
        if ((hostColumn = $this$presentInfo.getHostTableColumn()) != null) {
            s2 = (String)s2 + " (for " + hostColumn.getTableName() + "." + hostColumn.getName() + ")";
        }
        return s2;
    }

    @NlsSafe
    private final String describeOraSingleRoutine(OraSingleRoutine routine2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraInnerRoutine.ROUTINE_NR);
        return this.describeRoutine(routine2, context);
    }

    @NlsSafe
    private final String describeOraInnerRoutine(OraInnerRoutine routine2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraInnerRoutine.ROUTINE_NR);
        ((Collection)context.getDescribed()).add(OraInnerRoutine.OVERLOAD_NR);
        return this.describeRoutine(routine2, context);
    }

    private final void describeOraInnerRoutine(PresentationData presentation, OraInnerRoutine r) {
        short ovr = r.getOverloadNr();
        if (ovr > 0) {
            presentation.addText("[" + ovr + "] ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        this.describeOraRoutine(presentation, r);
    }

    private final void describeOraRoutine(PresentationData presentation, OraRoutine r) {
        PositioningNamingFamily positioningNamingFamily = r.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
        PositioningNamingFamily arguments = positioningNamingFamily;
        StringBuilder b2 = new StringBuilder(arguments.size() * 16);
        BasicMixinTypedElement result2 = null;
        boolean was = false;
        if (arguments.isNotEmpty()) {
            b2.append('(');
            for (OraArgument a : arguments) {
                ArgumentDirection d2;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)a.getArgumentDirection()), (String)"getArgumentDirection(...)");
                if (d2 == ArgumentDirection.RESULT || d2 == ArgumentDirection.RETURN) {
                    result2 = a;
                }
                if (d2 == ArgumentDirection.RESULT || d2 == ArgumentDirection.RETURN || d2 == ArgumentDirection.SELF) continue;
                if (was) {
                    b2.append(',').append(' ');
                } else {
                    was = true;
                }
                b2.append(a.getName());
                if (d2 == ArgumentDirection.INOUT) {
                    b2.append(" in out");
                    continue;
                }
                if (d2 != ArgumentDirection.OUT) continue;
                b2.append(" out");
            }
            b2.append(')');
        }
        if (result2 != null) {
            DasType dasType = result2.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            String t = DasTypeUtilsKt.getTypeName(dasType);
            StringFun.appendIf(b2, !Intrinsics.areEqual((Object)t, (Object)"unknown"), ": ", t);
        }
        String string = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        presentation.addText(string2, DbPresentationCore.INFO_ATTRS);
    }

    @NlsSafe
    private final String describeOraSynonym(OraSynonym synonym2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraSynonym.TARGET_OBJECT_REF);
        return "synonym -> " + this.presentTarget(synonym2, null, true);
    }

    private final void describeOraSynonym(Project project, PresentationData presentation, OraSynonym synonym2) {
        String text2 = DbPresentationCore.arrow() + " " + this.presentTarget(synonym2, project, false);
        presentation.addText(text2, DbPresentationCore.INFO_ATTRS);
    }

    @NlsSafe
    private final String presentTarget(OraSynonym $this$presentTarget, Project project, boolean forceKind) {
        Object x;
        DasObject targetObject = this.resolveWithCache($this$presentTarget, project);
        if (targetObject != null) {
            return targetObject.getKind().code() + " " + targetObject.getName();
        }
        String dbLinkName = $this$presentTarget.getTargetDbLinkName();
        String schemaName = $this$presentTarget.getTargetSchemaName() != null && !Intrinsics.areEqual((Object)$this$presentTarget.getTargetSchemaName(), (Object)$this$presentTarget.getSchemaName()) ? $this$presentTarget.getTargetSchemaName() : null;
        String string = $this$presentTarget.getTargetObjectName();
        if (string == null) {
            string = "<unnamed-object>";
        }
        String objectName = string;
        String string2 = schemaName;
        Object object = x = string2 != null ? string2 + "." + objectName : objectName;
        if (dbLinkName != null) {
            x = (String)x + "@" + dbLinkName;
        }
        ObjectKind objectKind = $this$presentTarget.getTargetObjectKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getTargetObjectKind(...)");
        ObjectKind kind = objectKind;
        if (!Intrinsics.areEqual((Object)kind, (Object)ObjectKind.NONE)) {
            x = kind.code() + " " + (String)x;
        } else if (forceKind) {
            x = "<unknown> " + (String)x;
        }
        return x;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DasObject resolveWithCache(OraSynonym $this$resolveWithCache, Project project) {
        Object v3;
        block3: {
            if (project == null) return $this$resolveWithCache.getTargetObject();
            BasicModel basicModel = $this$resolveWithCache.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)basicModel, (String)"getModel(...)");
            BasicModModel m = (BasicModModel)basicModel;
            List<DbDataSource> list = DbPsiFacade.getInstance(project).getDataSources();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                DbDataSource it2 = (DbDataSource)t;
                boolean bl = false;
                RawDataSource rawDataSource = it2.getDelegate();
                LocalDataSource localDataSource = rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
                if (!Intrinsics.areEqual((Object)(localDataSource != null ? localDataSource.getModel() : null), (Object)m)) continue;
                v3 = t;
                break block3;
            }
            v3 = null;
        }
        DbDataSource dbDataSource = v3;
        if (dbDataSource == null) return $this$resolveWithCache.getTargetObject();
        DbDataSource ds = dbDataSource;
        boolean bl = false;
        DbElement dbElement = ds.findElement($this$resolveWithCache);
        Object object = dbElement;
        if (dbElement == null) return null;
        DbElement $this$asSafely$iv = object;
        boolean $i$f$asSafely = false;
        DbElement dbElement2 = $this$asSafely$iv;
        if (!(dbElement2 instanceof DbSynonym)) {
            dbElement2 = null;
        }
        DbSynonym dbSynonym = (DbSynonym)dbElement2;
        object = dbSynonym;
        if (dbSynonym == null) return null;
        DbElement dbElement3 = object.resolveTarget();
        object = dbElement3;
        if (dbElement3 == null) return null;
        Object object2 = object.getDelegate();
        object = object2;
        if (object2 == null) return null;
        Object $this$asSafely$iv2 = object;
        boolean $i$f$asSafely2 = false;
        Object object3 = $this$asSafely$iv2;
        if (!(object3 instanceof DasObject)) {
            object3 = null;
        }
        DasObject dasObject = (DasObject)object3;
        return dasObject;
    }

    private final String describeDbLink(OraDbLink dbLink, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraDbLink.CONNECT_USER_NAME);
        ((Collection)context.getDescribed()).add(OraDbLink.REMOTE_DATABASE_STRING);
        return "DB link -> " + this.presentRemote(dbLink);
    }

    private final void describeDbLink(PresentationData presentation, OraDbLink dbLink) {
        String text2 = DbPresentationCore.arrow() + " " + this.presentRemote(dbLink);
        presentation.addText(text2, DbPresentationCore.INFO_ATTRS);
    }

    @NlsSafe
    private final String presentRemote(OraDbLink $this$presentRemote) {
        Object object = $this$presentRemote.getConnectUserName() != null ? $this$presentRemote.getConnectUserName() + "@" : "";
        String string = this.presentRemoteDB($this$presentRemote);
        if (string == null) {
            string = "???";
        }
        return (String)object + string;
    }

    @NlsSafe
    private final String presentRemoteDB(OraDbLink $this$presentRemoteDB) {
        String string = $this$presentRemoteDB.getRemoteDatabaseString();
        if (string == null) {
            return null;
        }
        String rdb = string;
        if (StringsKt.startsWith$default((CharSequence)rdb, (char)'(', (boolean)false, (int)2, null)) {
            String host = StringFun.extract(rdb, REMOTE_DESC_HOST_PATTERN, 1);
            String port = StringFun.extract(rdb, REMOTE_DESC_PORT_PATTERN, 1);
            String serv = StringFun.extract(rdb, REMOTE_DESC_SERV_PATTERN, 2);
            if (host == null && port == null && serv == null) {
                CharSequence charSequence = rdb;
                Regex regex = SPACES_PATTERN;
                String string2 = " ";
                return regex.replace(charSequence, string2);
            }
            StringBuilder b2 = new StringBuilder();
            if (host != null) {
                b2.append(host);
            }
            if (port != null || serv != null) {
                b2.append(':');
            }
            if (port != null) {
                b2.append(port);
            }
            if (serv != null) {
                b2.append(':').append(serv);
            }
            return b2.toString();
        }
        return rdb;
    }

    private final String describeTablespace(OraTablespace tablespace, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraTablespace.CONTENT_CATEGORY);
        ((Collection)context.getDescribed()).add(OraTablespace.STATUS);
        ((Collection)context.getDescribed()).add(OraTablespace.BLOCK_SIZE);
        ((Collection)context.getDescribed()).add(OraTablespace.BIG_FILE);
        ((Collection)context.getDescribed()).add(OraTablespace.LOGGING);
        return this.describeTablespaceDetails(tablespace);
    }

    private final void describeTablespace(PresentationData presentation, OraTablespace tablespace) {
        OraTablespaceStatus oraTablespaceStatus = tablespace.getStatus();
        switch (oraTablespaceStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$2[oraTablespaceStatus.ordinal()]) {
            case 1: {
                presentation.setForcedTextForeground(Color.GRAY);
                break;
            }
            case 2: {
                presentation.setForcedTextForeground(Color.BLUE);
                break;
            }
            case 3: {
                presentation.setForcedTextForeground(Color.ORANGE);
            }
        }
        String text2 = this.describeTablespaceDetails(tablespace);
        if (((CharSequence)text2).length() > 0) {
            presentation.addText(text2, DbPresentationCore.INFO_ATTRS);
        }
    }

    @NonNls
    private final String describeTablespaceDetails(OraTablespace tablespace) {
        Enum it2;
        Enum enum_;
        StringBuilder b2 = new StringBuilder();
        OraTablespaceContentCategory oraTablespaceContentCategory = tablespace.getContentCategory();
        if (oraTablespaceContentCategory != null) {
            it2 = enum_ = oraTablespaceContentCategory;
            boolean bl = false;
            b2.append(((OraTablespaceContentCategory)it2).getDisplayName());
        }
        OraTablespaceStatus oraTablespaceStatus = tablespace.getStatus();
        if (oraTablespaceStatus != null) {
            it2 = enum_ = oraTablespaceStatus;
            boolean bl = false;
            StringFun.appendIfNotEmpty(b2, ", ").append(((OraTablespaceStatus)it2).getDisplayName());
        }
        int blockSize = tablespace.getBlockSize();
        if (blockSize > 0) {
            StringFun.appendIfNotEmpty(b2, ", ").append("block size ").append(blockSize);
        }
        if (tablespace.isBigFile()) {
            StringFun.appendIfNotEmpty(b2, ", ").append("big file");
        }
        OraTablespaceLogging oraTablespaceLogging = tablespace.getLogging();
        if (oraTablespaceLogging != null) {
            OraTablespaceLogging oraTablespaceLogging2;
            OraTablespaceLogging it3 = oraTablespaceLogging2 = oraTablespaceLogging;
            boolean bl = false;
            StringFun.appendIfNotEmpty(b2, ", ").append(it3.getDisplayName());
        }
        String string = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void describeDataFile(PresentationData presentation, OraDataFile dataFile) {
        Enum enum_;
        Color color;
        Color color2 = dataFile.getAvailabilityStatus() == OraDataFileAvailabilityStatus.DF_INVALID ? Color.RED : (dataFile.getAvailabilityStatus() == OraDataFileAvailabilityStatus.DF_UNDEFINED ? Color.ORANGE : (dataFile.getOnlineStatus() == OraDataFileOnlineStatus.DF_OFFLINE ? Color.GRAY : (color = dataFile.getOnlineStatus() == OraDataFileOnlineStatus.DF_RECOVER ? Color.MAGENTA : null)));
        if (color != null) {
            presentation.setForcedTextForeground(color);
        }
        OraTablespace oraTablespace = dataFile.getTablespace();
        if (oraTablespace == null) {
            return;
        }
        OraTablespace tablespace = oraTablespace;
        int bs = tablespace.getBlockSize();
        long size = dataFile.getFileSize() * (long)bs;
        String string = StringUtil.formatFileSize((long)size);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        String sizeStr = string;
        StringBuilder b2 = new StringBuilder();
        b2.append(sizeStr);
        if (dataFile.isAutoExtensible()) {
            long incSize = dataFile.getIncrementBy() * (long)bs;
            long maxSize = dataFile.getMaxSize() * (long)bs;
            b2.append("+ (inc by ").append(StringUtil.formatFileSize((long)incSize)).append(" max ").append(StringUtil.formatFileSize((long)maxSize)).append(')');
        }
        OraDataFileAvailabilityStatus oraDataFileAvailabilityStatus = dataFile.getAvailabilityStatus();
        if (oraDataFileAvailabilityStatus != null) {
            enum_ = oraDataFileAvailabilityStatus;
            OraDataFileAvailabilityStatus it2 = enum_;
            boolean bl = false;
            b2.append(' ').append(it2.getDisplayName());
        }
        OraDataFileOnlineStatus oraDataFileOnlineStatus = dataFile.getOnlineStatus();
        if (oraDataFileOnlineStatus != null) {
            Enum it3 = enum_ = oraDataFileOnlineStatus;
            boolean bl = false;
            b2.append(' ').append(((OraDataFileOnlineStatus)it3).getDisplayName());
        }
        String string2 = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String description = string2;
        presentation.addText(description, DbPresentationCore.INFO_ATTRS);
    }

    @NonNls
    private final String describeDataFile(OraDataFile dataFile, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(OraDataFile.FILE_ID);
        ((Collection)context.getDescribed()).add(OraDataFile.FILE_SIZE);
        ((Collection)context.getDescribed()).add(OraDataFile.USER_SIZE);
        ((Collection)context.getDescribed()).add(OraDataFile.AUTO_EXTENSIBLE);
        ((Collection)context.getDescribed()).add(OraDataFile.INCREMENT_BY);
        ((Collection)context.getDescribed()).add(OraDataFile.MAX_SIZE);
        ((Collection)context.getDescribed()).add(OraDataFile.AVAILABILITY_STATUS);
        ((Collection)context.getDescribed()).add(OraDataFile.ONLINE_STATUS);
        DescriptionService.Context this_$iv = context;
        boolean $i$f$getWithSurrogates = false;
        return this.describeDataFileDetails(dataFile, this_$iv.getOptions().getWithSurrogates());
    }

    private final String describeDataFileDetails(OraDataFile df, boolean withSurrogates) {
        Enum it2;
        Enum enum_;
        StringBuilder b2 = new StringBuilder();
        if (withSurrogates) {
            b2.append("id:").append(df.getFileId());
        }
        StringFun.appendIfNotEmpty(b2, ", ").append("size:").append(df.getFileSize());
        if (df.getUserSize() > 0L) {
            b2.append(" (user ").append(df.getUserSize()).append(')');
        }
        if (df.isAutoExtensible()) {
            b2.append(" +").append(df.getIncrementBy()).append(" max ").append(df.getMaxSize());
        }
        b2.append(" blocks");
        OraDataFileAvailabilityStatus oraDataFileAvailabilityStatus = df.getAvailabilityStatus();
        if (oraDataFileAvailabilityStatus != null) {
            it2 = enum_ = oraDataFileAvailabilityStatus;
            boolean bl = false;
            b2.append(", ").append(((OraDataFileAvailabilityStatus)it2).getDisplayName());
        }
        OraDataFileOnlineStatus oraDataFileOnlineStatus = df.getOnlineStatus();
        if (oraDataFileOnlineStatus != null) {
            it2 = enum_ = oraDataFileOnlineStatus;
            boolean bl = false;
            b2.append(", ").append(((OraDataFileOnlineStatus)it2).getDisplayName());
        }
        String string = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String describeOraRoot(OraRoot root2, DescriptionService.Context context) {
        String s2 = this.describeRoot(root2, context);
        OraTenantCategory oraTenantCategory = root2.getTenantCategory();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)oraTenantCategory), (String)"getTenantCategory(...)");
        OraTenantCategory tenantCategory = oraTenantCategory;
        if (tenantCategory.compareTo((Enum)OraTenantCategory.SOLID) > 0) {
            s2 = StringsKt.replace$default((String)s2, (String)"root", (String)("root of " + tenantCategory), (boolean)false, (int)4, null);
        }
        return s2;
    }

    @Override
    @Nullable
    public String getMinorObjectSchemaName(@NotNull BasicMinorObject obj2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        if (obj2 instanceof OraTrigger) {
            BasicReferenceInfo<? extends OraSchema> basicReferenceInfo = ((OraTrigger)obj2).getInSchemaRefInfo();
            string = basicReferenceInfo != null ? basicReferenceInfo.getName() : null;
        } else {
            string = null;
        }
        return string;
    }

    static {
        Object[] objectArray = new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL};
        REGEX_OPTIONS = SetsKt.setOf((Object[])objectArray);
        REMOTE_DESC_HOST_PATTERN = new Regex("\\(\\s*HOST\\s*=\\s*(.+?)\\s*\\)", REGEX_OPTIONS);
        REMOTE_DESC_PORT_PATTERN = new Regex("\\(\\s*PORT\\s*=\\s*(.+?)\\s*\\)", REGEX_OPTIONS);
        REMOTE_DESC_SERV_PATTERN = new Regex("\\(\\s*S(ID|ERVICE_NAME)\\s*=\\s*(.+?)\\s*\\)", REGEX_OPTIONS);
        SPACES_PATTERN = new Regex("\\s+", RegexOption.DOT_MATCHES_ALL);
        HEX_PATTERN = new Regex("[0-9A-Fa-f]+");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u0011\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/oracle/model/OraDescriptionService$Companion;", "", "()V", "HEX_PATTERN", "Lkotlin/text/Regex;", "getHEX_PATTERN", "()Lkotlin/text/Regex;", "REGEX_OPTIONS", "", "Lkotlin/text/RegexOption;", "getREGEX_OPTIONS", "()Ljava/util/Set;", "REMOTE_DESC_HOST_PATTERN", "getREMOTE_DESC_HOST_PATTERN", "REMOTE_DESC_PORT_PATTERN", "getREMOTE_DESC_PORT_PATTERN", "REMOTE_DESC_SERV_PATTERN", "getREMOTE_DESC_SERV_PATTERN", "SPACES_PATTERN", "getSPACES_PATTERN", "intellij.database.dialects.oracle"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<RegexOption> getREGEX_OPTIONS() {
            return REGEX_OPTIONS;
        }

        @NotNull
        public final Regex getREMOTE_DESC_HOST_PATTERN() {
            return REMOTE_DESC_HOST_PATTERN;
        }

        @NotNull
        public final Regex getREMOTE_DESC_PORT_PATTERN() {
            return REMOTE_DESC_PORT_PATTERN;
        }

        @NotNull
        public final Regex getREMOTE_DESC_SERV_PATTERN() {
            return REMOTE_DESC_SERV_PATTERN;
        }

        @NotNull
        public final Regex getSPACES_PATTERN() {
            return SPACES_PATTERN;
        }

        @NotNull
        public final Regex getHEX_PATTERN() {
            return HEX_PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ClusterType.values().length];
            try {
                nArray[ClusterType.INDEX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClusterType.HASH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OraTableType.values().length];
            try {
                nArray[OraTableType.BASIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTableType.MAT_LOG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTableType.MAT_LOG_TEMP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTableType.MAT_VIEW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[OraTablespaceStatus.values().length];
            try {
                nArray[OraTablespaceStatus.TS_OFFLINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTablespaceStatus.TS_READ_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTablespaceStatus.TS_UNDEFINED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

