/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.oracle.introspector.OraCatalogAccessPermissions;
import com.intellij.database.dialects.oracle.introspector.OraIntrospectorFunctions;
import com.intellij.database.dialects.oracle.introspector.OraTouchedObjectIds;
import com.intellij.database.dialects.oracle.introspector.OraTypeAndName;
import com.intellij.database.dialects.oracle.introspector.PortionType;
import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraCatalogObject;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterIndex;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraConstraint;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.dialects.oracle.model.OraLikeTable;
import com.intellij.database.dialects.oracle.model.OraMajorObject;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraObjectTypeBody;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageBody;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSchemaObject;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraSynonym;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableTrigger;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.OraView;
import com.intellij.database.dialects.oracle.model.OraViewTrigger;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Level;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.Version;
import com.intellij.database.util.common.StringFun;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u008e\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0010\"\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010#\u001a\u00020$2\n\u0010%\u001a\u00060&j\u0002`'\u001a\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020,\u001a\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\tH\u0000\u001a\u001a\u00100\u001a\u00020)2\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\bH\u0000\u001a\u001a\u00104\u001a\u00020)2\u0006\u00105\u001a\u0002062\b\u00103\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0012\u00107\u001a\u00020$2\b\u00108\u001a\u0004\u0018\u000109H\u0000\u001a\u0010\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020<H\u0000\u001a\u0018\u0010=\u001a\u00020)2\u0006\u0010;\u001a\u00020<2\u0006\u0010>\u001a\u00020?H\u0000\u001a\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020\bH\u0000\u001a\u0018\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020$H\u0000\u001ah\u0010G\u001a\u00020)2\u0006\u0010H\u001a\u00020I2\u0006\u0010;\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u00010\b2\u0006\u0010P\u001a\u00020\u000e2\b\u0010Q\u001a\u0004\u0018\u00010\b2\b\u0010R\u001a\u0004\u0018\u00010\b2\b\u0010S\u001a\u0004\u0018\u00010\b2\u0006\u0010T\u001a\u00020\b2\u0006\u0010U\u001a\u00020$H\u0000\u001aL\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020J2\b\u0010Y\u001a\u0004\u0018\u00010\b2\b\u0010Z\u001a\u0004\u0018\u00010\b2\b\u0010[\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\\\u001a\u00020\t2\b\b\u0002\u0010]\u001a\u00020\t2\b\b\u0002\u0010^\u001a\u00020\u000eH\u0000\u001a*\u0010_\u001a\u00020`2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\b\u0010a\u001a\u0004\u0018\u00010\b2\u0006\u0010b\u001a\u00020DH\u0000\u001a\u0010\u0010c\u001a\u00020A2\u0006\u0010d\u001a\u00020\bH\u0000\u001a\"\u0010e\u001a\u00020)2\u0006\u0010f\u001a\u00020g2\u0012\u0010h\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020j0i\u001a\"\u0010k\u001a\u00020)2\u0006\u0010l\u001a\u00020m2\u0012\u0010h\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020j0i\u001a\u0010\u0010n\u001a\u00020\b2\u0006\u0010a\u001a\u00020\bH\u0001\u001a\u0016\u0010o\u001a\u0004\u0018\u00010p*\u00020q2\u0006\u0010a\u001a\u00020\bH\u0000\u001a\u0016\u0010r\u001a\u0004\u0018\u00010s*\u00020<2\u0006\u0010a\u001a\u00020\bH\u0000\u001a\u0016\u0010t\u001a\u0004\u0018\u000109*\u00020J2\u0006\u0010u\u001a\u00020vH\u0000\u001a\u0016\u0010w\u001a\u0004\u0018\u00010x*\u00020<2\u0006\u0010a\u001a\u00020\bH\u0000\u001a\u0016\u0010y\u001a\u0004\u0018\u00010z*\u00020<2\u0006\u0010{\u001a\u00020\bH\u0000\u001a\u0012\u0010|\u001a\u00020\b*\b\u0012\u0004\u0012\u00020~0}H\u0000\u001a\u001e\u0010\u007f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020j0\u0007*\b\u0012\u0004\u0012\u00020~0}H\u0000\u001a&\u0010\u0080\u0001\u001a\u00020)*\u00030\u0081\u00012\n\u0010\u0082\u0001\u001a\u0005\u0018\u00010\u0083\u00012\n\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0083\u0001H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0011\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0003\"\u0014\u0010\u0013\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0003\"\u0014\u0010\u0015\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0003\"\u0014\u0010\u0017\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0003\"\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u001a\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0003\"\u000e\u0010\u001c\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0014\u0010!\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0003\u00a8\u0006\u0085\u0001"}, d2={"AUTO_NOT_NULL_CHECK_PATTERN", "Lkotlin/text/Regex;", "getAUTO_NOT_NULL_CHECK_PATTERN", "()Lkotlin/text/Regex;", "COLLECTION_TYPE_SURROGATE_NAME_PATTERN", "getCOLLECTION_TYPE_SURROGATE_NAME_PATTERN", "DATA_TYPE_STAR_SIZE", "", "", "", "DB_LINK_AUTH_PATTERN", "DB_LINK_CONNECT_PATTERN", "DB_LINK_SHARED_PATTERN", "DELIMITER", "", "EXPLICIT_UNIT_DATA_TYPES", "", "INDEX_EXPRESSION_STUB_PATTERN", "getINDEX_EXPRESSION_STUB_PATTERN", "INDEX_SURROGATE_NAME_PATTERN", "getINDEX_SURROGATE_NAME_PATTERN", "NATIVE_TRIGGER_DEFINITION_PATTERN", "getNATIVE_TRIGGER_DEFINITION_PATTERN", "SEQUENCE_SURROGATE_NAME_PATTERN", "getSEQUENCE_SURROGATE_NAME_PATTERN", "SIMPLE_DATA_TYPES", "SIMPLE_QUOTED_NAME_PATTERN", "getSIMPLE_QUOTED_NAME_PATTERN", "SRC_NAMES_PORTION_SIZE", "SYSTEM_SCHEMAS", "Ljava/util/TreeSet;", "getSYSTEM_SCHEMAS", "()Ljava/util/TreeSet;", "obfuscationTextPattern", "getObfuscationTextPattern", "adjustStringLiteralsForOracle9i", "", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "analyzeDbLinkSrc", "", "src", "dbLink", "Lcom/intellij/database/dialects/oracle/model/OraDbLink;", "applicablePortionTypeFor", "Lcom/intellij/database/dialects/oracle/introspector/PortionType;", "n", "applyStoredProgramSources", "obj", "Lcom/intellij/database/dialects/oracle/model/OraSourceAware;", "text", "applyViewSources", "view", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "canCheckOutdated", "e", "Lcom/intellij/database/model/basic/BasicElement;", "cleanSchemaIntrospectionInformation", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "dropUnexistentObjectsInSchema", "identifiers", "Lit/unimi/dsi/fastutil/longs/LongSet;", "getObjectKindByOracleTypeName", "Lcom/intellij/database/model/ObjectKind;", "oracleTypeName", "handleArgumentDirection", "Lcom/intellij/database/model/ArgumentDirection;", "directionChar", "nameExists", "makeArgument", "dasTypeSystem", "Lcom/intellij/database/types/DasTypeSystemBase;", "Lcom/intellij/database/model/basic/BasicSchema;", "routine", "Lcom/intellij/database/dialects/oracle/model/OraRoutine;", "position", "", "argName", "argDirection", "typeMod", "dataTypeSchemaName", "dataTypePackageName", "dataTypeSpec", "defaulted", "makeDataType", "Lcom/intellij/database/model/DataType;", "thisSchema", "typeSchemaName", "typePackageName", "typeSpec", "precision", "scale", "unitsCode", "makeOrGetArgument", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "name", "direction", "oracleKindByMajorInternalCode", "code", "setOracleCatalogAccessModeParameters", "permissions", "Lcom/intellij/database/dialects/oracle/introspector/OraCatalogAccessPermissions;", "parameters", "", "", "setOracleSpecificParameters", "version", "Lcom/intellij/database/util/Version;", "unquoteNameIfPossible", "findModConstraint", "Lcom/intellij/database/dialects/oracle/model/OraConstraint;", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "findModuleByName", "Lcom/intellij/database/dialects/oracle/model/OraModule;", "findOracleObjectByStringTypeAndName", "oracleTypeAndName", "Lcom/intellij/database/dialects/oracle/introspector/OraTypeAndName;", "findTableOrViewByName", "Lcom/intellij/database/dialects/oracle/model/OraLikeTable;", "findTrigger", "Lcom/intellij/database/dialects/oracle/model/OraTrigger;", "triggerName", "nameStr", "", "Lcom/intellij/database/dialects/oracle/introspector/OraTouchedObjectIds;", "schemasParameters", "setCreatedAndModifiedTimestamps", "Lcom/intellij/database/dialects/oracle/model/OraSchemaObject;", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "intellij.database.dialects.oracle"})
@JvmName(name="OraIntrospectorFunctions")
@SourceDebugExtension(value={"SMAP\nOraIntrospectorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraIntrospectorHelper.kt\ncom/intellij/database/dialects/oracle/introspector/OraIntrospectorFunctions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,601:1\n1#2:602\n1#2:617\n1549#3:603\n1620#3,3:604\n1603#3,9:607\n1855#3:616\n1856#3:618\n1612#3:619\n*S KotlinDebug\n*F\n+ 1 OraIntrospectorHelper.kt\ncom/intellij/database/dialects/oracle/introspector/OraIntrospectorFunctions\n*L\n533#1:617\n532#1:603\n532#1:604,3\n533#1:607,9\n533#1:616\n533#1:618\n533#1:619\n*E\n"})
public final class OraIntrospectorFunctions {
    @NotNull
    private static final TreeSet<String> SYSTEM_SCHEMAS;
    public static final int SRC_NAMES_PORTION_SIZE = 100;
    @NotNull
    private static final Set<String> SIMPLE_DATA_TYPES;
    @NotNull
    private static final Set<String> EXPLICIT_UNIT_DATA_TYPES;
    @NotNull
    private static final Map<String, Integer> DATA_TYPE_STAR_SIZE;
    @NotNull
    private static final Regex NATIVE_TRIGGER_DEFINITION_PATTERN;
    @NotNull
    private static final Regex SIMPLE_QUOTED_NAME_PATTERN;
    @NotNull
    private static final Regex AUTO_NOT_NULL_CHECK_PATTERN;
    @NotNull
    private static final Regex COLLECTION_TYPE_SURROGATE_NAME_PATTERN;
    @NotNull
    private static final Regex INDEX_SURROGATE_NAME_PATTERN;
    @NotNull
    private static final Regex INDEX_EXPRESSION_STUB_PATTERN;
    @NotNull
    private static final Regex SEQUENCE_SURROGATE_NAME_PATTERN;
    public static final char DELIMITER = '\uffff';
    @NotNull
    private static final Regex obfuscationTextPattern;
    @NotNull
    private static final Regex DB_LINK_SHARED_PATTERN;
    @NotNull
    private static final Regex DB_LINK_CONNECT_PATTERN;
    @NotNull
    private static final Regex DB_LINK_AUTH_PATTERN;

    @NotNull
    public static final TreeSet<String> getSYSTEM_SCHEMAS() {
        return SYSTEM_SCHEMAS;
    }

    @NotNull
    public static final PortionType applicablePortionTypeFor(int n) {
        return n <= 1 ? PortionType.ONE : (n <= PortionType.SMALL.getSize() ? PortionType.SMALL : (n <= PortionType.NORMAL.getSize() ? PortionType.NORMAL : PortionType.ALL));
    }

    public static final void setOracleCatalogAccessModeParameters(@NotNull OraCatalogAccessPermissions permissions, @NotNull Map<String, Object> parameters2) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        if (permissions.getHasSCR() || permissions.getHasSAD()) {
            parameters2.put("CAT", "sys.DBA");
            parameters2.put("DBA", true);
            parameters2.remove("SLOW");
            if (permissions.getFast()) {
                parameters2.put("FAST", true);
            } else {
                parameters2.remove("FAST");
            }
        } else {
            parameters2.put("CAT", "sys.ALL");
            parameters2.put("SLOW", true);
            parameters2.remove("DBA");
            parameters2.remove("FAST");
        }
    }

    public static final void setOracleSpecificParameters(@NotNull Version version, @NotNull Map<String, Object> parameters2) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        int[] nArray = new int[]{12, 2};
        if (version.isOrGreater(nArray) && Registry.is((String)"database.oracle.names.long")) {
            parameters2.put("N12", true);
        }
    }

    @NotNull
    public static final ObjectKind oracleKindByMajorInternalCode(@NotNull String code) {
        ObjectKind objectKind;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        switch (code) {
            case "TA": {
                ObjectKind objectKind2 = ObjectKind.TABLE;
                objectKind = objectKind2;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"TABLE");
                break;
            }
            case "CL": {
                ObjectKind objectKind3 = ObjectKind.CLUSTER;
                objectKind = objectKind3;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"CLUSTER");
                break;
            }
            case "VI": {
                ObjectKind objectKind4 = ObjectKind.VIEW;
                objectKind = objectKind4;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind4, (String)"VIEW");
                break;
            }
            case "SY": {
                ObjectKind objectKind5 = ObjectKind.SYNONYM;
                objectKind = objectKind5;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind5, (String)"SYNONYM");
                break;
            }
            case "SE": {
                ObjectKind objectKind6 = ObjectKind.SEQUENCE;
                objectKind = objectKind6;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind6, (String)"SEQUENCE");
                break;
            }
            case "PR": {
                ObjectKind objectKind7 = ObjectKind.ROUTINE;
                objectKind = objectKind7;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind7, (String)"ROUTINE");
                break;
            }
            case "FU": {
                ObjectKind objectKind8 = ObjectKind.ROUTINE;
                objectKind = objectKind8;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind8, (String)"ROUTINE");
                break;
            }
            case "PA": {
                ObjectKind objectKind9 = ObjectKind.PACKAGE;
                objectKind = objectKind9;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind9, (String)"PACKAGE");
                break;
            }
            case "MA": {
                ObjectKind objectKind10 = ObjectKind.MAT_VIEW;
                objectKind = objectKind10;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind10, (String)"MAT_VIEW");
                break;
            }
            case "YB": {
                ObjectKind objectKind11 = ObjectKind.OBJECT_TYPE;
                objectKind = objectKind11;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind11, (String)"OBJECT_TYPE");
                break;
            }
            case "YC": {
                ObjectKind objectKind12 = ObjectKind.COLLECTION_TYPE;
                objectKind = objectKind12;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind12, (String)"COLLECTION_TYPE");
                break;
            }
            case "DA": {
                ObjectKind objectKind13 = ObjectKind.DB_LINK;
                objectKind = objectKind13;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind13, (String)"DB_LINK");
                break;
            }
            default: {
                ObjectKind objectKind14 = ObjectKind.UNKNOWN_OBJECT;
                objectKind = objectKind14;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind14, (String)"UNKNOWN_OBJECT");
            }
        }
        return objectKind;
    }

    public static final void cleanSchemaIntrospectionInformation(@NotNull OraSchema schema2) {
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        schema2.setLastIntrospectionVersion(0);
        schema2.setLastIntrospectionLocalTimestamp(null);
        schema2.setLastIntrospectionL1Timestamp(null);
        schema2.setLastIntrospectionL2Timestamp(null);
        schema2.setLastIntrospectionL3Timestamp(null);
        schema2.setCommentsHash(0L);
        schema2.setDbLinksHash(0L);
    }

    public static final void dropUnexistentObjectsInSchema(@NotNull OraSchema schema2, @NotNull LongSet identifiers) {
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)identifiers, (String)"identifiers");
        ModNamingIdentifyingFamily<? extends OraSequence> modNamingIdentifyingFamily = schema2.getSequences();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getSequences(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily, identifiers);
        ModNamingIdentifyingFamily<? extends OraCluster> modNamingIdentifyingFamily2 = schema2.getClusters();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getClusters(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily2, identifiers);
        ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily3 = schema2.getTables();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getTables(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily3, identifiers);
        ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily4 = schema2.getMatViews();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getMatViews(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily4, identifiers);
        ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily5 = schema2.getViews();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getViews(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily5, identifiers);
        ModNamingIdentifyingFamily<? extends OraPackage> modNamingIdentifyingFamily6 = schema2.getPackages();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"getPackages(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily6, identifiers);
        ModNamingIdentifyingFamily<? extends OraObjectType> modNamingIdentifyingFamily7 = schema2.getObjectTypes();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily7, (String)"getObjectTypes(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily7, identifiers);
        ModNamingIdentifyingFamily<? extends OraCollectionType> modNamingIdentifyingFamily8 = schema2.getCollectionTypes();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily8, (String)"getCollectionTypes(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily8, identifiers);
        ModNamingIdentifyingFamily<? extends OraSingleRoutine> modNamingIdentifyingFamily9 = schema2.getRoutines();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily9, (String)"getRoutines(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily9, identifiers);
        ModNamingIdentifyingFamily<? extends OraSynonym> modNamingIdentifyingFamily10 = schema2.getSynonyms();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily10, (String)"getSynonyms(...)");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily10, identifiers);
        for (OraCluster oraCluster : schema2.getClusters()) {
            ModSingletonFamily<? extends OraClusterIndex> modSingletonFamily = oraCluster.getIndices();
            Intrinsics.checkNotNullExpressionValue(modSingletonFamily, (String)"getIndices(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects(modSingletonFamily, identifiers);
        }
        for (OraTable oraTable : schema2.getTables()) {
            Family family = oraTable.getIndices();
            Intrinsics.checkNotNullExpressionValue((Object)family, (String)"getIndices(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)family), identifiers);
            ModNamingIdentifyingFamily<? extends OraTableTrigger> modNamingIdentifyingFamily11 = oraTable.getTriggers();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily11, (String)"getTriggers(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily11, identifiers);
        }
        for (Object t : schema2.getMatViews()) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            OraMatView oraMatView = (OraMatView)t;
        }
        for (OraView oraView : schema2.getViews()) {
            ModNamingIdentifyingFamily<? extends OraViewTrigger> modNamingIdentifyingFamily12 = oraView.getTriggers();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily12, (String)"getTriggers(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily12, identifiers);
        }
        for (OraPackage oraPackage : schema2.getPackages()) {
            ModSingletonFamily<? extends OraPackageBody> modSingletonFamily = oraPackage.getBodies();
            Intrinsics.checkNotNullExpressionValue(modSingletonFamily, (String)"getBodies(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects(modSingletonFamily, identifiers);
        }
        for (OraObjectType oraObjectType : schema2.getObjectTypes()) {
            ModSingletonFamily<? extends OraObjectTypeBody> modSingletonFamily = oraObjectType.getBodies();
            Intrinsics.checkNotNullExpressionValue(modSingletonFamily, (String)"getBodies(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects(modSingletonFamily, identifiers);
        }
    }

    public static final void setCreatedAndModifiedTimestamps(@NotNull OraSchemaObject $this$setCreatedAndModifiedTimestamps, @Nullable Date createdTimestamp, @Nullable Date modifiedTimestamp) {
        Intrinsics.checkNotNullParameter((Object)$this$setCreatedAndModifiedTimestamps, (String)"<this>");
        $this$setCreatedAndModifiedTimestamps.setCreatedTimestamp(createdTimestamp);
        $this$setCreatedAndModifiedTimestamps.setModifiedTimestamp(modifiedTimestamp);
    }

    @Nullable
    public static final OraLikeTable findTableOrViewByName(@NotNull OraSchema $this$findTableOrViewByName, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$findTableOrViewByName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        OraLikeTable oraLikeTable = (OraLikeTable)$this$findTableOrViewByName.getMatViews().get(name2);
        if (oraLikeTable == null && (oraLikeTable = (OraLikeTable)$this$findTableOrViewByName.getTables().get(name2)) == null) {
            oraLikeTable = (OraLikeTable)$this$findTableOrViewByName.getViews().get(name2);
        }
        return oraLikeTable;
    }

    @Nullable
    public static final OraModule findModuleByName(@NotNull OraSchema $this$findModuleByName, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$findModuleByName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        OraModule oraModule = (OraModule)$this$findModuleByName.getObjectTypes().get(name2);
        if (oraModule == null) {
            oraModule = (OraModule)$this$findModuleByName.getPackages().get(name2);
        }
        return oraModule;
    }

    @Nullable
    public static final OraConstraint findModConstraint(@NotNull OraTable $this$findModConstraint, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$findModConstraint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        OraConstraint oraConstraint = (OraConstraint)$this$findModConstraint.getKeys().get(name2);
        if (oraConstraint == null && (oraConstraint = (OraConstraint)$this$findModConstraint.getForeignKeys().get(name2)) == null) {
            oraConstraint = (OraConstraint)$this$findModConstraint.getChecks().get(name2);
        }
        return oraConstraint;
    }

    @Nullable
    public static final OraTrigger findTrigger(@NotNull OraSchema $this$findTrigger, @NotNull String triggerName) {
        Intrinsics.checkNotNullParameter((Object)$this$findTrigger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        OraTrigger trigger2 = null;
        for (OraTable oraTable : $this$findTrigger.getTables()) {
            trigger2 = (OraTrigger)oraTable.getTriggers().get(triggerName);
            if (trigger2 == null) continue;
            return trigger2;
        }
        for (OraView oraView : $this$findTrigger.getViews()) {
            trigger2 = (OraTrigger)oraView.getTriggers().get(triggerName);
            if (trigger2 == null) continue;
            return trigger2;
        }
        for (OraMatView oraMatView : $this$findTrigger.getMatViews()) {
            trigger2 = (OraTrigger)oraMatView.getTriggers().get(triggerName);
            if (trigger2 == null) continue;
            return trigger2;
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static final String unquoteNameIfPossible(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Object object = SIMPLE_QUOTED_NAME_PATTERN.matchEntire((CharSequence)name2);
        if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
            object = name2;
        }
        return object;
    }

    public static final void makeArgument(@NotNull DasTypeSystemBase dasTypeSystem, @NotNull BasicSchema schema2, @NotNull OraRoutine routine2, short position, @Nullable String argName, char argDirection, @Nullable String typeMod, @Nullable String dataTypeSchemaName, @Nullable String dataTypePackageName, @NotNull String dataTypeSpec, boolean defaulted) {
        Intrinsics.checkNotNullParameter((Object)dasTypeSystem, (String)"dasTypeSystem");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
        Intrinsics.checkNotNullParameter((Object)dataTypeSpec, (String)"dataTypeSpec");
        ArgumentDirection dir = OraIntrospectorFunctions.handleArgumentDirection(argDirection, argName != null);
        OraArgument argument = OraIntrospectorFunctions.makeOrGetArgument(routine2, position, argName, dir);
        DataType dataType = OraIntrospectorFunctions.makeDataType$default(schema2, dataTypeSchemaName, dataTypePackageName, dataTypeSpec, 0, 0, '\u0000', 112, null);
        CharSequence charSequence = typeMod;
        if (!(charSequence == null || charSequence.length() == 0)) {
            DataType dataType2 = DataTypeFactory.withSuffix(dataType, StringUtil.toUpperCase((String)typeMod));
            Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"withSuffix(...)");
            dataType = dataType2;
        }
        argument.setStoredType(dasTypeSystem.createDasType(dataType));
        CharSequence charSequence2 = charSequence = "???";
        OraArgument oraArgument = argument;
        boolean bl = false;
        boolean bl2 = defaulted;
        oraArgument.setDefaultExpression((String)(bl2 ? charSequence : null));
    }

    @NotNull
    public static final ArgumentDirection handleArgumentDirection(char directionChar, boolean nameExists) {
        ArgumentDirection dir = ArgumentDirection.of(directionChar);
        if (dir == null && nameExists) {
            dir = ArgumentDirection.IN;
        }
        if (dir == null) {
            dir = ArgumentDirection.IN;
        }
        return dir;
    }

    @NotNull
    public static final OraArgument makeOrGetArgument(@NotNull OraRoutine routine2, short position, @Nullable String name2, @NotNull ArgumentDirection direction) {
        Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        OraArgument argument = null;
        if (direction == ArgumentDirection.RETURN) {
            BasicModArgument basicModArgument = routine2.createOrGetReturnArgument();
            Intrinsics.checkNotNull((Object)basicModArgument, (String)"null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraArgument");
            argument = (OraArgument)basicModArgument;
            argument.setRealName(name2);
        } else {
            PositioningNamingFamily positioningNamingFamily = routine2.getArguments();
            Object object = name2;
            if (object == null) {
                object = "unnamed_" + position;
            }
            Object e2 = positioningNamingFamily.createOrGet((String)object);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"createOrGet(...)");
            argument = (OraArgument)e2;
            argument.setPosition(position);
            argument.setArgumentDirection(direction);
        }
        return argument;
    }

    @NotNull
    public static final DataType makeDataType(@NotNull BasicSchema thisSchema, @Nullable String typeSchemaName, @Nullable String typePackageName, @Nullable String typeSpec, int precision, int scale, char unitsCode) {
        Intrinsics.checkNotNullParameter((Object)thisSchema, (String)"thisSchema");
        String spec2 = typeSpec;
        if (spec2 != null && spec2.length() > 7 && StringsKt.startsWith$default((String)spec2, (String)"PL/SQL ", (boolean)false, (int)2, null)) {
            String string = spec2.substring(7);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            spec2 = string;
        }
        DataType type2 = null;
        if (spec2 == null) {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"UNKNOWN");
            type2 = dataType;
        } else if (StringsKt.startsWith$default((String)spec2, (String)"INTERVAL YEAR TO", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)spec2, (String)"INTERVAL DAY TO", (boolean)false, (int)2, null)) {
            int p2 = StringsKt.indexOf$default((CharSequence)spec2, (String)"TO", (int)0, (boolean)false, (int)6, null);
            String string = spec2.substring(0, p2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            String string3 = spec2.substring(p2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            DataType dataType = DataTypeFactory.of(null, null, string2, precision, 0, null, ((Object)StringsKt.trim((CharSequence)string3)).toString() + (String)(scale != 0 ? "(" + scale + ")" : ""), false, false);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            type2 = dataType;
        } else if (StringsKt.contains$default((CharSequence)spec2, (CharSequence)"(", (boolean)false, (int)2, null)) {
            DataType dataType = DataTypeFactory.of(spec2);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            type2 = dataType;
        } else {
            DataType dataType;
            LengthUnit units;
            boolean customType = typeSchemaName != null;
            boolean simple = SIMPLE_DATA_TYPES.contains(spec2) && !customType;
            boolean explicitUnits = EXPLICIT_UNIT_DATA_TYPES.contains(spec2) && unitsCode == 'C' && !customType;
            char c2 = unitsCode;
            LengthUnit lengthUnit = c2 == 'B' ? LengthUnit.BYTE : (c2 == 'C' ? LengthUnit.CHAR : (units = c2 == 'D' ? LengthUnit.DIGIT : null));
            String explicitSchemaName = customType ? (Intrinsics.areEqual((Object)thisSchema.getRealName(), (Object)typeSchemaName) || Intrinsics.areEqual((Object)typeSchemaName, (Object)"PUBLIC") ? null : typeSchemaName) : null;
            Integer starSize = DATA_TYPE_STAR_SIZE.get(spec2);
            int p3 = starSize != null && precision == starSize ? 0x7FFFFFFE : precision;
            String suffix2 = null;
            if (StringsKt.startsWith((String)spec2, (String)"TIMESTAMP ", (boolean)true)) {
                suffix2 = StringsKt.contains((CharSequence)spec2, (CharSequence)"LOCAL", (boolean)true) ? "WITH LOCAL TIME ZONE" : "WITH TIME ZONE";
                spec2 = "TIMESTAMP";
            }
            if (customType) {
                DataType dataType2 = DataTypeFactory.of(explicitSchemaName, typePackageName, spec2, -1, 0, null, suffix2, false, true);
                dataType = dataType2;
                Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"of(...)");
            } else if (simple) {
                DataType dataType3 = DataTypeFactory.of(null, typePackageName, spec2, -1, -1, units, suffix2, false, false);
                dataType = dataType3;
                Intrinsics.checkNotNullExpressionValue((Object)dataType3, (String)"of(...)");
            } else {
                DataType dataType4 = DataTypeFactory.of(null, typePackageName, spec2, p3, scale, units, suffix2, explicitUnits, false);
                dataType = dataType4;
                Intrinsics.checkNotNullExpressionValue((Object)dataType4, (String)"of(...)");
            }
            type2 = dataType;
        }
        return type2;
    }

    public static /* synthetic */ DataType makeDataType$default(BasicSchema basicSchema, String string, String string2, String string3, int n, int n3, char c2, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n = -1;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x40) != 0) {
            c2 = '\u0000';
        }
        return OraIntrospectorFunctions.makeDataType(basicSchema, string, string2, string3, n, n3, c2);
    }

    public static final void applyStoredProgramSources(@NotNull OraSourceAware obj2, @Nullable String text2) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        CharSequence charSequence = text2;
        if (!(charSequence == null || charSequence.length() == 0)) {
            obj2.setSourceText(new SimpleCompositeText((CharSequence)text2, CompositeText.Kind.ORIGINAL_TEXT));
            if (obj2 instanceof OraMajorObject) {
                ((OraMajorObject)((Object)obj2)).setDetailsLevel(Level.L3);
            }
        } else {
            obj2.setSourceText(null);
        }
    }

    public static final void applyViewSources(@NotNull BasicModSourceAware view2, @Nullable String text2) {
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        CharSequence charSequence = text2;
        if (!(charSequence == null || charSequence.length() == 0)) {
            view2.setSourceText(new SimpleCompositeText((CharSequence)text2, CompositeText.Kind.ORIGINAL_TEXT));
            if (view2 instanceof OraMajorObject) {
                ((OraMajorObject)((Object)view2)).setDetailsLevel(Level.L3);
            }
        } else {
            view2.setSourceText(null);
        }
    }

    @NotNull
    public static final Regex getNATIVE_TRIGGER_DEFINITION_PATTERN() {
        return NATIVE_TRIGGER_DEFINITION_PATTERN;
    }

    @NotNull
    public static final Regex getSIMPLE_QUOTED_NAME_PATTERN() {
        return SIMPLE_QUOTED_NAME_PATTERN;
    }

    @NotNull
    public static final Regex getAUTO_NOT_NULL_CHECK_PATTERN() {
        return AUTO_NOT_NULL_CHECK_PATTERN;
    }

    @NotNull
    public static final Regex getCOLLECTION_TYPE_SURROGATE_NAME_PATTERN() {
        return COLLECTION_TYPE_SURROGATE_NAME_PATTERN;
    }

    @NotNull
    public static final Regex getINDEX_SURROGATE_NAME_PATTERN() {
        return INDEX_SURROGATE_NAME_PATTERN;
    }

    @NotNull
    public static final Regex getINDEX_EXPRESSION_STUB_PATTERN() {
        return INDEX_EXPRESSION_STUB_PATTERN;
    }

    @NotNull
    public static final Regex getSEQUENCE_SURROGATE_NAME_PATTERN() {
        return SEQUENCE_SURROGATE_NAME_PATTERN;
    }

    public static final boolean canCheckOutdated(@Nullable BasicElement e2) {
        return e2 == null || e2 instanceof OraCatalogObject && !(e2 instanceof OraSchema) && ((OraCatalogObject)e2).getObjectId() != Long.MIN_VALUE && ((OraCatalogObject)e2).getModifiedTimestamp() != null;
    }

    @Nullable
    public static final BasicElement findOracleObjectByStringTypeAndName(@NotNull BasicSchema $this$findOracleObjectByStringTypeAndName, @NotNull OraTypeAndName oracleTypeAndName) {
        Intrinsics.checkNotNullParameter((Object)$this$findOracleObjectByStringTypeAndName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)oracleTypeAndName, (String)"oracleTypeAndName");
        String string = oracleTypeAndName.getType();
        if (string == null) {
            return null;
        }
        String objectTypeName = string;
        ObjectKind objectKind = OraIntrospectorFunctions.getObjectKindByOracleTypeName(objectTypeName);
        if (objectKind == null) {
            return null;
        }
        ObjectKind objectKind2 = objectKind;
        String string2 = oracleTypeAndName.getName();
        if (string2 == null) {
            return null;
        }
        String objectName = string2;
        ObjectKind objectKind3 = objectKind2;
        if (Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.OBJECT_TYPE)) {
            BasicElement o2;
            Family<? extends BasicElement> family1 = $this$findOracleObjectByStringTypeAndName.familyOf(ObjectKind.OBJECT_TYPE);
            NamingFamily namingFamily = family1 instanceof NamingFamily ? (NamingFamily)family1 : null;
            BasicElement basicElement = o2 = namingFamily != null ? (BasicElement)namingFamily.get(objectName) : null;
            if (o2 == null) {
                Family<? extends BasicElement> family2 = $this$findOracleObjectByStringTypeAndName.familyOf(ObjectKind.COLLECTION_TYPE);
                NamingFamily namingFamily2 = family2 instanceof NamingFamily ? (NamingFamily)family2 : null;
                o2 = namingFamily2 != null ? (BasicElement)namingFamily2.get(objectName) : null;
            }
            return o2;
        }
        if (Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.BODY)) {
            ObjectKind objectKind4;
            char o2 = objectTypeName.charAt(0);
            if (o2 == 'P') {
                objectKind4 = ObjectKind.PACKAGE;
            } else if (o2 == 'T') {
                objectKind4 = ObjectKind.OBJECT_TYPE;
            } else {
                return null;
            }
            ObjectKind parentKind = objectKind4;
            Family<? extends BasicElement> family = $this$findOracleObjectByStringTypeAndName.familyOf(parentKind);
            if (family == null) {
                return null;
            }
            Family<? extends BasicElement> parentFamily = family;
            BasicNode basicNode = parentFamily instanceof NamingFamily ? (NamingFamily)parentFamily : null;
            if (basicNode == null || (basicNode = (BasicElement)basicNode.get(objectName)) == null) {
                return null;
            }
            BasicNode parent2 = basicNode;
            Family<? extends BasicElement> family2 = parent2.familyOf(ObjectKind.BODY);
            return family2 != null ? (BasicElement)CollectionsKt.firstOrNull((Iterable)family2) : null;
        }
        Family<? extends BasicElement> family = $this$findOracleObjectByStringTypeAndName.familyOf(objectKind2);
        if (family == null) {
            return null;
        }
        Family<? extends BasicElement> family3 = family;
        return family3 instanceof NamingFamily ? (BasicElement)((NamingFamily)family3).get(objectName) : null;
    }

    @Nullable
    public static final ObjectKind getObjectKindByOracleTypeName(@NotNull String oracleTypeName) {
        Intrinsics.checkNotNullParameter((Object)oracleTypeName, (String)"oracleTypeName");
        return switch (oracleTypeName) {
            case "INDEX" -> ObjectKind.INDEX;
            case "TABLE" -> ObjectKind.TABLE;
            case "CLUSTER" -> ObjectKind.CLUSTER;
            case "VIEW" -> ObjectKind.VIEW;
            case "SYNONYM" -> ObjectKind.SYNONYM;
            case "SEQUENCE" -> ObjectKind.SEQUENCE;
            case "PROCEDURE" -> ObjectKind.ROUTINE;
            case "FUNCTION" -> ObjectKind.ROUTINE;
            case "PACKAGE" -> ObjectKind.PACKAGE;
            case "PACKAGE BODY" -> ObjectKind.BODY;
            case "TRIGGER" -> ObjectKind.TRIGGER;
            case "TYPE" -> ObjectKind.OBJECT_TYPE;
            case "TYPE BODY" -> ObjectKind.BODY;
            case "MATERIALIZED VIEW" -> ObjectKind.MAT_VIEW;
            case "DATABASE LINK" -> ObjectKind.DB_LINK;
            default -> null;
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Object> schemasParameters(@NotNull Collection<OraTouchedObjectIds> $this$schemasParameters) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$schemasParameters, (String)"<this>");
        Iterable $this$map$iv = $this$schemasParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            OraTouchedObjectIds oraTouchedObjectIds = (OraTouchedObjectIds)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(p0.getSchemaId());
        }
        long[] schemaIds2 = CollectionsKt.toLongArray((Collection)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv = $this$schemasParameters;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            OraTouchedObjectIds p0 = (OraTouchedObjectIds)element$iv$iv;
            boolean bl2 = false;
            if (p0.getSchemaName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List schemaNames2 = (List)destination$iv$iv2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"schema_ids", (Object)schemaIds2), TuplesKt.to((Object)"schema_names", (Object)schemaNames2)};
        SortedMap map2 = MapsKt.sortedMapOf((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), (Pair[])pairArray);
        return map2;
    }

    @NotNull
    public static final String nameStr(@NotNull Collection<OraTouchedObjectIds> $this$nameStr) {
        Intrinsics.checkNotNullParameter($this$nameStr, (String)"<this>");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$nameStr), (Function1)nameStr.1.INSTANCE), null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public static final Regex getObfuscationTextPattern() {
        return obfuscationTextPattern;
    }

    public static final boolean adjustStringLiteralsForOracle9i(@NotNull StringBuilder buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int q2 = buf.indexOf("q'{");
        if (q2 < 0) {
            return false;
        }
        int p2 = buf.indexOf("}'", q2 + 3);
        if (p2 < 0) {
            return false;
        }
        buf.delete(p2, p2 + 1);
        int i2 = p2 - 1;
        int n = q2 + 3;
        if (n <= i2) {
            while (true) {
                if (buf.charAt(i2) == '\'') {
                    buf.insert(i2 + 1, '\'');
                }
                if (i2 == n) break;
                --i2;
            }
        }
        buf.delete(q2 + 2, q2 + 3);
        buf.delete(q2, q2 + 1);
        return true;
    }

    public static final void analyzeDbLinkSrc(@NotNull String src2, @NotNull OraDbLink dbLink) {
        OraDbLink oraDbLink;
        Intrinsics.checkNotNullParameter((Object)src2, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dbLink, (String)"dbLink");
        Pair<String, String> pair = (Pair<String, String>)src2;
        boolean shared = DB_LINK_SHARED_PATTERN.matches((CharSequence)pair);
        pair = OraIntrospectorFunctions.analyzeDbLinkSrc$extractNamePwd(src2, DB_LINK_CONNECT_PATTERN, 1, 4);
        String connName = (String)pair.component1();
        String connPwd = (String)pair.component2();
        Pair<String, String> pair2 = OraIntrospectorFunctions.analyzeDbLinkSrc$extractNamePwd(src2, DB_LINK_AUTH_PATTERN, 1, 4);
        String authName = (String)pair2.component1();
        String authPwd = (String)pair2.component2();
        OraDbLink $this$analyzeDbLinkSrc_u24lambda_u242 = oraDbLink = dbLink;
        boolean bl = false;
        $this$analyzeDbLinkSrc_u24lambda_u242.setShared(shared);
        $this$analyzeDbLinkSrc_u24lambda_u242.setConnectUserName(connName);
        $this$analyzeDbLinkSrc_u24lambda_u242.setConnectUserPassword(connPwd);
        $this$analyzeDbLinkSrc_u24lambda_u242.setAuthUserName(authName);
        $this$analyzeDbLinkSrc_u24lambda_u242.setAuthUserPassword(authPwd);
    }

    private static final Pair<String, String> analyzeDbLinkSrc$extractNamePwd(String $src, Regex pattern2, int index1, int index2) {
        Pair np = StringFun.extract($src, pattern2, index1, index2);
        if (np.getSecond() != null) {
            Object object = np.getSecond();
            Intrinsics.checkNotNull((Object)object);
            if (StringsKt.startsWith$default((CharSequence)((CharSequence)object), (char)':', (boolean)false, (int)2, null)) {
                np = new Pair(np.getFirst(), null);
            }
        }
        return np;
    }

    static {
        Object[] objectArray = new String[]{"SYS", "SYSTEM", "ORDDATA", "AUDSYS", "CTXSYS", "ORDSYS", "MDSYS", "CTXSYS", "WMSYS", "DVSYS", "LBACSYS", "OLAPSYS", "OJVMSYS", "APPQOSSYS", "XDB", "PUBLIC"};
        SYSTEM_SCHEMAS = SetsKt.sortedSetOf((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), (Object[])objectArray);
        objectArray = new String[]{"INTEGER", "BINARY_INTEGER", "BINARY_FLOAT", "BINARY_DOUBLE", "DATE", "TIME", "ROWID", "UROWID", "CLOB", "BLOB", "LONG", "LONG RAW", "BFILE"};
        SIMPLE_DATA_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"CHAR", "VARCHAR", "VARCHAR2"};
        EXPLICIT_UNIT_DATA_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"NUMBER", (Object)0x7FFFFFFE), TuplesKt.to((Object)"FLOAT", (Object)126)};
        DATA_TYPE_STAR_SIZE = MapsKt.mapOf((Pair[])objectArray);
        NATIVE_TRIGGER_DEFINITION_PATTERN = new Regex("(?s)^CREATE(\\s*OR\\s*REPLACE)?(\\s*[EN][A-Z]+)?\\s+TRIGGER.+$");
        SIMPLE_QUOTED_NAME_PATTERN = new Regex("^\\s*\"([^\"]*)\"\\s*$");
        AUTO_NOT_NULL_CHECK_PATTERN = new Regex("\".+\" IS NOT NULL");
        COLLECTION_TYPE_SURROGATE_NAME_PATTERN = new Regex("^SYS_PLSQL_[0-9A-F_]+(DUMMY[0-9A-F_]*)?$");
        INDEX_SURROGATE_NAME_PATTERN = new Regex("^SYS_\\w*\\d+\\$*$");
        INDEX_EXPRESSION_STUB_PATTERN = new Regex("^SYS_NC\\d+.$");
        SEQUENCE_SURROGATE_NAME_PATTERN = new Regex("^ISEQ\\$+_\\d+$");
        obfuscationTextPattern = new Regex("^[^\\n]*wrapped\\s*\\n", RegexOption.DOT_MATCHES_ALL);
        objectArray = new RegexOption[]{RegexOption.DOT_MATCHES_ALL, RegexOption.IGNORE_CASE};
        DB_LINK_SHARED_PATTERN = new Regex("^\\s*CREATE\\s+(PUBLIC\\s+)?SHARED\\s.*$", SetsKt.setOf((Object[])objectArray));
        objectArray = new RegexOption[]{RegexOption.COMMENTS, RegexOption.IGNORE_CASE};
        DB_LINK_CONNECT_PATTERN = new Regex("CONNECT \\s+ TO \\s+ \"(.*?)(\"|\\s) \\s* (IDENTIFIED \\s+ BY \\s+ VALUES? \\s* '(.*?)')?", SetsKt.setOf((Object[])objectArray));
        objectArray = new RegexOption[]{RegexOption.COMMENTS, RegexOption.IGNORE_CASE};
        DB_LINK_AUTH_PATTERN = new Regex("AUTHENTICATED \\s+ BY \\s+ \"(.*?)(\"|\\s) \\s* (IDENTIFIED \\s+ BY \\s+ VALUES? \\s* '(.*?)')?", SetsKt.setOf((Object[])objectArray));
    }
}

