/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.intellij.database.dialects.oracle.introspector.OraMajorSourceText;
import com.intellij.database.dialects.oracle.introspector.OraTriggerSourceText;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.core.RowLayout;
import com.intellij.database.remote.jdba.sql.Scriptum;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class OraIntroQueries {
    static final OraIntroQueries QUERIES = new OraIntroQueries();
    @NotNull
    final Scriptum myScriptum = Scriptum.of(OraIntroQueries.class);
    final SqlQuery<Timestamp> askForTimeNow = new SqlQuery("select sysdate from dual", Layouts.rowOf((RowLayout)Layouts.oneOf(Timestamp.class)));
    final SqlQuery<OneSessionInfo> retrieveSessionInfo = this.myScriptum.query("RetrieveSessionInfo", Layouts.rowOf((RowLayout)Layouts.structOf(OneSessionInfo.class)));
    final SqlQuery<OneServerInfo> retrieveServerInfo = this.myScriptum.query("RetrieveServerInfo", Layouts.rowOf((RowLayout)Layouts.structOf(OneServerInfo.class)));
    final SqlQuery<Character[]> checkBaseDictionariesAccess = this.myScriptum.query("CheckBaseDictionariesAccess", Layouts.columnOf(Character.class));
    final SqlQuery<Boolean> checkFastDictionariesAccess = this.myScriptum.query("CheckFastDictionariesAccess", Layouts.existence());
    final SqlQuery<List<LongIdName>> retrieveAllSchemas = this.myScriptum.query("RetrieveAllSchemas", Layouts.listOf((RowLayout)Layouts.structOf(LongIdName.class)));
    final SqlQuery<OneSchemaInfo> retrieveSchemaInfo = this.myScriptum.query("RetrieveSchemaInfo", Layouts.rowOf((RowLayout)Layouts.structOf(OneSchemaInfo.class)));
    final SqlQuery<OneSchemaInfo> retrievePublicSchemaInfo = this.myScriptum.query("RetrievePublicSchemaInfo", Layouts.rowOf((RowLayout)Layouts.structOf(OneSchemaInfo.class)));
    final SqlQuery<List<String>> retrieveAllMajorNamesFast = this.myScriptum.query("RetrieveAllMajorNamesFast", Layouts.listOf((RowLayout)Layouts.oneOf(String.class)));
    final SqlQuery<List<String>> retrieveAllMajorNames = this.myScriptum.query("RetrieveAllMajorNames", Layouts.listOf((RowLayout)Layouts.oneOf(String.class)));
    final SqlQuery<long[]> retrieveAllObjectIdentifiersFast = this.myScriptum.query("RetrieveAllObjectIdentifiersFast", Layouts.columnOfLongs((int)4000));
    final SqlQuery<long[]> retrieveAllObjectIdentifiers = this.myScriptum.query("RetrieveAllObjectIdentifiers", Layouts.columnOfLongs((int)4000));
    final SqlQuery<Long> checkSchemaId = this.myScriptum.query("CheckSchemaId", Layouts.singleOf(Long.class));
    final SqlQuery<List<OneSynonym>> retrieveAllSynonymsFast = this.myScriptum.query("RetrieveAllSynonymsFast", Layouts.listOf((RowLayout)Layouts.structOf(OneSynonym.class)));
    final SqlQuery<List<OneSynonym>> retrieveAllSynonyms = this.myScriptum.query("RetrieveAllSynonyms", Layouts.listOf((RowLayout)Layouts.structOf(OneSynonym.class)));
    final SqlQuery<List<OneSynonym>> retrieveFragmentSynonyms = this.myScriptum.query("RetrieveFragmentSynonyms", Layouts.listOf((RowLayout)Layouts.structOf(OneSynonym.class)));
    final SqlQuery<List<String>> listFragmentRegularIds = this.myScriptum.query("ListFragmentRegularIds", Layouts.listOf((RowLayout)Layouts.oneOf(String.class)));
    final SqlQuery<List<String>> listFragmentTypeIds = this.myScriptum.query("ListFragmentTypeIds", Layouts.listOf((RowLayout)Layouts.oneOf(String.class)));
    final SqlQuery<List<OneColumnName>> retrieveAllColumnNamesFast = this.myScriptum.query("RetrieveAllColumnNamesFast", Layouts.listOf((RowLayout)Layouts.structOf(OneColumnName.class)));
    final SqlQuery<List<OneSlowColumnName>> retrieveAllColumnNamesFull = this.myScriptum.query("RetrieveAllColumnNamesFull", Layouts.listOf((RowLayout)Layouts.structOf(OneSlowColumnName.class)));
    final SqlQuery<List<OneSlowColumnName>> retrieveAllColumnNamesInc = this.myScriptum.query("RetrieveAllColumnNamesInc", Layouts.listOf((RowLayout)Layouts.structOf(OneSlowColumnName.class)));
    final SqlQuery<List<OneMinorObjectName>> retrieveAllMinorObjectNamesFast = this.myScriptum.query("RetrieveAllMinorObjectNamesFast", Layouts.listOf((RowLayout)Layouts.structOf(OneMinorObjectName.class)));
    final SqlQuery<List<OneMinorObjectName>> retrieveAllMinorObjectNames = this.myScriptum.query("RetrieveAllMinorObjectNames", Layouts.listOf((RowLayout)Layouts.structOf(OneMinorObjectName.class)));
    final SqlQuery<List<OneConstraintName>> retrieveAllConstraintNamesFast = this.myScriptum.query("RetrieveAllConstraintNamesFast", Layouts.listOf((RowLayout)Layouts.structOf(OneConstraintName.class)));
    final SqlQuery<List<OneConstraintName>> retrieveAllConstraintNames = this.myScriptum.query("RetrieveAllConstraintNames", Layouts.listOf((RowLayout)Layouts.structOf(OneConstraintName.class)));
    final SqlQuery<List<OneInnerRoutineName>> retrieveAllInnerRoutineNamesFast = this.myScriptum.query("RetrieveAllInnerRoutineNamesFast", Layouts.listOf((RowLayout)Layouts.structOf(OneInnerRoutineName.class)));
    final SqlQuery<List<OneInnerRoutineName>> retrieveAllInnerRoutineNames = this.myScriptum.query("RetrieveAllInnerRoutineNames", Layouts.listOf((RowLayout)Layouts.structOf(OneInnerRoutineName.class)));
    final SqlQuery<List<OneArgumentName>> retrieveAllArgumentNamesFast = this.myScriptum.query("RetrieveAllArgumentNamesFast", Layouts.listOf((RowLayout)Layouts.structOf(OneArgumentName.class)));
    final SqlQuery<List<OneArgumentName>> retrieveAllArgumentNames = this.myScriptum.query("RetrieveAllArgumentNames", Layouts.listOf((RowLayout)Layouts.structOf(OneArgumentName.class)));
    final SqlQuery<List<OneArgumentName>> retrieveAllArgumentNamesSlow10 = this.myScriptum.query("RetrieveAllArgumentNamesSlow10", Layouts.listOf((RowLayout)Layouts.structOf(OneArgumentName.class)));
    final SqlQuery<List<OneArgumentName>> retrieveAllArgumentNamesFull10 = this.myScriptum.query("RetrieveAllArgumentNamesFull10", Layouts.listOf((RowLayout)Layouts.structOf(OneArgumentName.class)));
    final SqlQuery<List<OneArgumentName>> retrieveAllArgumentNamesFull = this.myScriptum.query("RetrieveAllArgumentNamesFull", Layouts.listOf((RowLayout)Layouts.structOf(OneArgumentName.class)));
    final SqlQuery<List<OneArgumentName>> retrieveAllArgumentNamesInc = this.myScriptum.query("RetrieveAllArgumentNamesInc", Layouts.listOf((RowLayout)Layouts.structOf(OneArgumentName.class)));
    final SqlQuery<List<OneSequence>> retrieveSequences = this.myScriptum.query("RetrieveSequences", Layouts.listOf((RowLayout)Layouts.structOf(OneSequence.class)));
    final SqlQuery<List<OneObjectType>> retrieveObjectTypes = this.myScriptum.query("RetrieveObjectTypes", Layouts.listOf((RowLayout)Layouts.structOf(OneObjectType.class)));
    final SqlQuery<List<OneCollectionType>> retrieveCollectionTypes = this.myScriptum.query("RetrieveCollectionTypes", Layouts.listOf((RowLayout)Layouts.structOf(OneCollectionType.class)));
    final SqlQuery<List<OneObjectTypeAttribute>> retrieveObjectTypeAttributes = this.myScriptum.query("RetrieveObjectTypeAttributes", Layouts.listOf((RowLayout)Layouts.structOf(OneObjectTypeAttribute.class)));
    final SqlQuery<List<OneCluster>> retrieveClusters = this.myScriptum.query("RetrieveClusters", Layouts.listOf((RowLayout)Layouts.structOf(OneCluster.class)));
    final SqlQuery<List<OneCluster>> retrieveClustersWhenNoPermissions = this.myScriptum.query("RetrieveClustersWhenNoPermissions", Layouts.listOf((RowLayout)Layouts.structOf(OneCluster.class)));
    final SqlQuery<List<OneTable>> retrieveTables = this.myScriptum.query("RetrieveTables", Layouts.listOf((RowLayout)Layouts.structOf(OneTable.class)));
    final SqlQuery<List<OneMatLog>> retrieveMatLogs = this.myScriptum.query("RetrieveMatLogs", Layouts.listOf((RowLayout)Layouts.structOf(OneMatLog.class)));
    final SqlQuery<List<OneMatView>> retrieveMatViews = this.myScriptum.query("RetrieveMatViews", Layouts.listOf((RowLayout)Layouts.structOf(OneMatView.class)));
    final SqlQuery<List<OneView>> retrieveViews = this.myScriptum.query("RetrieveViews", Layouts.listOf((RowLayout)Layouts.structOf(OneView.class)));
    final SqlQuery<List<OneColumn>> retrieveColumns = this.myScriptum.query("RetrieveColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneColumn.class)));
    final SqlQuery<List<OneMinorText>> retrieveColumnDefaultsLong = this.myScriptum.query("RetrieveColumnDefaultsLong", Layouts.listOf((RowLayout)Layouts.structOf(OneMinorText.class)));
    final SqlQuery<Integer> retrieveColumnDefaultsXml = this.myScriptum.query("RetrieveColumnDefaultsXml", Layouts.singleOf(Integer.class));
    final SqlQuery<List<OneClusterIndex>> retrieveClusterIndicesFast = this.myScriptum.query("RetrieveClusterIndicesFast", Layouts.listOf((RowLayout)Layouts.structOf(OneClusterIndex.class)));
    final SqlQuery<List<OneClusterIndex>> retrieveClusterIndicesUser = this.myScriptum.query("RetrieveClusterIndicesUser", Layouts.listOf((RowLayout)Layouts.structOf(OneClusterIndex.class)));
    final SqlQuery<List<OneTableClusterColumn>> retrieveTableClusterColumnsDba = this.myScriptum.query("RetrieveTableClusterColumnsDba", Layouts.listOf((RowLayout)Layouts.structOf(OneTableClusterColumn.class)));
    final SqlQuery<List<OneTableClusterColumn>> retrieveTableClusterColumnsUser = this.myScriptum.query("RetrieveTableClusterColumnsUser", Layouts.listOf((RowLayout)Layouts.structOf(OneTableClusterColumn.class)));
    final SqlQuery<List<OneIndex>> retrieveIndices = this.myScriptum.query("RetrieveIndices", Layouts.listOf((RowLayout)Layouts.structOf(OneIndex.class)));
    final SqlQuery<List<OneIndexItem>> retrieveIndicesColumns = this.myScriptum.query("RetrieveIndicesColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneIndexItem.class)));
    final SqlQuery<List<OneIndexItem>> retrieveIndicesExpressions = this.myScriptum.query("RetrieveIndicesExpressions", Layouts.listOf((RowLayout)Layouts.structOf(OneIndexItem.class)));
    final SqlQuery<List<OneKey>> retrieveKeys = this.myScriptum.query("RetrieveKeys", Layouts.listOf((RowLayout)Layouts.structOf(OneKey.class)));
    final SqlQuery<List<OneForeignKey>> retrieveForeignKeysFast = this.myScriptum.query("RetrieveForeignKeysFast", Layouts.listOf((RowLayout)Layouts.structOf(OneForeignKey.class)));
    final SqlQuery<List<OneForeignKey>> retrieveForeignKeys = this.myScriptum.query("RetrieveForeignKeys", Layouts.listOf((RowLayout)Layouts.structOf(OneForeignKey.class)));
    final SqlQuery<List<OneCheck>> retrieveChecks = this.myScriptum.query("RetrieveChecks", Layouts.listOf((RowLayout)Layouts.structOf(OneCheck.class)));
    final SqlQuery<List<OneMinorText>> retrieveCheckPredicates12 = this.myScriptum.query("RetrieveCheckPredicates12", Layouts.listOf((RowLayout)Layouts.structOf(OneMinorText.class)));
    final SqlQuery<List<OneMinorText>> retrieveCheckPredicatesLong = this.myScriptum.query("RetrieveCheckPredicatesLong", Layouts.listOf((RowLayout)Layouts.structOf(OneMinorText.class)));
    final SqlQuery<Integer> retrieveCheckPredicatesXml = this.myScriptum.query("RetrieveCheckPredicatesXml", Layouts.singleOf(Integer.class));
    final SqlQuery<List<OneConstraintColumn>> retrieveConstraintColumns = this.myScriptum.query("RetrieveConstraintColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneConstraintColumn.class)));
    final SqlQuery<List<OneTrigger>> retrieveTriggers = this.myScriptum.query("RetrieveTriggers", Layouts.listOf((RowLayout)Layouts.structOf(OneTrigger.class)));
    final SqlQuery<List<String[]>> retrieveTriggerUpdateColumns = this.myScriptum.query("RetrieveTriggerUpdateColumns", Layouts.listOf((RowLayout)Layouts.arrayOf((int)4, String.class)));
    final SqlQuery<List<OnePackage>> retrievePackages = this.myScriptum.query("RetrievePackages", Layouts.listOf((RowLayout)Layouts.structOf(OnePackage.class)));
    final SqlQuery<List<OnePackageRoutine>> retrieveInnerRoutines11 = this.myScriptum.query("RetrieveInnerRoutines11", Layouts.listOf((RowLayout)Layouts.structOf(OnePackageRoutine.class)));
    final SqlQuery<List<OnePackageRoutine>> retrieveInnerRoutines10 = this.myScriptum.query("RetrieveInnerRoutines10", Layouts.listOf((RowLayout)Layouts.structOf(OnePackageRoutine.class)));
    final SqlQuery<List<OneTypeMethod>> retrieveTypeMethods11 = this.myScriptum.query("RetrieveTypeMethods11", Layouts.listOf((RowLayout)Layouts.structOf(OneTypeMethod.class)));
    final SqlQuery<List<OneTypeMethod>> retrieveTypeMethods10 = this.myScriptum.query("RetrieveTypeMethods10", Layouts.listOf((RowLayout)Layouts.structOf(OneTypeMethod.class)));
    final SqlQuery<List<OneInnerRoutineArgument>> retrieveInnerRoutineArguments = this.myScriptum.query("RetrieveInnerRoutineArguments", Layouts.listOf((RowLayout)Layouts.structOf(OneInnerRoutineArgument.class)));
    final SqlQuery<List<OneSingleRoutine>> retrieveSingleRoutines = this.myScriptum.query("RetrieveSingleRoutines", Layouts.listOf((RowLayout)Layouts.structOf(OneSingleRoutine.class)));
    final SqlQuery<List<OneSingleRoutineArgument>> retrieveSingleRoutineArguments = this.myScriptum.query("RetrieveSingleRoutineArguments", Layouts.listOf((RowLayout)Layouts.structOf(OneSingleRoutineArgument.class)));
    final SqlQuery<Long> calculateDbLinksHash = this.myScriptum.query("CalculateDbLinksHash", Layouts.singleOf(Long.class));
    final SqlQuery<List<OneDbLink>> retrieveDbLinks = this.myScriptum.query("RetrieveDbLinks", Layouts.listOf((RowLayout)Layouts.structOf(OneDbLink.class)));
    final SqlQuery<List<OneDbLink>> retrieveDbLinksWithSrc = this.myScriptum.query("RetrieveDbLinksWithSrc", Layouts.listOf((RowLayout)Layouts.structOf(OneDbLink.class)));
    final SqlQuery<Long> calculateCommentsHash = this.myScriptum.query("CalculateCommentsHash", Layouts.singleOf(Long.class));
    final SqlQuery<List<OneComment>> retrieveComments = this.myScriptum.query("RetrieveComments", Layouts.listOf((RowLayout)Layouts.structOf(OneComment.class)));
    final SqlQuery<List<OneDependency>> retrieveDependenciesFast = this.myScriptum.query("RetrieveDependenciesFast", Layouts.listOf((RowLayout)Layouts.structOf(OneDependency.class)));
    final SqlQuery<List<OneSlowDependency>> retrieveDependencies = this.myScriptum.query("RetrieveDependencies", Layouts.listOf((RowLayout)Layouts.structOf(OneSlowDependency.class)));
    final SqlQuery<List<OneSlowDependency>> retrieveDependenciesFrag = this.myScriptum.query("RetrieveDependenciesFrag", Layouts.listOf((RowLayout)Layouts.structOf(OneSlowDependency.class)));
    final SqlQuery<Integer> retrieveMatViewSourcesXml = this.myScriptum.query("RetrieveMatViewSourcesXml", Layouts.singleOf(Integer.class));
    final SqlQuery<List<OraMajorSourceText>> retrieveMatViewSourcesLong = this.myScriptum.query("RetrieveMatViewSourcesLong", Layouts.listOf((RowLayout)Layouts.structOf(OraMajorSourceText.class)));
    final SqlQuery<Integer> retrieveViewSourcesXml = this.myScriptum.query("RetrieveViewSourcesXml", Layouts.singleOf(Integer.class));
    final SqlQuery<List<OraMajorSourceText>> retrieveViewSources12 = this.myScriptum.query("RetrieveViewSources12", Layouts.listOf((RowLayout)Layouts.structOf(OraMajorSourceText.class)));
    final SqlQuery<List<OraMajorSourceText>> retrieveViewSourcesLong = this.myScriptum.query("RetrieveViewSourcesLong", Layouts.listOf((RowLayout)Layouts.structOf(OraMajorSourceText.class)));
    final SqlQuery<Integer> retrieveTriggerSourcesXml = this.myScriptum.query("RetrieveTriggerSourcesXml", Layouts.singleOf(Integer.class));
    final SqlQuery<List<OraTriggerSourceText>> retrieveTriggerSourcesLong = this.myScriptum.query("RetrieveTriggerSourcesLong", Layouts.listOf((RowLayout)Layouts.structOf(OraTriggerSourceText.class)));
    final SqlQuery<String[]> listSourceNames = this.myScriptum.query("ListSourceNames", Layouts.columnOf(String.class));
    final SqlQuery<List<OneSrcLine>> retrievePortionOfSources = this.myScriptum.query("RetrievePortionOfSources", Layouts.listOf((RowLayout)Layouts.structOf(OneSrcLine.class)));
    final SqlQuery<long[]> listInvalidObjectsFast = this.myScriptum.query("ListInvalidObjectsFast", Layouts.columnOfLongs((int)1000));
    final SqlQuery<long[]> listInvalidObjects = this.myScriptum.query("ListInvalidObjects", Layouts.columnOfLongs((int)1000));
    final SqlQuery<List<OneError>> retrieveErrors = this.myScriptum.query("RetrieveErrors", Layouts.listOf((RowLayout)Layouts.structOf(OneError.class)));
    final SqlQuery<long[]> retrieveDebugInfoPresence = this.myScriptum.query("RetrieveDebugInfoPresence", Layouts.columnOfLongs((int)1000));
    final SqlQuery<List<OneNativeDefinition>> retrieveNativeDefinitions = this.myScriptum.query("RetrieveNativeDefinitions", Layouts.listOf((RowLayout)Layouts.structOf(OneNativeDefinition.class)));
    final SqlQuery<List<OneState>> retrieveStatesFast = this.myScriptum.query("RetrieveStatesFast", Layouts.listOf((RowLayout)Layouts.structOf(OneState.class)));
    final SqlQuery<List<OneState>> retrieveStates = this.myScriptum.query("RetrieveStates", Layouts.listOf((RowLayout)Layouts.structOf(OneState.class)));
    final SqlQuery<Long> calculateTablespacesHashDba = this.myScriptum.query("CalculateTablespacesHashDba", Layouts.singleOf(Long.class));
    final SqlQuery<Long> calculateTablespacesHashUser = this.myScriptum.query("CalculateTablespacesHashUser", Layouts.singleOf(Long.class));
    final SqlQuery<List<OneTablespace>> retrieveTablespaces = this.myScriptum.query("RetrieveTablespaces", Layouts.listOf((RowLayout)Layouts.structOf(OneTablespace.class)));
    final SqlQuery<List<OneDataFile>> retrieveDataFiles = this.myScriptum.query("RetrieveDataFiles", Layouts.listOf((RowLayout)Layouts.structOf(OneDataFile.class)));
    final SqlQuery<List<OneUser>> retrieveDbUsers = this.myScriptum.query("RetrieveDatabaseUsers", Layouts.listOf((RowLayout)Layouts.structOf(OneUser.class)));

    static final class OneSessionInfo {
        String current_schema;
        String current_user;
        String database_name;
        Timestamp now;
        String nowstr;

        OneSessionInfo() {
        }
    }

    static final class OneServerInfo {
        byte tenant_category;

        OneServerInfo() {
        }
    }

    static final class OneSchemaInfo {
        long user_id;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;

        OneSchemaInfo() {
        }
    }

    static final class OneSynonym {
        String synonym_schema_name;
        long synonym_id;
        String synonym_name;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;
        String origin_db_link;
        String origin_schema_name;
        String origin_object_name;

        OneSynonym() {
        }
    }

    static final class OneColumnName {
        long major_id;
        char major_kind;
        short column_position;
        String column_name;

        OneColumnName() {
        }
    }

    static final class OneSlowColumnName {
        String schema_name;
        String table_name;
        short column_position;
        String column_name;

        OneSlowColumnName() {
        }
    }

    static final class OneMinorObjectName {
        long major_id;
        long minor_id;
        char major_kind;
        char minor_kind;
        String minor_name;
        boolean is_disabled;

        OneMinorObjectName() {
        }
    }

    static final class OneConstraintName {
        long major_id;
        char constraint_type;
        String constraint_name;
        boolean surrogate;
        boolean is_disabled;

        OneConstraintName() {
        }
    }

    static final class OneInnerRoutineName {
        long major_id;
        int routine_nr;
        short routine_overload;
        String routine_name;

        OneInnerRoutineName() {
        }
    }

    static final class OneArgumentName {
        long major_id;
        int routine_nr;
        short routine_overload;
        short argument_position;
        char argument_direction;
        String routine_name;
        String argument_name;

        OneArgumentName() {
        }
    }

    static final class OneSequence {
        String sequence_name;
        BigDecimal min_value;
        BigDecimal max_value;
        long increment_by;
        boolean cycle_flag;
        boolean order_flag;
        Integer cache_size;
        BigDecimal next_value;
        long object_id;
        boolean generated;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;

        OneSequence() {
        }
    }

    static final class OneObjectType {
        String type_name;
        String supertype_schema_name;
        String supertype_name;
        boolean is_incomplete;
        boolean is_final;
        boolean is_instantiable;
        long object_id;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;
        long body_object_id;
        Timestamp body_created_timestamp;
        Timestamp body_modified_timestamp;

        OneObjectType() {
        }
    }

    static final class OneCollectionType {
        long object_id;
        String type_name;
        char collection_kind;
        String data_type_schema_name;
        String data_type;
        int data_size;
        int data_scale;
        char data_size_units;
        int upper_bound;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;

        OneCollectionType() {
        }
    }

    static final class OneObjectTypeAttribute {
        String type_name;
        short position;
        String attr_name;
        String data_type_schema;
        String data_type;
        int data_size;
        int data_scale;
        char data_size_units;
        String attr_type_mod;

        OneObjectTypeAttribute() {
        }
    }

    static final class OneCluster {
        long id;
        char type_code;
        boolean single_table;
        int block_size;
        int hash_cardinality;
        String hash_expression;
        String tablespace_name;
        String decompiled_text;

        OneCluster() {
        }
    }

    static final class OneTable {
        String table_name;
        long object_id;
        char organization_kind;
        boolean has_mat_log;
        boolean is_mat_log;
        boolean is_mat_view;
        boolean is_temp;
        boolean is_temp_preserved;
        boolean surrogate;
        String master_table_name;
        String row_type_schema_name;
        String row_type_name;
        String cluster_name;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;

        OneTable() {
        }
    }

    static final class OneMatLog {
        String table_name;
        String log_name;
        boolean with_rowid;
        boolean with_object_id;
        boolean with_primary_key;
        boolean with_sequence;
        boolean with_new_values;

        OneMatLog() {
        }
    }

    static final class OneMatView {
        String view_name;
        long object_id;
        int text_length;
        boolean prebuilt;
        boolean modifiable;
        char refresh_method;
        char refresh_mode;
        boolean is_invalid;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;

        OneMatView() {
        }
    }

    static final class OneView {
        String view_name;
        long object_id;
        int text_length;
        boolean modifiable;
        boolean is_invalid;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;

        OneView() {
        }
    }

    static final class OneColumn {
        char major_kind;
        long major_id;
        short column_position;
        String column_name;
        String data_type_schema_name;
        String data_type;
        int data_size;
        int data_scale;
        char data_size_units;
        boolean mandatory;
        boolean explicit_precision;
        boolean computed;
        boolean identity_column;
        boolean default_on_null;
        int default_expression_length;
        boolean is_hidden;

        OneColumn() {
        }
    }

    static final class OneMinorText {
        String major_name;
        String minor_name;
        String text;

        OneMinorText() {
        }
    }

    static final class OneClusterIndex {
        String cluster_name;
        String index_name;
        long index_id;
        String tablespace_name;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;

        OneClusterIndex() {
        }
    }

    static final class OneTableClusterColumn {
        String table_name;
        String column_name;

        OneTableClusterColumn() {
        }
    }

    static final class OneIndex {
        String table_name;
        String index_name;
        boolean uniqueness;
        boolean clustering;
        boolean function_based;
        boolean bitmap;
        boolean surrogate;
        long object_id;
        String tablespace_name;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;
        String indextype_owner;
        String indextype_name;

        OneIndex() {
        }
    }

    static final class OneIndexItem {
        String table_name;
        String index_schema_name;
        String index_name;
        short column_position;
        char direction;
        String item;

        OneIndexItem() {
        }
    }

    static final class OneKey {
        String table_name;
        String constraint_name;
        boolean is_surrogate_name;
        boolean is_pk;
        boolean is_deferrable;
        boolean is_initially_deferred;
        boolean is_disabled;
        String index_schema_name;
        String index_name;
        Timestamp modified_timestamp;

        OneKey() {
        }
    }

    static final class OneForeignKey {
        long table_id;
        String table_name;
        String constraint_name;
        boolean is_surrogate_name;
        long ref_schema_id;
        String ref_schema_name;
        String ref_table_name;
        String ref_key_name;
        char cascade_rule;
        boolean is_deferrable;
        boolean is_initially_deferred;
        boolean is_disabled;
        Timestamp modified_timestamp;

        OneForeignKey() {
        }
    }

    static final class OneCheck {
        String table_name;
        String constraint_name;
        boolean is_surrogate_name;
        boolean is_deferrable;
        boolean is_initially_deferred;
        boolean is_disabled;
        Timestamp modified_timestamp;

        OneCheck() {
        }
    }

    static final class OneConstraintColumn {
        String table_name;
        String constraint_name;
        short column_position;
        String column_name;

        OneConstraintColumn() {
        }
    }

    static final class OneTrigger {
        String table_name;
        String trigger_schema_name;
        String trigger_name;
        long trigger_id;
        short turn;
        String events;
        boolean has_on_update_columns;
        String referencing_names;
        String condition;
        String action_type;
        boolean is_disabled;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;

        OneTrigger() {
        }
    }

    static final class OnePackage {
        long object_id;
        String package_name;
        boolean is_body;
        boolean is_invalid;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;

        OnePackage() {
        }
    }

    static final class OnePackageRoutine
    extends OneInnerRoutine {
        String module_name;
        String routine_name;
        short overload_nr;
        boolean is_deterministic;

        OnePackageRoutine() {
        }

        @Override
        String getModuleName() {
            return this.module_name;
        }

        @Override
        String getRoutineName() {
            return this.routine_name;
        }

        @Override
        short getOverloadNr() {
            return this.overload_nr;
        }

        @Override
        boolean isDeterministic() {
            return this.is_deterministic;
        }
    }

    static final class OneTypeMethod
    extends OneInnerRoutine {
        String module_name;
        String routine_name;
        short overload_nr;
        boolean is_deterministic;
        boolean is_final;
        boolean is_instantiable;
        boolean is_overriding;

        OneTypeMethod() {
        }

        @Override
        String getModuleName() {
            return this.module_name;
        }

        @Override
        String getRoutineName() {
            return this.routine_name;
        }

        @Override
        short getOverloadNr() {
            return this.overload_nr;
        }

        @Override
        boolean isDeterministic() {
            return this.is_deterministic;
        }
    }

    static final class OneInnerRoutineArgument {
        String package_name;
        String routine_name;
        short overload_nr;
        short position;
        String arg_name;
        char arg_direction;
        String type_mod;
        String data_type_schema_name;
        String data_type_package_name;
        String data_type;
        boolean is_defaulted;

        OneInnerRoutineArgument() {
        }
    }

    static final class OneSingleRoutine {
        String name;
        char kind;
        boolean is_invalid;
        long object_id;
        boolean is_deterministic;
        Timestamp created_timestamp;
        Timestamp modified_timestamp;

        OneSingleRoutine() {
        }
    }

    static final class OneSingleRoutineArgument {
        String routine_name;
        String arg_name;
        short position;
        char arg_direction;
        String type_mod;
        String data_type_schema_name;
        String data_type_package_name;
        String data_type;
        boolean is_defaulted;

        OneSingleRoutineArgument() {
        }
    }

    static final class OneDbLink {
        String name;
        String remote_db;
        String connect_user_name;
        String src;
        Timestamp created_timestamp;

        OneDbLink() {
        }
    }

    static final class OneComment {
        String table_name;
        String column_name;
        String comments;

        OneComment() {
        }
    }

    static final class OneDependency {
        long object_id;
        long referenced_id;

        OneDependency() {
        }
    }

    static final class OneSlowDependency {
        String type;
        String name;
        String referenced_schema_name;
        String referenced_type;
        String referenced_name;
        long referenced_id;

        OneSlowDependency() {
        }
    }

    static final class OneSrcLine {
        String type;
        String name;
        String text;

        OneSrcLine() {
        }
    }

    static final class OneError {
        String name;
        char type_code;
        boolean is_body;
        int line;
        int position;
        String message;

        OneError() {
        }
    }

    static final class OneNativeDefinition {
        long object_id;
        String text;

        OneNativeDefinition() {
        }
    }

    static final class OneState {
        long object_id;
        Timestamp modified_timestamp;

        OneState() {
        }
    }

    static final class OneTablespace {
        String name;
        int block_size;
        char content_category;
        byte logging;
        char status;
        boolean bigfile;
        boolean local_extent_management;
        boolean auto_segment_management;

        OneTablespace() {
        }
    }

    static final class OneDataFile {
        String tablespace_name;
        short position;
        int file_id;
        String file_name;
        long file_size;
        long user_size;
        long increment_by;
        long max_size;
        boolean auto_extensible;
        char availability_status;
        char online_status;

        OneDataFile() {
        }
    }

    static final class OneUser {
        long user_id;
        String username;
        String account_status;
        String default_tablespace;
        String temporary_tablespace;
        String profile;

        OneUser() {
        }
    }

    static abstract class OneInnerRoutine {
        OneInnerRoutine() {
        }

        abstract String getModuleName();

        abstract String getRoutineName();

        abstract short getOverloadNr();

        abstract boolean isDeterministic();
    }
}

