/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.debugger.SqlProgramSource;
import com.intellij.database.dialects.oracle.debugger.OraNamespace;
import com.intellij.database.dialects.oracle.debugger.OraProgram;
import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraMatViewTrigger;
import com.intellij.database.dialects.oracle.model.OraModel;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableTrigger;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.OraView;
import com.intellij.database.dialects.oracle.model.OraViewTrigger;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.containers.SLRUCache;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\tJ\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\tH\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020\u001cH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R;\u0010\u0007\u001a/\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \n*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u000b0\b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraProgramSources;", "", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;)V", "programCache", "Lcom/intellij/util/containers/SLRUCache;", "Lcom/intellij/database/dialects/oracle/debugger/OraProgram;", "kotlin.jvm.PlatformType", "Ljava/util/Optional;", "Lcom/intellij/database/debugger/SqlProgramSource;", "Lorg/jetbrains/annotations/NotNull;", "psiManager", "Lcom/intellij/psi/PsiManager;", "findAssociatedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "modelElement", "Lcom/intellij/database/dialects/oracle/model/OraSourceAware;", "findProgramSource", "program", "getProgramSource", "resolveBodyObject", "Lcom/intellij/database/dialects/oracle/model/OraBody;", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "name", "", "resolveModelElement", "resolveModelProgramObject", "namespace", "Lcom/intellij/database/dialects/oracle/debugger/OraNamespace;", "programName", "resolveModelSchemaObject", "schemaName", "resolveTopLevelProgramObject", "resolveTriggerObject", "Lcom/intellij/database/dialects/oracle/model/OraTrigger;", "intellij.database.dialects.oracle.ex"})
public final class OraProgramSources {
    @NotNull
    private final Project project;
    @NotNull
    private final LocalDataSource ds;
    @NotNull
    private final PsiManager psiManager;
    @NotNull
    private final SLRUCache<OraProgram, Optional<SqlProgramSource>> programCache;

    public OraProgramSources(@NotNull Project project, @NotNull LocalDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        this.project = project;
        this.ds = ds;
        PsiManager psiManager = PsiManagerImpl.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.psiManager = psiManager;
        SLRUCache sLRUCache = SLRUCache.slruCache((int)7, (int)7, this::findProgramSource);
        Intrinsics.checkNotNullExpressionValue((Object)sLRUCache, (String)"slruCache(...)");
        this.programCache = sLRUCache;
    }

    @Nullable
    public final SqlProgramSource getProgramSource(@NotNull OraProgram program) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        return ((Optional)this.programCache.get((Object)program)).orElse(null);
    }

    private final Optional<SqlProgramSource> findProgramSource(OraProgram program) {
        OraSourceAware oraSourceAware = this.resolveModelElement(program);
        if (oraSourceAware == null) {
            Optional<SqlProgramSource> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        OraSourceAware modelElement = oraSourceAware;
        VirtualFile virtualFile = this.findAssociatedVirtualFile(modelElement);
        if (virtualFile == null) {
            Optional<SqlProgramSource> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile = this.psiManager.findFile(virtualFile2);
        ObjectKind objectKind = modelElement.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        Optional<SqlProgramSource> optional = Optional.of(new SqlProgramSource(objectKind, modelElement, virtualFile2, psiFile));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    private final OraSourceAware resolveModelElement(OraProgram program) {
        OraSchema oraSchema = this.resolveModelSchemaObject(program.getSchemaName());
        if (oraSchema == null) {
            return null;
        }
        OraSchema schema2 = oraSchema;
        return this.resolveModelProgramObject(schema2, program.getNamespace(), program.getProgramName());
    }

    private final OraSchema resolveModelSchemaObject(String schemaName) {
        DasModel dasModel = this.ds.getModel();
        OraModel oraModel = dasModel instanceof OraModel ? (OraModel)dasModel : null;
        if (oraModel == null) {
            return null;
        }
        OraModel model2 = oraModel;
        OraRoot oraRoot = model2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)oraRoot, (String)"getRoot(...)");
        OraRoot database = oraRoot;
        return (OraSchema)database.getSchemas().get(schemaName);
    }

    private final OraSourceAware resolveModelProgramObject(OraSchema schema2, OraNamespace namespace, String programName) {
        return switch (WhenMappings.$EnumSwitchMapping$0[namespace.ordinal()]) {
            case 1, 2 -> null;
            case 3 -> this.resolveTopLevelProgramObject(schema2, programName);
            case 4 -> this.resolveBodyObject(schema2, programName);
            case 5 -> this.resolveTriggerObject(schema2, programName);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final OraSourceAware resolveTopLevelProgramObject(OraSchema schema2, String name2) {
        OraSingleRoutine routine2 = (OraSingleRoutine)schema2.getRoutines().get(name2);
        if (routine2 != null) {
            return routine2;
        }
        OraPackage oraPackage = (OraPackage)schema2.getPackages().get(name2);
        if (oraPackage != null) {
            return oraPackage;
        }
        OraObjectType objectType = (OraObjectType)schema2.getObjectTypes().get(name2);
        if (objectType != null) {
            return objectType;
        }
        return null;
    }

    private final OraBody resolveBodyObject(OraSchema schema2, String name2) {
        OraPackage oraPackage = (OraPackage)schema2.getPackages().get(name2);
        if (oraPackage != null) {
            return (OraBody)oraPackage.getBodies().get();
        }
        OraObjectType objectType = (OraObjectType)schema2.getObjectTypes().get(name2);
        if (objectType != null) {
            return (OraBody)objectType.getBodies().get();
        }
        return null;
    }

    private final OraTrigger resolveTriggerObject(OraSchema schema2, String name2) {
        OraTrigger trigger2;
        for (OraTable oraTable : schema2.getTables()) {
            OraTableTrigger trigger22 = (OraTableTrigger)oraTable.getTriggers().get(name2);
            if (!(trigger22 instanceof OraTrigger)) continue;
            return trigger22;
        }
        for (OraMatView oraMatView : schema2.getMatViews()) {
            trigger2 = (OraMatViewTrigger)oraMatView.getTriggers().get(name2);
            if (!(trigger2 instanceof OraTrigger)) continue;
            return trigger2;
        }
        for (OraView oraView : schema2.getViews()) {
            trigger2 = (OraViewTrigger)oraView.getTriggers().get(name2);
            if (!(trigger2 instanceof OraTrigger)) continue;
            return trigger2;
        }
        return null;
    }

    private final VirtualFile findAssociatedVirtualFile(OraSourceAware modelElement) {
        return DbSrcUtils.findDbSrcFile(this.project, this.ds, modelElement, null, true);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OraNamespace.values().length];
            try {
                nArray[OraNamespace.NS_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraNamespace.NS_CURSOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraNamespace.NS_TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraNamespace.NS_BODY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraNamespace.NS_TRIGGER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

