/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.BaseAffectAnalysisFun;
import com.intellij.database.dialects.base.BaseAffectAnalyzer;
import com.intellij.database.dialects.oracle.OraAffectAnalyzerKt;
import com.intellij.database.introspection.BelongingAreaKind;
import com.intellij.database.introspection.ObjectAffectionType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.SearchPath;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.oracle.psi.OraCreatePackageBodyStatementImpl;
import com.intellij.sql.dialects.oracle.psi.OraCreatePackageStatementImpl;
import com.intellij.sql.dialects.oracle.psi.OraCreateTypeBodyStatementImpl;
import com.intellij.sql.dialects.oracle.psi.OraCreateTypeStatementImpl;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.impl.SqlDefinitionHolderStatementImpl;
import com.intellij.sql.psi.impl.SqlDropStatementImpl;
import com.intellij.sql.psi.impl.SqlRenameToClauseImpl;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/oracle/OraAffectAnalyzer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "()V", "prepareDeterminer", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "dbms", "Lcom/intellij/database/Dbms;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "OraDeterminer", "intellij.database.dialects.oracle"})
public final class OraAffectAnalyzer
extends BaseAffectAnalyzer {
    @Override
    @NotNull
    protected BaseAffectAnalyzer.Determiner prepareDeterminer(@NotNull Dbms dbms, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return new OraDeterminer(searchPath);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/oracle/OraAffectAnalyzer$OraDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$SingleDatabaseDeterminer;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/database/util/SearchPath;)V", "analyzeDdlStatement", "", "statement", "Lcom/intellij/sql/psi/SqlDdlStatement;", "analyzeDropStatement", "Lcom/intellij/sql/psi/impl/SqlDropStatementImpl;", "handleAlterStatement", "Lcom/intellij/sql/psi/SqlAlterStatement;", "handleCreateProgram", "Lcom/intellij/sql/psi/SqlCreateStatement;", "programKind", "Lcom/intellij/database/model/ObjectKind;", "isSpec", "", "handleRenameClause", "renameClause", "Lcom/intellij/sql/psi/SqlRenameToClause;", "handleRenameNewStyle", "Lcom/intellij/sql/psi/impl/SqlDefinitionHolderStatementImpl;", "intellij.database.dialects.oracle"})
    @SourceDebugExtension(value={"SMAP\nOraAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraAffectAnalyzer.kt\ncom/intellij/database/dialects/oracle/OraAffectAnalyzer$OraDeterminer\n+ 2 BaseAffectAnalysisFun.kt\ncom/intellij/database/dialects/base/BaseAffectAnalysisFun\n+ 3 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n33#2:97\n256#3:98\n256#3:99\n436#4:100\n288#5,2:101\n*S KotlinDebug\n*F\n+ 1 OraAffectAnalyzer.kt\ncom/intellij/database/dialects/oracle/OraAffectAnalyzer$OraDeterminer\n*L\n61#1:97\n68#1:98\n80#1:99\n86#1:100\n86#1:101,2\n*E\n"})
    private static final class OraDeterminer
    extends BaseAffectAnalyzer.SingleDatabaseDeterminer {
        public OraDeterminer(@Nullable SearchPath searchPath) {
            super(searchPath);
        }

        @Override
        protected void analyzeDdlStatement(@NotNull SqlDdlStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlDdlStatement sqlDdlStatement = statement2;
            if (sqlDdlStatement instanceof SqlAlterStatement) {
                this.handleAlterStatement((SqlAlterStatement)statement2);
            } else if (sqlDdlStatement instanceof SqlDefinitionHolderStatementImpl) {
                this.handleRenameNewStyle((SqlDefinitionHolderStatementImpl)statement2);
            } else if (sqlDdlStatement instanceof OraCreatePackageStatementImpl) {
                SqlCreateStatement sqlCreateStatement = (SqlCreateStatement)statement2;
                ObjectKind objectKind = ObjectKind.PACKAGE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PACKAGE");
                this.handleCreateProgram(sqlCreateStatement, objectKind, true);
            } else if (sqlDdlStatement instanceof OraCreatePackageBodyStatementImpl) {
                SqlCreateStatement sqlCreateStatement = (SqlCreateStatement)statement2;
                ObjectKind objectKind = ObjectKind.PACKAGE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PACKAGE");
                this.handleCreateProgram(sqlCreateStatement, objectKind, false);
            } else if (sqlDdlStatement instanceof OraCreateTypeStatementImpl) {
                SqlCreateStatement sqlCreateStatement = (SqlCreateStatement)statement2;
                ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OBJECT_TYPE");
                this.handleCreateProgram(sqlCreateStatement, objectKind, true);
            } else if (sqlDdlStatement instanceof OraCreateTypeBodyStatementImpl) {
                SqlCreateStatement sqlCreateStatement = (SqlCreateStatement)statement2;
                ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OBJECT_TYPE");
                this.handleCreateProgram(sqlCreateStatement, objectKind, false);
            } else {
                super.analyzeDdlStatement(statement2);
            }
        }

        @Override
        protected void analyzeDropStatement(@NotNull SqlDropStatementImpl statement2) {
            Intrinsics.checkNotNullParameter((Object)((Object)statement2), (String)"statement");
            ObjectKind kind = statement2.getTargetType();
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.BODY)) {
                PsiElement w = BaseAffectAnalysisFun.findChild((PsiElement)statement2, OraAffectAnalyzerKt.access$getPsiTypeOrPackageTypes$p());
                PsiElement psiElement = w;
                if (Intrinsics.areEqual((Object)psiElement, (Object)SqlCommonKeywords.SQL_TYPE)) {
                    kind = ObjectKind.OBJECT_TYPE;
                } else if (Intrinsics.areEqual((Object)psiElement, (Object)SqlCommonKeywords.SQL_PACKAGE)) {
                    kind = ObjectKind.PACKAGE;
                }
                BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, ObjectAffectionType.WAS_DROPPED, BelongingAreaKind.A_SCHEMA, kind, (SqlNameElement)statement2.getTargetExpression(), 0, 16, null);
            } else {
                super.analyzeDropStatement(statement2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void handleCreateProgram(SqlCreateStatement statement2, ObjectKind programKind, boolean isSpec) {
            void $this$hasChild$iv;
            PsiElement psiElement = statement2.getNameIdentifier();
            String string = psiElement != null ? psiElement.getText() : null;
            if (string == null) {
                return;
            }
            String identifierText = string;
            PsiElement psiElement2 = (PsiElement)statement2;
            Set types$iv = OraAffectAnalyzerKt.access$getPsiReplaceOrUpdateTypes$p();
            boolean $i$f$hasChild = false;
            boolean orReplace = BaseAffectAnalysisFun.findChild((PsiElement)$this$hasChild$iv, types$iv) != null;
            ObjectAffectionType action = isSpec && !orReplace ? ObjectAffectionType.WAS_CREATED : ObjectAffectionType.WAS_ALTERED;
            BaseAffectAnalyzer.Determiner.handleIdentifier$default(this, action, BelongingAreaKind.A_SCHEMA, programKind, identifierText, (PsiElement)statement2, 0, 32, null);
        }

        private final void handleAlterStatement(SqlAlterStatement statement2) {
            SqlReferenceExpression sqlReferenceExpression = statement2.getAlterTargetReference();
            if (sqlReferenceExpression == null) {
                return;
            }
            SqlReferenceExpression objectRef = sqlReferenceExpression;
            BaseAffectAnalyzer.Companion companion = BaseAffectAnalyzer.Companion;
            PsiElement $this$child$iv = (PsiElement)statement2;
            boolean $i$f$child = false;
            SqlRenameToClauseImpl renameClause = (SqlRenameToClauseImpl)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlRenameToClauseImpl.class, (boolean)false);
            if (renameClause == null) {
                BaseAffectAnalyzer.Determiner.handleReference$default(this, ObjectAffectionType.WAS_ALTERED, null, objectRef, 0, 8, null);
            } else {
                SqlNameElement newNameElement = renameClause.getNameElement();
                this.handleRename(BelongingAreaKind.A_SCHEMA, objectRef, (SqlElement)newNameElement);
            }
        }

        private final void handleRenameNewStyle(SqlDefinitionHolderStatementImpl statement2) {
            BaseAffectAnalyzer.Companion companion = BaseAffectAnalyzer.Companion;
            PsiElement $this$child$iv = (PsiElement)statement2;
            boolean $i$f$child = false;
            SqlRenameToClause renameClause = (SqlRenameToClause)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlRenameToClause.class, (boolean)false);
            if (renameClause != null) {
                this.handleRenameClause(renameClause);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void handleRenameClause(SqlRenameToClause renameClause) {
            Object v1;
            SqlReferenceExpression originReference;
            block1: {
                void $this$firstOrNull$iv;
                originReference = renameClause.getTargetReference();
                Object $this$childrenOfType$iv = (PsiElement)renameClause;
                boolean $i$f$childrenOfType = false;
                List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, SqlIdentifier.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                $this$childrenOfType$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SqlIdentifier it2 = (SqlIdentifier)element$iv;
                    boolean bl = false;
                    if (!(it2 != originReference)) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            SqlIdentifier targetIdentifier = v1;
            this.handleRename(BelongingAreaKind.A_SCHEMA, ObjectKind.SCHEMA_OBJECT, (SqlNameElement)originReference, (SqlElement)targetIdentifier);
        }
    }
}

