/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.ssrp;

import com.intellij.database.dialects.mssql.ssrp.SsrpConstants;
import com.intellij.database.dialects.mssql.ssrp.SsrpDecoder;
import com.intellij.database.dialects.mssql.ssrp.SsrpEncoder;
import com.intellij.database.dialects.mssql.ssrp.SsrpInfo;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SsrpNet {
    public static Set<Response> queryNetworkInstances(int port, int timeout) throws SsrpConstants.SsrpException {
        DatagramSocket sock = null;
        HashSet<Response> result2 = new HashSet<Response>();
        Consumer consumer2 = response -> result2.add((Response)response);
        try {
            sock = new DatagramSocket();
            sock.setBroadcast(true);
            byte[] req2 = SsrpEncoder.createClientBroadcastReq();
            sock.setSoTimeout(timeout);
            sock.send(new DatagramPacket(req2, req2.length, InetAddress.getByName("255.255.255.255"), port));
            DatagramPacket packet = SsrpNet.allocateLargePacket();
            while (SsrpNet.appendResponseOrTimeout(Collections.emptyMap(), sock, packet, (Consumer<Response>)consumer2) != Boolean.FALSE) {
            }
            HashSet<Response> hashSet = result2;
            return hashSet;
        }
        catch (IOException e2) {
            throw new SsrpConstants.SsrpException(e2);
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    @NotNull
    public static Set<Response> queryNetworkInstances(@NotNull Set<String> hosts, int port, int timeout) throws SsrpConstants.SsrpException {
        HashSet hashSet;
        if (hosts == null) {
            SsrpNet.$$$reportNull$$$0(0);
        }
        DatagramSocket sock = null;
        HashSet result2 = new HashSet();
        HashSet added = new HashSet();
        Consumer consumer2 = response -> {
            result2.add(response);
            added.add(response.host);
        };
        try {
            Boolean res2;
            sock = new DatagramSocket();
            byte[] req2 = SsrpEncoder.createClientUnicastReq();
            sock.setSoTimeout(timeout);
            HashMap<InetAddress, String> addr2host = new HashMap<InetAddress, String>();
            HashMap<String, InetAddress> host2addr = new HashMap<String, InetAddress>();
            int count = 0;
            for (String host : hosts) {
                try {
                    InetAddress address = InetAddress.getByName(host);
                    addr2host.put(address, host);
                    host2addr.put(host, address);
                    sock.send(new DatagramPacket(req2, req2.length, address, port));
                    ++count;
                }
                catch (UnknownHostException e2) {
                    consumer2.consume((Object)SsrpNet.createUnknownHost(host));
                }
            }
            DatagramPacket packet = SsrpNet.allocateLargePacket();
            int i2 = 0;
            while (i2 < count && (res2 = SsrpNet.appendResponseOrTimeout(addr2host, sock, packet, (Consumer<Response>)consumer2)) != Boolean.FALSE) {
                if (res2 == null) continue;
                ++i2;
            }
            for (String host : hosts) {
                if (added.contains(host)) continue;
                consumer2.consume((Object)SsrpNet.createNoResponse(host, (InetAddress)host2addr.get(host)));
            }
            HashSet hashSet2 = result2;
            hashSet = hashSet2;
        }
        catch (IOException e3) {
            throw new SsrpConstants.SsrpException(e3);
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
        if (hashSet == null) {
            SsrpNet.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public static Response queryInstances(@NotNull String host, int port, int timeout) throws SsrpConstants.SsrpException {
        if (host == null) {
            SsrpNet.$$$reportNull$$$0(2);
        }
        DatagramSocket sock = null;
        Ref result2 = Ref.create();
        Consumer consumer2 = response -> result2.set(response);
        try {
            sock = new DatagramSocket();
            byte[] req2 = SsrpEncoder.createClientUnicastReq();
            sock.setSoTimeout(timeout);
            InetAddress address = InetAddress.getByName(host);
            sock.send(new DatagramPacket(req2, req2.length, address, port));
            DatagramPacket packet = SsrpNet.allocateLargePacket();
            while (SsrpNet.appendResponseOrTimeout(Collections.singletonMap(address, host), sock, packet, (Consumer<Response>)consumer2) == null) {
            }
            if (result2.get() != null) {
                Response response2 = (Response)result2.get();
                return response2;
            }
            Response response3 = SsrpNet.createNoResponse(host, address);
            return response3;
        }
        catch (UnknownHostException e2) {
            Response response4 = SsrpNet.createUnknownHost(host);
            return response4;
        }
        catch (IOException e3) {
            throw new SsrpConstants.SsrpException(e3);
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    @NotNull
    private static Response createNoResponse(@NotNull String host, InetAddress address) {
        if (host == null) {
            SsrpNet.$$$reportNull$$$0(3);
        }
        return new Response(SsrpInfo.concat("ServerName", host, "SsrpError", "NoResponse"), host, address);
    }

    @NotNull
    private static Response createUnknownHost(@NotNull String host) {
        if (host == null) {
            SsrpNet.$$$reportNull$$$0(4);
        }
        return new Response(SsrpInfo.concat("ServerName", host, "SsrpError", "UnknownHost"), host, null);
    }

    @NotNull
    private static DatagramPacket allocateLargePacket() {
        byte[] responseBuffer = new byte[65600];
        return new DatagramPacket(responseBuffer, responseBuffer.length);
    }

    private static Boolean appendResponseOrTimeout(@NotNull Map<InetAddress, String> addr2host, @NotNull DatagramSocket sock, @NotNull DatagramPacket buffer, @NotNull Consumer<Response> consumer2) throws SsrpConstants.SsrpException {
        if (addr2host == null) {
            SsrpNet.$$$reportNull$$$0(5);
        }
        if (sock == null) {
            SsrpNet.$$$reportNull$$$0(6);
        }
        if (buffer == null) {
            SsrpNet.$$$reportNull$$$0(7);
        }
        if (consumer2 == null) {
            SsrpNet.$$$reportNull$$$0(8);
        }
        try {
            sock.receive(buffer);
            String resp = SsrpDecoder.decodeResponseString(ByteBuffer.wrap(buffer.getData()));
            if (resp == null) {
                return null;
            }
            consumer2.consume((Object)new Response(resp, addr2host.get(buffer.getAddress()), buffer.getAddress()));
        }
        catch (SocketTimeoutException e2) {
            return false;
        }
        catch (IOException e3) {
            throw new SsrpConstants.SsrpException(e3);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hosts";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/ssrp/SsrpNet";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addr2host";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sock";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/ssrp/SsrpNet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "queryNetworkInstances";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "queryNetworkInstances";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "queryInstances";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNoResponse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUnknownHost";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendResponseOrTimeout";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class Response {
        public String response;
        public String host;
        public InetAddress addr;

        public Response(String response, String host, InetAddress addr) {
            this.response = response;
            this.host = host;
            this.addr = addr;
        }
    }
}

