/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.generator.producers;

import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateSequence;
import com.intellij.database.dialects.mssql.generator.MsScriptGeneratorHelperKt;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001a\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0002H\u0014J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0012*\u00020\u0002H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/mssql/generator/producers/MsCreateSequence;", "Lcom/intellij/database/dialects/base/generator/producers/CreateSequence;", "Lcom/intellij/database/dialects/mssql/model/MsSequence;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/mssql/model/MsSequence;)V", "gatherSequenceIdentityParameters", "", "sequence", "parameters", "", "", "produceComment", "exists", "", "comment", "maximumDefault", "Ljava/math/BigInteger;", "minimumDefault", "intellij.database.dialects.mssql"})
public final class MsCreateSequence
extends CreateSequence<MsSequence> {
    public MsCreateSequence(@NotNull ScriptingContext context, @NotNull MsSequence element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        super(context, (BasicSequence)element2);
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        MsScriptGeneratorHelperKt.msAlterComment(this, exists, comment);
    }

    @Override
    public void gatherSequenceIdentityParameters(@NotNull MsSequence sequence, @NotNull List<String> parameters2) {
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        DasType dasType = sequence.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = dasType;
        if (!Intrinsics.areEqual((Object)dasType2, DasTypeSystemBase.UNKNOWN) && !StringsKt.equals((String)DasTypeUtilsKt.getTypeName(dasType2), (String)"bigint", (boolean)true)) {
            Collection collection2 = parameters2;
            DasType dasType3 = sequence.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"getDasType(...)");
            collection2.add("as " + this.script(dasType3));
        }
        super.gatherSequenceIdentityParameters((BasicSequence)sequence, parameters2);
        if (sequence.isCycled()) {
            parameters2.add("cycle");
        }
        if (sequence.getCacheSize() < 0L) {
            parameters2.add("no cache");
        } else if (sequence.getCacheSize() > 0L) {
            parameters2.add("cache " + sequence.getCacheSize());
        }
    }

    @Override
    @Nullable
    protected BigInteger minimumDefault(@NotNull MsSequence $this$minimumDefault) {
        Intrinsics.checkNotNullParameter((Object)$this$minimumDefault, (String)"<this>");
        DasType dasType = $this$minimumDefault.getUnderlyingType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getUnderlyingType(...)");
        return DasTypeUtilsKt.getMinValue(dasType);
    }

    @Override
    @Nullable
    protected BigInteger maximumDefault(@NotNull MsSequence $this$maximumDefault) {
        Intrinsics.checkNotNullParameter((Object)$this$maximumDefault, (String)"<this>");
        DasType dasType = $this$maximumDefault.getUnderlyingType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getUnderlyingType(...)");
        return DasTypeUtilsKt.getMaxValue(dasType);
    }
}

