/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.database.dialects.mssql.MsExecutionEnvironmentHelper;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.impl.SqlSequenceValueExpressionImpl;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.FilteredTraverserBase;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J<\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014j\u0002`\u00150\u0013H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/mssql/MsExecutionEnvironmentHelper;", "Lcom/intellij/database/dialects/base/BaseExecutionEnvironmentHelper;", "()V", "getSslState", "Lcom/intellij/util/ThreeState;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "isSafeToLimitRowCount", "", "text", "", "project", "Lcom/intellij/openapi/project/Project;", "runInSpecificEnvironment", "", "sql", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "execution", "Lcom/intellij/util/ThrowableRunnable;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "setRowcount", "maxRows", "", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsExecutionEnvironmentHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsExecutionEnvironmentHelper.kt\ncom/intellij/database/dialects/mssql/MsExecutionEnvironmentHelper\n+ 2 StandardResultsProcessors.kt\ncom/intellij/database/dataSource/connection/statements/StandardResultsProcessors\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n149#2:79\n1726#3,3:80\n*S KotlinDebug\n*F\n+ 1 MsExecutionEnvironmentHelper.kt\ncom/intellij/database/dialects/mssql/MsExecutionEnvironmentHelper\n*L\n26#1:79\n68#1:80,3\n*E\n"})
public final class MsExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @Override
    @NotNull
    public ThreeState getSslState(@NotNull DatabaseConnectionCore connection2) {
        String encryption;
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        boolean $i$f$first = false;
        String string = encryption = (String)SmartStatementFactoryService.Companion.getInstance().poweredBy(connection2).simple().execute("select encrypt_option from sys.dm_exec_connections where session_id = @@spid", (ExecutionMode)StandardExecutionMode.QUERY, new ResultsProducer.VoidReadyProcessor<String>(){

            public String empty() {
                Object rs = null;
                boolean bl = false;
                return null;
            }

            public String results(@NotNull RemoteResultSet resultSet, int subQueryIndex, int resultSetIndex, @Nullable ResultsProducer.ReferenceInfo referenceInfo, @NotNull Function2<? super RemoteResultSet, ? super ResultsProducer.ReferenceInfo, Unit> referenceConsumer) {
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
                Intrinsics.checkNotNullParameter(referenceConsumer, (String)"referenceConsumer");
                RemoteResultSet rs = resultSet.next() ? resultSet : null;
                boolean bl = false;
                RemoteResultSet remoteResultSet = rs;
                return remoteResultSet != null ? remoteResultSet.getString(1) : null;
            }

            public String parameterResults(@NotNull List<? extends OutParameter<?>> parameters2, int subQueryIndex, int resultSetIndex, @NotNull Function1<? super OutParameter<?>, ? extends Object> retriever) {
                Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
                Intrinsics.checkNotNullParameter(retriever, (String)"retriever");
                Object rs = null;
                boolean bl = false;
                return null;
            }

            public String updateCount(int count) {
                Object rs = null;
                boolean bl = false;
                return null;
            }
        }).rightOr((Object)null);
        return Intrinsics.areEqual((Object)string, (Object)"TRUE") ? ThreeState.YES : (Intrinsics.areEqual((Object)string, (Object)"FALSE") ? ThreeState.NO : ThreeState.UNSURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runInSpecificEnvironment(@NotNull String sql, @NotNull Configuration configuration, @NotNull DatabaseConnectionCore connection2, @Nullable Project project, @NotNull ThrowableRunnable<Exception> execution) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter(execution, (String)"execution");
        Integer maxRows = configuration.getMaxRows();
        boolean patch = false;
        if (maxRows != null && !GridUtilCore.isPageSizeUnlimited((int)maxRows) && this.isSafeToLimitRowCount(sql, project)) {
            this.setRowcount(maxRows, connection2);
            patch = true;
        }
        try {
            execution.run();
        }
        finally {
            if (patch) {
                this.setRowcount(0, connection2);
            }
        }
    }

    private final void setRowcount(int maxRows, DatabaseConnectionCore connection2) {
        SmartStatementFactoryService.Companion.getInstance().poweredBy(connection2).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute("SET ROWCOUNT " + maxRows, setRowcount.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSafeToLimitRowCount(String text2, Project project) {
        boolean bl;
        block4: {
            void $this$all$iv;
            if (project == null) {
                return false;
            }
            SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)sqlPsiFacade, (String)"getInstance(...)");
            SqlPsiFacade psiFacade2 = sqlPsiFacade;
            SqlFile sqlFile = psiFacade2.createROFile(DbSqlUtilCore.getSqlDialect(Dbms.MSSQL), (CharSequence)text2, null);
            Intrinsics.checkNotNullExpressionValue((Object)sqlFile, (String)"createROFile(...)");
            SqlFile sql = sqlFile;
            FilteredTraverserBase filteredTraverserBase = SyntaxTraverser.psiTraverser().withRoot((Object)sql);
            Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"withRoot(...)");
            SyntaxTraverser traverser2 = (SyntaxTraverser)filteredTraverserBase;
            FilteredTraverserBase filteredTraverserBase2 = traverser2.expandAndSkip(arg_0 -> MsExecutionEnvironmentHelper.isSafeToLimitRowCount$lambda$1(isSafeToLimitRowCount.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase2, (String)"expandAndSkip(...)");
            Iterable iterable = (Iterable)filteredTraverserBase2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiElement statement2 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(statement2 instanceof SqlCompositeElement) ? true : statement2 instanceof SqlSelectStatement && PsiTreeUtil.findChildOfType((PsiElement)statement2, SqlFunctionCallExpression.class) == null && PsiTreeUtil.findChildOfType((PsiElement)statement2, SqlSelectIntoClause.class) == null && PsiTreeUtil.findChildOfType((PsiElement)statement2, SqlSequenceValueExpressionImpl.class) == null) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean isSafeToLimitRowCount$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

