/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.translator.tree_creator.builder;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.mongo.translator.MongoToDatabaseScriptTranslator;
import com.intellij.database.dialects.mongo.translator.tree.MongoIdentifier;
import com.intellij.database.dialects.mongo.translator.tree.expression.MongoConstructorOperator;
import com.intellij.database.dialects.mongo.translator.tree.expression.MongoFunctionOperator;
import com.intellij.database.dialects.mongo.translator.tree.expression.function.IMongoArgumentList;
import com.intellij.database.dialects.mongo.translator.tree.expression.function.IMongoFunction;
import com.intellij.database.dialects.mongo.translator.tree.expression.function.MongoFunction;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.MongoConstructorArgumentList;
import com.intellij.database.dialects.mongo.translator.tree.expression.literal.MongoLiteralConstructed;
import com.intellij.database.dialects.mongo.translator.tree_creator.builder.IMongoFunctionBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\fH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/mongo/translator/tree_creator/builder/MongoFunctionBuilder;", "Lcom/intellij/database/dialects/mongo/translator/tree_creator/builder/IMongoFunctionBuilder;", "o", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "root", "Lcom/intellij/sql/psi/SqlElement;", "(Lcom/intellij/sql/psi/SqlFunctionCallExpression;Lcom/intellij/sql/psi/SqlElement;)V", "argumentList", "Lcom/intellij/database/dialects/mongo/translator/tree/expression/function/IMongoArgumentList;", "callableIdentifier", "Lcom/intellij/database/dialects/mongo/translator/tree/MongoIdentifier;", "isAggregateCall", "", "getO", "()Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "getRoot", "()Lcom/intellij/sql/psi/SqlElement;", "withNew", "v", "build", "Lcom/intellij/database/dialects/mongo/translator/tree/expression/function/IMongoFunction;", "convertConstructorOpName", "Lcom/intellij/database/dialects/mongo/translator/tree/expression/MongoConstructorOperator;", "name", "", "convertFunctionOpName", "Lcom/intellij/database/dialects/mongo/translator/tree/expression/MongoFunctionOperator;", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nMongoFunctionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoFunctionBuilder.kt\ncom/intellij/database/dialects/mongo/translator/tree_creator/builder/MongoFunctionBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1#2:234\n*E\n"})
public final class MongoFunctionBuilder
implements IMongoFunctionBuilder {
    @NotNull
    private final SqlFunctionCallExpression o;
    @NotNull
    private final SqlElement root;
    private boolean isAggregateCall;
    private boolean withNew;
    @Nullable
    private MongoIdentifier callableIdentifier;
    @Nullable
    private IMongoArgumentList argumentList;

    public MongoFunctionBuilder(@NotNull SqlFunctionCallExpression o2, @NotNull SqlElement root2) {
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this.o = o2;
        this.root = root2;
    }

    @NotNull
    public final SqlFunctionCallExpression getO() {
        return this.o;
    }

    @NotNull
    public final SqlElement getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public IMongoFunction build() {
        MongoIdentifier mongoIdentifier = this.callableIdentifier;
        if (mongoIdentifier == null) {
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        MongoIdentifier callableIdentifier = mongoIdentifier;
        IMongoArgumentList iMongoArgumentList = this.argumentList;
        if (iMongoArgumentList == null) {
            throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
        }
        IMongoArgumentList argumentList = iMongoArgumentList;
        MongoFunctionOperator functionOp = this.convertFunctionOpName(callableIdentifier.getName());
        MongoConstructorOperator constructorOp = this.convertConstructorOpName(callableIdentifier.getName());
        if (functionOp != MongoFunctionOperator.UNKNOWN || functionOp == MongoFunctionOperator.UNKNOWN && constructorOp == MongoConstructorOperator.UNKNOWN && !this.withNew) {
            if (this.withNew) {
                String string = DatabaseBundle.message("MongoTranslator.errors.after.new.a.literal.constructor.is.expected.instead.of.a.function.call", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                throw MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
            }
            if (functionOp == MongoFunctionOperator.COUNT && !((Collection)argumentList.getArguments()).isEmpty()) {
                String string = DatabaseBundle.message("MongoTranslator.errors.only.count.star.is.supported", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                throw MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
            }
            if (functionOp == MongoFunctionOperator.REDUCE || functionOp == MongoFunctionOperator.MAP || functionOp == MongoFunctionOperator.FILTER || functionOp == MongoFunctionOperator.LET) {
                Object[] objectArray = new Object[]{callableIdentifier.getName()};
                String string = DatabaseBundle.message("MongoTranslator.errors.function.0.is.unsupported", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                throw MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
            }
            String string = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return new MongoFunction(this.isAggregateCall, functionOp, callableIdentifier, argumentList, string);
        }
        if (constructorOp != MongoConstructorOperator.UNKNOWN || constructorOp == MongoConstructorOperator.UNKNOWN && functionOp == MongoFunctionOperator.UNKNOWN && this.withNew) {
            if (this.isAggregateCall) {
                throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
            }
            if (!(argumentList instanceof MongoConstructorArgumentList)) {
                String string = DatabaseBundle.message("MongoTranslator.errors.literal.constructor.require.literal.arguments", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                throw MongoToDatabaseScriptTranslator.Companion.createTranslationException(string, (PsiElement)this.o, (PsiElement)this.root);
            }
            MongoConstructorArgumentList mongoConstructorArgumentList = (MongoConstructorArgumentList)argumentList;
            String string = this.o.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return new MongoLiteralConstructed(this.withNew, constructorOp, callableIdentifier, mongoConstructorArgumentList, string);
        }
        throw MongoToDatabaseScriptTranslator.Companion.createTranslationPSIStructureException((PsiElement)this.o, (PsiElement)this.root);
    }

    @Override
    @NotNull
    public MongoFunctionBuilder isAggregateCall(boolean v2) {
        MongoFunctionBuilder mongoFunctionBuilder;
        MongoFunctionBuilder $this$isAggregateCall_u24lambda_u240 = mongoFunctionBuilder = this;
        boolean bl = false;
        $this$isAggregateCall_u24lambda_u240.isAggregateCall = v2;
        return mongoFunctionBuilder;
    }

    @Override
    @NotNull
    public MongoFunctionBuilder withNew(boolean v2) {
        MongoFunctionBuilder mongoFunctionBuilder;
        MongoFunctionBuilder $this$withNew_u24lambda_u241 = mongoFunctionBuilder = this;
        boolean bl = false;
        $this$withNew_u24lambda_u241.withNew = v2;
        return mongoFunctionBuilder;
    }

    @Override
    @NotNull
    public MongoFunctionBuilder callableIdentifier(@NotNull MongoIdentifier v2) {
        MongoFunctionBuilder mongoFunctionBuilder;
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        MongoFunctionBuilder $this$callableIdentifier_u24lambda_u242 = mongoFunctionBuilder = this;
        boolean bl = false;
        $this$callableIdentifier_u24lambda_u242.callableIdentifier = v2;
        return mongoFunctionBuilder;
    }

    @Override
    @NotNull
    public MongoFunctionBuilder argumentList(@NotNull IMongoArgumentList v2) {
        MongoFunctionBuilder mongoFunctionBuilder;
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        MongoFunctionBuilder $this$argumentList_u24lambda_u243 = mongoFunctionBuilder = this;
        boolean bl = false;
        $this$argumentList_u24lambda_u243.argumentList = v2;
        return mongoFunctionBuilder;
    }

    private final MongoFunctionOperator convertFunctionOpName(String name2) {
        String string = name2.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return switch (string) {
            case "ABS" -> MongoFunctionOperator.ABS;
            case "ACCUMULATOR" -> MongoFunctionOperator.ACCUMULATOR;
            case "ACOS" -> MongoFunctionOperator.ACOS;
            case "ACOSH" -> MongoFunctionOperator.ACOSH;
            case "ADD" -> MongoFunctionOperator.ADD;
            case "ADDTOSET" -> MongoFunctionOperator.ADD_TO_SET;
            case "ALLELEMENTSTRUE" -> MongoFunctionOperator.ALL_ELEMENTS_TRUE;
            case "AND" -> MongoFunctionOperator.AND;
            case "ANYELEMENTTRUE" -> MongoFunctionOperator.ANY_ELEMENT_TRUE;
            case "ARRAYELEMAT" -> MongoFunctionOperator.ARRAY_ELEM_AT;
            case "ARRAYTOOBJECT" -> MongoFunctionOperator.ARRAY_TO_OBJECT;
            case "ASIN" -> MongoFunctionOperator.ASIN;
            case "ASINH" -> MongoFunctionOperator.ASINH;
            case "ATAN" -> MongoFunctionOperator.ATAN;
            case "ATAN2" -> MongoFunctionOperator.ATAN2;
            case "ATANH" -> MongoFunctionOperator.ATANH;
            case "AVG" -> MongoFunctionOperator.AVG;
            case "BINARYSIZE" -> MongoFunctionOperator.BINARY_SIZE;
            case "BSONSIZE" -> MongoFunctionOperator.BSON_SIZE;
            case "CEIL" -> MongoFunctionOperator.CEIL;
            case "CMP" -> MongoFunctionOperator.CMP;
            case "CONCAT" -> MongoFunctionOperator.CONCAT;
            case "CONCATARRAYS" -> MongoFunctionOperator.CONCAT_ARRAYS;
            case "COND" -> MongoFunctionOperator.COND;
            case "CONVERT" -> MongoFunctionOperator.CONVERT;
            case "COS" -> MongoFunctionOperator.COS;
            case "COUNT" -> MongoFunctionOperator.COUNT;
            case "DATEFROMPARTS" -> MongoFunctionOperator.DATE_FROM_PARTS;
            case "DATETOPARTS" -> MongoFunctionOperator.DATE_TO_PARTS;
            case "DATEFROMSTRING" -> MongoFunctionOperator.DATE_FROM_STRING;
            case "DATETOSTRING" -> MongoFunctionOperator.DATE_TO_STRING;
            case "DAYOFMONTH" -> MongoFunctionOperator.DAY_OF_MONTH;
            case "DAYOFWEEK" -> MongoFunctionOperator.DAY_OF_WEEK;
            case "DAYOFYEAR" -> MongoFunctionOperator.DAY_OF_YEAR;
            case "DEGREESTORADIANS" -> MongoFunctionOperator.DEGREES_TO_RADIANS;
            case "DIVIDE" -> MongoFunctionOperator.DIVIDE;
            case "EQ" -> MongoFunctionOperator.EQ;
            case "EXP" -> MongoFunctionOperator.EXP;
            case "FILTER" -> MongoFunctionOperator.FILTER;
            case "FIRST" -> MongoFunctionOperator.FIRST;
            case "FLOOR" -> MongoFunctionOperator.FLOOR;
            case "FUNCTION" -> MongoFunctionOperator.FUNCTION;
            case "GT" -> MongoFunctionOperator.GT;
            case "GTE" -> MongoFunctionOperator.GTE;
            case "HOUR" -> MongoFunctionOperator.HOUR;
            case "IFNULL" -> MongoFunctionOperator.IF_NULL;
            case "IN" -> MongoFunctionOperator.IN;
            case "INDEXOFARRAY" -> MongoFunctionOperator.INDEX_OF_ARRAY;
            case "INDEXOFBYTES" -> MongoFunctionOperator.INDEX_OF_BYTES;
            case "INDEXOFCP" -> MongoFunctionOperator.INDEX_OF_CP;
            case "ISARRAY" -> MongoFunctionOperator.IS_ARRAY;
            case "ISNUMBER" -> MongoFunctionOperator.IS_NUMBER;
            case "ISODAYOFWEEK" -> MongoFunctionOperator.ISO_DAY_OF_WEEK;
            case "ISOWEEK" -> MongoFunctionOperator.ISO_WEEK;
            case "ISOWEEKYEAR" -> MongoFunctionOperator.ISO_WEEK_YEAR;
            case "LAST" -> MongoFunctionOperator.LAST;
            case "LET" -> MongoFunctionOperator.LET;
            case "LITERAL" -> MongoFunctionOperator.LITERAL;
            case "LN" -> MongoFunctionOperator.LN;
            case "LOG" -> MongoFunctionOperator.LOG;
            case "LOG10" -> MongoFunctionOperator.LOG10;
            case "LT" -> MongoFunctionOperator.LT;
            case "LTE" -> MongoFunctionOperator.LTE;
            case "LTRIM" -> MongoFunctionOperator.LTRIM;
            case "MAP" -> MongoFunctionOperator.MAP;
            case "MAX" -> MongoFunctionOperator.MAX;
            case "MERGEOBJECTS" -> MongoFunctionOperator.MERGE_OBJECTS;
            case "META" -> MongoFunctionOperator.META;
            case "MIN" -> MongoFunctionOperator.MIN;
            case "MILLISECOND" -> MongoFunctionOperator.MILLISECOND;
            case "MINUTE" -> MongoFunctionOperator.MINUTE;
            case "MOD" -> MongoFunctionOperator.MOD;
            case "MONTH" -> MongoFunctionOperator.MONTH;
            case "MULTIPLY" -> MongoFunctionOperator.MULTIPLY;
            case "NE" -> MongoFunctionOperator.NE;
            case "NOT" -> MongoFunctionOperator.NOT;
            case "OBJECTTOARRAY" -> MongoFunctionOperator.OBJECT_TO_ARRAY;
            case "OR" -> MongoFunctionOperator.OR;
            case "POW" -> MongoFunctionOperator.POW;
            case "PUSH" -> MongoFunctionOperator.PUSH;
            case "RADIANSTODEGREES" -> MongoFunctionOperator.RADIANS_TO_DEGREES;
            case "RANGE" -> MongoFunctionOperator.RANGE;
            case "REDUCE" -> MongoFunctionOperator.REDUCE;
            case "REGEXFIND" -> MongoFunctionOperator.REGEX_FIND;
            case "REGEXFINDALL" -> MongoFunctionOperator.REGEX_FIND_ALL;
            case "REGEXMATCH" -> MongoFunctionOperator.REGEX_MATCH;
            case "REPLACEONE" -> MongoFunctionOperator.REPLACE_ONE;
            case "REPLACEALL" -> MongoFunctionOperator.REPLACE_ALL;
            case "REVERSEARRAY" -> MongoFunctionOperator.REVERSE_ARRAY;
            case "ROUND" -> MongoFunctionOperator.ROUND;
            case "RTRIM" -> MongoFunctionOperator.RTRIM;
            case "SECOND" -> MongoFunctionOperator.SECOND;
            case "SETDIFFERENCE" -> MongoFunctionOperator.SET_DIFFERENCE;
            case "SETEQUALS" -> MongoFunctionOperator.SET_EQUALS;
            case "SETINTERSECTION" -> MongoFunctionOperator.SET_INTERSECTION;
            case "SETISSUBSET" -> MongoFunctionOperator.SET_IS_SUBSET;
            case "SETUNION" -> MongoFunctionOperator.SET_UNION;
            case "SIZE" -> MongoFunctionOperator.SIZE;
            case "SIN" -> MongoFunctionOperator.SIN;
            case "SLICE" -> MongoFunctionOperator.SLICE;
            case "SPLIT" -> MongoFunctionOperator.SPLIT;
            case "SQRT" -> MongoFunctionOperator.SQRT;
            case "STDDEVPOP" -> MongoFunctionOperator.STD_DEV_POP;
            case "STDDEVSAMP" -> MongoFunctionOperator.STD_DEV_SAMP;
            case "STRCASECMP" -> MongoFunctionOperator.STRCASECMP;
            case "STRLENBYTES" -> MongoFunctionOperator.STR_LEN_BYTES;
            case "STRLENCP" -> MongoFunctionOperator.STR_LEN_CP;
            case "SUBSTR" -> MongoFunctionOperator.SUBSTR;
            case "SUBSTRBYTES" -> MongoFunctionOperator.SUBSTR_BYTES;
            case "SUBSTRCP" -> MongoFunctionOperator.SUBSTR_CP;
            case "SUBTRACT" -> MongoFunctionOperator.SUBTRACT;
            case "SUM" -> MongoFunctionOperator.SUM;
            case "SWITCH" -> MongoFunctionOperator.SWITCH;
            case "TAN" -> MongoFunctionOperator.TAN;
            case "TOBOOL" -> MongoFunctionOperator.TO_BOOL;
            case "TODATE" -> MongoFunctionOperator.TO_DATE;
            case "TODECIMAL" -> MongoFunctionOperator.TO_DECIMAL;
            case "TODOUBLE" -> MongoFunctionOperator.TO_DOUBLE;
            case "TOINT" -> MongoFunctionOperator.TO_INT;
            case "TOLONG" -> MongoFunctionOperator.TO_LONG;
            case "TOOBJECTID" -> MongoFunctionOperator.TO_OBJECT_ID;
            case "TOSTRING" -> MongoFunctionOperator.TO_STRING;
            case "TOLOWER" -> MongoFunctionOperator.TO_LOWER;
            case "TOUPPER" -> MongoFunctionOperator.TO_UPPER;
            case "TRIM" -> MongoFunctionOperator.TRIM;
            case "TRUNC" -> MongoFunctionOperator.TRUNC;
            case "TYPE" -> MongoFunctionOperator.TYPE;
            case "WEEK" -> MongoFunctionOperator.WEEK;
            case "YEAR" -> MongoFunctionOperator.YEAR;
            case "ZIP" -> MongoFunctionOperator.ZIP;
            default -> MongoFunctionOperator.UNKNOWN;
        };
    }

    private final MongoConstructorOperator convertConstructorOpName(String name2) {
        String string = name2.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return switch (string) {
            case "BINDATA" -> MongoConstructorOperator.BIN_DATA;
            case "HEXDATA" -> MongoConstructorOperator.HEX_DATA;
            case "UUID" -> MongoConstructorOperator.UUID;
            case "MD5" -> MongoConstructorOperator.MD5;
            case "OBJECTID" -> MongoConstructorOperator.OBJECT_ID;
            case "DATE" -> MongoConstructorOperator.DATE;
            case "ISODATE" -> MongoConstructorOperator.ISO_DATE;
            case "CODE" -> MongoConstructorOperator.CODE;
            case "DBREF" -> MongoConstructorOperator.DBREF;
            case "REGEXP" -> MongoConstructorOperator.REG_EXP;
            case "NUMBERINT" -> MongoConstructorOperator.NUMBER_INT;
            case "NUMBERLONG" -> MongoConstructorOperator.NUMBER_LONG;
            case "NUMBERDECIMAL" -> MongoConstructorOperator.NUMBER_DECIMAL;
            case "TIMESTAMP" -> MongoConstructorOperator.TIMESTAMP;
            case "MINKEY" -> MongoConstructorOperator.MIN_KEY;
            case "MAXKEY" -> MongoConstructorOperator.MAX_KEY;
            default -> MongoConstructorOperator.UNKNOWN;
        };
    }
}

