/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hivebase.types;

import com.intellij.database.dialects.hivebase.types.HiveBaseGenericType;
import com.intellij.database.types.DasMapType;
import com.intellij.database.types.DasSimpleTypeClass;
import com.intellij.database.types.DasType;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/hivebase/types/HiveMapType;", "Lcom/intellij/database/dialects/hivebase/types/HiveBaseGenericType;", "Lcom/intellij/database/types/DasMapType;", "keyType", "Lcom/intellij/database/types/DasType;", "valueType", "(Lcom/intellij/database/types/DasType;Lcom/intellij/database/types/DasType;)V", "getKeyType", "()Lcom/intellij/database/types/DasType;", "getValueType", "getTypeClass", "Lcom/intellij/database/types/DasSimpleTypeClass;", "transform", "transformer", "Ljava/util/function/Function;", "Companion", "intellij.database.dialects.hivebase"})
public final class HiveMapType
extends HiveBaseGenericType
implements DasMapType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DasSimpleTypeClass TYPE_CLASS = new DasSimpleTypeClass("map");

    public HiveMapType(@NotNull DasType keyType, @NotNull DasType valueType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Object[] objectArray = new DasType[]{keyType, valueType};
        super(CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @NotNull
    public DasSimpleTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    @Override
    @NotNull
    public DasType getKeyType() {
        return this.getArguments().get(0);
    }

    @Override
    @NotNull
    public DasType getValueType() {
        return this.getArguments().get(1);
    }

    @Override
    @NotNull
    public DasType transform(@NotNull Function<DasType, DasType> transformer) {
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        DasType dasType = transformer.apply(this.getKeyType());
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"apply(...)");
        DasType dasType2 = transformer.apply(this.getValueType());
        Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"apply(...)");
        return new HiveMapType(dasType, dasType2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/hivebase/types/HiveMapType$Companion;", "", "()V", "TYPE_CLASS", "Lcom/intellij/database/types/DasSimpleTypeClass;", "getTYPE_CLASS", "()Lcom/intellij/database/types/DasSimpleTypeClass;", "intellij.database.dialects.hivebase"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DasSimpleTypeClass getTYPE_CLASS() {
            return TYPE_CLASS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

