/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactory;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;

public final class H2DefinitionProvider
extends AbstractDefinitionProvider {
    private static final String INDEX_STMT = "SELECT SQL FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND INDEX_NAME=?";
    private static final String TABLE_STMT = "SELECT SQL FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME=?";
    private static final String TABLE_STMT_2 = "SELECT DB_OBJECT_SQL('TABLE', ?, ?)";
    private static final String TRIGGER_STMT = "SELECT SQL FROM INFORMATION_SCHEMA.TRIGGERS WHERE TABLE_SCHEMA=? AND TRIGGER_NAME=?";
    private static final String TRIGGER_STMT_2 = "SELECT DB_OBJECT_SQL('TRIGGER', ?, ?)";
    private static final String VIEW_STMT = "SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA=? AND TABLE_NAME=?";

    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            H2DefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.INDEX || kind == ObjectKind.TABLE || kind == ObjectKind.TRIGGER || kind == ObjectKind.VIEW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects2, @NotNull DatabaseConnectionCore connection2, @NotNull PairConsumer<DasObject, Object> consumer2) {
        if (objects2 == null) {
            H2DefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            H2DefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            H2DefinitionProvider.$$$reportNull$$$0(3);
        }
        ReusableSmartStatement<ParameterizedStatementDecoration> indexStmt = null;
        ReusableSmartStatement<ParameterizedStatementDecoration> tableStmt = null;
        ReusableSmartStatement<ParameterizedStatementDecoration> triggerStmt = null;
        ReusableSmartStatement<ParameterizedStatementDecoration> viewStmt = null;
        try {
            boolean newSchema = connection2.getVersion().isOrGreater(2);
            SmartStatementFactory statements2 = SmartStatementFactoryService.getInstance().poweredBy(connection2);
            indexStmt = statements2.parameterized().reuse(INDEX_STMT);
            tableStmt = statements2.parameterized().reuse(newSchema ? TABLE_STMT_2 : TABLE_STMT);
            triggerStmt = statements2.parameterized().reuse(newSchema ? TRIGGER_STMT_2 : TRIGGER_STMT);
            viewStmt = statements2.parameterized().reuse(newSchema ? TABLE_STMT_2 : VIEW_STMT);
            for (DasObject dasObject : objects2) {
                ReusableSmartStatement<ParameterizedStatementDecoration> statement2;
                ObjectKind kind = dasObject.getKind();
                if (kind == ObjectKind.INDEX) {
                    ReusableSmartStatement<ParameterizedStatementDecoration> statement22 = indexStmt;
                } else if (kind == ObjectKind.TABLE) {
                    statement2 = tableStmt;
                } else if (kind == ObjectKind.TRIGGER) {
                    statement2 = triggerStmt;
                } else {
                    if (kind != ObjectKind.VIEW) continue;
                    statement2 = viewStmt;
                }
                StatementParameters parameters2 = new StatementParameters().text(DasUtil.getSchema(dasObject));
                parameters2 = kind == ObjectKind.INDEX ? parameters2.text(DasUtil.getName(dasObject.getDasParent())).text(dasObject.getName()) : parameters2.text(dasObject.getName());
                consumer2.consume((Object)dasObject, EitherKt.any(statement2.execute(parameters2.asDecoration(), StandardResultsProcessors.FIRST_STRING)));
            }
        }
        finally {
            DbImplUtilCore.closeSafe(indexStmt);
            DbImplUtilCore.closeSafe(tableStmt);
            DbImplUtilCore.closeSafe(triggerStmt);
            DbImplUtilCore.closeSafe(viewStmt);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/h2/H2DefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

