/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum.model;

import com.intellij.database.dialects.greenplum.model.GPlumExternalTable;
import com.intellij.database.dialects.greenplum.model.GPlumLocalTable;
import com.intellij.database.dialects.greenplum.model.GPlumLocalTableColumn;
import com.intellij.database.dialects.greenplum.model.GPlumModelHelper;
import com.intellij.database.dialects.greenplum.model.GPlumPartition;
import com.intellij.database.dialects.greenplum.model.properties.GPlumPartitionKind;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumDescriptionService;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/greenplum/model/GPlumDescriptionService;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumDescriptionService;", "()V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeExternalTable", "t", "Lcom/intellij/database/dialects/greenplum/model/GPlumExternalTable;", "describeLocalTable", "Lcom/intellij/database/dialects/greenplum/model/GPlumLocalTable;", "describePartition", "Lcom/intellij/database/dialects/greenplum/model/GPlumPartition;", "inclusiveOrExclusive", "inclusive", "", "intellij.database.dialects.greenplum"})
public final class GPlumDescriptionService
extends PgGPlumDescriptionService {
    @Override
    @NotNull
    protected PgGPlumBaseModelHelper getHelper() {
        return GPlumModelHelper.INSTANCE;
    }

    @Override
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof GPlumExternalTable ? this.describeExternalTable((GPlumExternalTable)e2, context) : (basicElement instanceof GPlumLocalTable ? this.describeLocalTable((GPlumLocalTable)e2, context) : (basicElement instanceof GPlumPartition ? this.describePartition((GPlumPartition)e2, context) : super.content(e2, context)));
    }

    private final String describeLocalTable(GPlumLocalTable t, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(GPlumLocalTable.DISTRIBUTION_KEYS);
        ((Collection)context.getDescribed()).add(GPlumLocalTable.DISTRIBUTED_RANDOMLY);
        ((Collection)context.getDescribed()).add(GPlumLocalTable.PARTITIONS_TREE);
        Object res2 = super.describePgTable(t, context);
        List<Integer> list = t.getDistributionKeys();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDistributionKeys(...)");
        if (!((Collection)list).isEmpty()) {
            res2 = (String)res2 + " distribution_keys " + t.getDistributionKeys();
        }
        if (t.isDistributedRandomly()) {
            res2 = (String)res2 + " distributed_randomly";
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)res2))).toString();
    }

    private final String describeExternalTable(GPlumExternalTable t, DescriptionService.Context context) {
        String string;
        ((Collection)context.getDescribed()).add(GPlumExternalTable.WRITABLE);
        ((Collection)context.getDescribed()).add(GPlumExternalTable.LOCATIONS);
        ((Collection)context.getDescribed()).add(GPlumExternalTable.EXEC_LOCATION);
        ((Collection)context.getDescribed()).add(GPlumExternalTable.FORMAT);
        ((Collection)context.getDescribed()).add(GPlumExternalTable.FORMAT_OPTIONS);
        ((Collection)context.getDescribed()).add(GPlumExternalTable.ENCODING);
        ((Collection)context.getDescribed()).add(GPlumExternalTable.REJECT_LIMIT);
        ((Collection)context.getDescribed()).add(GPlumExternalTable.REJECT_LIMIT_TYPE);
        ((Collection)context.getDescribed()).add(GPlumExternalTable.DISTRIBUTION_KEYS);
        ((Collection)context.getDescribed()).add(GPlumExternalTable.DISTRIBUTED_RANDOMLY);
        ((Collection)context.getDescribed()).add(GPlumExternalTable.COMMAND);
        ArrayList attributes2 = new ArrayList();
        ((Collection)attributes2).add(t.isWritable() ? "writable" : "readable");
        Collection collection2 = attributes2;
        List<String> list = t.getLocations();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getLocations(...)");
        if (!((Collection)list).isEmpty()) {
            List<String> list2 = t.getLocations();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getLocations(...)");
            string = "locations (" + CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null) + ")";
        } else {
            string = "command (" + t.getCommand() + ")";
        }
        collection2.add(string);
        if (t.getExecLocation() != null) {
            ((Collection)attributes2).add("exec location (" + t.getExecLocation() + ")");
        }
        ((Collection)attributes2).add("format (" + t.getFormat().getName() + ")");
        ((Collection)attributes2).add("options (" + t.getFormatOptions() + ")");
        ((Collection)attributes2).add("encoding (" + t.getEncoding() + ")");
        if (t.getRejectLimit() != 0) {
            ((Collection)attributes2).add("reject limit (" + t.getRejectLimit() + " " + t.getRejectLimitType().getName() + ")");
        }
        List<Integer> list3 = t.getDistributionKeys();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getDistributionKeys(...)");
        if (!((Collection)list3).isEmpty()) {
            ((Collection)attributes2).add("distribution_keys " + t.getDistributionKeys());
        }
        if (t.isDistributedRandomly()) {
            ((Collection)attributes2).add("distributed_randomly");
        }
        return CollectionsKt.joinToString$default((Iterable)attributes2, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final String describePartition(GPlumPartition e2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(GPlumPartition.COLUMNS);
        ((Collection)context.getDescribed()).add(GPlumPartition.PARTITION_KIND);
        ((Collection)context.getDescribed()).add(GPlumPartition.VALUES);
        ((Collection)context.getDescribed()).add(GPlumPartition.START_VALUE);
        ((Collection)context.getDescribed()).add(GPlumPartition.START_INCLUSIVE);
        ((Collection)context.getDescribed()).add(GPlumPartition.END_INCLUSIVE);
        ((Collection)context.getDescribed()).add(GPlumPartition.END_VALUE);
        ((Collection)context.getDescribed()).add(GPlumPartition.EVERY_VALUE);
        ((Collection)context.getDescribed()).add(GPlumPartition.ORDER);
        ((Collection)context.getDescribed()).add(GPlumPartition.DEFAULT_PARTITION);
        ArrayList descriptions = new ArrayList();
        GPlumLocalTable gPlumLocalTable = e2.getLocalTable();
        Intrinsics.checkNotNull((Object)gPlumLocalTable);
        GPlumLocalTable table = gPlumLocalTable;
        ArrayList columns2 = new ArrayList();
        for (Integer attribute : e2.getColumns()) {
            Object object = (GPlumLocalTableColumn)table.getColumns().getByNaturalPosition((short)attribute.intValue());
            if (object == null || (object = object.getName()) == null) {
                object = "?unknown?";
            }
            Object column2 = object;
            ((Collection)columns2).add(column2);
        }
        if (!((Collection)columns2).isEmpty()) {
            ((Collection)descriptions).add("columns (" + CollectionsKt.joinToString$default((Iterable)columns2, null, null, null, (int)0, null, null, (int)63, null) + ")");
        }
        ((Collection)descriptions).add("kind (" + e2.getPartitionKind().getSqlName() + ")");
        if (e2.getPartitionKind() == GPlumPartitionKind.LIST) {
            if (e2.getValues() != null) {
                ((Collection)descriptions).add("values (" + e2.getValues() + ")");
            }
        } else {
            if (e2.getStartValue() != null) {
                ((Collection)descriptions).add("start (" + e2.getStartValue() + " " + this.inclusiveOrExclusive(e2.isStartInclusive()) + ")");
            }
            if (e2.getEndValue() != null) {
                ((Collection)descriptions).add("end (" + e2.getEndValue() + " " + this.inclusiveOrExclusive(e2.isEndInclusive()) + ")");
            }
            if (e2.getEveryValue() != null) {
                ((Collection)descriptions).add("every (" + e2.getEveryValue() + ")");
            }
        }
        ((Collection)descriptions).add("order (" + e2.getOrder() + ")");
        if (e2.isDefaultPartition()) {
            ((Collection)descriptions).add("default");
        }
        return CollectionsKt.joinToString$default((Iterable)descriptions, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final String inclusiveOrExclusive(boolean inclusive) {
        return inclusive ? "inclusive" : "exclusive";
    }
}

