/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.db2.model.Db2DefType;
import com.intellij.database.dialects.db2.model.properties.Db2DataTypeSubKind;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Db2BaseDialect
extends AbstractDatabaseDialect {
    private final Dbms myDbms;

    public Db2BaseDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            Db2BaseDialect.$$$reportNull$$$0(0);
        }
        super(new TypeHelper.DB2TypeHelper());
        this.myDbms = dbms;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            Db2BaseDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = StringUtil.trimStart((String)this.myDbms.getDisplayName(), (String)"IBM ");
        if (string == null) {
            Db2BaseDialect.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            Db2BaseDialect.$$$reportNull$$$0(3);
        }
        if (identifier == null) {
            Db2BaseDialect.$$$reportNull$$$0(4);
        }
        if (qualifier == null) {
            Db2BaseDialect.$$$reportNull$$$0(5);
        }
        DasObject schema2 = DasUtil.getSchemaObject(qualifier);
        DasObject catalog = DasUtil.getCatalogObject(qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDasParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema2, DasUtil.getName(schema2), catalog, DasUtil.getName(catalog), pkg, pkgName);
        if (ddlBuilder == null) {
            Db2BaseDialect.$$$reportNull$$$0(6);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        if (binaryData == null) {
            Db2BaseDialect.$$$reportNull$$$0(7);
        }
        String string = "BLOB(x'" + ObjectFormatterUtil.toHexString((byte[])binaryData) + "')";
        if (string == null) {
            Db2BaseDialect.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            Db2BaseDialect.$$$reportNull$$$0(9);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", current.getName());
    }

    @NotNull
    public DdlBuilder generated(@NotNull DdlBuilder builder) {
        if (builder == null) {
            Db2BaseDialect.$$$reportNull$$$0(10);
        }
        DdlBuilder ddlBuilder = builder.space().keywords("GENERATED", "ALWAYS", "AS", "IDENTITY").plain("(").keywords("START", "WITH").space().literal("1").space().keywords("INCREMENT", "BY").space().literal("1").plain(")");
        if (ddlBuilder == null) {
            Db2BaseDialect.$$$reportNull$$$0(11);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsInsertDefaultIntoAutoVal() {
        return true;
    }

    @Override
    @Nullable
    public DasType getDasType(@Nullable PsiElement refElement, @NotNull DbElement resolved) {
        Object delegate;
        if (resolved == null) {
            Db2BaseDialect.$$$reportNull$$$0(12);
        }
        if ((delegate = resolved.getDelegate()) instanceof Db2DefType) {
            Db2DataTypeSubKind subKind = ((Db2DefType)delegate).getSubKind();
            return SqlTableTypeBase.createObjectTypeType(resolved, resolved, refElement, subKind == Db2DataTypeSubKind.ROW);
        }
        return null;
    }

    @Override
    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            Db2BaseDialect.$$$reportNull$$$0(13);
        }
        return dialect instanceof Db2BaseDialect;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element2, @NotNull DatabaseConnectionCore connection2) throws Exception {
        if (element2 == null) {
            Db2BaseDialect.$$$reportNull$$$0(14);
        }
        if (connection2 == null) {
            Db2BaseDialect.$$$reportNull$$$0(15);
        }
        Dbms dbms = connection2.getDbms();
        Map<String, Object> map2 = DbImplUtilCore.resultRowAsMap(connection2, String.format("SELECT tabname, card, collationname, create_time FROM syscat.tables WHERE owner = '%s' AND tabname LIKE '%s' ESCAPE '#'", DbImplUtilCore.escapeStr(DasUtil.getSchema(element2)), DbImplUtilCore.escapeSql(element2.getName(), true, dbms)), "CARD", "rows", "COLLATIONNAME", "collation", "CREATE_TIME", "created");
        if (map2 == null) {
            Db2BaseDialect.$$$reportNull$$$0(16);
        }
        return map2;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection2) throws SQLException {
        Dbms dbms;
        String s2;
        if (connection2 == null) {
            Db2BaseDialect.$$$reportNull$$$0(17);
        }
        return StringUtil.isEmpty((String)(s2 = DbImplUtilCore.concatStringResults(connection2, dbms = connection2.getDbms(), "select current_schema from sysibm.sysdummy1", 1, DbImplUtilCore.ConcatenationProps.LINES))) ? null : SearchPath.of(ObjectPath.create(s2, ObjectKind.SCHEMA));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 8, 11, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/db2/Db2BaseDialect";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/db2/Db2BaseDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generated";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 16: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generated";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDasType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 8, 11, 16 -> new IllegalStateException(string);
        };
    }
}

