/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.introspector;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.cassandra.generator.producers.CassTableProducersKt;
import com.intellij.database.dialects.cassandra.introspector.CassIntroQueries;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveColumns$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$CassSchemaRetriever$retrieveDefTypes$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospector$applySchemas$1$invoke$;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospectorHelperKt;
import com.intellij.database.dialects.cassandra.introspector.CassIntrospectorKt;
import com.intellij.database.dialects.cassandra.model.CassAggregate;
import com.intellij.database.dialects.cassandra.model.CassArgument;
import com.intellij.database.dialects.cassandra.model.CassDefType;
import com.intellij.database.dialects.cassandra.model.CassDefTypeAttribute;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassKey;
import com.intellij.database.dialects.cassandra.model.CassLikeTable;
import com.intellij.database.dialects.cassandra.model.CassMatView;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassRoot;
import com.intellij.database.dialects.cassandra.model.CassRoutine;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.dialects.cassandra.model.CassTrigger;
import com.intellij.database.dialects.cassandra.model.defaults.CassSchemaPropertyKind;
import com.intellij.database.dialects.cassandra.model.defaults.CassTablePropertyKind;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.query.PreprocessedQuery;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementCacheOptimizersKt;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.ElementSearcherNN;
import com.intellij.database.model.FamilySearcher;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.IndexColumn;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.remote.jdbc.RemoteCassConnection;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002&'B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J4\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u00020\u0011R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\u001c\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0003H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0014H\u0014J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J&\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010!\u001a\u00020\u001aH\u0014J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0014H\u0014J\b\u0010#\u001a\u00020\nH\u0016J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/cassandra/model/CassRoot;", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "applySchemas", "", "newSchemas", "", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneSchema;", "currentSchema", "", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever;", "schema", "hasSelectPrivilege", "", "tableName", "introspectNamespacesInTran", "tran", "introspectOneSchema", "introspectSchemasAuto", "schemas", "whole", "introspectTheServerObjects", "retrieveAndApplySchemas", "retrieveRoles21", "retrieveRoles22", "CassSchemaRetriever", "Factory", "intellij.database.dialects.cassandra"})
public class CassIntrospector
extends BaseSingleDatabaseIntrospector<CassRoot, CassSchema> {
    public CassIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.CASSANDRA;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"CASSANDRA");
        super(context, nature, dbms, modelFactory);
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseRetriever<CassRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull CassRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    protected CassSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull CassSchema schema2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        return new CassSchemaRetriever(transaction, schema2);
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Object object = new int[]{3, 0};
        List schemas2 = this.getServerVersion().isOrGreater((int)object) ? this.performQuery(tran, CassIntroQueries.Companion.getQUERIES().getRetrieveSchemas3()) : this.performQuery(tran, CassIntroQueries.Companion.getQUERIES().getRetrieveSchemas2());
        object = new int[]{4};
        if (this.getServerVersion().isOrGreater((int)object)) {
            object = schemas2;
            Intrinsics.checkNotNull((Object)object);
            Collection collection2 = (Collection)object;
            List<CassIntroQueries.OneSchema3> list = this.performQuery(tran, CassIntroQueries.Companion.getQUERIES().getRetrieveVirtualSchemas());
            Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
            schemas2 = CollectionsKt.plus((Collection)collection2, (Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)introspectNamespacesInTran.1.INSTANCE));
        }
        object = schemas2;
        Intrinsics.checkNotNull((Object)object);
        this.applySchemas((List<? extends CassIntroQueries.OneSchema>)object, this.getDbConnectionInfo().schemaName);
    }

    @Override
    protected void introspectTheServerObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        int[] nArray = new int[]{2, 2};
        if (this.getServerVersion().isOrGreater(nArray)) {
            if (this.hasSelectPrivilege("system_auth.roles")) {
                this.retrieveRoles22(tran);
            }
        } else if (this.hasSelectPrivilege("system_auth.users")) {
            this.retrieveRoles21(tran);
        }
    }

    private final boolean hasSelectPrivilege(String tableName) {
        DatabaseConnectionCore databaseConnectionCore = this.getDbConnection();
        if (databaseConnectionCore == null) {
            return true;
        }
        DatabaseConnectionCore connection2 = databaseConnectionCore;
        return SmartStatementFactoryService.Companion.getInstance().poweredBy(connection2).simple().execute("select * from " + tableName, hasSelectPrivilege.1.INSTANCE).rightOr(false);
    }

    private final void retrieveRoles22(DBTransaction tran) {
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default(this, CassIntroQueries.Companion.getQUERIES().getRetrieveRoles22(), null, null, 6, null);
        this.inModel((Function1)new Function1<CassRoot, Unit>(tran, (PreprocessedQuery<List<CassIntroQueries.OneRole>>)pq){
            final /* synthetic */ DBTransaction $tran;
            final /* synthetic */ PreprocessedQuery<List<CassIntroQueries.OneRole>> $pq;
            {
                this.$tran = $tran;
                this.$pq = $pq;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CassRoot root2) {
                void $this$modifyAndCleanup_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                ModFamily modFamily = root2.getRoles();
                DBTransaction dBTransaction = this.$tran;
                PreprocessedQuery<List<CassIntroQueries.OneRole>> preprocessedQuery = this.$pq;
                boolean inc$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModNamingFamily it2 = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl = false;
                X x = dBTransaction.query(preprocessedQuery.query).runOnce();
                Intrinsics.checkNotNullExpressionValue(x, (String)"runOnce(...)");
                Iterable $this$forEach$iv = (Iterable)x;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String name2;
                    CassRole cassRole;
                    CassIntroQueries.OneRole r = (CassIntroQueries.OneRole)element$iv;
                    boolean bl2 = false;
                    if (r.name == null) continue;
                    CassRole $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240 = cassRole = root2.getRoles().createOrGet(name2);
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240.setSuperRole(r.is_superuser);
                    $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240.setCanLogin(r.can_login);
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
        });
    }

    private final void retrieveRoles21(DBTransaction tran) {
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default(this, CassIntroQueries.Companion.getQUERIES().getRetrieveRoles21(), null, null, 6, null);
        this.inModel((Function1)new Function1<CassRoot, Unit>(tran, (PreprocessedQuery<List<CassIntroQueries.OneRole>>)pq){
            final /* synthetic */ DBTransaction $tran;
            final /* synthetic */ PreprocessedQuery<List<CassIntroQueries.OneRole>> $pq;
            {
                this.$tran = $tran;
                this.$pq = $pq;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CassRoot root2) {
                void $this$modifyAndCleanup_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                ModFamily modFamily = root2.getRoles();
                DBTransaction dBTransaction = this.$tran;
                PreprocessedQuery<List<CassIntroQueries.OneRole>> preprocessedQuery = this.$pq;
                boolean inc$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModNamingFamily it2 = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl = false;
                X x = dBTransaction.query(preprocessedQuery.query).runOnce();
                Intrinsics.checkNotNullExpressionValue(x, (String)"runOnce(...)");
                Iterable $this$forEach$iv = (Iterable)x;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String name2;
                    CassRole cassRole;
                    CassIntroQueries.OneRole r = (CassIntroQueries.OneRole)element$iv;
                    boolean bl2 = false;
                    if (r.name == null) continue;
                    CassRole $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240 = cassRole = root2.getRoles().createOrGet(name2);
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240.setSuperRole(r.is_superuser);
                    $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240.setCanLogin(true);
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
        });
    }

    @Override
    public void retrieveAndApplySchemas() {
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ CassIntrospector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DBTransaction it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                this.this$0.introspectNamespacesInTran(it2);
            }
        }));
    }

    private final void applySchemas(List<? extends CassIntroQueries.OneSchema> newSchemas, String currentSchema) {
        this.inModel((Function1)new Function1<CassRoot, Unit>(newSchemas, currentSchema){
            final /* synthetic */ List<CassIntroQueries.OneSchema> $newSchemas;
            final /* synthetic */ String $currentSchema;
            {
                this.$newSchemas = $newSchemas;
                this.$currentSchema = $currentSchema;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CassRoot root2) {
                void $this$iv$iv$iv;
                void $this$applySchemasNamed$iv$iv;
                void $this$applySchemasNamed$iv;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                NamingFamily namingFamily = root2.getSchemas();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
                NamingFamily namingFamily2 = namingFamily;
                List<CassIntroQueries.OneSchema> list = this.$newSchemas;
                String string = this.$currentSchema;
                boolean $i$f$applySchemasNamed = false;
                void var6_6 = $this$applySchemasNamed$iv;
                ElementSearchCache searchCache$iv$iv = new ElementSearchCache();
                boolean $i$f$applySchemasNamed2 = false;
                FamilySearcher<T, D> familySearcher = ElementCacheOptimizersKt.byName(ElementCacheKt.searchElement(searchCache$iv$iv), (Function1)new Function1<CassIntroQueries.OneSchema, String>(){

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    @NotNull
                    public final String invoke(Object $this$byName) {
                        CassIntroQueries.OneSchema p0 = (CassIntroQueries.OneSchema)$this$byName;
                        boolean bl = false;
                        return p0.getName();
                    }
                }).inFamily((Family)$this$applySchemasNamed$iv$iv);
                Function2 filler$iv$iv$iv = applySchemas$1$invoke$$inlined$applySchemasNamed$2.INSTANCE;
                boolean $i$f$orCreateBulk = false;
                ArrayList<E> items$iv$iv$iv = new ArrayList<E>();
                ElementSearcherNN<T, void> searcher$iv$iv$iv = ElementCacheKt.orCreateElement((ElementSearcher)$this$iv$iv$iv, (Function1)new Function1<D, T>((FamilySearcher)$this$iv$iv$iv, filler$iv$iv$iv, items$iv$iv$iv){
                    final /* synthetic */ FamilySearcher this$0;
                    final /* synthetic */ Function2 $filler;
                    final /* synthetic */ ArrayList $items;
                    {
                        this.this$0 = $receiver;
                        this.$filler = $filler;
                        this.$items = $items;
                        super(1);
                    }

                    @NotNull
                    public final T invoke(D it2) {
                        T t = BasicMetaUtils.getMetaObject(this.this$0.getFamily()).newDataObject();
                        FamilySearcher familySearcher = this.this$0;
                        Function2 function2 = this.$filler;
                        ArrayList arrayList = this.$items;
                        T $this$invoke_u24lambda_u240 = t;
                        boolean bl = false;
                        Intrinsics.checkNotNull($this$invoke_u24lambda_u240);
                        familySearcher.fillImpl($this$invoke_u24lambda_u240, it2, function2);
                        ((Collection)arrayList).add($this$invoke_u24lambda_u240);
                        T t2 = t;
                        Intrinsics.checkNotNullExpressionValue(t2, (String)"apply(...)");
                        return t2;
                    }
                });
                try {
                    void scs$iv;
                    ElementSearcherNN<T, void> schemas$iv$iv = searcher$iv$iv$iv;
                    boolean bl = false;
                    void $this$applySchemasImpl$iv$iv$iv = $this$applySchemasNamed$iv$iv;
                    boolean $i$f$applySchemasImpl = false;
                    $this$applySchemasImpl$iv$iv$iv.markChildrenAsSyncPending();
                    Iterable $this$forEach$iv$iv$iv$iv = (Iterable)scs$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String string2;
                        void s2;
                        void sc$iv$iv;
                        T element$iv$iv$iv$iv;
                        T sc$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        T t = sc$iv$iv$iv;
                        void $this$applySchemasNamed_u24lambda_u249_u24lambda_u248$iv$iv = $this$applySchemasImpl$iv$iv$iv;
                        boolean bl3 = false;
                        BasicModMateNamespace $this$applySchemasNamed_u24lambda_u249_u24lambda_u248_u24lambda_u247$iv$iv = (BasicModMateNamespace)schemas$iv$iv.find(sc$iv$iv);
                        boolean bl4 = false;
                        CassIntroQueries.OneSchema oneSchema = (CassIntroQueries.OneSchema)sc$iv$iv;
                        CassSchema $this$invoke_u24lambda_u243 = (CassSchema)$this$applySchemasNamed_u24lambda_u249_u24lambda_u248_u24lambda_u247$iv$iv;
                        boolean bl5 = false;
                        void var32_32 = s2;
                        if (var32_32 instanceof CassIntroQueries.OneSchema2) {
                            string2 = CassIntrospectorHelperKt.concatClassAndOptions(((CassIntroQueries.OneSchema2)s2).strategy_class, ((CassIntroQueries.OneSchema2)s2).strategy_options, CassIntrospectorKt.access$getLOG$p());
                        } else if (var32_32 instanceof CassIntroQueries.OneSchema3) {
                            if (((CassIntroQueries.OneSchema3)s2).replication != null) {
                                String it2;
                                boolean bl6 = false;
                                string2 = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(it2, CassIntrospectorKt.access$getLOG$p(), null, 4, null);
                            } else {
                                string2 = null;
                            }
                        } else {
                            string2 = null;
                        }
                        String replication = string2;
                        Map prop = new LinkedHashMap<K, V>();
                        Boolean bl7 = s2.getDurableWrites();
                        if (bl7 != null) {
                            boolean it3 = bl7;
                            boolean bl8 = false;
                            prop.put(CassSchemaPropertyKind.DURABLE_WRITES, CassTableProducersKt.toLiteral(it3));
                        }
                        if (replication != null) {
                            String it4;
                            boolean bl9 = false;
                            prop.put(CassSchemaPropertyKind.REPLICATION, it4);
                        }
                        $this$invoke_u24lambda_u243.setProperties(prop);
                        $this$invoke_u24lambda_u243.setVirtual(s2.getVirtual());
                        $this$invoke_u24lambda_u243.setCurrent(Intrinsics.areEqual((Object)s2.getName(), (Object)string));
                    }
                    $this$applySchemasImpl$iv$iv$iv.removeSyncPendingChildren();
                    $this$applySchemasImpl$iv$iv$iv.sort();
                }
                finally {
                    Family<T> family = $this$iv$iv$iv.getFamily();
                    Intrinsics.checkNotNull(family, (String)"null cannot be cast to non-null type com.intellij.database.model.families.Family<T of com.intellij.database.model.FamilySearcher>");
                    BaseModel.createBulk(family, (Iterable)items$iv$iv$iv);
                }
            }
        });
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends CassSchema> schemas2, boolean whole) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
        for (CassSchema cassSchema : schemas2) {
            this.introspectOneSchema(tran, cassSchema);
        }
    }

    private final void introspectOneSchema(DBTransaction tran, CassSchema schema2) {
        this.handleErrors("Introspect schema " + schema2.getName(), (Function0<Unit>)((Function0)new Function0<Unit>(this, tran, schema2){
            final /* synthetic */ CassIntrospector this$0;
            final /* synthetic */ DBTransaction $tran;
            final /* synthetic */ CassSchema $schema;
            {
                this.this$0 = $receiver;
                this.$tran = $tran;
                this.$schema = $schema;
                super(0);
            }

            public final void invoke() {
                CassSchemaRetriever retriever = this.this$0.createSchemaRetriever(this.$tran, this.$schema);
                retriever.process();
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003:\u0001_B\u0017\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\b\u0010!\u001a\u00020\nH\u0016J.\u0010\"\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0002J\u001e\u0010%\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020&0\u000eH\u0002J\u001e\u0010'\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020(0\u000eH\u0002J\u0018\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J&\u00103\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002042\u0006\u00105\u001a\u0002062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020&0\u000eH\u0002J,\u00107\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u0012092\u0006\u0010*\u001a\u00020;H\u0002J\u0018\u0010<\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020=H\u0002J\u0018\u0010>\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010A\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002Jc\u0010B\u001a\u00020\n\"\b\b\u0000\u0010C*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00022\u0012\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HC0F0E2\u000e\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020I0H2\u001e\u0010J\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002HC0\u000e\u0012\u0004\u0012\u00020\n0KH\u0002\u00a2\u0006\u0002\u0010LJ\u0010\u0010M\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010N\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010O\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010P\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010Q\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010R\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010S\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J$\u0010T\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00022\u0012\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020U0F0EH\u0002J\u0010\u0010V\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010W\u001a\u00020\n2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020\u0015H\u0002J\u001c\u0010[\u001a\u00020\n2\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020I09H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010]\u001a\u00020\u0012H\u0002J\u0010\u0010^\u001a\u00020\u00122\u0006\u0010]\u001a\u00020\u0012H\u0002\u00a8\u0006`"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/cassandra/model/CassRoot;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/cassandra/model/CassSchema;)V", "createKey", "", "table", "Lcom/intellij/database/dialects/cassandra/model/CassLikeTable;", "columns", "", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneColumn;", "getAggregateInitConditions", "", "", "keyspace", "getDataType", "Lcom/intellij/database/model/DataType;", "validator", "unwrapFrozen", "", "getInitCondition", "initConditions", "a", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneAggregate;", "isIndexCustom", "kind", "isPossibleToIntrospectSchemaIncrementally", "tran", "process", "processAggregate", "aggregate", "Lcom/intellij/database/dialects/cassandra/model/CassAggregate;", "processColumns2", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneColumn2;", "processColumns3", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneColumn3;", "processDefType", "t", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneDefType;", "objectType", "Lcom/intellij/database/dialects/cassandra/model/CassDefType;", "processFunction", "f", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneFunction;", "function", "Lcom/intellij/database/dialects/cassandra/model/CassFunction;", "processIndex", "Lcom/intellij/database/dialects/cassandra/model/CassTable;", "index", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "processLikeTable", "properties", "", "Lcom/intellij/database/dialects/cassandra/model/defaults/CassTablePropertyKind;", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneLikeTable;", "processLikeTable2", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneLikeTable2;", "processLikeTable3", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneLikeTable3;", "retrieveAggregates", "retrieveColumns", "retrieveColumnsInner", "T", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "", "freeParameters", "", "", "action", "Lkotlin/Function2;", "(Lcom/intellij/database/dialects/cassandra/model/CassSchema;Lcom/intellij/database/remote/jdba/sql/SqlQuery;[Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "retrieveDefTypes", "retrieveFunctions", "retrieveIndices", "retrieveIndices2", "retrieveIndices3", "retrieveMatViews", "retrieveTables", "retrieveTables3", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneTable3;", "retrieveTriggers", "setReturnType", "routine", "Lcom/intellij/database/dialects/cassandra/model/CassRoutine;", "returnDataType", "setVersionParameters", "parameters", "s", "unwrapReversed", "ColumnSorter", "intellij.database.dialects.cassandra"})
    @SourceDebugExtension(value={"SMAP\nCassIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassIntrospector.kt\ncom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/NameCache\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,558:1\n181#2,4:559\n185#2,3:565\n181#2,4:570\n185#2,3:577\n239#2:580\n242#2,6:585\n221#2,3:609\n224#2:614\n199#2,6:615\n206#2,5:623\n225#2:628\n221#2,3:660\n224#2:665\n199#2,6:666\n206#2,5:674\n225#2:679\n221#2,3:684\n224#2:689\n199#2,6:690\n206#2,5:698\n225#2:703\n181#2,7:704\n181#2,7:716\n239#2:728\n242#2:731\n243#2,5:734\n1855#3,2:563\n1855#3,2:568\n1855#3:574\n1856#3:576\n1855#3,2:581\n1855#3,2:583\n1855#3:591\n1856#3:598\n1855#3,2:599\n1855#3,2:603\n1549#3:605\n1620#3,3:606\n1855#3,2:621\n1855#3:629\n1856#3:642\n1603#3,9:643\n1855#3:652\n1856#3:654\n1612#3:655\n1549#3:656\n1620#3,3:657\n1855#3,2:672\n1549#3:680\n1620#3,3:681\n1855#3,2:696\n1855#3,2:711\n1855#3,2:723\n1855#3,2:729\n1855#3,2:732\n1#4:575\n1#4:653\n297#5,6:592\n297#5,5:630\n297#5,6:635\n302#5:641\n603#6:601\n603#6:602\n37#7,2:612\n37#7,2:663\n37#7,2:687\n13374#8,3:713\n13374#8,3:725\n13374#8,3:739\n*S KotlinDebug\n*F\n+ 1 CassIntrospector.kt\ncom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever\n*L\n181#1:559,4\n181#1:565,3\n211#1:570,4\n211#1:577,3\n262#1:580\n262#1:585,6\n350#1:609,3\n350#1:614\n350#1:615,6\n350#1:623,5\n350#1:628\n403#1:660,3\n403#1:665\n403#1:666,6\n403#1:674,5\n403#1:679\n431#1:684,3\n431#1:689\n431#1:690,6\n431#1:698,5\n431#1:703\n448#1:704,7\n494#1:716,7\n539#1:728\n539#1:731\n539#1:734,5\n191#1:563,2\n201#1:568,2\n212#1:574\n212#1:576\n263#1:581,2\n264#1:583,2\n283#1:591\n283#1:598\n309#1:599,2\n327#1:603,2\n350#1:605\n350#1:606,3\n351#1:621,2\n365#1:629\n365#1:642\n386#1:643,9\n386#1:652\n386#1:654\n386#1:655\n403#1:656\n403#1:657,3\n404#1:672,2\n431#1:680\n431#1:681,3\n433#1:696,2\n450#1:711,2\n498#1:723,2\n539#1:729,2\n540#1:732,2\n386#1:653\n285#1:592,6\n369#1:630,5\n374#1:635,6\n369#1:641\n320#1:601\n321#1:602\n350#1:612,2\n403#1:663,2\n431#1:687,2\n460#1:713,3\n520#1:725,3\n551#1:739,3\n*E\n"})
    protected final class CassSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<CassSchema> {
        public CassSchemaRetriever(@NotNull DBTransaction transaction, CassSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            super((BaseNativeIntrospector)CassIntrospector.this, transaction, (BasicModSchema)schema2);
            this.setVersionParameters(this.getParametersMap());
        }

        @Override
        public boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull CassSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            return false;
        }

        private final void setVersionParameters(Map<String, Object> parameters2) {
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(CassIntrospector.this.getServerVersion(), 3, new IntRange(0, 11), parameters2);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(CassIntrospector.this.getServerVersion(), 4, 0, new IntRange(1, 1), parameters2);
        }

        @Override
        public void process() {
            this.prepareParameters();
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull CassSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    CassSchemaRetriever.access$retrieveTables(this.this$0, schema2);
                }
            });
            int[] nArray = new int[]{3};
            if (CassIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                    final /* synthetic */ CassSchemaRetriever this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull CassSchema schema2) {
                        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                        CassSchemaRetriever.access$retrieveMatViews(this.this$0, schema2);
                    }
                });
            }
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull CassSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    CassSchemaRetriever.access$retrieveColumns(this.this$0, schema2);
                }
            });
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull CassSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    CassSchemaRetriever.access$retrieveIndices(this.this$0, schema2);
                }
            });
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull CassSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    CassSchemaRetriever.access$retrieveTriggers(this.this$0, schema2);
                }
            });
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull CassSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    CassSchemaRetriever.access$retrieveFunctions(this.this$0, schema2);
                }
            });
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull CassSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    CassSchemaRetriever.access$retrieveAggregates(this.this$0, schema2);
                }
            });
            this.inSchema((Function1)new Function1<CassSchema, Unit>(this){
                final /* synthetic */ CassSchemaRetriever this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull CassSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    CassSchemaRetriever.access$retrieveDefTypes(this.this$0, schema2);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTables(CassSchema schema2) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            CassIntrospector.this.reportRetrieving(objectKind);
            ModFamily modFamily = schema2.getTables();
            CassIntrospector cassIntrospector = CassIntrospector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily it2 = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            if (schema2.isVirtual()) {
                int[] nArray = new int[]{4};
                if (cassIntrospector.getServerVersion().isOrGreater(nArray)) {
                    this.retrieveTables3(schema2, CassIntroQueries.Companion.getQUERIES().getRetrieveVirtualTables4());
                }
            } else {
                int[] nArray = new int[]{3};
                if (cassIntrospector.getServerVersion().isOrGreater(nArray)) {
                    this.retrieveTables3(schema2, CassIntroQueries.Companion.getQUERIES().getRetrieveTables3());
                } else {
                    SqlQuery<List<CassIntroQueries.OneTable2>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveTables2();
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)schema2.getName(), (String)"getName(...)");
                    List<CassIntroQueries.OneTable2> list = this.performQuery(sqlQuery, null, objectArray);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String name2;
                        CassIntroQueries.OneTable2 t = (CassIntroQueries.OneTable2)element$iv;
                        boolean bl2 = false;
                        if (t.name == null) continue;
                        CassTable table = schema2.getTables().createOrGet(name2);
                        Intrinsics.checkNotNull((Object)table);
                        CassLikeTable cassLikeTable = table;
                        Intrinsics.checkNotNull((Object)t);
                        this.processLikeTable2(cassLikeTable, t);
                    }
                }
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        private final void retrieveTables3(CassSchema schema2, SqlQuery<List<CassIntroQueries.OneTable3>> query) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema2.getName(), (String)"getName(...)");
            Iterable $this$forEach$iv = this.performQuery(query, null, objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name2;
                CassIntroQueries.OneTable3 t = (CassIntroQueries.OneTable3)element$iv;
                boolean bl = false;
                if (t.name == null) continue;
                CassTable table = schema2.getTables().createOrGet(name2);
                Intrinsics.checkNotNull((Object)table);
                this.processLikeTable3(table, t);
            }
        }

        private final void retrieveMatViews(CassSchema schema2) {
            ObjectKind objectKind = ObjectKind.MAT_VIEW;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"MAT_VIEW");
            CassIntrospector.this.reportRetrieving(objectKind);
            ModFamily $this$modifyAndCleanup_u24default$iv = schema2.getMatViews();
            boolean inc$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily it2 = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            SqlQuery<List<CassIntroQueries.OneMatView3>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveMatViews();
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema2.getName(), (String)"getName(...)");
            List<CassIntroQueries.OneMatView3> list = this.performQuery(sqlQuery, null, objectArray);
            Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                String string2;
                CharSequence charSequence;
                String it3;
                CassMatView cassMatView;
                String name2;
                CassIntroQueries.OneMatView3 mv = (CassIntroQueries.OneMatView3)element$iv;
                boolean bl2 = false;
                if (mv.name == null) continue;
                CassMatView matView = schema2.getMatViews().createOrGet(name2);
                Intrinsics.checkNotNull((Object)matView);
                CassLikeTable cassLikeTable = matView;
                Intrinsics.checkNotNull((Object)mv);
                this.processLikeTable3(cassLikeTable, mv);
                CassMatView cassMatView2 = matView;
                if (mv.where_clause != null) {
                    CharSequence charSequence2;
                    cassMatView = cassMatView2;
                    boolean bl3 = false;
                    charSequence = it3;
                    if (charSequence.length() == 0) {
                        boolean bl4 = false;
                        charSequence2 = null;
                    } else {
                        charSequence2 = charSequence;
                    }
                    string2 = (String)charSequence2;
                    cassMatView2 = cassMatView;
                } else {
                    string2 = null;
                }
                cassMatView2.setWhereClause(string2);
                CassMatView cassMatView3 = matView;
                if (mv.base_table_name != null) {
                    CharSequence charSequence3;
                    cassMatView = cassMatView3;
                    boolean bl5 = false;
                    charSequence = it3;
                    if (charSequence.length() == 0) {
                        boolean bl6 = false;
                        charSequence3 = null;
                    } else {
                        charSequence3 = charSequence;
                    }
                    string = (String)charSequence3;
                    cassMatView3 = cassMatView;
                } else {
                    string = null;
                }
                cassMatView3.setBaseTableName(string);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void processLikeTable(CassLikeTable table, Map<CassTablePropertyKind, String> properties2, CassIntroQueries.OneLikeTable t) {
            block13: {
                String string;
                Object object;
                CassLikeTable cassLikeTable = table;
                String string2 = t.getComm();
                if (string2 != null) {
                    void it2;
                    String string3 = string2;
                    CassLikeTable cassLikeTable2 = cassLikeTable;
                    boolean bl = false;
                    object = ((CharSequence)it2).length() == 0 ? null : it2;
                    cassLikeTable = cassLikeTable2;
                } else {
                    object = null;
                }
                cassLikeTable.setComment((String)object);
                String string4 = t.getCachingValue();
                if (string4 != null) {
                    String it3 = string4;
                    boolean bl = false;
                    string = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(it3, CassIntrospectorKt.access$getLOG$p(), null, 4, null);
                    if (string != null) {
                        it3 = string;
                        boolean bl2 = false;
                        properties2.put(CassTablePropertyKind.CACHING, it3);
                    }
                }
                string4 = t.getCompressionValue();
                if (string4 != null) {
                    String it4 = string4;
                    boolean bl = false;
                    string = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(it4, CassIntrospectorKt.access$getLOG$p(), null, 4, null);
                    if (string != null) {
                        it4 = string;
                        boolean bl3 = false;
                        properties2.put(CassTablePropertyKind.COMPRESSION, it4);
                    }
                }
                Double d2 = t.getBloomFilterFpChance();
                if (d2 != null) {
                    double it5 = ((Number)d2).doubleValue();
                    boolean bl = false;
                    properties2.put(CassTablePropertyKind.BLOOM_FILTER_FP_CHANCE, CassTableProducersKt.toLiteral(it5));
                }
                Integer n = t.getDefaultTimeToLive();
                if (n != null) {
                    int it6 = ((Number)n).intValue();
                    boolean bl = false;
                    properties2.put(CassTablePropertyKind.DEFAULT_TIME_TO_LIVE, CassTableProducersKt.toLiteral(it6));
                }
                String string5 = t.getSpeculativeRetry();
                if (string5 != null) {
                    String it7 = string5;
                    boolean bl = false;
                    properties2.put(CassTablePropertyKind.SPECULATIVE_RETRY, it7);
                }
                Integer n3 = t.getGcGraceSeconds();
                if (n3 != null) {
                    int it8 = ((Number)n3).intValue();
                    boolean bl = false;
                    properties2.put(CassTablePropertyKind.GC_GRACE_SECONDS, CassTableProducersKt.toLiteral(it8));
                }
                Integer n4 = t.getMaxIndexInterval();
                if (n4 != null) {
                    int it9 = ((Number)n4).intValue();
                    boolean bl = false;
                    properties2.put(CassTablePropertyKind.MAX_INDEX_INTERVAL, CassTableProducersKt.toLiteral(it9));
                }
                Integer n5 = t.getMemtableFlushPeriodInMs();
                if (n5 != null) {
                    int it10 = ((Number)n5).intValue();
                    boolean bl = false;
                    properties2.put(CassTablePropertyKind.MEMTABLE_FLUSH_PERIOD_IN_MS, CassTableProducersKt.toLiteral(it10));
                }
                Integer n6 = t.getMinIndexInterval();
                if (n6 != null) {
                    int it11 = ((Number)n6).intValue();
                    boolean bl = false;
                    properties2.put(CassTablePropertyKind.MIN_INDEX_INTERVAL, CassTableProducersKt.toLiteral(it11));
                }
                Double d3 = t.getReadRepairChance();
                if (d3 == null) break block13;
                double it12 = ((Number)d3).doubleValue();
                boolean bl = false;
                properties2.put(CassTablePropertyKind.READ_REPAIR_CHANCE, CassTableProducersKt.toLiteral(it12));
            }
        }

        private final void processLikeTable2(CassLikeTable table, CassIntroQueries.OneLikeTable2 t) {
            Map properties2 = new LinkedHashMap();
            Intrinsics.checkNotNull((Object)t, (String)"null cannot be cast to non-null type com.intellij.database.dialects.cassandra.introspector.CassIntroQueries.OneLikeTable");
            this.processLikeTable(table, properties2, t);
            String string = CassIntrospectorHelperKt.concatClassAndOptions(t.getCompactionStrategyClass(), t.getCompactionStrategyOptions(), CassIntrospectorKt.access$getLOG$p());
            if (string != null) {
                String it2 = string;
                boolean bl = false;
                properties2.put(CassTablePropertyKind.COMPACTION, it2);
            }
            table.setProperties(properties2);
        }

        private final void processLikeTable3(CassLikeTable table, CassIntroQueries.OneLikeTable3 t) {
            Map properties2 = new LinkedHashMap();
            Intrinsics.checkNotNull((Object)t, (String)"null cannot be cast to non-null type com.intellij.database.dialects.cassandra.introspector.CassIntroQueries.OneLikeTable");
            this.processLikeTable(table, properties2, t);
            Boolean bl = t.getCdcValue();
            if (bl != null) {
                boolean it2 = bl;
                boolean bl2 = false;
                properties2.put(CassTablePropertyKind.CDC, CassTableProducersKt.toLiteral(it2));
            }
            Double d2 = t.getCrcCheckChance();
            if (d2 != null) {
                double it3 = ((Number)d2).doubleValue();
                boolean bl3 = false;
                properties2.put(CassTablePropertyKind.CRC_CHECK_CHANCE, CassTableProducersKt.toLiteral(it3));
            }
            Double d3 = t.getDclocalReadRepairChance();
            if (d3 != null) {
                double it4 = ((Number)d3).doubleValue();
                boolean bl4 = false;
                properties2.put(CassTablePropertyKind.DCLOCAL_READ_REPAIR_CHANCE, CassTableProducersKt.toLiteral(it4));
            }
            String string = t.getCompactionValue();
            if (string != null) {
                String it5 = string;
                boolean bl5 = false;
                String string2 = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(it5, CassIntrospectorKt.access$getLOG$p(), null, 4, null);
                if (string2 != null) {
                    it5 = string2;
                    boolean bl6 = false;
                    properties2.put(CassTablePropertyKind.COMPACTION, it5);
                }
            }
            String string3 = t.getAdditionalWritePolicy();
            if (string3 != null) {
                String it6 = string3;
                boolean bl7 = false;
                properties2.put(CassTablePropertyKind.ADDITIONAL_WRITE_POLICY, it6);
            }
            table.setProperties(properties2);
        }

        private final void retrieveColumns(CassSchema schema2) {
            boolean bl;
            CassMatView v2;
            boolean bl2;
            CassTable t;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            CassIntrospector.this.reportRetrieving(objectKind);
            CassIntrospector cassIntrospector = CassIntrospector.this;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Function1 it2 = CassSchemaRetriever$retrieveColumns$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32 = false;
            ModNamingFamily<? extends CassTable> modNamingFamily = schema2.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (CassTable)element$iv;
                bl2 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it2.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends CassMatView> modNamingFamily2 = schema2.getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getMatViews(...)");
            $this$forEach$iv = modNamingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v2 = (CassMatView)element$iv;
                bl = false;
                PositioningNamingFamily positioningNamingFamily = v2.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it2.invoke((Object)positioningNamingFamily);
            }
            boolean bl3 = false;
            Object[] $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32 = new String[]{schema2.getName()};
            Object[] freeParameters = $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32;
            $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32 = new int[2];
            $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32[0] = (String)3;
            $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32[1] = (String)false;
            if (cassIntrospector.getServerVersion().isOrGreater((int[])$i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32)) {
                $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32 = new int[2];
                $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32[0] = (String)4;
                $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32[1] = false;
                if (cassIntrospector.getServerVersion().isOrGreater((int[])$i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveColumns$32) && schema2.isVirtual()) {
                    this.retrieveColumnsInner(schema2, CassIntroQueries.Companion.getQUERIES().getRetrieveVirtualColumns4(), freeParameters, (Function2)new Function2<CassLikeTable, List<? extends CassIntroQueries.OneColumn3>, Unit>((Object)this){

                        public final void invoke(@NotNull CassLikeTable p0, @NotNull List<CassIntroQueries.OneColumn3> p1) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter(p1, (String)"p1");
                            CassSchemaRetriever.access$processColumns3((CassSchemaRetriever)this.receiver, p0, p1);
                        }
                    });
                } else {
                    this.retrieveColumnsInner(schema2, CassIntroQueries.Companion.getQUERIES().getRetrieveColumns3(), freeParameters, (Function2)new Function2<CassLikeTable, List<? extends CassIntroQueries.OneColumn3>, Unit>((Object)this){

                        public final void invoke(@NotNull CassLikeTable p0, @NotNull List<CassIntroQueries.OneColumn3> p1) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter(p1, (String)"p1");
                            CassSchemaRetriever.access$processColumns3((CassSchemaRetriever)this.receiver, p0, p1);
                        }
                    });
                }
            } else {
                this.retrieveColumnsInner(schema2, CassIntroQueries.Companion.getQUERIES().getRetrieveColumns2(), freeParameters, (Function2)new Function2<CassLikeTable, List<? extends CassIntroQueries.OneColumn2>, Unit>((Object)this){

                    public final void invoke(@NotNull CassLikeTable p0, @NotNull List<CassIntroQueries.OneColumn2> p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter(p1, (String)"p1");
                        CassSchemaRetriever.access$processColumns2((CassSchemaRetriever)this.receiver, p0, p1);
                    }
                });
            }
            it = CassSchemaRetriever$retrieveColumns$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            boolean bl4 = false;
            ModNamingFamily<? extends CassTable> modNamingFamily3 = schema2.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getTables(...)");
            $this$forEach$iv = modNamingFamily3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (CassTable)element$iv;
                bl2 = false;
                PositioningNamingFamily positioningNamingFamily = t.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
            ModNamingFamily<? extends CassMatView> modNamingFamily4 = schema2.getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"getMatViews(...)");
            $this$forEach$iv = modNamingFamily4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v2 = (CassMatView)element$iv;
                bl = false;
                PositioningNamingFamily positioningNamingFamily = v2.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                it.invoke((Object)positioningNamingFamily);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final <T extends CassIntroQueries.OneColumn> void retrieveColumnsInner(CassSchema schema, SqlQuery<List<T>> query, Object[] freeParameters, Function2<? super CassLikeTable, ? super List<? extends T>, Unit> action) {
            block5: {
                tableCache = new NameCache<T>();
                columns = new ArrayList<E>();
                $this$forEach$iv = this.performQuery(query, null, Arrays.copyOf(freeParameters, freeParameters.length));
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    c = (CassIntroQueries.OneColumn)element$iv;
                    $i$a$-forEach-CassIntrospector$CassSchemaRetriever$retrieveColumnsInner$1 = false;
                    if (c.getTableName() == null) continue;
                    this_$iv = tableCache;
                    $i$f$get = false;
                    var16_17 = this_$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v0 = this_$iv$iv.getV();
                    Intrinsics.checkNotNull(v0);
                    if (Intrinsics.areEqual((Object)v0.getName(), (Object)tableName)) {
                        v1 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var19_20 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, tableName){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = $create;
                                this.$name = $name;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        var20_21 = this_$iv$iv;
                        var21_22 = this_$iv$iv;
                        $i$a$-get-CassIntrospector$CassSchemaRetriever$retrieveColumnsInner$1$1 = false;
                        if ((CassLikeTable)$this$retrieveColumnsInner_u24lambda_u2435_u24lambda_u2434.getV() != null) {
                            $i$a$-let-CassIntrospector$CassSchemaRetriever$retrieveColumnsInner$1$1$1 = false;
                            action.invoke((Object)v, (Object)columns);
                        }
                        columns.clear();
                        v2 = schema.getTables();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                        v3 = (CassLikeTable)it.invoke(v2);
                        if (v3 == null) {
                            v4 = schema.getMatViews();
                            Intrinsics.checkNotNullExpressionValue(v4, (String)"getMatViews(...)");
                            v3 = (CassLikeTable)it.invoke(v4);
                        }
                        var21_22.setV((BasicModNamedElement)v3);
                        v1 = this_$iv$iv.getV();
                    }
                    columns.add(c);
                }
                v5 = (CassLikeTable)tableCache.getV();
                if (v5 == null) break block5;
                table = v5;
                $i$a$-let-CassIntrospector$CassSchemaRetriever$retrieveColumnsInner$2 = false;
                action.invoke((Object)table, (Object)columns);
            }
        }

        private final void processColumns3(CassLikeTable table, List<CassIntroQueries.OneColumn3> columns2) {
            ColumnSorter columnSorter = new ColumnSorter(columns2);
            Iterable $this$forEach$iv = columns2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name2;
                CassIntroQueries.OneColumn3 c2 = (CassIntroQueries.OneColumn3)element$iv;
                boolean bl = false;
                if (c2.name == null) continue;
                BasicModTableOrViewColumn column2 = (BasicModTableOrViewColumn)table.getColumns().renewAt(columnSorter.idx(c2), name2);
                if (c2.type != null) {
                    String type2;
                    boolean bl2 = false;
                    DataType dataType = DataTypeFactory.of(type2);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    column2.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
                }
                if (!(column2 instanceof CassTableColumn)) continue;
                ((CassTableColumn)column2).setStaticColumn(Intrinsics.areEqual((Object)c2.kind, (Object)"static"));
            }
            this.createKey(table, columns2);
        }

        private final void createKey(CassLikeTable table, List<? extends CassIntroQueries.OneColumn> columns2) {
            CassKey k = (CassKey)table.getKeys().createOrGet("primary key");
            Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)columns2), (Function1)createKey.partitioningCols.1.INSTANCE);
            boolean $i$f$sortedBy = false;
            Sequence partitioningCols2 = SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b2) {
                    CassIntroQueries.OneColumn it2 = (CassIntroQueries.OneColumn)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it2.getPos());
                    it2 = (CassIntroQueries.OneColumn)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it2.getPos()));
                }
            }), (Function1)createKey.partitioningCols.3.INSTANCE);
            Sequence $this$sortedBy$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)columns2), (Function1)createKey.clusteringCols.1.INSTANCE);
            boolean $i$f$sortedBy2 = false;
            Sequence clusteringCols2 = SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b2) {
                    CassIntroQueries.OneColumn it2 = (CassIntroQueries.OneColumn)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it2.getPos());
                    it2 = (CassIntroQueries.OneColumn)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it2.getPos()));
                }
            }), (Function1)createKey.clusteringCols.3.INSTANCE);
            k.setColumns(SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)partitioningCols2, (Sequence)clusteringCols2)));
        }

        private final void processColumns2(CassLikeTable table, List<CassIntroQueries.OneColumn2> columns2) {
            ColumnSorter columnSorter = new ColumnSorter(columns2);
            Iterable $this$forEach$iv = columns2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataType it2;
                String string;
                String name2;
                CassIntroQueries.OneColumn2 c2 = (CassIntroQueries.OneColumn2)element$iv;
                boolean bl = false;
                if (c2.name == null) continue;
                BasicModTableOrViewColumn column2 = (BasicModTableOrViewColumn)table.getColumns().renewAt(columnSorter.idx(c2), name2);
                if (column2 instanceof CassTableColumn) {
                    ((CassTableColumn)column2).setStaticColumn(Intrinsics.areEqual((Object)c2.type, (Object)"static"));
                }
                if ((string = c2.validator) == null) continue;
                String it3 = string;
                boolean bl2 = false;
                String string2 = this.unwrapReversed(it3);
                string = string2;
                if (string2 == null) {
                    continue;
                }
                String validator = string;
                if (CassSchemaRetriever.getDataType$default(this, validator, false, 2, null) == null) continue;
                boolean bl3 = false;
                column2.setStoredType(DasUnresolvedTypeReference.Companion.of(it2));
            }
            this.createKey(table, columns2);
        }

        private final String unwrapReversed(String s2) {
            if (StringsKt.startsWith$default((String)s2, (String)"org.apache.cassandra.db.marshal.ReversedType", (boolean)false, (int)2, null)) {
                String string = s2.substring(StringsKt.indexOf$default((CharSequence)s2, (char)'(', (int)0, (boolean)false, (int)6, null) + 1, StringsKt.lastIndexOf$default((CharSequence)s2, (char)')', (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            return s2;
        }

        private final void retrieveIndices(CassSchema schema2) {
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            CassIntrospector.this.reportRetrieving(objectKind);
            int[] nArray = new int[]{3};
            if (CassIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                this.retrieveIndices3(schema2);
            } else {
                this.retrieveIndices2(schema2);
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final void retrieveIndices2(CassSchema schema) {
            v0 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"getTables(...)");
            $this$map$iv = v0;
            $i$f$map = false;
            var4_5 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var9_18 = (CassTable)item$iv$iv;
                var33_16 = destination$iv$iv;
                $i$a$-map-CassIntrospector$CassSchemaRetriever$retrieveIndices2$1 = false;
                var33_16.add(it.getIndices());
            }
            families$iv = (List)destination$iv$iv;
            inc$iv = true;
            $i$f$modifyFamiliesAndCleanup = false;
            $this$toTypedArray$iv$iv = families$iv;
            $i$f$toTypedArray = false;
            thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            $i$f$modifyFamiliesAndCleanup = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            $i$a$-modifyFamiliesAndCleanup$default-CassIntrospector$CassSchemaRetriever$retrieveIndices2$2 = false;
            v1 = CassIntroQueries.Companion.getQUERIES().getRetrieveIndices2();
            var12_27 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"getName(...)");
            v2 = this.performQuery(v1, null, var12_27);
            Intrinsics.checkNotNullExpressionValue(v2, (String)"performQuery(...)");
            $this$forEach$iv = v2;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                i = (CassIntroQueries.OneIndex2)element$iv /* !! */ ;
                $i$a$-forEach-CassIntrospector$CassSchemaRetriever$retrieveIndices2$2$1 = false;
                fullName = i.name;
                if (fullName == null) continue;
                dot = StringsKt.indexOf$default((CharSequence)fullName, (char)'.', (int)0, (boolean)false, (int)6, null);
                Intrinsics.checkNotNullExpressionValue((Object)fullName.substring(0, dot), (String)"substring(...)");
                Intrinsics.checkNotNullExpressionValue((Object)fullName.substring(dot + 1), (String)"substring(...)");
                if ((CassTable)schema.getTables().get(tableName) == null) continue;
                table.getIndices().createOrGet(indexName);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
            tableCache = new NameCache<T>();
            indexCache = new NameCache<T>();
            columns = new ArrayList<E>();
            v3 = CassIntroQueries.Companion.getQUERIES().getRetrieveColumns2();
            $i$f$modifyFamiliesAndCleanup = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema.getName(), (String)"getName(...)");
            v4 = this.performQuery(v3, null, $i$f$modifyFamiliesAndCleanup);
            Intrinsics.checkNotNullExpressionValue(v4, (String)"performQuery(...)");
            $this$forEach$iv = v4;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                block12: {
                    block11: {
                        c = (CassIntroQueries.OneColumn2)element$iv;
                        $i$a$-forEach-CassIntrospector$CassSchemaRetriever$retrieveIndices2$3 = false;
                        if (c.index_name == null || c.index_name == null || c.getTableName() == null) continue;
                        this_$iv = indexCache;
                        $i$f$get = false;
                        element$iv /* !! */  = this_$iv;
                        create$iv$iv = false;
                        $i$f$get = false;
                        if (this_$iv$iv.getV() == null) break block11;
                        v5 = this_$iv$iv.getV();
                        Intrinsics.checkNotNull(v5);
                        if (!Intrinsics.areEqual((Object)v5.getName(), (Object)indexName)) break block11;
                        v6 = this_$iv$iv.getV();
                        break block12;
                    }
                    fullName = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, indexName){
                        final /* synthetic */ boolean $create;
                        final /* synthetic */ String $name;
                        {
                            this.$create = $create;
                            this.$name = $name;
                            super(1);
                        }

                        @Nullable
                        public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                            Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                            return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                        }
                    };
                    dot = this_$iv$iv;
                    var20_40 = this_$iv$iv;
                    $i$a$-get-CassIntrospector$CassSchemaRetriever$retrieveIndices2$3$1 = false;
                    table = (CassTable)tableCache.getV();
                    index = (CassIndex)$this$retrieveIndices2_u24lambda_u2449_u24lambda_u2448.getV();
                    if (table != null && index != null) {
                        CassSchemaRetriever.access$processIndex(this, table, index, columns);
                    }
                    columns.clear();
                    this_$iv = tableCache;
                    $i$f$get = false;
                    var26_47 = this_$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v7 = this_$iv$iv.getV();
                    Intrinsics.checkNotNull(v7);
                    if (Intrinsics.areEqual((Object)v7.getName(), (Object)tableName)) {
                        v8 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var29_50 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, tableName){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = $create;
                                this.$name = $name;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        var30_51 = this_$iv$iv;
                        var31_52 = this_$iv$iv;
                        $i$a$-get-CassIntrospector$CassSchemaRetriever$retrieveIndices2$3$1$1 = false;
                        v9 = schema.getTables();
                        Intrinsics.checkNotNullExpressionValue(v9, (String)"getTables(...)");
                        var31_52.setV((BasicModNamedElement)((CassTable)it.invoke(v9)));
                        v8 = this_$iv$iv.getV();
                    }
                    if ((v10 /* !! */  = (CassTable)v8) != null && (v10 /* !! */  = (var24_45 = v10 /* !! */ .getIndices())) != null) {
                        Intrinsics.checkNotNull((Object)v10 /* !! */ );
                        v11 = (CassIndex)it.invoke((Object)var24_45);
                    } else {
                        v11 = null;
                    }
                    var20_40.setV((BasicModNamedElement)v11);
                    v6 = this_$iv$iv.getV();
                }
                Intrinsics.checkNotNull((Object)c);
                columns.add(c);
            }
            table = (CassTable)tableCache.getV();
            index = (CassIndex)indexCache.getV();
            if (table != null && index != null) {
                this.processIndex(table, index, columns);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void processIndex(CassTable table, CassIndex index, List<CassIntroQueries.OneColumn2> columns) {
            v0 = (CassIntroQueries.OneColumn2)CollectionsKt.firstOrNull(columns);
            if (v0 == null) {
                return;
            }
            firstCol = v0;
            index.setCustom(this.isIndexCustom(firstCol.index_type));
            var5_5 = columns;
            var25_6 = index;
            $i$f$mapNotNull = false;
            var7_8 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var12_13 = $this$forEach$iv$iv$iv.iterator();
            while (var12_13.hasNext()) {
                block6: {
                    block7: {
                        block9: {
                            block8: {
                                block5: {
                                    element$iv$iv = element$iv$iv$iv = var12_13.next();
                                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                    c = (CassIntroQueries.OneColumn2)element$iv$iv;
                                    $i$a$-mapNotNull-CassIntrospector$CassSchemaRetriever$processIndex$1 = false;
                                    if (c.name != null) break block5;
                                    v1 = null;
                                    break block6;
                                }
                                options = c.index_options;
                                modifier = null;
                                if (options == null) break block7;
                                obj = CassIntrospectorHelperKt.parseObject(options, CassIntrospectorKt.access$getLOG$p());
                                v2 = obj;
                                if ((v2 != null ? v2.get("index_keys_and_values") : null) == null) break block8;
                                modifier = "entries";
                                break block7;
                            }
                            v3 = obj;
                            if ((v3 != null ? v3.get("index_keys") : null) == null) break block9;
                            modifier = "keys";
                            break block7;
                        }
                        v4 = (CassTableColumn)table.getColumns().get(columnName);
                        if (v4 == null || (v4 = (var22_23 = v4.getDasType())) == null) ** GOTO lbl-1000
                        Intrinsics.checkNotNull((Object)v4);
                        v4 = DasTypeUtilsKt.getTypeName(var22_23);
                        if (v4 != null) {
                            v5 = StringsKt.startsWith$default((String)v4, (String)"frozen<", (boolean)false, (int)2, null);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v5 = false;
                        }
                        if (v5) {
                            modifier = "full";
                        }
                    }
                    v1 = new IndexColumn(columnName, modifier);
                }
                if (v1 == null) continue;
                it$iv$iv = v1;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            var25_6.setColumns((List)destination$iv$iv);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveIndices3(CassSchema schema2) {
            void $this$mapTo$iv$iv;
            ModNamingFamily<? extends CassTable> modNamingFamily = schema2.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                CassTable cassTable = (CassTable)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it2.getIndices());
            }
            Collection families$iv = (List)destination$iv$iv;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Collection $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            SqlQuery<List<CassIntroQueries.OneIndex3>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveIndices3();
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema2.getName(), (String)"getName(...)");
            List<CassIntroQueries.OneIndex3> list = this.performQuery(sqlQuery, null, objectArray);
            Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                JsonElement it3;
                Object object2;
                JsonElement jsonElement;
                String indexName;
                CassTable table;
                String tableName;
                CassIntroQueries.OneIndex3 i2 = (CassIntroQueries.OneIndex3)element$iv;
                boolean bl2 = false;
                if (i2.table_name == null || i2.name == null || (CassTable)schema2.getTables().get(tableName) == null) continue;
                CassIndex index2 = (CassIndex)table.getIndices().createOrGet(indexName);
                index2.setCustom(this.isIndexCustom(i2.kind));
                String options2 = i2.options;
                if (options2 == null) continue;
                JsonObject obj2 = CassIntrospectorHelperKt.parseObject(options2, CassIntrospectorKt.access$getLOG$p());
                Object object3 = obj2;
                if (object3 != null && (object3 = (jsonElement = object3.get("target"))) != null) {
                    Intrinsics.checkNotNull((Object)object3);
                    it3 = object2 = jsonElement;
                    boolean bl3 = false;
                    object3 = it3.isJsonPrimitive() ? object2 : null;
                    if (object3 != null && (object3 = (object2 = object3.getAsString())) != null) {
                        Object object4;
                        String modificator;
                        Intrinsics.checkNotNull((Object)object3);
                        JsonElement target2 = object2;
                        boolean bl4 = false;
                        int parenth = StringsKt.indexOf$default((CharSequence)((CharSequence)target2), (String)"(", (int)0, (boolean)false, (int)6, null);
                        if (parenth != -1) {
                            String string = target2.substring(0, parenth);
                            v5 = string;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        } else {
                            v5 = modificator = null;
                        }
                        if (modificator != null) {
                            String string = target2.substring(parenth + 1, target2.length() - 1);
                            object4 = string;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        } else {
                            object4 = target2;
                        }
                        Object colName = object4;
                        index2.setColumns(CollectionsKt.listOf((Object)new IndexColumn((String)colName, StringUtil.toLowerCase((String)modificator))));
                    }
                }
                if ((object = obj2) != null && (object = (jsonElement = object.get("class_name"))) != null) {
                    Intrinsics.checkNotNull((Object)object);
                    it3 = object2 = jsonElement;
                    boolean bl5 = false;
                    object = it3.isJsonPrimitive() ? object2 : null;
                    if (object != null && (object = (object2 = object.getAsString())) != null) {
                        Intrinsics.checkNotNull((Object)object);
                        Object it4 = object2;
                        boolean bl6 = false;
                        index2.setClassName((String)it4);
                    }
                }
                index2.setOptions(CassIntrospectorHelperKt.jsonToCassandraMapLiteral(options2, CassIntrospectorKt.access$getLOG$p(), (Function1<? super String, Boolean>)((Function1)retrieveIndices3.2.1.5.INSTANCE)));
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final boolean isIndexCustom(String kind) {
            return StringUtil.equalsIgnoreCase((CharSequence)kind, (CharSequence)"custom");
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggers(CassSchema schema2) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            CassIntrospector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends CassTable> modNamingFamily = schema2.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                CassTable cassTable = (CassTable)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it2.getTriggers());
            }
            Collection families$iv = (List)destination$iv$iv;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Collection $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            SqlQuery<List<CassIntroQueries.OneTrigger>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveTriggers();
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema2.getName(), (String)"getName(...)");
            List<CassIntroQueries.OneTrigger> list = this.performQuery(sqlQuery, null, objectArray);
            Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
            Iterable iterable2 = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                String triggerName;
                CassTable table;
                String tableName;
                CassIntroQueries.OneTrigger t = (CassIntroQueries.OneTrigger)element$iv;
                boolean bl2 = false;
                if (t.table_name == null || t.name == null || (CassTable)schema2.getTables().get(tableName) == null) continue;
                CassTrigger trigger2 = table.getTriggers().createOrGet(triggerName);
                String string2 = t.options;
                if (string2 == null) continue;
                String it3 = string2;
                boolean bl3 = false;
                JsonObject jsonObject = CassIntrospectorHelperKt.parseObject(it3, CassIntrospectorKt.access$getLOG$p());
                Object object = jsonObject != null ? jsonObject.get("class") : null;
                string2 = object;
                if (object == null) continue;
                String it4 = string = string2;
                boolean bl4 = false;
                string2 = it4.isJsonPrimitive() ? string : null;
                if (string2 == null || (string2 = (string = string2.getAsString())) == null) continue;
                Intrinsics.checkNotNull((Object)string2);
                String it5 = string;
                boolean bl5 = false;
                trigger2.setClassName(it5);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final void retrieveFunctions(CassSchema schema2) {
            int[] nArray = new int[]{2, 2};
            if (!CassIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            CassIntrospector.this.reportRetrieving(objectKind);
            ModFamily $this$modifyAndCleanup_u24default$iv = schema2.getFunctions();
            boolean inc$iv22 = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily it2 = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            SqlQuery<List<CassIntroQueries.OneFunction>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveFunctions();
            Object[] inc$iv22 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema2.getName(), (String)"getName(...)");
            List<CassIntroQueries.OneFunction> list = this.performQuery(sqlQuery, null, inc$iv22);
            Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name2;
                CassIntroQueries.OneFunction f = (CassIntroQueries.OneFunction)element$iv;
                boolean bl2 = false;
                if (f.name == null) continue;
                CassFunction function2 = (CassFunction)schema2.getFunctions().createNewOne();
                function2.setName(name2);
                Intrinsics.checkNotNull((Object)f);
                Intrinsics.checkNotNull((Object)function2);
                this.processFunction(f, function2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processFunction(CassIntroQueries.OneFunction f, CassFunction function2) {
            DataType dataType = this.getDataType(f.return_type, true);
            if (dataType != null) {
                DataType it2 = dataType;
                boolean bl = false;
                this.setReturnType(function2, it2);
            }
            if (f.argument_names != null) {
                String[] $this$forEachIndexed$iv = f.argument_names;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (String item$iv : $this$forEachIndexed$iv) {
                    DataType it3;
                    String string;
                    void argumentName;
                    int n = index$iv++;
                    String string2 = item$iv;
                    int index2 = n;
                    boolean bl = false;
                    CassArgument argument = (CassArgument)function2.getArguments().renewAt((short)(index2 + 2), (String)argumentName);
                    if (f.argument_types != null) {
                        string = f.argument_types[index2];
                    } else {
                        String[] cfr_ignored_0 = f.argument_types;
                        string = null;
                    }
                    if (this.getDataType(string, true) == null) continue;
                    boolean bl2 = false;
                    argument.setStoredType(DasUnresolvedTypeReference.Companion.of(it3));
                }
            }
            function2.setCalledOnNullInput(f.called_on_null_input);
            function2.setLanguage(f.language);
            String string = f.body;
            if (string == null) {
                return;
            }
            String body2 = string;
            ((BasicModModel)function2.getModel()).writeSources(() -> CassSchemaRetriever.processFunction$lambda$69(function2, body2));
        }

        private final void setReturnType(CassRoutine routine2, DataType returnDataType) {
            CassArgument argument = (CassArgument)routine2.getArguments().renewAt((short)1, "");
            argument.setStoredType(DasUnresolvedTypeReference.Companion.of(returnDataType));
            argument.setArgumentDirection(ArgumentDirection.RETURN);
        }

        private final DataType getDataType(String validator, boolean unwrapFrozen) {
            String string;
            if (validator == null) {
                return null;
            }
            int[] nArray = new int[]{3, 0};
            if (CassIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                string = validator;
            } else {
                string = CassIntrospectorHelperKt.parseDataType(validator);
                if (string == null) {
                    return null;
                }
            }
            String specification = string;
            return DataTypeFactory.of(unwrapFrozen ? this.unwrapFrozen(specification) : specification);
        }

        static /* synthetic */ DataType getDataType$default(CassSchemaRetriever cassSchemaRetriever, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return cassSchemaRetriever.getDataType(string, bl);
        }

        private final String unwrapFrozen(String s2) {
            if (StringsKt.startsWith$default((String)s2, (String)"frozen<", (boolean)false, (int)2, null)) {
                String string = s2.substring(7, s2.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            return s2;
        }

        private final void retrieveAggregates(CassSchema schema2) {
            int[] nArray = new int[]{2, 2};
            if (!CassIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.AGGREGATE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"AGGREGATE");
            CassIntrospector.this.reportRetrieving(objectKind);
            ModFamily $this$modifyAndCleanup_u24default$iv = schema2.getAggregates();
            boolean inc$iv = true;
            boolean $i$f$modifyAndCleanup22 = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily it2 = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            String string = schema2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Map<String, String> initConditions = this.getAggregateInitConditions(string);
            SqlQuery<List<CassIntroQueries.OneAggregate>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveAggregate();
            Object[] $i$f$modifyAndCleanup22 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema2.getName(), (String)"getName(...)");
            List<CassIntroQueries.OneAggregate> list = this.performQuery(sqlQuery, null, $i$f$modifyAndCleanup22);
            Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name2;
                CassIntroQueries.OneAggregate a = (CassIntroQueries.OneAggregate)element$iv;
                boolean bl2 = false;
                if (a.name == null) continue;
                CassAggregate aggregate = (CassAggregate)schema2.getAggregates().createNewOne();
                aggregate.setName(name2);
                Intrinsics.checkNotNull((Object)a);
                Intrinsics.checkNotNull((Object)aggregate);
                this.processAggregate(a, aggregate, initConditions);
            }
        }

        private final Map<String, String> getAggregateInitConditions(String keyspace) {
            RemoteConnection connection2;
            DatabaseConnectionCore databaseConnectionCore = CassIntrospector.this.getDbConnection();
            Object object = connection2 = databaseConnectionCore != null ? databaseConnectionCore.getRemoteConnection() : null;
            if (connection2 == null || !(connection2 instanceof RemoteCassConnection)) {
                return null;
            }
            try {
                return ((RemoteCassConnection)connection2).getAggregateInitConditions(keyspace);
            }
            catch (NoSuchObjectException e2) {
                CassIntrospectorKt.access$getLOG$p().error((Throwable)e2);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processAggregate(CassIntroQueries.OneAggregate a, CassAggregate aggregate, Map<String, String> initConditions) {
            block3: {
                DataType dataType = this.getDataType(a.return_type, true);
                if (dataType != null) {
                    DataType it2 = dataType;
                    boolean bl = false;
                    this.setReturnType(aggregate, it2);
                }
                if (a.signature != null) {
                    String[] $this$forEachIndexed$iv = a.signature;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (String item$iv : $this$forEachIndexed$iv) {
                        void type2;
                        int n = index$iv++;
                        String string = item$iv;
                        int index2 = n;
                        boolean bl = false;
                        CassArgument argument = (CassArgument)aggregate.getArguments().renewAt((short)(index2 + 2), "");
                        DataType dataType2 = DataTypeFactory.of(this.unwrapFrozen((String)type2));
                        Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"of(...)");
                        argument.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType2));
                    }
                }
                aggregate.setFinalFunc(a.final_func);
                aggregate.setStateFunc(a.state_func);
                aggregate.setInitCond(this.getInitCondition(initConditions, a));
                DataType dataType3 = this.getDataType(a.state_type, true);
                if (dataType3 == null) break block3;
                DataType it3 = dataType3;
                boolean bl = false;
                aggregate.setStateStoredType(DasUnresolvedTypeReference.Companion.of(it3));
            }
        }

        private final String getInitCondition(Map<String, String> initConditions, CassIntroQueries.OneAggregate a) {
            String string;
            if (initConditions == null) {
                return "???";
            }
            String string2 = a.name;
            if (a.signature != null) {
                string = ArraysKt.joinToString$default((Object[])a.signature, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
                    final /* synthetic */ CassSchemaRetriever this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull String it2) {
                        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                        return CassSchemaRetriever.access$unwrapFrozen(this.this$0, it2);
                    }
                }), (int)31, null);
            } else {
                String[] cfr_ignored_0 = a.signature;
                string = null;
            }
            String signature2 = string2 + "(" + string + ")";
            return initConditions.get(signature2);
        }

        private final void retrieveDefTypes(CassSchema schema2) {
            ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OBJECT_TYPE");
            CassIntrospector.this.reportRetrieving(objectKind);
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Function1 it2 = CassSchemaRetriever$retrieveDefTypes$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveDefTypes$32 = false;
            ModNamingFamily<? extends CassDefType> modNamingFamily = schema2.getDefTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getDefTypes(...)");
            it2.invoke(modNamingFamily);
            ModNamingFamily<? extends CassDefType> modNamingFamily2 = schema2.getDefTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getDefTypes(...)");
            Iterable $this$forEach$iv = modNamingFamily2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CassDefType d2 = (CassDefType)element$iv;
                boolean bl = false;
                ModPositioningNamingFamily<? extends CassDefTypeAttribute> modPositioningNamingFamily = d2.getAttributes();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getAttributes(...)");
                it2.invoke(modPositioningNamingFamily);
            }
            boolean bl = false;
            SqlQuery<List<CassIntroQueries.OneDefType>> sqlQuery = CassIntroQueries.Companion.getQUERIES().getRetrieveDefTypes();
            Object[] $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveDefTypes$32 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)schema2.getName(), (String)"getName(...)");
            List<CassIntroQueries.OneDefType> list = this.performQuery(sqlQuery, null, $i$a$-modifyFamiliesAndCleanup-CassIntrospector$CassSchemaRetriever$retrieveDefTypes$32);
            Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
            $this$forEach$iv = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String name2;
                CassIntroQueries.OneDefType t = (CassIntroQueries.OneDefType)element$iv;
                boolean bl2 = false;
                if (t.name == null) continue;
                CassDefType objectType = schema2.getDefTypes().createOrGet(name2);
                Intrinsics.checkNotNull((Object)t);
                Intrinsics.checkNotNull((Object)objectType);
                this.processDefType(t, objectType);
            }
            it = CassSchemaRetriever$retrieveDefTypes$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            boolean bl3 = false;
            ModNamingFamily<? extends CassDefType> modNamingFamily3 = schema2.getDefTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getDefTypes(...)");
            it.invoke(modNamingFamily3);
            ModNamingFamily<? extends CassDefType> modNamingFamily4 = schema2.getDefTypes();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"getDefTypes(...)");
            $this$forEach$iv = modNamingFamily4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CassDefType d3 = (CassDefType)element$iv;
                boolean bl4 = false;
                ModPositioningNamingFamily<? extends CassDefTypeAttribute> modPositioningNamingFamily = d3.getAttributes();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getAttributes(...)");
                it.invoke(modPositioningNamingFamily);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processDefType(CassIntroQueries.OneDefType t, CassDefType objectType) {
            if (t.field_names == null) {
                return;
            }
            String[] fieldNames = t.field_names;
            if (t.field_types == null) {
                return;
            }
            String[] fieldTypes = t.field_types;
            String[] $this$forEachIndexed$iv = fieldNames;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (String item$iv : $this$forEachIndexed$iv) {
                DataType it2;
                void objectTypeName;
                int n = index$iv++;
                String string = item$iv;
                int index2 = n;
                boolean bl = false;
                CassDefTypeAttribute attribute = objectType.getAttributes().renewAt((short)(index2 + 1), (String)objectTypeName);
                if (CassSchemaRetriever.getDataType$default(this, fieldTypes[index2], false, 2, null) == null) continue;
                boolean bl2 = false;
                attribute.setStoredType(DasUnresolvedTypeReference.Companion.of(it2));
            }
        }

        private static final void processFunction$lambda$69(CassFunction $function, String $body) {
            Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
            Intrinsics.checkNotNullParameter((Object)$body, (String)"$body");
            $function.setSourceText(BaseIntrospectionFunctions.toCompositeText($body, CompositeText.Kind.ORIGINAL_TEXT));
        }

        public static final /* synthetic */ void access$retrieveTables(CassSchemaRetriever $this, CassSchema schema2) {
            $this.retrieveTables(schema2);
        }

        public static final /* synthetic */ void access$retrieveMatViews(CassSchemaRetriever $this, CassSchema schema2) {
            $this.retrieveMatViews(schema2);
        }

        public static final /* synthetic */ void access$retrieveColumns(CassSchemaRetriever $this, CassSchema schema2) {
            $this.retrieveColumns(schema2);
        }

        public static final /* synthetic */ void access$retrieveIndices(CassSchemaRetriever $this, CassSchema schema2) {
            $this.retrieveIndices(schema2);
        }

        public static final /* synthetic */ void access$retrieveTriggers(CassSchemaRetriever $this, CassSchema schema2) {
            $this.retrieveTriggers(schema2);
        }

        public static final /* synthetic */ void access$retrieveFunctions(CassSchemaRetriever $this, CassSchema schema2) {
            $this.retrieveFunctions(schema2);
        }

        public static final /* synthetic */ void access$retrieveAggregates(CassSchemaRetriever $this, CassSchema schema2) {
            $this.retrieveAggregates(schema2);
        }

        public static final /* synthetic */ void access$retrieveDefTypes(CassSchemaRetriever $this, CassSchema schema2) {
            $this.retrieveDefTypes(schema2);
        }

        public static final /* synthetic */ String access$unwrapFrozen(CassSchemaRetriever $this, String s2) {
            return $this.unwrapFrozen(s2);
        }

        public static final /* synthetic */ void access$processColumns3(CassSchemaRetriever $this, CassLikeTable table, List columns2) {
            $this.processColumns3(table, columns2);
        }

        public static final /* synthetic */ void access$processColumns2(CassSchemaRetriever $this, CassLikeTable table, List columns2) {
            $this.processColumns2(table, columns2);
        }

        public static final /* synthetic */ void access$processIndex(CassSchemaRetriever $this, CassTable table, CassIndex index2, List columns2) {
            $this.processIndex(table, index2, columns2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever$ColumnSorter;", "", "columns", "", "Lcom/intellij/database/dialects/cassandra/introspector/CassIntroQueries$OneColumn;", "(Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever;Ljava/util/List;)V", "clusteringColsCount", "", "partitionColsCount", "regularColumnsCount", "idx", "", "c", "intellij.database.dialects.cassandra"})
        @SourceDebugExtension(value={"SMAP\nCassIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassIntrospector.kt\ncom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever$ColumnSorter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,558:1\n1774#2,4:559\n1774#2,4:563\n*S KotlinDebug\n*F\n+ 1 CassIntrospector.kt\ncom/intellij/database/dialects/cassandra/introspector/CassIntrospector$CassSchemaRetriever$ColumnSorter\n*L\n296#1:559,4\n297#1:563,4\n*E\n"})
        private final class ColumnSorter {
            private final int partitionColsCount;
            private final int clusteringColsCount;
            private int regularColumnsCount;

            public ColumnSorter(List<? extends CassIntroQueries.OneColumn> columns2) {
                int n;
                int n3;
                CassIntroQueries.OneColumn it2;
                int count$iv;
                int n4;
                Iterable $this$count$iv;
                Intrinsics.checkNotNullParameter(columns2, (String)"columns");
                Iterable iterable = columns2;
                ColumnSorter columnSorter = this;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n4 = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it2 = (CassIntroQueries.OneColumn)element$iv;
                        boolean bl = false;
                        if (!(it2.getK() == CassIntroQueries.ColumnKind.PARTITIONING) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n4 = count$iv;
                }
                columnSorter.partitionColsCount = n3 = n4;
                $this$count$iv = columns2;
                columnSorter = this;
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it2 = (CassIntroQueries.OneColumn)element$iv;
                        boolean bl = false;
                        if (!(it2.getK() == CassIntroQueries.ColumnKind.CLUSTERING) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                columnSorter.clusteringColsCount = n3 = n;
            }

            public final short idx(@NotNull CassIntroQueries.OneColumn c2) {
                Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
                return (short)(1 + (switch (WhenMappings.$EnumSwitchMapping$0[c2.getK().ordinal()]) {
                    case 1 -> c2.getPos();
                    case 2 -> c2.getPos() + this.partitionColsCount;
                    default -> {
                        int var2_2 = this.regularColumnsCount;
                        this.regularColumnsCount = var2_2 + 1;
                        yield this.partitionColsCount + this.clusteringColsCount + var2_2;
                    }
                }));
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[CassIntroQueries.ColumnKind.values().length];
                    try {
                        nArray[CassIntroQueries.ColumnKind.PARTITIONING.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[CassIntroQueries.ColumnKind.CLUSTERING.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.cassandra"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{2, 0};
            return version.isOrGreater(nArray);
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new CassIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return false;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/cassandra/introspector/CassIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.cassandra"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

