/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.ForbidIncrementalOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.introspection.BelongingAreaKind;
import com.intellij.database.introspection.CheckUptodatenessIntrospectionTask;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DatabaseIntrospectionTask;
import com.intellij.database.introspection.DatabaseObjectsIntrospectionTask;
import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.FamilyFragment;
import com.intellij.database.introspection.FragmentIntrospectionTask;
import com.intellij.database.introspection.IntrospectionMetricKey;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.RegularIntrospectionTask;
import com.intellij.database.introspection.SchemasIntrospectionTask;
import com.intellij.database.introspection.ServerObjectsIntrospectionTask;
import com.intellij.database.introspection.query.PreprocessedQuery;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementChecker;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModMultiLevelRoot;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPathFun;
import com.intellij.database.util.ObjectPathNamespace;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.common.BooleanFun;
import com.intellij.database.util.common.CalendarFun;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.util.common.StringFun;
import com.intellij.database.util.common.TreeFun;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.rmi.RemoteException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\b\u0012\u0004\u0012\u0002H\u00010\u0007:\b\u008f\u0001\u0090\u0001\u0091\u0001\u0092\u0001B'\b\u0014\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\"\u00100\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u00120\u001e2\f\u00102\u001a\b\u0012\u0004\u0012\u00020103H\u0014J\u0018\u00104\u001a\u00020+2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0014J\u0018\u00109\u001a\u0004\u0018\u00010:2\f\u00102\u001a\b\u0012\u0004\u0012\u00020103H\u0016J\u001a\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020:2\b\u0010=\u001a\u0004\u0018\u00010:H\u0002J\u001a\u0010>\u001a\u00020+2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020+0@H\u0086\b\u00f8\u0001\u0000J\u001a\u0010A\u001a\u00020+2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020+0@H\u0086\b\u00f8\u0001\u0000J;\u0010B\u001a \u0012\u0006\b\u0001\u0012\u00028\u00010CR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u00105\u001a\u0002062\u0006\u0010D\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010EJ;\u0010F\u001a \u0012\u0006\b\u0001\u0012\u00028\u00010GR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u00105\u001a\u0002062\u0006\u0010D\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010HJ;\u0010I\u001a \u0012\u0006\b\u0001\u0012\u00028\u00020JR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u00105\u001a\u0002062\u0006\u0010K\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010LJ(\u0010M\u001a\u00020+2\u0006\u0010N\u001a\u00020:2\b\u0010O\u001a\u0004\u0018\u00010:2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020+0@H\u0004J\n\u0010Q\u001a\u0004\u0018\u00010:H\u0016J\u001e\u0010R\u001a\u00020+2\u0006\u0010O\u001a\u00020:2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020+0@H\u0004J$\u0010S\u001a\u00020-2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010T\u001a\u00020U2\b\u0010V\u001a\u0004\u0018\u00010WH\u0016J\u001b\u0010X\u001a\u00020+2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0ZH\u0016\u00a2\u0006\u0002\u0010\\J\u001e\u0010]\u001a\u00020+2\u0006\u00105\u001a\u0002062\f\u0010^\u001a\b\u0012\u0004\u0012\u0002010_H\u0002J\u0010\u0010`\u001a\u00020+2\u0006\u00105\u001a\u000206H\u0014J\b\u0010a\u001a\u00020+H\u0016J\u0010\u0010b\u001a\u00020+2\u0006\u0010c\u001a\u000206H$J0\u0010d\u001a\u0014\u0012\u0004\u0012\u000201\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0Z0\u001e2\f\u00102\u001a\b\u0012\u0004\u0012\u000201032\u0006\u0010e\u001a\u00020\u0012H\u0016J8\u0010d\u001a\u00020+2\f\u00102\u001a\b\u0012\u0004\u0012\u000201032\u0006\u0010e\u001a\u00020\u00122\u0018\u0010f\u001a\u0014\u0012\u0004\u0012\u000201\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0Z0gH&J\u0018\u0010h\u001a\u00020+2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020iH\u0014J\u0018\u0010j\u001a\u00020+2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020kH\u0014J\u0006\u0010l\u001a\u00020+J\u0010\u0010m\u001a\u00020+2\u0006\u0010c\u001a\u000206H\u0004J\b\u0010n\u001a\u00020+H\u0016J\u0010\u0010o\u001a\u00020+2\u0006\u0010c\u001a\u000206H\u0014J\u000e\u0010p\u001a\b\u0012\u0004\u0012\u00020r0qH\u0016J&\u0010s\u001a\u00020+2\u0006\u0010t\u001a\u00020u2\u0006\u0010O\u001a\u00020:2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020+0@H\u0004J \u0010v\u001a\u0004\u0018\u0001Hw\"\u0006\b\u0003\u0010w\u0018\u00012\u0006\u0010x\u001a\u00020:H\u0084\b\u00a2\u0006\u0002\u0010yJ9\u0010z\u001a\u0002H\u0001\"\u0004\b\u0003\u0010\u00012\f\u0010{\u001a\b\u0012\u0004\u0012\u0002H\u00010|2\u0016\b\u0002\u0010}\u001a\u0010\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020~\u0018\u00010\u001eH\u0004\u00a2\u0006\u0002\u0010\u007fJH\u0010\u0080\u0001\u001a\u00020+\"\u0005\b\u0003\u0010\u0081\u00012\u0015\u0010{\u001a\u0011\u0012\r\b\u0001\u0012\t\u0012\u0005\u0012\u0003H\u0081\u0001030|2\t\b\u0002\u0010\u0082\u0001\u001a\u00020 2\u0014\u0010?\u001a\u0010\u0012\u0005\u0012\u0003H\u0081\u0001\u0012\u0004\u0012\u00020+0\u0083\u0001H\u0004J\t\u0010\u0084\u0001\u001a\u00020+H\u0004J\u0012\u0010\u0085\u0001\u001a\u00020+2\u0007\u0010\u0086\u0001\u001a\u00020\u0002H\u0002J\t\u0010\u0087\u0001\u001a\u00020+H\u0016J\u001e\u0010\u0088\u0001\u001a\u00020+2\u000f\b\u0004\u0010\u0089\u0001\u001a\b\u0012\u0004\u0012\u00020+0@H\u0084\b\u00f8\u0001\u0000J\r\u0010\u008a\u0001\u001a\u00020:*\u00020:H\u0004J?\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u0002Hw0Z\"\u0004\b\u0003\u0010w*\b\u0012\u0004\u0012\u0002Hw0Z2\u0014\u0010\u008c\u0001\u001a\u000f\u0012\u0004\u0012\u0002Hw\u0012\u0004\u0012\u0002Hw0\u0083\u0001H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u008d\u0001J;\u0010\u008b\u0001\u001a\t\u0012\u0004\u0012\u0002Hw0\u008e\u0001\"\u0004\b\u0003\u0010w*\t\u0012\u0004\u0012\u0002Hw0\u008e\u00012\u0014\u0010\u008c\u0001\u001a\u000f\u0012\u0004\u0012\u0002Hw\u0012\u0004\u0012\u0002Hw0\u0083\u0001H\u0084\b\u00f8\u0001\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0014\"\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020 X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0093\u0001"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "R", "Lcom/intellij/database/model/basic/BasicModRoot;", "D", "Lcom/intellij/database/model/basic/BasicModDatabase;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "nature", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "considerSystemSchemasReinstrospection", "", "getConsiderSystemSchemasReinstrospection", "()Z", "dasTypeSystem", "Lcom/intellij/database/types/DasTypeSystemBase;", "getDasTypeSystem", "()Lcom/intellij/database/types/DasTypeSystemBase;", "forbidIncremental", "getForbidIncremental", "setForbidIncremental", "(Z)V", "introspectorKindVersions", "", "Lcom/intellij/database/model/ObjectKind;", "", "getIntrospectorKindVersions", "()Ljava/util/Map;", "introspectorVersion", "getIntrospectorVersion", "()I", "sqlHelper", "Lcom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper;", "getSqlHelper", "()Lcom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper;", "adjustRootIntrospectionLevel", "", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "dataSourceIntrospectionLevel", "Lcom/intellij/database/model/properties/Level;", "checkElementsUptodate", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "", "checkUptodate", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "task", "Lcom/intellij/database/introspection/CheckUptodatenessIntrospectionTask;", "collectDiagnosticInfo", "", "concatErrorContextPrefixWithMessage", "prefix", "message", "continueOnAnyError", "action", "Lkotlin/Function0;", "continueOnDbError", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "database", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;)Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "createNativeRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;)Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "schema", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "doSectionAndHandleErrors", "sectionName", "operationName", "operation", "getCurrentDatabase", "handleErrors", "init", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "introspectionScope", "Lcom/intellij/database/util/TreePattern;", "introspectAuto", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "([Lcom/intellij/database/model/basic/BasicNamespace;)V", "introspectElementsInCompatibleMode", "elementsToRefresh", "", "introspectGeneral", "introspectNamespaces", "introspectNamespacesInTran", "tran", "introspectNativeDefinitions", "withNestedElements", "result", "", "introspectRegularElements", "Lcom/intellij/database/introspection/RegularIntrospectionTask;", "introspectServerElements", "Lcom/intellij/database/introspection/ServerObjectsIntrospectionTask;", "introspectServerObjects", "introspectServerObjectsInTran", "introspectSessionState", "introspectTheServerObjects", "listDeferredTasks", "", "Lcom/intellij/database/introspection/IntrospectionTask;", "measureAndHandleErrors", "metricKey", "Lcom/intellij/database/introspection/IntrospectionMetricKey;", "parseStatement", "T", "src", "(Ljava/lang/String;)Ljava/lang/Object;", "performQuery", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "namedParameters", "", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;Ljava/util/Map;)Ljava/lang/Object;", "performQueryHandleEachRow", "X", "packSize", "Lkotlin/Function1;", "postIntrospectionProcess", "postIntrospectionProcessWithModel", "root", "processDeferredTasks", "writeSources", "r", "dbIntern", "inplace", "t", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)[Ljava/lang/Object;", "", "AbstractDatabaseRetriever", "AbstractNativeRetriever", "AbstractRetriever", "AbstractSchemaRetriever", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseNativeIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 2 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 3 IntrospectorSqlHelper.kt\ncom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,846:1\n34#2:847\n26#3:848\n1477#4:849\n1502#4,3:850\n1505#4,3:860\n1477#4:863\n1502#4,3:864\n1505#4,3:874\n1549#4:877\n1620#4,3:878\n1864#4,3:915\n372#5,7:853\n372#5,7:867\n1#6:881\n1144#7:882\n1130#7,3:883\n1145#7:886\n966#7,2:887\n1061#7,2:889\n968#7,5:891\n1066#7,2:896\n973#7,2:898\n977#7,2:900\n1062#7:902\n979#7,5:903\n1066#7,2:908\n984#7,2:910\n13374#8,3:912\n*S KotlinDebug\n*F\n+ 1 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n*L\n101#1:847\n130#1:848\n225#1:849\n225#1:850,3\n225#1:860,3\n228#1:863\n228#1:864,3\n228#1:874,3\n229#1:877\n229#1:878,3\n843#1:915,3\n225#1:853,7\n228#1:867,7\n290#1:882\n290#1:883,3\n290#1:886\n390#1:887,2\n390#1:889,2\n390#1:891,5\n390#1:896,2\n390#1:898,2\n405#1:900,2\n405#1:902\n405#1:903,5\n405#1:908,2\n405#1:910,2\n842#1:912,3\n*E\n"})
public abstract class BaseNativeIntrospector<R extends BasicModRoot, D extends BasicModDatabase, S extends BasicModSchema>
extends BaseIntrospector<R> {
    private final int introspectorVersion;
    @NotNull
    private final Map<ObjectKind, Integer> introspectorKindVersions;
    private boolean forbidIncremental;
    private final boolean considerSystemSchemasReinstrospection;
    @NotNull
    private final IntrospectorSqlHelper sqlHelper;
    @NotNull
    private final DasTypeSystemBase dasTypeSystem;

    protected int getIntrospectorVersion() {
        return this.introspectorVersion;
    }

    @NotNull
    protected Map<ObjectKind, Integer> getIntrospectorKindVersions() {
        return this.introspectorKindVersions;
    }

    protected final boolean getForbidIncremental() {
        return this.forbidIncremental;
    }

    protected final void setForbidIncremental(boolean bl) {
        this.forbidIncremental = bl;
    }

    protected final boolean getConsiderSystemSchemasReinstrospection() {
        return this.considerSystemSchemasReinstrospection;
    }

    @NotNull
    protected final IntrospectorSqlHelper getSqlHelper() {
        return this.sqlHelper;
    }

    @NotNull
    protected final DasTypeSystemBase getDasTypeSystem() {
        return this.dasTypeSystem;
    }

    protected BaseNativeIntrospector(@NotNull DBIntrospectionContext context, @NotNull BaseIntrospector.Nature nature, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        super(context, nature, dbms, modelFactory);
        this.introspectorKindVersions = MapsKt.emptyMap();
        this.considerSystemSchemasReinstrospection = BaseIntrospectionFunctions.stringToBoolean(System.getProperty("dbe.always.reintrospect.system.schemas"));
        this.sqlHelper = new IntrospectorSqlHelper(context.getProject(), dbms);
        this.dasTypeSystem = DasTypeSystems.getTypeSystem(dbms);
    }

    @Override
    @NotNull
    public BasicModModel init(@Nullable BasicModModel model2, @NotNull LocalDataSource dataSource2, @Nullable TreePattern introspectionScope) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        BasicModModel m = super.init(model2, dataSource2, introspectionScope);
        this.trace("Introspector version: " + this.getIntrospectorVersion());
        this.forbidIncremental = Intrinsics.areEqual(DbOptionProvider.getOptionValue(dataSource2, ForbidIncrementalOptionProvider.class), (Object)true);
        if (this.forbidIncremental) {
            this.trace("Incremental introspection is disabled");
        }
        this.adjustRootIntrospectionLevel(m, dataSource2.getIntrospectionLevel());
        return m;
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustRootIntrospectionLevel(BasicModModel model2, com.intellij.database.model.properties.Level dataSourceIntrospectionLevel) {
        BasicRoot basicRoot = model2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        BasicRoot modelRoot = basicRoot;
        if (modelRoot instanceof BasicModMultiLevelRoot && ((BasicModMultiLevelRoot)modelRoot).getExplicitIntrospectionLevel() != dataSourceIntrospectionLevel) {
            void $this$modify$iv;
            BasicModModel basicModModel = model2;
            ModelModifier<BasicModMultiLevelRoot> modifier$iv = arg_0 -> BaseNativeIntrospector.adjustRootIntrospectionLevel$lambda$0(this, dataSourceIntrospectionLevel, arg_0);
            boolean $i$f$modify = false;
            $this$modify$iv.modify(BasicModMultiLevelRoot.class, modifier$iv);
        }
    }

    protected final <R> R performQuery(@NotNull SqlQuery<R> query, @Nullable Map<String, ? extends Object> namedParameters) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default(this, query, namedParameters, null, 4, null);
        return (R)this.inTransaction((Function1)new Function1<DBTransaction, R>(this, pq){
            final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;
            final /* synthetic */ PreprocessedQuery<R> $pq;
            {
                this.this$0 = $receiver;
                this.$pq = $pq;
                super(1);
            }

            public final R invoke(@NotNull DBTransaction transaction) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                IntrospectionQueryContext introspectionQueryContext = this.this$0;
                SqlQuery<X> sqlQuery = this.$pq.query;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
                return (R)IntrospectionQueryContext.runQuery$default(introspectionQueryContext, transaction, sqlQuery, this.$pq.bindableParameters, null, 4, null);
            }
        });
    }

    public static /* synthetic */ Object performQuery$default(BaseNativeIntrospector baseNativeIntrospector, SqlQuery sqlQuery, Map map2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQuery");
        }
        if ((n & 2) != 0) {
            map2 = null;
        }
        return baseNativeIntrospector.performQuery(sqlQuery, map2);
    }

    protected final <X> void performQueryHandleEachRow(@NotNull SqlQuery<? extends Iterable<? extends X>> query, int packSize, @NotNull Function1<? super X, Unit> action) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default(this, query, null, null, 6, null);
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this, pq, packSize, action){
            final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;
            final /* synthetic */ PreprocessedQuery<? extends Iterable<X>> $pq;
            final /* synthetic */ int $packSize;
            final /* synthetic */ Function1<X, Unit> $action;
            {
                this.this$0 = $receiver;
                this.$pq = $pq;
                this.$packSize = $packSize;
                this.$action = $action;
                super(1);
            }

            public final void invoke(@NotNull DBTransaction transaction) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                SqlQuery<X> sqlQuery = this.$pq.query;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
                this.this$0.runQueryHandleEachRow(transaction, sqlQuery, this.$pq.bindableParameters, this.$packSize, null, null, this.$action);
            }
        }));
    }

    public static /* synthetic */ void performQueryHandleEachRow$default(BaseNativeIntrospector baseNativeIntrospector, SqlQuery sqlQuery, int n, Function1 function1, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryHandleEachRow");
        }
        if ((n3 & 2) != 0) {
            n = 4096;
        }
        baseNativeIntrospector.performQueryHandleEachRow(sqlQuery, n, function1);
    }

    protected final /* synthetic */ <T> T parseStatement(String src2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)src2, (String)"src");
        boolean $i$f$parseStatement = false;
        try {
            IntrospectorSqlHelper this_$iv = this.sqlHelper;
            boolean $i$f$statements = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            object = this_$iv.statements(src2, Object.class).first();
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e2) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.log.error((Throwable)e2);
            }
            this.log.warn("Failed to parse sources", (Throwable)e2);
            object = null;
        }
        return (T)object;
    }

    @Override
    protected void introspectGeneral(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.introspectNamespaces();
        this.introspectAutoInTran(transaction, null);
        this.introspectServerObjectsInTran(transaction);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void introspectRegularElements(@NotNull DBTransaction transaction, @NotNull RegularIntrospectionTask task) {
        String schemaName;
        Object schemaGroups2;
        Object $this$groupBy$iv;
        Object fragmentPath;
        boolean fragmentIntro;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Set paths2 = CollectionsKt.toSet((Iterable)task.getElementsToRefresh());
        Collection superfluousNodes2 = TreeFun.findSuperfluousSubNodes(paths2, (Function1)introspectRegularElements.superfluousNodes.1.INSTANCE);
        if (!superfluousNodes2.isEmpty()) {
            paths2 = SetsKt.minus((Set)paths2, (Iterable)CollectionsKt.toSet((Iterable)superfluousNodes2));
        }
        Set<ObjectKind> supportedFragmentKinds = (fragmentIntro = this.nature.getSupportFragmentIntrospection()) ? this.nature.getSupportFragmentKinds() : SetsKt.emptySet();
        String taskDatabaseName = task.getDatabaseName();
        boolean includeDatabase = false;
        LinkedHashSet pathOfSchemas = new LinkedHashSet();
        LinkedHashSet pathOfFragments = new LinkedHashSet();
        LinkedHashSet pathOfDatabaseObjects = new LinkedHashSet();
        LinkedHashSet pathOfServerObjects = new LinkedHashSet();
        boolean allServerObjects = false;
        for (ObjectPath path : paths2) {
            ObjectKind kind = path.kind;
            ObjectPathNamespace objectPathNamespace = ObjectPathFun.getNamespace(path);
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.DATABASE)) {
                if (Intrinsics.areEqual((Object)ObjectPathFun.getDatabaseName(path), (Object)taskDatabaseName)) {
                    includeDatabase = true;
                    continue;
                }
                this.logError("RegularTask(in database " + task.getDatabaseDisplayName() + ") contains path of another database " + ObjectPathFun.getDatabaseName(path));
                continue;
            }
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.SCHEMA)) {
                ((Collection)pathOfSchemas).add(path);
                continue;
            }
            if (objectPathNamespace instanceof ObjectPathNamespace.InSchema) {
                Object object = fragmentPath = fragmentIntro ? ObjectPathFun.thisOrParentOfKind(path, supportedFragmentKinds) : null;
                if (fragmentPath != null) {
                    ((Collection)pathOfFragments).add(fragmentPath);
                    continue;
                }
                ((Collection)pathOfSchemas).add(((ObjectPathNamespace.InSchema)objectPathNamespace).getSchemaPath());
                continue;
            }
            if (objectPathNamespace instanceof ObjectPathNamespace.InDatabase) {
                Object object = fragmentPath = fragmentIntro ? ObjectPathFun.thisOrParentOfKind(path, supportedFragmentKinds) : null;
                if (fragmentPath != null) {
                    ((Collection)pathOfDatabaseObjects).add(fragmentPath);
                    continue;
                }
                includeDatabase = true;
                continue;
            }
            if (!(objectPathNamespace instanceof ObjectPathNamespace.InServer)) continue;
            Object object = fragmentPath = fragmentIntro ? ObjectPathFun.thisOrParentOfKind(path, supportedFragmentKinds) : null;
            if (fragmentPath != null) {
                ((Collection)pathOfServerObjects).add(fragmentPath);
                continue;
            }
            allServerObjects = true;
        }
        if (includeDatabase) {
            pathOfSchemas.clear();
            pathOfDatabaseObjects.clear();
        }
        if (allServerObjects) {
            pathOfServerObjects.clear();
        }
        ArrayList tasks = new ArrayList();
        if (includeDatabase) {
            ((Collection)tasks).add(new DatabaseIntrospectionTask(taskDatabaseName));
        }
        if (!((Collection)pathOfSchemas).isEmpty()) {
            Set schemaNames2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)pathOfSchemas), (Function1)((Function1)introspectRegularElements.schemaNames.1.INSTANCE)));
            ((Collection)tasks).add(new SchemasIntrospectionTask(taskDatabaseName, schemaNames2));
        }
        if (!((Collection)pathOfFragments).isEmpty()) {
            void $this$groupByTo$iv$iv;
            $this$groupBy$iv = pathOfFragments;
            boolean bl = false;
            fragmentPath = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                ObjectPath it2 = (ObjectPath)element$iv$iv;
                boolean bl2 = false;
                String key$iv$iv = ObjectPathFun.getSchemaName(it2);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl22 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            schemaGroups2 = destination$iv$iv;
            for (Map.Entry entry : schemaGroups2.entrySet()) {
                void $this$mapTo$iv$iv;
                void $this$groupByTo$iv$iv2;
                schemaName = (String)entry.getKey();
                List schemaPaths = (List)entry.getValue();
                if (schemaName == null) continue;
                Iterable $this$groupBy$iv2 = schemaPaths;
                boolean $i$f$groupBy3 = false;
                Iterable list$iv$iv = $this$groupBy$iv2;
                Object destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$groupByTo2 = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                    Object object;
                    ObjectPath it3 = (ObjectPath)element$iv$iv;
                    boolean bl3 = false;
                    ObjectKind key$iv$iv = it3.kind;
                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl32 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv2 = (List)object;
                    list$iv$iv2.add(element$iv$iv);
                }
                Map familyGroups = destination$iv$iv2;
                Iterable $this$map$iv = familyGroups.entrySet();
                boolean $i$f$map = false;
                destination$iv$iv2 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void fg;
                    Map.Entry bl3 = (Map.Entry)item$iv$iv;
                    Collection collection2 = destination$iv$iv3;
                    boolean bl4 = false;
                    Object k = fg.getKey();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                    collection2.add(new FamilyFragment((ObjectKind)k, SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)fg.getValue())), (Function1)((Function1)introspectRegularElements.fragments.1.1.INSTANCE)))));
                }
                List fragments2 = (List)destination$iv$iv3;
                FragmentIntrospectionTask newTask = new FragmentIntrospectionTask(taskDatabaseName, schemaName, BelongingAreaKind.A_SCHEMA, fragments2, true);
                ((Collection)tasks).add(newTask);
            }
        }
        if (!((Collection)pathOfDatabaseObjects).isEmpty()) {
            ((Collection)tasks).add(new DatabaseObjectsIntrospectionTask(taskDatabaseName, pathOfDatabaseObjects, false));
        }
        if (!((Collection)pathOfServerObjects).isEmpty() || allServerObjects) {
            Iterable iterable;
            schemaGroups2 = tasks;
            $this$groupBy$iv = pathOfDatabaseObjects;
            if ($this$groupBy$iv.isEmpty()) {
                boolean bl = false;
                iterable = null;
            } else {
                iterable = $this$groupBy$iv;
            }
            boolean bl = allServerObjects;
            Set set = (Set)iterable;
            schemaGroups2.add(new ServerObjectsIntrospectionTask(set, bl));
        }
        if (CollectionFun.containsElements(tasks, (Function1)introspectRegularElements.2.INSTANCE)) {
            throw new InternalError("A regular task is turned into another regular task that can follow with infinite loop of consequent introspections");
        }
        int n = tasks.size();
        switch (n) {
            case 0: {
                this.logError("Cannot handle the content of this RegularIntrospectionTask");
                break;
            }
            case 1: {
                DefiniteIntrospectionTask theNewTask = (DefiniteIntrospectionTask)CollectionsKt.first((List)tasks);
                this.trace("The given RegularIntrospectionTask was turned into a " + theNewTask);
                if (this.checkTaskCanBeIntrospectedWithThisConnection(task)) {
                    this.introspectInTran(transaction, theNewTask);
                    break;
                }
                this.deferTask(theNewTask);
                break;
            }
            default: {
                boolean bl;
                this.trace("The given RegularIntrospectionTask was turned into " + n + " tasks:" + CollectionsKt.joinToString$default((Iterable)tasks, null, null, null, (int)0, null, (Function1)introspectRegularElements.3.INSTANCE, (int)31, null));
                Collection<DefiniteIntrospectionTask> readyTasks2 = CollectionFun.extract(tasks, (Function1)new Function1<IntrospectionTask, Boolean>((Object)this){

                    @NotNull
                    public final Boolean invoke(@NotNull IntrospectionTask p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((BaseNativeIntrospector)this.receiver).checkTaskCanBeIntrospectedWithThisConnection(p0);
                    }
                });
                if (readyTasks2.size() == n) {
                    this.trace("and all " + n + " new tasks can be introspected in this connection");
                } else if (tasks.size() == n) {
                    this.trace("and all " + n + " new tasks should be introspected with other connections");
                } else {
                    this.trace("and " + readyTasks2.size() + " new tasks can be introspected in this connection but the other " + tasks.size() + " ones must wait for another connections");
                }
                boolean bl4 = bl = tasks.size() + readyTasks2.size() == n;
                if (_Assertions.ENABLED && !bl) {
                    schemaName = "Assertion failed";
                    throw new AssertionError((Object)schemaName);
                }
                if (!((Collection)tasks).isEmpty()) {
                    for (DefiniteIntrospectionTask t : tasks) {
                        Intrinsics.checkNotNull((Object)t);
                        this.deferTask(t);
                    }
                }
                if (!(!readyTasks2.isEmpty())) break;
                for (DefiniteIntrospectionTask readyTask : readyTasks2) {
                    this.introspectInTran(transaction, readyTask);
                }
            }
        }
    }

    @Override
    protected void introspectServerElements(@NotNull DBTransaction transaction, @NotNull ServerObjectsIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.introspectServerObjects();
    }

    private final void introspectElementsInCompatibleMode(DBTransaction transaction, Collection<? extends BasicElement> elementsToRefresh2) {
        Set schemas2 = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)elementsToRefresh2), (Function1)introspectElementsInCompatibleMode.schemas.1.INSTANCE));
        this.introspectAutoInTran(transaction, schemas2);
    }

    @Override
    public void introspectAuto(@NotNull BasicNamespace[] namespaces2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)namespaces2, (String)"namespaces");
        int n = namespaces2.length;
        BaseIntrospector this_$iv = this;
        boolean $i$f$trace = false;
        BaseIntrospector this_$iv$iv = this_$iv;
        boolean $i$f$getTracing = false;
        if (BaseIntrospector.access$getDiagnosticRecorder(this_$iv$iv) != null) {
            bl = true;
        } else {
            Logger logger2 = BaseIntrospector.access$getDbLogger(this_$iv$iv);
            Level level$iv$iv = logger2 != null ? BaseIntrospector.Companion.access$getEffectiveLevel(BaseIntrospector.Companion, logger2) : null;
            bl = level$iv$iv != null && level$iv$iv.intValue() <= BaseIntrospector.access$getTRACE_LEVEL_VALUE$cp();
        }
        if (bl) {
            BaseIntrospector baseIntrospector = this_$iv;
            boolean bl2 = false;
            BaseIntrospector.access$trace(baseIntrospector, (String)(n > 0 ? "Introspect Automatically, the following " + n + " namespaces are specified: " + ArraysKt.joinToString$default((Object[])namespaces2, (CharSequence)"", null, null, (int)0, null, (Function1)introspectAuto.1.1.INSTANCE, (int)30, null) : "Introspection Automatically, namespaces are not specified"));
        }
        this.introspectServerAndSessionInfo();
        ArrayList<BasicNamespace> theNamespaces = new ArrayList<BasicNamespace>(n);
        if (n > 0) {
            for (BasicNamespace ns : namespaces2) {
                boolean bl3 = this.getModel().contains(ns);
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl4 = false;
                    String string = "Namespaces must be from this model";
                    throw new AssertionError((Object)string);
                }
                theNamespaces.add(ns);
            }
        }
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this, theNamespaces){
            final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;
            final /* synthetic */ ArrayList<BasicNamespace> $theNamespaces;
            {
                this.this$0 = $receiver;
                this.$theNamespaces = $theNamespaces;
                super(1);
            }

            public final void invoke(@NotNull DBTransaction tran) {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                this.this$0.introspectAutoInTran(tran, (Collection<BasicNamespace>)this.$theNamespaces);
            }
        }));
    }

    @Override
    public void introspectNamespaces() {
        this.introspectServerAndSessionInfo();
        this.logFlow("Introspect namespaces");
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DBTransaction it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                this.this$0.introspectNamespacesInTran(it2);
            }
        }));
    }

    protected abstract void introspectNamespacesInTran(@NotNull DBTransaction var1);

    @Override
    public void introspectSessionState() {
        this.trace("Asked to introspect server and session state");
        this.introspectServerAndSessionInfo();
    }

    @Override
    public final void introspectServerObjects() {
        this.trace("Asked to introspect server and database objects");
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DBTransaction transaction) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                this.this$0.introspectServerObjectsInTran(transaction);
            }
        }));
    }

    protected final void introspectServerObjectsInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        if (this.nature.getSupportServerObjects() && !this.getServerObjectsDone()) {
            this.trace("Introspecting the server objects");
            this.introspectTheServerObjects(tran);
            this.setServerObjectsDone(true);
        }
    }

    protected void introspectTheServerObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
    }

    @Override
    @NotNull
    public Map<BasicElement, String[]> introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements2, boolean withNestedElements) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Map result2 = new LinkedHashMap();
        this.introspectNativeDefinitions(elements2, withNestedElements, result2);
        return result2;
    }

    public abstract void introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> var1, boolean var2, @NotNull Map<BasicElement, String[]> var3);

    @Override
    protected void checkUptodate(@NotNull DBTransaction transaction, @NotNull CheckUptodatenessIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Collection elements2 = SequencesKt.toList(this.derefElements(task.getElementsToCheck()));
        this.checkElementsUptodate(elements2);
    }

    @NotNull
    protected abstract AbstractDatabaseRetriever<? extends D> createDatabaseRetriever(@NotNull DBTransaction var1, @NotNull D var2);

    @NotNull
    protected abstract AbstractNativeRetriever<? extends D> createNativeRetriever(@NotNull DBTransaction var1, @NotNull D var2);

    @NotNull
    protected abstract AbstractSchemaRetriever<? extends S> createSchemaRetriever(@NotNull DBTransaction var1, @NotNull S var2);

    protected final void postIntrospectionProcess() {
        this.getModel().modify(BasicModRoot.class, new ModelModifier(this){
            final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;
            {
                this.this$0 = $receiver;
            }

            public final void perform(BasicModRoot r) {
                Intrinsics.checkNotNull((Object)r);
                BaseNativeIntrospector.access$postIntrospectionProcessWithModel(this.this$0, r);
            }
        });
    }

    private final void postIntrospectionProcessWithModel(BasicModRoot root2) {
        for (BasicModSchema basicModSchema : root2.getAllSchemas()) {
            Intrinsics.checkNotNull((Object)basicModSchema);
            BaseIntrospectionFunctions.derefAll(basicModSchema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void writeSources(@NotNull Function0<Unit> r) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(r, (String)"r");
        boolean $i$f$writeSources = false;
        BaseIntrospector baseIntrospector = this;
        String name$iv = "WriteSources";
        boolean $i$f$doSection = false;
        CharSequence message$iv$iv = null;
        boolean $i$f$logSectionBegin = false;
        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv);
        DiagnosticSectionReference ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv, message$iv$iv) : null;
        try {
            boolean bl = false;
            this.getModel().writeSources(new Runnable(r){
                final /* synthetic */ Function0<Unit> $r;
                {
                    this.$r = $r;
                }

                public final void run() {
                    this.$r.invoke();
                }
            });
        }
        finally {
            InlineMarker.finallyStart((int)1);
            void this_$iv$iv = this_$iv;
            boolean $i$f$logSectionEnd = false;
            if (ref$iv != null) {
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
                if (dataSourceDiagnosticRecorder2 != null) {
                    DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv, null, 2, null);
                }
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    @Override
    @Nullable
    public String getCurrentDatabase() {
        return this.getDbConnectionInfo().databaseName;
    }

    @Override
    @Nullable
    public String collectDiagnosticInfo(@NotNull Iterable<? extends BasicElement> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        return this.getClass().getSimpleName();
    }

    protected final void measureAndHandleErrors(@NotNull IntrospectionMetricKey metricKey, @NotNull String operationName, @NotNull Function0<Unit> operation2) {
        Intrinsics.checkNotNullParameter((Object)metricKey, (String)"metricKey");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter(operation2, (String)"operation");
        this.handleErrors(operationName, (Function0<Unit>)((Function0)new Function0<Unit>(this, metricKey, operation2){
            final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;
            final /* synthetic */ IntrospectionMetricKey $metricKey;
            final /* synthetic */ Function0<Unit> $operation;
            {
                this.this$0 = $receiver;
                this.$metricKey = $metricKey;
                this.$operation = $operation;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void metricKey$iv;
                void this_$iv;
                BaseIntrospector baseIntrospector = this.this$0;
                IntrospectionMetricKey introspectionMetricKey = this.$metricKey;
                Function0<Unit> operation$iv = this.$operation;
                boolean $i$f$measure = false;
                BaseIntrospector.access$getTimeMeter((BaseIntrospector)this_$iv).measure(metricKey$iv, operation$iv);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doSectionAndHandleErrors(@NotNull String sectionName, @Nullable String operationName, @NotNull Function0<Unit> operation2) {
        Intrinsics.checkNotNullParameter((Object)sectionName, (String)"sectionName");
        Intrinsics.checkNotNullParameter(operation2, (String)"operation");
        BaseIntrospector this_$iv = this;
        boolean $i$f$doSection = false;
        BaseIntrospector this_$iv$iv = this_$iv;
        boolean $i$f$logSectionBegin = false;
        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder(this_$iv$iv);
        DiagnosticSectionReference ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(sectionName, operationName) : null;
        try {
            boolean bl = false;
            String string = operationName;
            if (string == null) {
                string = sectionName;
            }
            this.handleErrors(string, operation2);
        }
        finally {
            this_$iv$iv = this_$iv;
            boolean $i$f$logSectionEnd = false;
            if (ref$iv != null) {
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder(this_$iv$iv);
                if (dataSourceDiagnosticRecorder2 != null) {
                    DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv, null, 2, null);
                }
            }
        }
    }

    protected final void handleErrors(@NotNull String operationName, @NotNull Function0<Unit> operation2) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter(operation2, (String)"operation");
        try {
            operation2.invoke();
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (DBException d2) {
            String prefix = "Error encountered when performing " + operationName;
            String message2 = this.concatErrorContextPrefixWithMessage(prefix, d2.getMessage());
            this.logWarn(message2, d2);
            this.getErrorSink().consume((Object)message2, (Object)d2);
        }
        catch (NullPointerException npe) {
            String message3 = "NPE encountered when performing " + operationName;
            this.logError(message3, npe);
            this.getErrorSink().consume((Object)message3, (Object)npe);
        }
        catch (RemoteException e2) {
            String prefix = "RMI error (" + e2.getClass().getSimpleName() + ") encountered when performing " + operationName;
            String message4 = this.concatErrorContextPrefixWithMessage(prefix, e2.getMessage());
            this.trace(message4);
            throw e2;
        }
        catch (Exception e3) {
            String prefix = "Unexpected error (" + e3.getClass().getSimpleName() + ") encountered when performing " + operationName;
            String message5 = this.concatErrorContextPrefixWithMessage(prefix, e3.getMessage());
            this.logError(message5, e3);
            this.getErrorSink().consume((Object)message5, (Object)e3);
        }
    }

    private final String concatErrorContextPrefixWithMessage(String prefix, String message2) {
        return message2 == null ? prefix : (StringsKt.contains$default((CharSequence)message2, (char)'\n', (boolean)false, (int)2, null) ? prefix + ":\n" + message2 : prefix + ": " + message2);
    }

    @NotNull
    protected Map<BasicElement, Boolean> checkElementsUptodate(@NotNull Iterable<? extends BasicElement> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Map<BasicElement, Boolean> map2 = Collections.emptyMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"emptyMap(...)");
        return map2;
    }

    @Override
    @NotNull
    public List<IntrospectionTask> listDeferredTasks() {
        return CollectionsKt.toList((Iterable)this.getDeferredTasks());
    }

    @Override
    public void processDeferredTasks() {
        if (this.getDeferredTasks().isEmpty()) {
            this.trace("No deferred tasks to process.");
            return;
        }
        int n = this.getDeferredTasks().size();
        Collection tasksToProcess2 = CollectionFun.extract((Collection)this.getDeferredTasks(), (Function1)new Function1<IntrospectionTask, Boolean>(this){
            final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IntrospectionTask it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return this.this$0.checkConnectionApplicable(it2).compareTo((Enum)BaseIntrospector.ConnectionApplicability.connApplicablePartial) >= 0;
            }
        });
        if (tasksToProcess2.isEmpty()) {
            this.logWarn("There are " + n + " deferred tasks but none of them can be processed with the current connection");
            return;
        }
        this.trace(StringFun.centerAndPadAsTitle("PROCESS " + tasksToProcess2.size() + " OF " + n + " DEFERRED TASKS", 140, '='));
        this.trace("Tasks to process:\n\t" + CollectionsKt.joinToString$default((Iterable)tasksToProcess2, (CharSequence)"\n\t", null, null, (int)0, null, null, (int)62, null));
        this.introspectTheTasks(tasksToProcess2);
    }

    public final void continueOnDbError(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$continueOnDbError = false;
        try {
            action.invoke();
        }
        catch (DBException e2) {
            this.getErrorSink().consume(null, (Object)e2);
        }
    }

    public final void continueOnAnyError(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$continueOnAnyError = false;
        try {
            action.invoke();
        }
        catch (Exception e2) {
            this.getErrorSink().consume(null, (Object)e2);
        }
    }

    @NotNull
    protected final String dbIntern(@NotNull String $this$dbIntern) {
        Intrinsics.checkNotNullParameter((Object)$this$dbIntern, (String)"<this>");
        String string = DbUtil.intern($this$dbIntern);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intern(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T> T[] inplace(@NotNull T[] $this$inplace, @NotNull Function1<? super T, ? extends T> t) {
        T[] TArray;
        Intrinsics.checkNotNullParameter($this$inplace, (String)"<this>");
        Intrinsics.checkNotNullParameter(t, (String)"t");
        boolean $i$f$inplace = false;
        T[] $this$inplace_u24lambda_u2410 = TArray = $this$inplace;
        boolean bl = false;
        T[] $this$forEachIndexed$iv = $this$inplace_u24lambda_u2410;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (T item$iv : $this$forEachIndexed$iv) {
            void s2;
            int n = index$iv++;
            T t2 = item$iv;
            int i2 = n;
            boolean bl2 = false;
            $this$inplace_u24lambda_u2410[i2] = t.invoke((Object)s2);
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T> List<T> inplace(@NotNull List<T> $this$inplace, @NotNull Function1<? super T, ? extends T> t) {
        List<T> list;
        Intrinsics.checkNotNullParameter($this$inplace, (String)"<this>");
        Intrinsics.checkNotNullParameter(t, (String)"t");
        boolean $i$f$inplace = false;
        List<T> $this$inplace_u24lambda_u2412 = list = $this$inplace;
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = $this$inplace_u24lambda_u2412;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t2 = item$iv;
            int i2 = n;
            boolean bl2 = false;
            $this$inplace_u24lambda_u2412.set(i2, t.invoke((Object)s2));
        }
        return list;
    }

    private static final void adjustRootIntrospectionLevel$lambda$0(BaseNativeIntrospector this$0, com.intellij.database.model.properties.Level $dataSourceIntrospectionLevel, BasicModMultiLevelRoot root2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this$0.trace("Copying the explicitly set introspection level " + $dataSourceIntrospectionLevel + " from the data source to the model root");
        root2.setExplicitIntrospectionLevel($dataSourceIntrospectionLevel);
    }

    public static final /* synthetic */ void access$postIntrospectionProcessWithModel(BaseNativeIntrospector $this, BasicModRoot root2) {
        $this.postIntrospectionProcessWithModel(root2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u00180\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020\r0\u000fH\u0004J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u0016\u0010\u0007\u001a\u00028\u0003X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;)V", "getDatabase", "()Lcom/intellij/database/model/basic/BasicModDatabase;", "Lcom/intellij/database/model/basic/BasicModDatabase;", "inDatabase", "", "modifier", "Lkotlin/Function1;", "retrieveSchemas", "retrieveServerAndDatabaseObjects", "intellij.database.dialects.base"})
    protected static abstract class AbstractDatabaseRetriever<D extends BasicModDatabase>
    extends AbstractRetriever {
        @NotNull
        private final D database;
        final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;

        protected AbstractDatabaseRetriever(@NotNull DBTransaction transaction, D database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super(transaction);
            this.database = database;
        }

        @NotNull
        protected final D getDatabase() {
            return this.database;
        }

        public void retrieveSchemas() {
        }

        public void retrieveServerAndDatabaseObjects() {
        }

        protected final void inDatabase(@NotNull Function1<? super D, Unit> modifier) {
            Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
            this.getModel().modify((BasicElement)this.database, BasicModDatabase.class, new ModelModifier(modifier){
                final /* synthetic */ Function1<D, Unit> $modifier;
                {
                    this.$modifier = $modifier;
                }

                public final void perform(BasicModDatabase it2) {
                    Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type D of com.intellij.database.dialects.base.introspector.BaseNativeIntrospector.AbstractDatabaseRetriever");
                    this.$modifier.invoke((Object)it2);
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u00180\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J8\u0010\u0012\u001a\u00020\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0016H\u0016J0\u0010\u0012\u001a\u00020\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0016H\u0014J8\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0016H\u0014R\u0016\u0010\u0007\u001a\u00028\u0003X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;)V", "getDatabase", "()Lcom/intellij/database/model/basic/BasicModDatabase;", "Lcom/intellij/database/model/basic/BasicModDatabase;", "expandElementsBeforeRetrievingNativeDefinitions", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "process", "", "retrieveNativeDefinitions", "withNestedElements", "", "result", "", "", "", "retrieveNativeDefinitionsFor", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseNativeIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,846:1\n1477#2:847\n1502#2,3:848\n1505#2,3:858\n372#3,7:851\n*S KotlinDebug\n*F\n+ 1 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever\n*L\n615#1:847\n615#1:848,3\n615#1:858,3\n615#1:851,7\n*E\n"})
    protected static abstract class AbstractNativeRetriever<D extends BasicModDatabase>
    extends AbstractRetriever {
        @NotNull
        private final D database;
        final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;

        protected AbstractNativeRetriever(@NotNull DBTransaction transaction, D database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super(transaction);
            this.database = database;
        }

        @NotNull
        protected final D getDatabase() {
            return this.database;
        }

        public void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements2, boolean withNestedElements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            Iterable<? extends BasicElement> elementsToProcess = withNestedElements ? this.expandElementsBeforeRetrievingNativeDefinitions(elements2) : elements2;
            this.retrieveNativeDefinitions(elementsToProcess, result2);
        }

        @NotNull
        protected Iterable<BasicElement> expandElementsBeforeRetrievingNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements2) {
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            return CollectionsKt.toList(elements2);
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements2, @NotNull Map<BasicElement, String[]> result2) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            Iterable<? extends BasicElement> $this$groupBy$iv = elements2;
            boolean $i$f$groupBy = false;
            Iterable<? extends BasicElement> iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                BasicElement it2 = (BasicElement)element$iv$iv;
                boolean bl = false;
                ObjectKind key$iv$iv = it2.getKind();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map groups2 = destination$iv$iv;
            for (Map.Entry entry : groups2.entrySet()) {
                ObjectKind kind = (ObjectKind)entry.getKey();
                List kindElements = (List)entry.getValue();
                Intrinsics.checkNotNull((Object)kind);
                this.retrieveNativeDefinitionsFor(kind, kindElements, result2);
            }
        }

        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements2, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
        }

        @Override
        public void process() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0003\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0004\u00a2\u0006\u0002\u0010\u0013JK\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0003\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00152\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0019\"\u00020\u0017H\u0004\u00a2\u0006\u0002\u0010\u001aJL\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001c\"\u0004\b\u0003\u0010\u001d2\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u001e0\u00122\u0016\b\u0002\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00152\b\b\u0002\u0010\u001f\u001a\u00020 H\u0014JB\u0010!\u001a\u00020\"\"\u0004\b\u0003\u0010\u00102\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00100\u001e0\u00122\b\b\u0002\u0010\u001f\u001a\u00020 2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\"0$H\u0004J/\u0010%\u001a\u0004\u0018\u0001H\u0010\"\b\b\u0003\u0010\u0010*\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010&\u001a\u00020\u0016H\u0004\u00a2\u0006\u0002\u0010'J2\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001c\"\u0004\b\u0003\u0010\u001d2\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u001e0\u00122\u0006\u0010&\u001a\u00020\u0016H\u0004J\b\u0010)\u001a\u00020\"H&J\u0014\u0010*\u001a\u00020+2\n\u0010,\u001a\u00060-j\u0002`.H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006/"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "(Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "getModel", "()Lcom/intellij/database/model/basic/BasicModModel;", "searchCache", "Lcom/intellij/database/model/ElementSearchCache;", "getSearchCache", "()Lcom/intellij/database/model/ElementSearchCache;", "getTransaction", "()Lcom/intellij/database/layoutedQueries/DBTransaction;", "performQuery", "X", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;)Ljava/lang/Object;", "namedParameters", "", "", "", "freeParameters", "", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;Ljava/util/Map;[Ljava/lang/Object;)Ljava/lang/Object;", "performQueryForList", "", "R", "", "packSize", "", "performQueryHandleEachRow", "", "action", "Lkotlin/Function1;", "performQuerySafe", "introspectionScopeRemark", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;Ljava/lang/String;)Ljava/lang/Object;", "performQuerySafeList", "process", "queryPostPreprocess", "", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.database.dialects.base"})
    protected abstract class AbstractRetriever
    extends IntrospectionQueryContext {
        @NotNull
        private final DBTransaction transaction;
        @NotNull
        private final BasicModModel model;
        @NotNull
        private final ElementSearchCache searchCache;

        public AbstractRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(BaseNativeIntrospector.this, null, 2, null);
            this.transaction = transaction;
            this.model = BaseNativeIntrospector.this.getModel();
            BaseNativeIntrospector.this.logMemory(true);
            this.searchCache = new ElementSearchCache();
        }

        @NotNull
        protected final DBTransaction getTransaction() {
            return this.transaction;
        }

        @NotNull
        protected final BasicModModel getModel() {
            return this.model;
        }

        @NotNull
        public final ElementSearchCache getSearchCache() {
            return this.searchCache;
        }

        public abstract void process();

        protected final <X> X performQuery(@NotNull SqlQuery<X> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return this.performQuery(this.transaction, query);
        }

        protected final <X> X performQuery(@NotNull SqlQuery<X> query, @Nullable Map<String, ? extends Object> namedParameters, Object ... freeParameters) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)freeParameters, (String)"freeParameters");
            return this.performQuery(this.transaction, query, namedParameters, Arrays.copyOf(freeParameters, freeParameters.length));
        }

        @NotNull
        protected <R> List<R> performQueryForList(@NotNull SqlQuery<? extends Iterable<? extends R>> query, @Nullable Map<String, ? extends Object> namedParameters, int packSize) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return this.performQueryForList(this.transaction, query, namedParameters, packSize);
        }

        public static /* synthetic */ List performQueryForList$default(AbstractRetriever abstractRetriever, SqlQuery sqlQuery, Map map2, int n, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryForList");
            }
            if ((n3 & 2) != 0) {
                map2 = null;
            }
            if ((n3 & 4) != 0) {
                n = 4096;
            }
            return abstractRetriever.performQueryForList(sqlQuery, map2, n);
        }

        protected final <X> void performQueryHandleEachRow(@NotNull SqlQuery<? extends Iterable<? extends X>> query, int packSize, @NotNull Function1<? super X, Unit> action) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.performQueryHandleEachRow(this.transaction, query, packSize, action);
        }

        public static /* synthetic */ void performQueryHandleEachRow$default(AbstractRetriever abstractRetriever, SqlQuery sqlQuery, int n, Function1 function1, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryHandleEachRow");
            }
            if ((n3 & 2) != 0) {
                n = 1000;
            }
            abstractRetriever.performQueryHandleEachRow(sqlQuery, n, function1);
        }

        @Nullable
        protected final <X> X performQuerySafe(@NotNull SqlQuery<X> query, @NotNull String introspectionScopeRemark) {
            X x;
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)introspectionScopeRemark, (String)"introspectionScopeRemark");
            try {
                x = this.performQuery(query);
            }
            catch (DBException e2) {
                this.log.error(StringsKt.trimMargin$default((String)("|Error occurred when introspected " + introspectionScopeRemark + ", query " + query.getDisplayName() + ":\n                     |" + e2.getMessage() + "\n                     |SQL statement:\n                     |" + e2.statementText), null, (int)1, null));
                x = null;
            }
            return x;
        }

        @NotNull
        protected final <R> List<R> performQuerySafeList(@NotNull SqlQuery<? extends Iterable<? extends R>> query, @NotNull String introspectionScopeRemark) {
            List list;
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)introspectionScopeRemark, (String)"introspectionScopeRemark");
            try {
                list = AbstractRetriever.performQueryForList$default(this, query, null, 0, 6, null);
            }
            catch (DBException e2) {
                this.log.error(StringsKt.trimMargin$default((String)("|Error occurred when introspected " + introspectionScopeRemark + ", query " + query.getDisplayName() + ":\n                     |" + e2.getMessage() + "\n                     |SQL statement:\n                     |" + e2.statementText), null, (int)1, null));
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @Override
        protected boolean queryPostPreprocess(@NotNull StringBuilder buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return BaseNativeIntrospector.this.queryPostPreprocess(buf);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u00180\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\bB!\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u00100\u001a\u000201H\u0014J\b\u00102\u001a\u000201H\u0014J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\r0&2\u0006\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000201H\u0014J\b\u00107\u001a\u000201H\u0014J\b\u00108\u001a\u000209H\u0014J\u001c\u0010:\u001a\u0002012\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u0002010<H\u0004J\u001d\u0010=\u001a\u00020+2\u0006\u0010>\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0003H&\u00a2\u0006\u0002\u0010?J\u0018\u0010@\u001a\u0002012\u0006\u0010A\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0002J'\u0010B\u001a\u0004\u0018\u0001HC\"\b\b\u0004\u0010C*\u00020D2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002HC0FH\u0004\u00a2\u0006\u0002\u0010GJ*\u0010H\u001a\b\u0012\u0004\u0012\u0002HJ0I\"\u0004\b\u0004\u0010J2\u0014\u0010E\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002HJ0K0FH\u0004J\b\u0010L\u001a\u000201H\u0017J\b\u0010M\u001a\u000201H\u0016J\u0006\u0010N\u001a\u000201J\b\u0010O\u001a\u000201H\u0016J\b\u0010P\u001a\u000201H\u0014J\b\u0010Q\u001a\u000201H\u0014J#\u0010R\u001a\u0002012\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0002\u0010SJ\u0016\u0010T\u001a\u0002012\f\u0010U\u001a\b\u0012\u0004\u0012\u00020W0VH\u0016J\"\u0010X\u001a\u000e\u0012\u0004\u0012\u0002HZ\u0012\u0004\u0012\u0002H[0Y\"\b\b\u0004\u0010Z*\u00020\\\"\u0004\b\u0005\u0010[R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010)\u001a\u0004\b'\u0010(R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006]"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)V", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "(Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;Lcom/intellij/database/introspection/IntrospectionMode;)V", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "getFragmentKind", "()Lcom/intellij/database/model/ObjectKind;", "setFragmentKind", "(Lcom/intellij/database/model/ObjectKind;)V", "fragmentNames", "", "", "getFragmentNames", "()[Ljava/lang/String;", "setFragmentNames", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "introspectionBeginLocalTimestamp", "Ljava/time/Instant;", "getIntrospectionBeginLocalTimestamp", "()Ljava/time/Instant;", "setIntrospectionBeginLocalTimestamp", "(Ljava/time/Instant;)V", "newMode", "getMode", "()Lcom/intellij/database/introspection/IntrospectionMode;", "setMode", "(Lcom/intellij/database/introspection/IntrospectionMode;)V", "outdatedKinds", "", "getSchema", "()Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/model/basic/BasicModSchema;", "withSources", "", "getWithSources", "()Z", "setWithSources", "(Z)V", "analyzeBriefInfo", "", "analyzeCurrentContent", "checkOutdatedKinds", "existentVersion", "", "clearSchema", "finishSchema", "getSchemaStateNumber", "", "inSchema", "modifier", "Lkotlin/Function1;", "isPossibleToIntrospectSchemaIncrementally", "tran", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)Z", "modeIsChanged", "oldMode", "performQuerySafe", "X", "", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;)Ljava/lang/Object;", "performQuerySafeList", "", "R", "", "prepareParameters", "process", "processMainPhase", "processPreliminaryPhase", "retrieveMainContent", "retrieveMajorNames", "retrieveNamedFragments", "(Lcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "retrieveSpecificFragments", "fragments", "", "Lcom/intellij/database/model/basic/BasicMajorObject;", "searchInSchema", "Lcom/intellij/database/model/ElementChecker;", "T", "D", "Lcom/intellij/database/model/basic/BasicElement;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseNativeIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 SequenceFun.kt\ncom/intellij/database/util/common/SequenceFun\n+ 8 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,846:1\n1#2:847\n26#3:848\n1144#4:849\n1130#4,3:850\n1145#4:853\n1144#4:854\n1130#4,3:855\n1145#4:858\n1477#5:859\n1502#5,3:860\n1505#5,3:870\n372#6,7:863\n9#7:873\n37#8,2:874\n*S KotlinDebug\n*F\n+ 1 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever\n*L\n651#1:848\n679#1:849\n679#1:850,3\n679#1:853\n691#1:854\n691#1:855,3\n691#1:858\n794#1:859\n794#1:860,3\n794#1:870,3\n794#1:863,7\n800#1:873\n800#1:874,2\n*E\n"})
    protected abstract class AbstractSchemaRetriever<S extends BasicModSchema>
    extends AbstractRetriever {
        @NotNull
        private final S schema;
        @NotNull
        private IntrospectionMode mode;
        private boolean withSources;
        @NotNull
        private ObjectKind fragmentKind;
        @NotNull
        private String[] fragmentNames;
        @NotNull
        private Instant introspectionBeginLocalTimestamp;
        @NotNull
        private final Set<ObjectKind> outdatedKinds;
        final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;

        @NotNull
        public final S getSchema() {
            return this.schema;
        }

        @NotNull
        public final IntrospectionMode getMode() {
            return this.mode;
        }

        public final void setMode(@NotNull IntrospectionMode newMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)newMode), (String)"newMode");
            if (this.mode != newMode) {
                IntrospectionMode oldMode = this.mode;
                this.mode = newMode;
                this.modeIsChanged(oldMode, newMode);
            }
        }

        public final boolean getWithSources() {
            return this.withSources;
        }

        public final void setWithSources(boolean bl) {
            this.withSources = bl;
        }

        @NotNull
        public final ObjectKind getFragmentKind() {
            return this.fragmentKind;
        }

        public final void setFragmentKind(@NotNull ObjectKind objectKind) {
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"<set-?>");
            this.fragmentKind = objectKind;
        }

        @NotNull
        public final String[] getFragmentNames() {
            return this.fragmentNames;
        }

        public final void setFragmentNames(@NotNull String[] stringArray) {
            Intrinsics.checkNotNullParameter((Object)stringArray, (String)"<set-?>");
            this.fragmentNames = stringArray;
        }

        @NotNull
        protected final Instant getIntrospectionBeginLocalTimestamp() {
            return this.introspectionBeginLocalTimestamp;
        }

        protected final void setIntrospectionBeginLocalTimestamp(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.introspectionBeginLocalTimestamp = instant;
        }

        protected AbstractSchemaRetriever(@NotNull DBTransaction transaction, S schema2) {
            IntrospectionMode introspectionMode;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            IntrospectionMode introspectionMode2 = introspectionMode = IntrospectionMode.FULL;
            S s2 = schema2;
            DBTransaction dBTransaction = transaction;
            reference var8_8 = this$0;
            AbstractSchemaRetriever abstractSchemaRetriever = this;
            boolean bl = false;
            boolean bl2 = this$0.getForbidIncremental();
            abstractSchemaRetriever(var8_8, dBTransaction, (BasicModSchema)s2, bl2 ? introspectionMode : null);
        }

        protected AbstractSchemaRetriever(@NotNull DBTransaction transaction, @Nullable S schema2, IntrospectionMode mode) {
            BaseIntrospector baseIntrospector;
            Level level$iv$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            this.this$0 = this$0;
            super(transaction);
            this.mode = IntrospectionMode.FULL;
            ObjectKind objectKind = ObjectKind.NONE;
            Intrinsics.checkNotNull((Object)objectKind);
            this.fragmentKind = objectKind;
            boolean $i$f$emptyArray = false;
            this.fragmentNames = new String[0];
            this.introspectionBeginLocalTimestamp = CalendarFun.currentInstantTruncatedToSeconds();
            this.schema = schema2;
            this$0.trace(StringFun.centerAndPadAsTitle("SCHEMA RETRIEVER: " + schema2.getName(), 140, '-'));
            boolean schemaHasChildren = schema2.hasChildren();
            boolean incrementalIsPossible = this.isPossibleToIntrospectSchemaIncrementally(transaction, schema2);
            IntrospectionMode introspectionMode = mode;
            if (introspectionMode == null) {
                introspectionMode = schemaHasChildren && incrementalIsPossible ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
            }
            this.setMode(introspectionMode);
            this.withSources = this$0.getOptions().getSources().compareTo((Enum)DBIntrospectionOptions.SourceLoading.USER_SOURCES) >= 0;
            this$0.trace(StringsKt.trimMargin$default((String)("|Schema has children: " + schemaHasChildren + "\n               |Incremental is possible: " + incrementalIsPossible + "\n               |Asked mode: " + mode + "\n               |Decided mode: " + this.mode + "\n            "), null, (int)1, null));
            BaseIntrospector this_$iv = this$0;
            boolean $i$f$trace = false;
            BaseIntrospector this_$iv$iv = this_$iv;
            boolean $i$f$getTracing = false;
            if (BaseIntrospector.access$getDiagnosticRecorder(this_$iv$iv) != null) {
                bl = true;
            } else {
                Logger logger2 = BaseIntrospector.access$getDbLogger(this_$iv$iv);
                level$iv$iv = logger2 != null ? BaseIntrospector.Companion.access$getEffectiveLevel(BaseIntrospector.Companion, logger2) : null;
                bl = level$iv$iv != null && level$iv$iv.intValue() <= BaseIntrospector.access$getTRACE_LEVEL_VALUE$cp();
            }
            if (bl) {
                baseIntrospector = this_$iv;
                boolean bl2 = false;
                BaseIntrospector.access$trace(baseIntrospector, StringsKt.trimMargin$default((String)("|Configuration info:\n           |    - schema id:             " + (schema2 instanceof BasicIdentifiedElement ? String.valueOf(((BasicIdentifiedElement)schema2).getObjectId()) : "no") + "\n           |    - schema has children:   " + BooleanFun.getYesNo(schemaHasChildren) + "\n           |    - mode:                  " + this.getMode() + "\n           |    - with sources:          " + BooleanFun.getYesNo(this.getWithSources()) + "\n        "), null, (int)1, null));
            }
            this.outdatedKinds = this.checkOutdatedKinds(schema2.getLastIntrospectionVersion());
            if (schemaHasChildren) {
                boolean bl2;
                this_$iv = this$0;
                $i$f$trace = false;
                this_$iv$iv = this_$iv;
                $i$f$getTracing = false;
                if (BaseIntrospector.access$getDiagnosticRecorder(this_$iv$iv) != null) {
                    bl2 = true;
                } else {
                    Logger logger3 = BaseIntrospector.access$getDbLogger(this_$iv$iv);
                    level$iv$iv = logger3 != null ? BaseIntrospector.Companion.access$getEffectiveLevel(BaseIntrospector.Companion, logger3) : null;
                    bl2 = level$iv$iv != null && level$iv$iv.intValue() <= BaseIntrospector.access$getTRACE_LEVEL_VALUE$cp();
                }
                if (bl2) {
                    baseIntrospector = this_$iv;
                    boolean bl4 = false;
                    StringBuilder b2 = new StringBuilder();
                    b2.append("Families before introspection:");
                    List<? extends Family<? extends BasicElement>> list = schema2.getFamilies();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getFamilies(...)");
                    List<? extends Family<? extends BasicElement>> families = list;
                    for (ModFamily modFamily : families) {
                        String string;
                        int n = modFamily.size();
                        if (n <= 0) continue;
                        ObjectKind kind = modFamily.getMetaObject().kind;
                        b2.append('\n');
                        StringBuilder stringBuilder = b2.append("    - ");
                        Intrinsics.checkNotNullExpressionValue((Object)kind.code(), (String)"code(...)");
                        Locale locale = Locale.ROOT;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                        String string2 = string.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        stringBuilder.append(string2);
                        b2.append(": ").append(n);
                        if (!this.outdatedKinds.contains(kind)) continue;
                        b2.append("  (outdated)");
                    }
                    String string = b2.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    BaseIntrospector.access$trace(baseIntrospector, string);
                }
            }
        }

        private final void modeIsChanged(IntrospectionMode oldMode, IntrospectionMode newMode) {
            this.this$0.trace("Introspection mode was changed from " + oldMode + " to " + newMode);
        }

        private final Set<ObjectKind> checkOutdatedKinds(int existentVersion) {
            Map<ObjectKind, Integer> kindVersions = this.this$0.getIntrospectorKindVersions();
            if (kindVersions.isEmpty()) {
                return SetsKt.emptySet();
            }
            TreeSet kinds = new TreeSet();
            for (Map.Entry<ObjectKind, Integer> entry : kindVersions.entrySet()) {
                ObjectKind k = entry.getKey();
                int v2 = ((Number)entry.getValue()).intValue();
                if (Intrinsics.areEqual((Object)k, (Object)ObjectKind.NONE) || existentVersion >= v2) continue;
                ((Collection)kinds).add(k);
            }
            return kinds;
        }

        public abstract boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction var1, @NotNull S var2);

        @ApiStatus.Internal
        public void prepareParameters() {
            block0: {
                BaseIntrospectionFunctions.setupModeParameters(this.mode, this.getParametersMap());
                this.setQueryParameter("SCHEMA_NAME", this.schema.getRealName());
                this.setQueryParameter("SCHEMA_ID", this.schema instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)this.schema).getObjectId() != Long.MIN_VALUE ? Long.valueOf(((BasicIdentifiedElement)this.schema).getObjectId()) : null);
                BasicDatabase basicDatabase = this.schema.getDatabase();
                if (basicDatabase == null) break block0;
                BasicDatabase it2 = basicDatabase;
                boolean bl = false;
                this.setQueryParameter("DATABASE_NAME", it2.getRealName());
            }
        }

        @NotNull
        public final <T extends BasicElement, D> ElementChecker<T, D> searchInSchema() {
            return ElementCacheKt.searchElement(this.getSearchCache());
        }

        protected final void inSchema(@NotNull Function1<? super S, Unit> modifier) {
            Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
            this.getModel().modify((BasicElement)this.schema, this.schema.getMetaObject().apiClass, new ModelModifier(modifier){
                final /* synthetic */ Function1<S, Unit> $modifier;
                {
                    this.$modifier = $modifier;
                }

                public final void perform(BasicElement schema2) {
                    Intrinsics.checkNotNull((Object)schema2, (String)"null cannot be cast to non-null type S of com.intellij.database.dialects.base.introspector.BaseNativeIntrospector.AbstractSchemaRetriever");
                    this.$modifier.invoke((Object)((BasicModSchema)schema2));
                }
            });
        }

        @Nullable
        protected final <X> X performQuerySafe(@NotNull SqlQuery<X> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return this.performQuerySafe(query, "schema " + this.schema.getRealName());
        }

        @NotNull
        protected final <R> List<R> performQuerySafeList(@NotNull SqlQuery<? extends Iterable<? extends R>> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return this.performQuerySafeList(query, "schema " + this.schema.getRealName());
        }

        @Override
        public void process() {
            this.introspectionBeginLocalTimestamp = CalendarFun.currentInstantTruncatedToSeconds();
            BaseIntrospector baseIntrospector = this.this$0;
            String string = this.schema.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            BaseIntrospector.reportIntrospectingSchema$default(baseIntrospector, string, null, null, 6, null);
            this.prepareParameters();
            this.processPreliminaryPhase();
            this.processMainPhase();
        }

        public void processPreliminaryPhase() {
            if (this.mode.fragment) {
                return;
            }
            this.analyzeBriefInfo();
            if (this.mode.increment) {
                this.analyzeCurrentContent();
            } else {
                this.clearSchema();
                this.retrieveMajorNames();
            }
        }

        public final void processMainPhase() {
            this.retrieveMainContent();
            this.finishSchema();
        }

        /*
         * WARNING - void declaration
         */
        public void retrieveSpecificFragments(@NotNull Collection<? extends BasicMajorObject> fragments2) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
            if (!this.this$0.nature.getSupportFragmentIntrospection()) {
                this.this$0.logWarn("Attempted to retrieve " + fragments2.size() + " fragments when the introspector doesn't support it");
                return;
            }
            Iterable $this$groupBy$iv = fragments2;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                ObjectKind key$iv$iv;
                BasicMajorObject it2 = (BasicMajorObject)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2.getKind(), (String)"getKind(...)");
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map groups2 = destination$iv$iv;
            for (Map.Entry entry : groups2.entrySet()) {
                void $this$toArray$iv;
                ObjectKind kind = (ObjectKind)entry.getKey();
                List objects2 = (List)entry.getValue();
                Sequence sequence = SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)objects2), (Function1)retrieveSpecificFragments.names.1.INSTANCE));
                boolean $i$f$toArray = false;
                Collection $this$toTypedArray$iv$iv = SequencesKt.toList((Sequence)$this$toArray$iv);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                String[] names2 = thisCollection$iv$iv.toArray(new String[0]);
                this.retrieveNamedFragments(kind, names2);
            }
        }

        public void retrieveNamedFragments(@NotNull ObjectKind fragmentKind, @NotNull String[] fragmentNames) {
            Intrinsics.checkNotNullParameter((Object)fragmentKind, (String)"fragmentKind");
            Intrinsics.checkNotNullParameter((Object)fragmentNames, (String)"fragmentNames");
            this.this$0.logWarn("Attempted to retrieve " + fragmentNames.length + " fragments of kind " + fragmentKind + " when the introspector doesn't support it");
        }

        protected void analyzeBriefInfo() {
        }

        protected void analyzeCurrentContent() {
        }

        protected void retrieveMajorNames() {
        }

        protected void retrieveMainContent() {
        }

        protected void finishSchema() {
            this.this$0.reportStatusDetails("Finishing retrieving the schema " + this.schema.getName(), "introspection.report.status.finishingTheSchema");
            this.schema.setLastIntrospectionLocalTimestamp(this.introspectionBeginLocalTimestamp);
            if (this.withSources && this.mode != IntrospectionMode.FRAGMENT) {
                this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, this.getSchemaStateNumber());
            }
            if (this.mode.full || this.mode.increment) {
                this.schema.setLastIntrospectionVersion(this.this$0.getIntrospectorVersion());
            }
        }

        protected long getSchemaStateNumber() {
            return 0L;
        }

        protected void clearSchema() {
            this.getModel().modify((BasicElement)this.schema, BasicModSchema.class, clearSchema.1.INSTANCE);
            this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, null);
        }
    }
}

