/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.BaseDmlHelperKt;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.MultiInsertRowsTask;
import com.intellij.database.util.DdlBuilder;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/base/generator/dml/BaseMultiInsertRowsGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/util/DdlBuilder;", "Lcom/intellij/database/script/generator/dml/MultiInsertRowsTask;", "task", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/script/generator/dml/MultiInsertRowsTask;Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "generate", "intellij.database.dialects.base"})
public class BaseMultiInsertRowsGenerator
extends DmlGenerator<DdlBuilder, MultiInsertRowsTask> {
    @NotNull
    private final Dbms dbms;

    public BaseMultiInsertRowsGenerator(@NotNull MultiInsertRowsTask task, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super((DmlTask)task);
        this.dbms = dbms;
    }

    @NotNull
    protected final Dbms getDbms() {
        return this.dbms;
    }

    @Override
    @NotNull
    public DdlBuilder generate() {
        DdlBuilder builder = ((MultiInsertRowsTask)this.getTask()).getOutput();
        builder.keyword("INSERT").space().keyword("INTO").space().qualifiedRef(((MultiInsertRowsTask)this.getTask()).getTable());
        List<String> columns2 = BaseDmlHelperKt.getColumnNamesForInsert((Collection)((MultiInsertRowsTask)this.getTask()).getColumnsForInsert(), this.dbms, ((MultiInsertRowsTask)this.getTask()).getIncludeAllColumns());
        boolean empty2 = columns2.isEmpty();
        if (empty2) {
            if (DmlUtilKt.dmlGenerator(this.dbms).getSupportsInsertDefaultValues()) {
                builder.space().keyword("DEFAULT").space().keyword("VALUES");
                return builder;
            }
            throw new IllegalArgumentException("Can't insert values without columns");
        }
        builder.space().symbol("(");
        DialectUtils.appendStringList(builder, (Iterable<String>)columns2);
        builder.symbol(")");
        builder.space().keyword("VALUES").space();
        List<List<Consumer<DdlBuilder>>> parameters2 = Collections.nCopies(((MultiInsertRowsTask)this.getTask()).getLinesCount(), BaseDmlHelperKt.getPlaceholdersForInsert((Collection<? extends AutoValueDescriptor>)((MultiInsertRowsTask)this.getTask()).getColumnsForInsert(), this.dbms, ((MultiInsertRowsTask)this.getTask()).getTable(), ((MultiInsertRowsTask)this.getTask()).getIncludeAllColumns()));
        int linesCount2 = parameters2.size();
        for (int i2 = 0; i2 < linesCount2; ++i2) {
            builder.symbol("(");
            DialectUtils.appendCommaSeparated(builder, (Iterable<? extends Consumer<DdlBuilder>>)parameters2.get(i2));
            builder.symbol(")");
            if (i2 >= linesCount2 - 1) continue;
            builder.literal(",");
        }
        return builder;
    }
}

