/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.diagnostic.DiagnosticMonitor;
import com.intellij.database.dialects.SqlAffectAnalyzer;
import com.intellij.database.dialects.base.BaseAffectAnalyzer;
import com.intellij.database.dialects.base.BaseAffectAnalyzer$Companion$parseQualifiedIdentifier$;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BelongingAreaKind;
import com.intellij.database.introspection.Impactees;
import com.intellij.database.introspection.ImpacteesBuilder;
import com.intellij.database.introspection.ObjectAffectionType;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.common.NumberFun;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.impl.SqlCreateSynonymStatementImpl;
import com.intellij.sql.psi.impl.SqlDropStatementImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0005\u0012\u0013\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "Lcom/intellij/database/dialects/SqlAffectAnalyzer;", "()V", "describeScript", "", "script", "", "Lcom/intellij/psi/PsiElement;", "determineAffectedObjects", "Lcom/intellij/database/introspection/Impactees;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "prepareDeterminer", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "dbms", "Lcom/intellij/database/Dbms;", "Companion", "Determiner", "MultiDatabaseDeterminer", "ScriptedName", "SingleDatabaseDeterminer", "intellij.database.dialects.base"})
public class BaseAffectAnalyzer
implements SqlAffectAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Impactees determineAffectedObjects(@NotNull DasDataSource dataSource2, @NotNull List<? extends PsiElement> script2, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter(script2, (String)"script");
        if (script2.isEmpty()) {
            return Impactees.EMPTY;
        }
        Dbms dbms = dataSource2.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Determiner determiner = this.prepareDeterminer(dbms, searchPath);
        for (PsiElement psiElement : script2) {
            determiner.analyze(psiElement);
        }
        Impactees impactees = determiner.getImpactees();
        String string = dataSource2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        DiagnosticMonitor.INSTANCE.record(string, (Function0<String>)((Function0)new Function0<String>(this, script2, impactees){
            final /* synthetic */ BaseAffectAnalyzer this$0;
            final /* synthetic */ List<PsiElement> $script;
            final /* synthetic */ Impactees $impactees;
            {
                this.this$0 = $receiver;
                this.$script = $script;
                this.$impactees = $impactees;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String scriptDescription = BaseAffectAnalyzer.access$describeScript(this.this$0, this.$script);
                String impactDescription = this.$impactees.toString();
                return StringsKt.trimMargin$default((String)("|Analysing script: " + StringsKt.replace$default((String)scriptDescription, (String)"\n", (String)"\n\t", (boolean)false, (int)4, null) + "\n         |Determined impact: " + StringsKt.replace$default((String)impactDescription, (String)"\n", (String)"\n\t", (boolean)false, (int)4, null) + "\n      "), null, (int)1, null);
            }
        }));
        return impactees;
    }

    private final String describeScript(List<? extends PsiElement> script2) {
        return NumberFun.toStringWithUnits(script2.size(), "statement") + ":" + CollectionsKt.joinToString$default((Iterable)script2, (CharSequence)"", null, null, (int)0, null, (Function1)describeScript.1.INSTANCE, (int)30, null);
    }

    @NotNull
    protected Determiner prepareDeterminer(@NotNull Dbms dbms, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return ModelFun.isMultiDatabase(dbms) ? (Determiner)new MultiDatabaseDeterminer(searchPath) : (Determiner)new SingleDatabaseDeterminer(searchPath);
    }

    public static final /* synthetic */ String access$describeScript(BaseAffectAnalyzer $this, List script2) {
        return $this.describeScript(script2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\n\b\u0000\u0010\u000f\u0018\u0001*\u00020\u0010*\u00020\u0010H\u0086\b\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion;", "", "()V", "parseQualifiedIdentifier", "", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$ScriptedName;", "str", "", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "skip", "", "child", "P", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,290:1\n1549#2:291\n1620#2,3:292\n223#3,2:295\n473#4:297\n*S KotlinDebug\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion\n*L\n266#1:291\n266#1:292,3\n272#1:295,2\n272#1:297\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <P extends PsiElement> P child(PsiElement $this$child) {
            Intrinsics.checkNotNullParameter((Object)$this$child, (String)"<this>");
            boolean $i$f$child = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"P");
            return (P)PsiTreeUtil.findChildOfType((PsiElement)$this$child, PsiElement.class, (boolean)false);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<ScriptedName> parseQualifiedIdentifier(@NotNull String str, @NotNull SqlLanguageDialect dialect, @NotNull Project project, int skip) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List parsedNames = null;
            if (!StringsKt.contains$default((CharSequence)str, (char)'\"', (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)str, (char)'[', (boolean)false, (int)2, null)) {
                void $this$mapTo$iv$iv;
                char[] cArray = new char[]{'.'};
                List split = StringsKt.split$default((CharSequence)str, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                Iterable $this$map$iv = split;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(new ScriptedName((String)it2, false));
                }
                parsedNames = (List)destination$iv$iv;
            } else {
                SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(str.toString(), dialect, project, null);
                if (sqlExpression == null) {
                    return null;
                }
                SqlExpression exp = sqlExpression;
                PsiElement $this$descendantsOfType_u24default$iv = (PsiElement)exp;
                boolean childrenFirst$iv = false;
                boolean $i$f$descendantsOfType = false;
                Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType_u24default$iv, (boolean)childrenFirst$iv, null, (int)2, null);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)Companion$parseQualifiedIdentifier$$inlined$descendantsOfType$default$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                parsedNames = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)sequence, (Function1)parseQualifiedIdentifier.2.INSTANCE));
            }
            if (parsedNames.size() <= skip) {
                return null;
            }
            List adjustedNames = skip <= 0 ? parsedNames : parsedNames.subList(0, parsedNames.size() - skip);
            return CollectionsKt.asReversed((List)adjustedNames);
        }

        public static /* synthetic */ List parseQualifiedIdentifier$default(Companion companion, String string, SqlLanguageDialect sqlLanguageDialect, Project project, int n, int n3, Object object) {
            if ((n3 & 8) != 0) {
                n = 0;
            }
            return companion.parseQualifiedIdentifier(string, sqlLanguageDialect, project, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b$\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH$J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H&J8\u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010%\u001a\u00020&H\u0004J@\u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u00102\b\b\u0002\u0010%\u001a\u00020&H\u0004J.\u0010*\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010+\u001a\u0004\u0018\u00010,2\b\b\u0002\u0010%\u001a\u00020&H\u0004J0\u0010-\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010.\u001a\u0004\u0018\u00010$2\b\u0010/\u001a\u0004\u0018\u000100H\u0004J&\u0010-\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u00101\u001a\u0004\u0018\u00010,2\b\u0010/\u001a\u0004\u0018\u000100H\u0004\u00a8\u00062"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "", "()V", "acceptObject", "", "actionType", "Lcom/intellij/database/introspection/ObjectAffectionType;", "affectAreaKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "qi", "", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$ScriptedName;", "analyze", "statement", "Lcom/intellij/psi/PsiElement;", "analyzeBatchBlock", "block", "Lcom/intellij/sql/psi/SqlBatchBlock;", "analyzeCallStatement", "Lcom/intellij/sql/psi/SqlCallStatement;", "analyzeCreateSynonym", "Lcom/intellij/sql/psi/impl/SqlCreateSynonymStatementImpl;", "analyzeDdlStatement", "Lcom/intellij/sql/psi/SqlDdlStatement;", "analyzeDropStatement", "Lcom/intellij/sql/psi/impl/SqlDropStatementImpl;", "analyzeRoutineDefinition", "Lcom/intellij/sql/psi/SqlRoutineDefinition;", "analyzeStatement", "Lcom/intellij/sql/psi/SqlStatement;", "getImpactees", "Lcom/intellij/database/introspection/Impactees;", "handleIdentifier", "identifierElement", "Lcom/intellij/sql/psi/SqlNameElement;", "skipNames", "", "identifierText", "", "psiContext", "handleReference", "ref", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "handleRename", "oldIdentifierElement", "newIdentifierElement", "Lcom/intellij/sql/psi/SqlElement;", "oldReference", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner\n+ 2 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n256#2:291\n1#3:292\n*S KotlinDebug\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner\n*L\n108#1:291\n*E\n"})
    protected static abstract class Determiner {
        public void analyze(@NotNull PsiElement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            PsiElement psiElement = statement2;
            if (psiElement instanceof SqlBatchBlock) {
                this.analyzeBatchBlock((SqlBatchBlock)statement2);
            } else if (psiElement instanceof SqlStatement) {
                this.analyzeStatement((SqlStatement)statement2);
            }
        }

        protected void analyzeBatchBlock(@NotNull SqlBatchBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            PsiElement[] psiElementArray = block.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            for (PsiElement innerElement : psiElementArray) {
                Intrinsics.checkNotNull((Object)innerElement);
                this.analyze(innerElement);
            }
        }

        protected void analyzeStatement(@NotNull SqlStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlStatement sqlStatement = statement2;
            if (sqlStatement instanceof SqlDdlStatement) {
                this.analyzeDdlStatement((SqlDdlStatement)statement2);
            } else if (sqlStatement instanceof SqlCallStatement) {
                this.analyzeCallStatement((SqlCallStatement)statement2);
            }
        }

        protected void analyzeDdlStatement(@NotNull SqlDdlStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlDdlStatement sqlDdlStatement = statement2;
            if (sqlDdlStatement instanceof SqlTableDefinition) {
                Determiner.handleIdentifier$default(this, ObjectAffectionType.WAS_CREATED, BelongingAreaKind.A_SCHEMA, ((SqlTableDefinition)statement2).getKind(), (SqlNameElement)((SqlTableDefinition)statement2).getNameElement(), 0, 16, null);
            } else if (sqlDdlStatement instanceof SqlRoutineDefinition) {
                this.analyzeRoutineDefinition((SqlRoutineDefinition)statement2);
            } else if (sqlDdlStatement instanceof SqlConstraintDefinition) {
                Determiner.handleReference$default(this, ObjectAffectionType.WAS_ALTERED, null, ((SqlConstraintDefinition)statement2).getParentRef(), 0, 8, null);
            } else if (sqlDdlStatement instanceof SqlAlterStatement) {
                Determiner.handleReference$default(this, ObjectAffectionType.WAS_ALTERED, null, ((SqlAlterStatement)statement2).getAlterTargetReference(), 0, 8, null);
            } else if (sqlDdlStatement instanceof SqlDropStatementImpl) {
                this.analyzeDropStatement((SqlDropStatementImpl)statement2);
            } else if (sqlDdlStatement instanceof SqlCreateIndexStatement) {
                Determiner.handleIdentifier$default(this, ObjectAffectionType.WAS_ALTERED, BelongingAreaKind.A_SCHEMA, ObjectKind.TABLE, (SqlNameElement)((SqlCreateIndexStatement)statement2).getTargetReference(), 0, 16, null);
            } else if (sqlDdlStatement instanceof SqlCreateTriggerStatement) {
                Determiner.handleIdentifier$default(this, ObjectAffectionType.WAS_ALTERED, BelongingAreaKind.A_SCHEMA, ObjectKind.TABLE, (SqlNameElement)((SqlCreateTriggerStatement)statement2).getTargetContextExpression(), 0, 16, null);
            } else if (sqlDdlStatement instanceof SqlCreateSynonymStatementImpl) {
                this.analyzeCreateSynonym((SqlCreateSynonymStatementImpl)statement2);
            }
        }

        protected void analyzeRoutineDefinition(@NotNull SqlRoutineDefinition statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlNameElement sqlNameElement = statement2.getNameElement();
            if (sqlNameElement == null) {
                return;
            }
            SqlNameElement nameElement = sqlNameElement;
            Determiner.handleIdentifier$default(this, ObjectAffectionType.WAS_CREATED, BelongingAreaKind.A_SCHEMA, ObjectKind.ROUTINE, nameElement, 0, 16, null);
        }

        protected void analyzeCreateSynonym(@NotNull SqlCreateSynonymStatementImpl statement2) {
            Intrinsics.checkNotNullParameter((Object)((Object)statement2), (String)"statement");
            Companion companion = Companion;
            PsiElement $this$child$iv = (PsiElement)statement2;
            boolean $i$f$child = false;
            Determiner.handleIdentifier$default(this, ObjectAffectionType.WAS_CREATED, BelongingAreaKind.A_SCHEMA, ObjectKind.SYNONYM, (SqlNameElement)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlReferenceExpression.class, (boolean)false), 0, 16, null);
        }

        protected void analyzeCallStatement(@NotNull SqlCallStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        }

        protected void analyzeDropStatement(@NotNull SqlDropStatementImpl statement2) {
            Intrinsics.checkNotNullParameter((Object)((Object)statement2), (String)"statement");
            Determiner.handleIdentifier$default(this, ObjectAffectionType.WAS_DROPPED, null, statement2.getTargetType(), (SqlNameElement)statement2.getTargetExpression(), 0, 16, null);
        }

        protected final void handleReference(@NotNull ObjectAffectionType actionType, @Nullable BelongingAreaKind affectAreaKind, @Nullable SqlReferenceExpression ref2, int skipNames) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            if (ref2 == null) {
                return;
            }
            ObjectKind objectKind = BaseIntrospectionFunctions.nullize(ref2.getKind(), SqlDbElementType.ANY);
            this.handleIdentifier(actionType, affectAreaKind, objectKind, (SqlNameElement)ref2, skipNames);
        }

        public static /* synthetic */ void handleReference$default(Determiner determiner, ObjectAffectionType objectAffectionType, BelongingAreaKind belongingAreaKind, SqlReferenceExpression sqlReferenceExpression, int n, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleReference");
            }
            if ((n3 & 8) != 0) {
                n = 0;
            }
            determiner.handleReference(objectAffectionType, belongingAreaKind, sqlReferenceExpression, n);
        }

        protected final void handleIdentifier(@NotNull ObjectAffectionType actionType, @Nullable BelongingAreaKind affectAreaKind, @Nullable ObjectKind objectKind, @Nullable SqlNameElement identifierElement, int skipNames) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            if (identifierElement == null) {
                return;
            }
            String identifierText = identifierElement.getText();
            this.handleIdentifier(actionType, affectAreaKind, objectKind, identifierText, (PsiElement)identifierElement, skipNames);
        }

        public static /* synthetic */ void handleIdentifier$default(Determiner determiner, ObjectAffectionType objectAffectionType, BelongingAreaKind belongingAreaKind, ObjectKind objectKind, SqlNameElement sqlNameElement, int n, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleIdentifier");
            }
            if ((n3 & 0x10) != 0) {
                n = 0;
            }
            determiner.handleIdentifier(objectAffectionType, belongingAreaKind, objectKind, sqlNameElement, n);
        }

        protected final void handleIdentifier(@NotNull ObjectAffectionType actionType, @Nullable BelongingAreaKind affectAreaKind, @Nullable ObjectKind objectKind, @Nullable CharSequence identifierText, @NotNull PsiElement psiContext, int skipNames) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)psiContext, (String)"psiContext");
            Language language = psiContext.getLanguage();
            SqlLanguageDialect sqlLanguageDialect = language instanceof SqlLanguageDialect ? (SqlLanguageDialect)language : null;
            if (sqlLanguageDialect == null) {
                SqlLanguageDialect sqlLanguageDialect2 = SqlLanguageDialect.getIsoDialect();
                sqlLanguageDialect = sqlLanguageDialect2;
                Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect2, (String)"getIsoDialect(...)");
            }
            SqlLanguageDialect dialect = sqlLanguageDialect;
            Project project = psiContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            List<ScriptedName> qi = Companion.parseQualifiedIdentifier(String.valueOf(identifierText), dialect, project2, skipNames);
            if (qi != null) {
                ObjectKind objectKind2 = objectKind;
                if (objectKind2 == null) {
                    BelongingAreaKind belongingAreaKind = affectAreaKind;
                    switch (belongingAreaKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[belongingAreaKind.ordinal()]) {
                        case -1: {
                            if (qi.size() >= 2) {
                                objectKind2 = ObjectKind.SCHEMA_OBJECT;
                                break;
                            }
                            objectKind2 = ObjectKind.UNKNOWN_OBJECT;
                            break;
                        }
                        case 1: {
                            objectKind2 = ObjectKind.UNKNOWN_OBJECT;
                            break;
                        }
                        case 2: {
                            objectKind2 = ObjectKind.UNKNOWN_OBJECT;
                            break;
                        }
                        case 3: {
                            objectKind2 = ObjectKind.SCHEMA_OBJECT;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                ObjectKind theKind = objectKind2;
                Intrinsics.checkNotNull((Object)theKind);
                this.acceptObject(actionType, affectAreaKind, theKind, qi);
            }
        }

        public static /* synthetic */ void handleIdentifier$default(Determiner determiner, ObjectAffectionType objectAffectionType, BelongingAreaKind belongingAreaKind, ObjectKind objectKind, CharSequence charSequence, PsiElement psiElement, int n, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleIdentifier");
            }
            if ((n3 & 0x20) != 0) {
                n = 0;
            }
            determiner.handleIdentifier(objectAffectionType, belongingAreaKind, objectKind, charSequence, psiElement, n);
        }

        protected final void handleRename(@Nullable BelongingAreaKind affectAreaKind, @Nullable SqlReferenceExpression oldReference, @Nullable SqlElement newIdentifierElement) {
            if (oldReference == null) {
                return;
            }
            ObjectKind objectKind = BaseIntrospectionFunctions.nullize(oldReference.getKind(), SqlDbElementType.ANY);
            this.handleRename(affectAreaKind, objectKind, (SqlNameElement)oldReference, newIdentifierElement);
        }

        protected final void handleRename(@Nullable BelongingAreaKind affectAreaKind, @Nullable ObjectKind objectKind, @Nullable SqlNameElement oldIdentifierElement, @Nullable SqlElement newIdentifierElement) {
            List list;
            Language language;
            SqlLanguageDialect sqlLanguageDialect;
            ObjectKind theKind;
            if (oldIdentifierElement == null) {
                return;
            }
            ObjectKind objectKind2 = objectKind;
            if (objectKind2 == null) {
                objectKind2 = theKind = ObjectKind.SCHEMA_OBJECT;
            }
            if ((sqlLanguageDialect = (language = oldIdentifierElement.getLanguage()) instanceof SqlLanguageDialect ? (SqlLanguageDialect)language : null) == null) {
                SqlLanguageDialect sqlLanguageDialect2 = SqlLanguageDialect.getIsoDialect();
                sqlLanguageDialect = sqlLanguageDialect2;
                Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect2, (String)"getIsoDialect(...)");
            }
            SqlLanguageDialect dialect = sqlLanguageDialect;
            Project project = oldIdentifierElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            String string = oldIdentifierElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            List oqi = com.intellij.database.dialects.base.BaseAffectAnalyzer$Companion.parseQualifiedIdentifier$default(Companion, string, dialect, project2, 0, 8, null);
            if (oqi != null) {
                Intrinsics.checkNotNull((Object)theKind);
                this.acceptObject(ObjectAffectionType.WAS_DROPPED, affectAreaKind, theKind, oqi);
            }
            if (newIdentifierElement == null || oqi == null) {
                return;
            }
            String string2 = newIdentifierElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            List sqi = com.intellij.database.dialects.base.BaseAffectAnalyzer$Companion.parseQualifiedIdentifier$default(Companion, string2, dialect, project2, 0, 8, null);
            if (sqi == null || sqi.isEmpty()) {
                return;
            }
            List $this$handleRename_u24lambda_u240 = list = CollectionsKt.createListBuilder((int)oqi.size());
            boolean bl = false;
            $this$handleRename_u24lambda_u240.add(sqi.get(0));
            $this$handleRename_u24lambda_u240.addAll(oqi.subList(1, oqi.size()));
            List nqi = CollectionsKt.build((List)list);
            Intrinsics.checkNotNull((Object)theKind);
            this.acceptObject(ObjectAffectionType.WAS_CREATED, affectAreaKind, theKind, nqi);
        }

        protected abstract void acceptObject(@NotNull ObjectAffectionType var1, @Nullable BelongingAreaKind var2, @NotNull ObjectKind var3, @NotNull List<ScriptedName> var4);

        @NotNull
        public abstract Impactees getImpactees();

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BelongingAreaKind.values().length];
                try {
                    nArray[BelongingAreaKind.A_ROOT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BelongingAreaKind.A_DATABASE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BelongingAreaKind.A_SCHEMA.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004JV\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001aH\u0004J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0014J\b\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$MultiDatabaseDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/database/util/SearchPath;)V", "b", "Lcom/intellij/database/introspection/ImpacteesBuilder;", "getB", "()Lcom/intellij/database/introspection/ImpacteesBuilder;", "currDatabase", "Lcom/intellij/database/util/ObjectPath;", "getCurrDatabase", "()Lcom/intellij/database/util/ObjectPath;", "currSchema", "getCurrSchema", "acceptObject", "", "actionType", "Lcom/intellij/database/introspection/ObjectAffectionType;", "affectAreaKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectName", "", "objectNameIsQuoted", "", "schemaName", "schemaNameIsQuoted", "databaseName", "databaseNameIsQuoted", "qi", "", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$ScriptedName;", "getImpactees", "Lcom/intellij/database/introspection/Impactees;", "intellij.database.dialects.base"})
    protected static class MultiDatabaseDeterminer
    extends Determiner {
        @NotNull
        private final ObjectPath currDatabase;
        @NotNull
        private final ObjectPath currSchema;
        @NotNull
        private final ImpacteesBuilder b;

        @NotNull
        protected final ObjectPath getCurrDatabase() {
            return this.currDatabase;
        }

        @NotNull
        protected final ObjectPath getCurrSchema() {
            return this.currSchema;
        }

        @NotNull
        protected final ImpacteesBuilder getB() {
            return this.b;
        }

        public MultiDatabaseDeterminer(@Nullable SearchPath searchPath) {
            ObjectPath currPath;
            Object object = searchPath;
            ObjectPath objectPath = currPath = object != null && (object = ((SearchPath)object).elements) != null ? (ObjectPath)CollectionsKt.firstOrNull((List)object) : null;
            ObjectPath objectPath2 = objectPath != null ? objectPath.findParent(ObjectKind.DATABASE, false) : null;
            if (objectPath2 == null) {
                ObjectPath objectPath3 = ObjectPath.create("@", ObjectKind.DATABASE);
                objectPath2 = objectPath3;
                Intrinsics.checkNotNullExpressionValue((Object)objectPath3, (String)"create(...)");
            }
            this.currDatabase = objectPath2;
            ObjectPath objectPath4 = currPath;
            ObjectPath objectPath5 = objectPath4 != null ? objectPath4.findParent(ObjectKind.SCHEMA, false) : null;
            if (objectPath5 == null) {
                ObjectPath objectPath6 = this.currDatabase.append("@", ObjectKind.SCHEMA);
                objectPath5 = objectPath6;
                Intrinsics.checkNotNullExpressionValue((Object)objectPath6, (String)"append(...)");
            }
            this.currSchema = objectPath5;
            this.b = new ImpacteesBuilder(this.currDatabase, this.currSchema);
        }

        @Override
        protected void acceptObject(@NotNull ObjectAffectionType actionType, @Nullable BelongingAreaKind affectAreaKind, @NotNull ObjectKind objectKind, @NotNull List<ScriptedName> qi) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
            Intrinsics.checkNotNullParameter(qi, (String)"qi");
            switch (qi.size()) {
                case 1: {
                    this.acceptObject(actionType, affectAreaKind, objectKind, qi.get(0).getName(), qi.get(0).isQuoted(), null, false, null, false);
                    break;
                }
                case 2: {
                    this.acceptObject(actionType, affectAreaKind, objectKind, qi.get(0).getName(), qi.get(0).isQuoted(), StringKt.nullize((String)qi.get(1).getName(), (boolean)false), qi.get(1).isQuoted(), null, false);
                    break;
                }
                case 3: {
                    this.acceptObject(actionType, affectAreaKind, objectKind, qi.get(0).getName(), qi.get(0).isQuoted(), StringKt.nullize((String)qi.get(1).getName(), (boolean)false), qi.get(1).isQuoted(), StringKt.nullize((String)qi.get(2).getName(), (boolean)false), qi.get(2).isQuoted());
                }
            }
        }

        protected final void acceptObject(@NotNull ObjectAffectionType actionType, @Nullable BelongingAreaKind affectAreaKind, @NotNull ObjectKind objectKind, @NotNull String objectName, boolean objectNameIsQuoted, @Nullable String schemaName, boolean schemaNameIsQuoted, @Nullable String databaseName, boolean databaseNameIsQuoted) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            BelongingAreaKind belongingAreaKind = affectAreaKind;
            if (belongingAreaKind == null) {
                belongingAreaKind = schemaName != null ? BelongingAreaKind.A_SCHEMA : null;
            }
            BelongingAreaKind theAffectAreaKind = belongingAreaKind;
            this.b.include(actionType, theAffectAreaKind, objectKind, objectName, objectNameIsQuoted, schemaName, schemaNameIsQuoted, databaseName, databaseNameIsQuoted);
        }

        @Override
        @NotNull
        public Impactees getImpactees() {
            return this.b.build();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$ScriptedName;", "", "name", "", "isQuoted", "", "(Ljava/lang/String;Z)V", "()Z", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.database.dialects.base"})
    public static final class ScriptedName {
        @NotNull
        private final String name;
        private final boolean isQuoted;

        public ScriptedName(@NotNull String name2, boolean isQuoted) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.isQuoted = isQuoted;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean isQuoted() {
            return this.isQuoted;
        }

        @NotNull
        public String toString() {
            return this.isQuoted ? this.name + "!" : this.name;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final boolean component2() {
            return this.isQuoted;
        }

        @NotNull
        public final ScriptedName copy(@NotNull String name2, boolean isQuoted) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new ScriptedName(name2, isQuoted);
        }

        public static /* synthetic */ ScriptedName copy$default(ScriptedName scriptedName, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = scriptedName.name;
            }
            if ((n & 2) != 0) {
                bl = scriptedName.isQuoted;
            }
            return scriptedName.copy(string, bl);
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isQuoted);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScriptedName)) {
                return false;
            }
            ScriptedName scriptedName = (ScriptedName)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)scriptedName.name)) {
                return false;
            }
            return this.isQuoted == scriptedName.isQuoted;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004JD\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u0018H\u0004J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$SingleDatabaseDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/database/util/SearchPath;)V", "b", "Lcom/intellij/database/introspection/ImpacteesBuilder;", "getB", "()Lcom/intellij/database/introspection/ImpacteesBuilder;", "currSchema", "Lcom/intellij/database/util/ObjectPath;", "getCurrSchema", "()Lcom/intellij/database/util/ObjectPath;", "acceptObject", "", "actionType", "Lcom/intellij/database/introspection/ObjectAffectionType;", "affectAreaKind", "Lcom/intellij/database/introspection/BelongingAreaKind;", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectName", "", "objectNameIsQuoted", "", "schemaName", "schemaNameIsQuoted", "qi", "", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$ScriptedName;", "getImpactees", "Lcom/intellij/database/introspection/Impactees;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$SingleDatabaseDeterminer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n1#2:291\n*E\n"})
    protected static class SingleDatabaseDeterminer
    extends Determiner {
        @Nullable
        private final ObjectPath currSchema;
        @NotNull
        private final ImpacteesBuilder b;

        public SingleDatabaseDeterminer(@Nullable SearchPath searchPath) {
            ObjectPath objectPath;
            SingleDatabaseDeterminer singleDatabaseDeterminer = this;
            Object object = searchPath;
            if (object != null && (object = ((SearchPath)object).elements) != null) {
                Object v2;
                SingleDatabaseDeterminer singleDatabaseDeterminer2;
                block3: {
                    Iterable iterable = (Iterable)object;
                    singleDatabaseDeterminer2 = singleDatabaseDeterminer;
                    Iterable iterable2 = iterable;
                    for (Object t : iterable2) {
                        ObjectPath it2 = (ObjectPath)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.kind, (Object)ObjectKind.SCHEMA)) continue;
                        v2 = t;
                        break block3;
                    }
                    v2 = null;
                }
                singleDatabaseDeterminer = singleDatabaseDeterminer2;
                objectPath = v2;
            } else {
                objectPath = null;
            }
            singleDatabaseDeterminer.currSchema = objectPath;
            this.b = new ImpacteesBuilder(null, this.currSchema);
        }

        @Nullable
        protected final ObjectPath getCurrSchema() {
            return this.currSchema;
        }

        @NotNull
        protected final ImpacteesBuilder getB() {
            return this.b;
        }

        @Override
        protected void acceptObject(@NotNull ObjectAffectionType actionType, @Nullable BelongingAreaKind affectAreaKind, @NotNull ObjectKind objectKind, @NotNull List<ScriptedName> qi) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
            Intrinsics.checkNotNullParameter(qi, (String)"qi");
            switch (qi.size()) {
                case 1: {
                    this.acceptObject(actionType, affectAreaKind, objectKind, qi.get(0).getName(), qi.get(0).isQuoted(), null, false);
                    break;
                }
                case 2: {
                    this.acceptObject(actionType, affectAreaKind, objectKind, qi.get(0).getName(), qi.get(0).isQuoted(), qi.get(1).getName(), qi.get(1).isQuoted());
                }
            }
        }

        protected final void acceptObject(@NotNull ObjectAffectionType actionType, @Nullable BelongingAreaKind affectAreaKind, @NotNull ObjectKind objectKind, @NotNull String objectName, boolean objectNameIsQuoted, @Nullable String schemaName, boolean schemaNameIsQuoted) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            BelongingAreaKind belongingAreaKind = affectAreaKind;
            if (belongingAreaKind == null) {
                belongingAreaKind = schemaName != null ? BelongingAreaKind.A_SCHEMA : null;
            }
            BelongingAreaKind theAffectAreaKind = belongingAreaKind;
            this.b.include(actionType, theAffectAreaKind, objectKind, objectName, objectNameIsQuoted, schemaName, schemaNameIsQuoted);
        }

        @Override
        @NotNull
        public Impactees getImpactees() {
            return this.b.build();
        }
    }
}

